#!/usr/bin/perl
#
#           RiSearch SQL
#
# web search engine, version 0.1
# (c) Sergej Tarasov, 2000-2002
#
# Homepage: http://risearch.org/
# email: risearch@risearch.org
# Last modified: 29.07.2002


$| = 1;

print "Content-Type: text/html\n\n";

use DBI;
require './config.pl';


$dbh = DBI->connect("DBI:mysql:${DATABASE}:${DBSERVER}", $USERNAME, $PASSWORD)
     or print "Not conected";


($DAY, $MONTH, $YEAR, $HOUR, $MINUTE) = (localtime)[3,4,5,2,1];
$date = sprintf "%04d.%02d.%02d", $YEAR+1900, $MONTH+1, $DAY;

$code = "\${\$_[0]} =~ tr/-+!a-zA-Z$CAP_LETTERS$LOW_LETTERS$numbers/ /cs;";
$remove_non_alphabetic = eval "sub { $code }";

$code = "\${\$_[0]} =~ tr/A-Z$CAP_LETTERS/a-z$LOW_LETTERS/;";
$to_lower_case = eval "sub { $code }";

&read_template("template.htm");
&get_query();

if (scalar(@query) != 0) {
    &get_results();
    eval { ($search_time,undef,undef,undef) = times };
    if ($@) { $search_time = $@ }
}

print &print_template("header");
if (scalar(@query) != 0) {
    if ($rescount>0) {
        print &print_template("results_header");
        &print_results();
        print &print_template("results_footer");
    } else {
        print &print_template("no_results");
    }
} else {
    print &print_template("empty_query");
}
print &print_template("footer");

#===================================================================

sub get_query {
if($ENV{'REQUEST_METHOD'} eq 'GET'){ 
   $query=$ENV{'QUERY_STRING'};
   }
 elsif($ENV{'REQUEST_METHOD'} eq 'POST'){
   read(STDIN, $query, $ENV{'CONTENT_LENGTH'});
   }


@formfields=split /&/,$query;

$stype = "AND";
foreach(@formfields){
   if(/^query=(.*)/) {$ndquery=$1}
   if(/^stpos=(.*)/) {$stpos=$1}
   if(/^stype=(.*)/) {$stype=$1}
   }
$query = urldecode($ndquery);


&$to_lower_case(\$query);
$query =~ s/(&.*?;)/&esc2char($1)/eg;

if ( ($stpos == 0) && ($create_log eq "YES") ) {
    open QUERY, ">>log/$date";
    print QUERY "$query\n";
    close(QUERY);
}

&$remove_non_alphabetic(\$query);
@dum = split / /,$query;
@query = ();
foreach $dum (@dum) {
   if (exists($stop_words{$dum})) { next }
   if (length($dum) >= $min_length) { $query[$#query+1] = $dum }
}

if ($stpos <0) {$stpos = 0};
}
#===================================================================

sub get_results {

for ($j=0; $j<scalar(@query); $j++) {
    
    $word = $query[$j];
    $rescount = 0;
    $word_id = $dbh->selectrow_array("SELECT word_id FROM words WHERE word='$word'")
        or $not_in++;
    if ($word_id) {
        push @word_id, $word_id;
        $sqlquery = "SELECT count(*) FROM word_link WHERE word_id='$word_id'";
        $rescount = $dbh->selectrow_array($sqlquery)
            or print "Error2... ".$dbh->errstr."<BR>";
    }
    $query_statistics .= " $query[$j]-$rescount\n";
    
    
    
}; # for $query

    if ($not_in == scalar(@query))  { return }
    if ($not_in && $stype eq "AND") { return }

    $w_id = join ", ", @word_id;
    if ($stype eq "AND") {
        $op = "&&";
    } else {
        $op = "||";
    }
    $hav = join " $op ", map { "sum(word_id=$_)" } @word_id;
    
    $sqlquery = "SELECT document_id
                 FROM word_link
                 WHERE word_id IN ($w_id)
                 GROUP BY document_id
                 HAVING ($hav)>0
                 ";
#    print "$sqlquery<BR>";
    
    $doc_id_ref = $dbh->selectall_arrayref($sqlquery) or print "Error... ".$dbh->errstr."<BR>";

    $rescount = scalar @{$doc_id_ref}; 


}
#===================================================================

sub print_results {

    for ($i=$stpos; $i<$stpos+$res_num; $i++) {
        if ($i == $rescount) {last};

        $doc_id = ${${$doc_id_ref}[$i]}[0];
#        print "<BR>Doc_ID = $doc_id<BR>";
        $sqlquery = "SELECT filename, file_size, title, description FROM documents WHERE document_id='$doc_id'";
        ($url, $size, $title, $description) = $dbh->selectrow_array($sqlquery);
        
        print &print_template("results");
    };  # for

    if ($rescount <= $res_num) {$next_results = ""; return 1}
    

    my $mhits = 20 * $res_num;
    my $pos2 = $stpos - $stpos % $mhits;
    my $pos1 = $pos2 - $mhits;
    my $pos3 = $pos2 + $mhits;

    if ($pos1 < 0) { my $prev = "" }
    else {
        $prev = " <A HREF=search.pl?query=".$ndquery."\&stpos=".$pos1."\&stype=".$stype;
        $prev .= ">PREV</A> \n";
    }

    if ($pos3 > $rescount) { my $next = "" }
    else {
        $next = " <A HREF=search.pl?query=".$ndquery."\&stpos=".$pos3."\&stype=".$stype;
        $next .= ">NEXT</A> \n";
    }

    $next_results .= $prev;
    $next_results .=  " |\n";
    for ($i=$pos2; $i<$pos3; $i += $res_num) {
       if ($i >= $rescount) {last}
       $page_number = $i/$res_num+1;
       if ( $i != $stpos ) {
           $next_results .=  "<A HREF=search.pl?query=".$ndquery."\&stpos=".$i."\&stype=".$stype;
           $next_results .=  ">".$page_number."</A> |\n";
       } else {
           $next_results .=  $page_number." |\n";
       }
    }
    $next_results .=  $next;
}
#===================================================================

sub read_template {
    my ($filename) = @_;
    
    open TEMPLATE, $filename or print "Could not find template";
    local $/;
    my $template = <TEMPLATE>;
    close(TEMPLATE);
    
    while ( $template =~ m|<!-- RiSearch::([^:]+?)::start -->(.*?)<!-- RiSearch::\1::end -->|gs) {
    	$templates{$1} = $2;
    }   
    return 1;
}
#===================================================================

sub print_template {
    my $part = shift;
    my $template = $templates{$part};      
    my $rand_number = int (rand(256));
    
    $template =~ s|%query%|$query|gs;
    $template =~ s|%search_time%|$search_time|gs;
    $template =~ s|%query_statistics%|$query_statistics|gs;
    $template =~ s|%stpos%|$stpos+1|egs;
    $template =~ s|%url%|$url|gs;
    $template =~ s|%title%|$title|gs;
    $template =~ s|%size%|$size|gs;
    $template =~ s|%description%|$description|gs;
    $template =~ s|%rescount%|$rescount|gs;
    $template =~ s|%next_results%|$next_results|gs;
    $template =~ s|%rand_number%|$rand_number|gs;
    $template =~ s|%right_form\((.*?)\)%|&right_form($1)|egs;
    
    return $template;
}
#===================================================================

sub urldecode{    
 local($val)=@_;  
 $val=~s/\+/ /g;
 $val=~s/%([0-9A-H]{2})/pack('C',hex($1))/ge;
 return $val;
}
#===================================================================

sub my_die {
   my ($str) = @_;
   print "$str\n";
   die
}
#===================================================================

sub right_form {
    my ($words) = @_;
    my $dum = $rescount % 10;
    $words =~ /"([^"]+)","([^"]+)","([^"]+)"/;
    my $w1 = $1; my $w2 = $2; my $w3 = $3;
    my $f = $w3;
    if ($dum == 1) {$f = $w1};
    if (($dum>1) && ($dum<5)) {$f = $w2};
    $dum = $rescount % 100;
    if (($dum>10) && ($dum<15)) {$f = $w3};
    return $f;
}
#===================================================================
