package com.ibm.almaden.ejb.session;

/*
**  Licensed Materials - Property of IBM
**
**  (C) COPYRIGHT IBM Corp. 1999-2001  All rights reserved
**
**  US Government Users Restricted Rights - Use, duplication or
**  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
**
**/

import java.util.Properties;
import javax.ejb.*;
import java.lang.*;

import java.rmi.*;
import java.util.*;
import java.sql.*;
import javax.naming.*;
import com.ibm.almaden.ejbmaker.*;

import org.w3c.dom.*;

// Home object pool

import com.ibm.almaden.ejb.HomePool.*;

//Entity Beans (Alphabetic)
import com.ibm.almaden.ejb.Attendee.*;
import com.ibm.almaden.ejb.Event.*;
import com.ibm.almaden.ejb.Person.*;
import com.ibm.almaden.ejb.Role.*;
import com.ibm.almaden.ejb.Timezone.*;


/**
 * Simple stateless session ejb 
 * 
 * @author <A HREF="mailto:edlund@almaden.ibm.com"> Stefan Edlund</A>
 **/

 
public class SessionBean implements javax.ejb.SessionBean {
	private javax.ejb.SessionContext mySessionCtx = null;

	// Home pool
	
	private HomeObjectPool homePool = null;
	
	// Home interfaces
	
	PersonHome personHome;
	EventHome eventHome;
	
	/**
	 * createThings. Create simple calendar data
	 *
	 */
	
	public EventXMLAdaptor createThings() throws javax.ejb.EJBException, CreateException, FinderException, RemoveException {			
		/*try {
			PersonHelper personHelper = PersonHelper.getInstance();
			EventHelper eventHelper= EventHelper.getInstance();
																
			// First create a person
	
			PersonXMLAdaptor person = new PersonXMLAdaptor();
			person.setFIRSTNAME("Joe");
			person.setLASTNAME("Schmoe");
			person.setID("joe");
		
			Enumeration en = TimezoneXMLAdaptor.findByTZ("PST");
			String tz = null;
			if(en.hasMoreElements()) {
				TimezoneXMLAdaptor tz_adaptor = (TimezoneXMLAdaptor)en.nextElement();
				tz = tz_adaptor.getPrimaryKey();
			}
			person.setTZ(tz);
			person = personHelper.create(person);
		
		
			// Create a calendar event, adding a person as an attendee of the event
		
			EventXMLAdaptor evt = new EventXMLAdaptor();
			evt.setSUMMARY("This is the summary");
			evt.setDTSTART(new java.sql.Timestamp(new java.util.Date().getTime()));
			evt.setDTEND(new java.sql.Timestamp(new java.util.Date().getTime()+3600000));
		
			// Add attendee
		
			AttendeeXMLAdaptor attendee = evt.addAttendee(person.getPrimaryKey());
		
			// Set role type
		
			en = RoleXMLAdaptor.findByRoleType("Chair");
			String rt = null;
			if(en.hasMoreElements()) {
				RoleXMLAdaptor rt_adaptor = (RoleXMLAdaptor)en.nextElement();
				rt = rt_adaptor.getPrimaryKey();
			}
			attendee.setRole(rt);
		
			// Create event
			evt = eventHelper.create(evt);
		
			return evt;
		} catch(RemoteException re) {
			throw new javax.ejb.EJBException(re.getMessage());			
		}*/
		return null;
	}
	
	 /**
	 * findThings. 
	 *
	 */
	
	public Enumeration findThings() throws javax.ejb.EJBException, FinderException {	
		try {
			Enumeration events = eventHome.findAllInstances();
			SerializableEnumeration se = new SerializableEnumeration();
			EventHelper eventHelper = EventHelper.getInstance();
			while(events.hasMoreElements()) {
				Event evt = (Event)javax.rmi.PortableRemoteObject.narrow(events.nextElement(), Event.class);
				EventXMLAdaptor adaptor = new EventXMLAdaptor(evt);
				// Expand to level 1:
				adaptor = eventHelper.expand(adaptor, 1);
				se.add(adaptor);
			}
			return se;
		} catch(RemoteException re) {
			throw new javax.ejb.EJBException(re.getMessage());			
		}
	}
	
	 /**
	 * removeThings. Remove what was created
	 *
	 */
	
	public void removeThings() throws javax.ejb.EJBException, FinderException, RemoveException
	{	
		try {
			EventHelper eventHelper = EventHelper.getInstance();
			PersonHelper personHelper = PersonHelper.getInstance();
					
			Enumeration en = eventHome.findAllInstances();
			while(en.hasMoreElements()) {
				Event evt = (Event)javax.rmi.PortableRemoteObject.narrow(en.nextElement(), Event.class);
				EventXMLAdaptor adaptor = new EventXMLAdaptor(evt);
				eventHelper.remove(adaptor);
			}
		
			en = personHome.findAllInstances();
			while(en.hasMoreElements()) {
				Person p = (Person)javax.rmi.PortableRemoteObject.narrow(en.nextElement(), Person.class);
				PersonXMLAdaptor adaptor = new PersonXMLAdaptor(p);
				personHelper.remove(adaptor);
			}
		} catch(RemoteException re) {
			throw new javax.ejb.EJBException(re.getMessage());			
		}
	}
	
	/**
	* ejbActivate 
    * @exception java.rmi.RemoteException Thrown for multiple reasons (see exception message)
	*/
	public void ejbActivate() throws java.rmi.RemoteException {
	}

	
	
	/**
	* ejbCreate method. Retrieve all home interfaces the first time (these are static class members)
	*/

	public void ejbCreate()  {
		homePool = HomeObjectPool.getInstance();
		personHome = (PersonHome)homePool.get("Person");
		eventHome = (EventHome)homePool.get("Event");
	} // create
	
	
	
	
	/**
	* ejbPassivate Passivate the bean (not used)
    * @exception java.rmi.RemoteException Thrown for multiple reasons (see exception message)
	*/
	
	public void ejbPassivate() throws java.rmi.RemoteException {
	}
	
	
	
	/**
	* ejbRemove Remove the bean
    * @exception java.rmi.RemoteException Thrown for multiple reasons (see exception message)
	*/
	
	public void ejbRemove() throws java.rmi.RemoteException {
		homePool.release(personHome);
		homePool.release(eventHome);
	}

	/**
	* setSessionContext Called by the container when the bean is moved into the pooled state
	*/
	public void setSessionContext(javax.ejb.SessionContext ctx) throws java.rmi.RemoteException {
		mySessionCtx = ctx;
	}
} // SessionBean





