package com.ibm.almaden.client;

/*
**  Licensed Materials - Property of IBM
**
**  (C) COPYRIGHT IBM Corp. 1999-2001  All rights reserved
**
**  US Government Users Restricted Rights - Use, duplication or
**  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
**
**/


import java.util.*;
import javax.naming.*;
import com.ibm.almaden.ejb.Person.*;
import javax.transaction.*;
//import com.ibm.websphere.examples.Inc.*;
import com.ibm.almaden.ejb.Person.*;
import com.ibm.almaden.ejb.Event.*;
import com.ibm.almaden.ejb.Attendee.*;
import com.ibm.almaden.ejb.Role.*;
import com.ibm.almaden.ejb.Timezone.*;
import com.ibm.almaden.ejb.HomePool.*;
import org.w3c.dom.*;
import org.apache.xml.serialize.*;
import java.io.*;

/**
 * Simple client. An Person EJB and an Event EJB is created, expanded and removed using helper classes.
 * 
 * @author <A HREF="mailto:edlund@almaden.ibm.com"> Stefan Edlund</A>
 **/

 
public class Client {
	public static void main(String [] args) {
		try {
			
			// Retrieve helper classes
			EventHelper event_helper = EventHelper.getInstance();
			PersonHelper person_helper = PersonHelper.getInstance();
			AttendeeHelper attendee_helper = AttendeeHelper.getInstance();
			

			// First create a new person ejb
			
			PersonXMLAdaptor new_person = new PersonXMLAdaptor();
			new_person.setFIRSTNAME("Albert");
			new_person.setLASTNAME("Einstein");
			new_person.setID("albert");
			Enumeration en = TimezoneXMLAdaptor.findByTZ("PST");
			String tz_pk = null;
			if(en.hasMoreElements())
				tz_pk = ((TimezoneXMLAdaptor)en.nextElement()).getPrimaryKey();
			new_person.setTZ(tz_pk);
			
			// Create it. Set new_person to the returned XML adaptor now containing a primary key
			// value.
			new_person = person_helper.create(new_person);
			
			// Create an event and add the person as an attendee of the event
			EventXMLAdaptor new_event = new EventXMLAdaptor();
			new_event.setSUMMARY("Sample event");
			new_event.setDTSTART(new java.sql.Timestamp(new Date().getTime()));
			new_event.setDTEND(new java.sql.Timestamp(new Date().getTime()+3600000));
			// Add attendee
			AttendeeXMLAdaptor attnd =  new_event.addAttendee(new_person.getPrimaryKey());
			// Find the role type of the attendee
			en = RoleXMLAdaptor.findByRoleType("Chair");
			String rt_pk = null;
			if(en.hasMoreElements())
				rt_pk = ((RoleXMLAdaptor)en.nextElement()).getPrimaryKey();
			// Set the role type
			attnd.setRole(rt_pk);
			
			// Now create complex object (event and attende ejb)
			new_event = event_helper.create(new_event);
			
			Document doc = new_event.getXML();
			System.out.println("Created event: ");
			printDoc(doc);
			System.out.println("Result after expansion to level 1:");
			EventXMLAdaptor expanded_adaptor = event_helper.expand(new_event, 1);
			doc = expanded_adaptor.getXML();
			printDoc(doc);
		
			System.out.println("Result after expansion to level 2:");
			expanded_adaptor = event_helper.expand(new_event, 2);
			doc = expanded_adaptor.getXML();
			printDoc(doc);
	
			System.out.println("Result after expansion to level 3:");
			expanded_adaptor = event_helper.expand(new_event, 3);
			doc = expanded_adaptor.getXML();
			printDoc(doc);
	
			// Remove Event and Person
			
			event_helper.remove(new_event);
			person_helper.remove(new_person);
			
			System.out.println("\nEJB's removed");
		 } catch(Exception e) {
			 e.printStackTrace();
		 }
	}
	
	private static void printDoc(Document doc) throws IOException {
		StringWriter sw = new StringWriter();
		XMLSerializer serializer = new XMLSerializer(sw, new OutputFormat(doc, "UTF-8", true));
		serializer.serialize(doc);
		System.out.println(sw.toString());
	}
} // Client




