/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.almaden.ejbmaker;

import java.lang.reflect.Constructor;
import java.rmi.RemoteException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Properties;
import javax.ejb.EJBObject;
import javax.ejb.FinderException;
import javax.ejb.Handle;
import javax.ejb.RemoveException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Document;

public abstract class XMLAdaptor {
    public static final String _dateTimeFormat = "yyyy-MM-dd'T'HH:mm";
    public static final String _usdateTimeFormat = "MM/dd/yy HH:mm a";
    public static final String _dateFormat = "yyyy-MM-dd";
    public static final int YEAR = 0;
    public static final int MONTH = 1;
    public static final int DAYINMONTH = 2;
    public static final int HOURS = 3;
    public static final int MINUTES = 4;
    protected Handle handle = null;
    static /* synthetic */ Class class$java$lang$String;

    public abstract Document getXML();

    public abstract void initialize(EJBObject var1) throws RemoteException;

    public abstract void initialize(Document var1);

    public abstract void initialize(XMLAdaptor var1);

    protected Document createDocument() {
        return new DocumentImpl();
    }

    public void setHandle(Handle h) {
        this.handle = h;
    }

    public Handle getHandle() {
        return this.handle;
    }

    public static Object createNewInstance(String cl, String txt) {
        if (!cl.startsWith("java.")) {
            cl = "java.lang." + cl;
        }
        try {
            Class<?> objClass = Class.forName(cl);
            if (cl.equals("java.sql.Timestamp")) {
                Calendar cal = XMLAdaptor.convertToCalendar(txt);
                Class[] signature = new Class[]{Long.TYPE};
                Constructor<?> constr = objClass.getConstructor(signature);
                Object[] parms = new Object[]{new Long(cal.getTime().getTime())};
                Object obj = constr.newInstance(parms);
                return obj;
            }
            if (cl.equals("java.sql.Time")) {
                String hrs = "0";
                String min = "0";
                String sec = "0";
                int cind = txt.indexOf(58);
                if (cind > 0) {
                    hrs = txt.substring(0, cind);
                    String substr = txt.substring(cind + 1);
                    if ((cind = substr.indexOf(58)) > 0) {
                        min = substr.substring(0, cind);
                        sec = substr.substring(cind + 1);
                    }
                }
                int hrs_i = Integer.parseInt(hrs);
                int min_i = Integer.parseInt(min);
                int sec_i = Integer.parseInt(sec);
                Time time = new Time(hrs_i, min_i, sec_i);
                return time;
            }
            if (cl.equals("java.sql.Date")) {
                Calendar cal = XMLAdaptor.convertToCalendar(txt);
                Class[] signature = new Class[]{Long.TYPE};
                Constructor<?> constr = objClass.getConstructor(signature);
                Object[] parms = new Object[]{new Long(cal.getTime().getTime())};
                Object obj = constr.newInstance(parms);
                return obj;
            }
            Class[] signature = new Class[]{class$java$lang$String == null ? (class$java$lang$String = XMLAdaptor.class$("java.lang.String")) : class$java$lang$String};
            Constructor<?> constr = objClass.getConstructor(signature);
            Object[] parms = new Object[]{txt};
            Object obj = constr.newInstance(parms);
            return obj;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void remove() throws RemoteException, FinderException, RemoveException {
        if (this.handle == null) {
            System.err.println("??? " + this.getClass().getName() + ": Handle is null in remove().");
            EJBObject bean = this.findByPrimaryKey();
            if (bean != null) {
                bean.remove();
            }
        } else {
            this.handle.getEJBObject().remove();
        }
    }

    public abstract String getPrimaryKey();

    public String toString() {
        String fullName = this.getClass().getName();
        return fullName.substring(fullName.lastIndexOf(".") + 1, fullName.length()) + "[" + this.getPrimaryKey() + "]";
    }

    protected abstract EJBObject findByPrimaryKey() throws RemoteException, FinderException;

    protected Object getHome(String jndi_name, Class home_class) throws NamingException {
        InitialContext ic = null;
        Properties p = new Properties();
        ((Hashtable)p).put("java.naming.factory.initial", "com.ibm.ejs.ns.jndi.CNInitialContextFactory");
        ic = new InitialContext();
        Object obj = ic.lookup(jndi_name);
        return PortableRemoteObject.narrow((Object)ic.lookup(jndi_name), (Class)home_class);
    }

    public Integer getNonPrimitiveInstance(int p) {
        return new Integer(p);
    }

    public Boolean getNonPrimitiveInstance(boolean p) {
        return new Boolean(p);
    }

    public Character getNonPrimitiveInstance(char p) {
        return new Character(p);
    }

    public Byte getNonPrimitiveInstance(byte p) {
        return new Byte(p);
    }

    public Short getNonPrimitiveInstance(short p) {
        return new Short(p);
    }

    public Long getNonPrimitiveInstance(long p) {
        return new Long(p);
    }

    public Float getNonPrimitiveInstance(float p) {
        return new Float(p);
    }

    public Double getNonPrimitiveInstance(double p) {
        return new Double(p);
    }

    public Object getNonPrimitiveInstance(Object o) {
        return o;
    }

    public String createXMLText(Object obj) {
        if (obj instanceof Timestamp) {
            return XMLAdaptor.convertSQLtoISO8601((Timestamp)obj);
        }
        if (obj instanceof Time) {
            return XMLAdaptor.convertSQLTimetoISO8601((Time)obj);
        }
        if (obj instanceof Date) {
            return XMLAdaptor.convertSQLDatetoISO8601((Date)obj);
        }
        return obj.toString();
    }

    public static String convertSQLtoISO8601(Timestamp ts) {
        int year = new Integer(XMLAdaptor.getPiece(ts, 0));
        int month = new Integer(XMLAdaptor.getPiece(ts, 1));
        int date = new Integer(XMLAdaptor.getPiece(ts, 2));
        int hours = new Integer(XMLAdaptor.getPiece(ts, 3));
        int mins = new Integer(XMLAdaptor.getPiece(ts, 4));
        return year + "-" + (month < 10 ? "0" : "") + month + "-" + (date < 10 ? "0" : "") + date + "T" + (hours < 10 ? "0" : "") + hours + ":" + (mins < 10 ? "0" : "") + mins;
    }

    public static String convertSQLTimetoISO8601(Time ts) {
        int hours = new Integer(XMLAdaptor.getPiece(ts, 3));
        int mins = new Integer(XMLAdaptor.getPiece(ts, 4));
        return (hours < 10 ? "0" : "") + hours + ":" + (mins < 10 ? "0" : "") + mins;
    }

    public static String convertSQLDatetoISO8601(Date ts) {
        int year = new Integer(XMLAdaptor.getPiece(ts, 0));
        int month = new Integer(XMLAdaptor.getPiece(ts, 1));
        int date = new Integer(XMLAdaptor.getPiece(ts, 2));
        return year + "-" + (month < 10 ? "0" : "") + month + "-" + (date < 10 ? "0" : "") + date;
    }

    public static Calendar convertToCalendar(String dateStamp) {
        if (dateStamp == null) {
            return null;
        }
        SimpleDateFormat dateTimeFormatter = new SimpleDateFormat(_dateTimeFormat);
        SimpleDateFormat dateFormatter = new SimpleDateFormat(_dateFormat);
        SimpleDateFormat usDateFormat = new SimpleDateFormat(_usdateTimeFormat);
        try {
            dateTimeFormatter.parse(dateStamp);
            return dateTimeFormatter.getCalendar();
        }
        catch (Exception e) {
            try {
                dateFormatter.parse(dateStamp);
                return dateFormatter.getCalendar();
            }
            catch (Exception pe) {
                try {
                    usDateFormat.parse(dateStamp);
                    return usDateFormat.getCalendar();
                }
                catch (Exception use) {
                    System.err.println("Error, cannot parse date-time format");
                    use.printStackTrace();
                    return Calendar.getInstance();
                }
            }
        }
    }

    public static String getPiece(Timestamp sqlTime, int what) {
        String thing = sqlTime.toString();
        int jj = 0;
        int ii = 0;
        switch (what) {
            case 0: {
                jj = thing.indexOf("-");
                ii = 0;
                break;
            }
            case 1: {
                ii = thing.indexOf("-");
                jj = thing.indexOf("-", ++ii);
                break;
            }
            case 2: {
                ii = thing.lastIndexOf("-");
                jj = thing.indexOf(" ", ++ii);
                break;
            }
            case 3: {
                ii = thing.indexOf(" ");
                ++ii;
                jj = thing.indexOf(":");
                break;
            }
            case 4: {
                ii = thing.indexOf(":");
                jj = thing.indexOf(":", ++ii);
                break;
            }
            default: {
                return null;
            }
        }
        return thing.substring(ii, jj);
    }

    public static String getPiece(Time sqlTime, int what) {
        String thing = sqlTime.toString();
        int jj = 0;
        int ii = 0;
        switch (what) {
            case 3: {
                ii = thing.indexOf(" ");
                ++ii;
                jj = thing.indexOf(":");
                break;
            }
            case 4: {
                ii = thing.indexOf(":");
                jj = thing.indexOf(":", ++ii);
                break;
            }
            default: {
                return null;
            }
        }
        return thing.substring(ii, jj);
    }

    public static String getPiece(Date sqlTime, int what) {
        String thing = sqlTime.toString();
        int jj = 0;
        int ii = 0;
        switch (what) {
            case 0: {
                jj = thing.indexOf("-");
                ii = 0;
                break;
            }
            case 1: {
                ii = thing.indexOf("-");
                jj = thing.indexOf("-", ++ii);
                break;
            }
            case 2: {
                ii = thing.lastIndexOf("-");
                ++ii;
                jj = thing.length();
                break;
            }
            default: {
                return null;
            }
        }
        return thing.substring(ii, jj);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

