/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.almaden.ejbmaker;

import com.ibm.almaden.ejbmaker.EJBCollection;
import com.ibm.almaden.ejbmaker.EJBDescription;
import com.ibm.almaden.ejbmaker.EJBGenerator;
import com.ibm.almaden.ejbmaker.EJBRelation;
import com.ibm.almaden.ejbmaker.EJBSourceGenerator;
import com.ibm.almaden.ejbmaker.PersistantField;
import com.ibm.almaden.ejbmaker.SmartWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class SQLCreateStatementGenerator
implements EJBGenerator {
    private String rdb_source_folder;
    private EJBCollection ejbCollection;

    public SQLCreateStatementGenerator(String source, EJBCollection coll) {
        this.rdb_source_folder = source;
        this.ejbCollection = coll;
    }

    public void generate() throws IOException {
        String merged_file_name = this.rdb_source_folder + File.separator + "CreateTables.ddl";
        SmartWriter merged_sw = new SmartWriter(merged_file_name);
        FileWriter mfw = merged_sw.createFile();
        int i = 0;
        while (i < this.ejbCollection.getNufDescriptions()) {
            EJBDescription ejbDesc = this.ejbCollection.getNthDescription(i);
            String bean_name = ejbDesc.getBeanName();
            String rdb_file_name = this.rdb_source_folder + File.separator + "Create" + bean_name + ".ddl";
            SmartWriter sw = new SmartWriter(rdb_file_name);
            FileWriter fw = sw.createFile();
            this.writeDescriptionSouce(fw, mfw, ejbDesc);
            sw.copyAndClose();
            ++i;
        }
        int i2 = 0;
        while (i2 < this.ejbCollection.getNufRelations()) {
            EJBRelation ejbRel = this.ejbCollection.getNthRelation(i2);
            String bean_name = ejbRel.getBeanName();
            String rdb_file_name = this.rdb_source_folder + File.separator + "Create" + bean_name + ".ddl";
            SmartWriter sw = new SmartWriter(rdb_file_name);
            FileWriter fw = sw.createFile();
            this.writeRelationSouce(fw, mfw, ejbRel);
            sw.copyAndClose();
            ++i2;
        }
        merged_sw.copyAndClose();
    }

    private void writeDescriptionSouce(FileWriter fw, FileWriter mfw, EJBDescription ejbDesc) throws IOException {
        String name = ejbDesc.getBeanName();
        if (EJBSourceGenerator.version < 4) {
            fw.write("CREATE TABLE EJB." + name + " (\t\t\\\n ");
            mfw.write("CREATE TABLE EJB." + name + " (\t\t\\\n ");
        } else {
            fw.write("CREATE TABLE " + name + " (\t\t\\\n ");
            mfw.write("CREATE TABLE " + name + " (\t\t\\\n ");
        }
        fw.write("\tprimaryKey\t\tVARCHAR(56) NOT NULL,\t\t\\\n");
        mfw.write("\tprimaryKey\t\tVARCHAR(56) NOT NULL,\t\t\\\n");
        int i = 0;
        while (i < ejbDesc.getPersistantFieldCollection().getNufPersistantFields()) {
            PersistantField pf = ejbDesc.getPersistantFieldCollection().getNthPersistantField(i);
            fw.write("\t" + pf.getFieldName() + "\t" + pf.getRDBType() + ",\t\t\\\n");
            mfw.write("\t " + pf.getFieldName() + "\t " + pf.getRDBType() + ",\t\t \\\n");
            ++i;
        }
        if (ejbDesc.getBeanType().equalsIgnoreCase("topic")) {
            fw.write("   REC_CRTD   TIMESTAMP,        \\\n");
            mfw.write("   REC_CRTD   TIMESTAMP,        \\\n");
        }
        if (ejbDesc.needsEncryption()) {
            fw.write("\tCRYPTKEY\tVARCHAR(251), \\\n");
            mfw.write("\tCRYPTKEY\tVARCHAR(251), \\\n");
        }
        fw.write("\tPRIMARY KEY\t\t(primaryKey)\t\t\\\n");
        mfw.write("\t PRIMARY KEY\t\t(primaryKey)\t\t\\\n");
        fw.write(")");
        mfw.write(")");
        mfw.write("\n\n");
    }

    private void writeRelationSouce(FileWriter fw, FileWriter mfw, EJBRelation ejbRel) throws IOException {
        String name = ejbRel.getBeanName();
        if (EJBSourceGenerator.version < 4) {
            fw.write("CREATE TABLE EJB." + name + " (\t\t\\\n ");
            mfw.write("CREATE TABLE EJB." + name + " (\t\t \\\n ");
        } else {
            fw.write("CREATE TABLE " + name + " (\t\t\\\n ");
            mfw.write("CREATE TABLE " + name + " (\t\t \\\n ");
        }
        fw.write("\tprimaryKey\t\tVARCHAR(56) NOT NULL,\t\t\\\n");
        mfw.write("\t primaryKey\t\tVARCHAR(56) NOT NULL,\t\t\\\n");
        fw.write("\t" + ejbRel.getFirstPField() + "\t\tVARCHAR(56),\t\t\\\n");
        mfw.write("  " + ejbRel.getFirstPField() + "\t\tVARCHAR(56),\t\t\\\n");
        fw.write("\t" + ejbRel.getSecondPField() + "\tVARCHAR(56),\t\t\\\n");
        mfw.write("\t " + ejbRel.getSecondPField() + "\tVARCHAR(56),\t\t\\\n");
        int i = 0;
        while (i < ejbRel.getPersistantFieldCollection().getNufPersistantFields()) {
            PersistantField pf = ejbRel.getPersistantFieldCollection().getNthPersistantField(i);
            fw.write("\t" + pf.getFieldName() + "\t" + pf.getRDBType() + ",\t\t\\\n");
            mfw.write("\t " + pf.getFieldName() + "\t " + pf.getRDBType() + ",\t\t \\\n");
            ++i;
        }
        if (ejbRel.needsEncryption()) {
            fw.write("\tCRYPTKEY\tVARCHAR(251), \\\n");
            mfw.write("\tCRYPTKEY\tVARCHAR(251), \\\n");
        }
        fw.write("\tPRIMARY KEY\t\t(primaryKey)\t\t\\\n");
        mfw.write("\t PRIMARY KEY\t\t(primaryKey)\t\t\\\n");
        fw.write(")");
        mfw.write(")");
        mfw.write("\n\n");
    }
}

