/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.almaden.ejbmaker;

import com.ibm.almaden.ejbmaker.EJBCollection;
import com.ibm.almaden.ejbmaker.EJBDescription;
import com.ibm.almaden.ejbmaker.EJBGenerator;
import com.ibm.almaden.ejbmaker.EJBRelation;
import com.ibm.almaden.ejbmaker.EJBSourceGenerator;
import com.ibm.almaden.ejbmaker.SmartWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class SQLCreateIndexStatGenerator
implements EJBGenerator {
    private String rdb_source_folder;
    private EJBCollection ejbCollection;

    public SQLCreateIndexStatGenerator(String source, EJBCollection coll) {
        this.rdb_source_folder = source;
        this.ejbCollection = coll;
    }

    public void generate() throws IOException {
        String file_name = this.rdb_source_folder + File.separator + "RunStats.ddl";
        SmartWriter sw = new SmartWriter(file_name);
        FileWriter mfw = sw.createFile();
        int i = 0;
        while (i < this.ejbCollection.getNufDescriptions()) {
            EJBDescription ejbDesc = this.ejbCollection.getNthDescription(i);
            String bean_name = ejbDesc.getBeanName();
            this.writeDescriptionSource(mfw, ejbDesc);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.ejbCollection.getNufRelations()) {
            EJBRelation ejbRel = this.ejbCollection.getNthRelation(i2);
            String bean_name = ejbRel.getBeanName();
            this.writeRelationSource(mfw, ejbRel);
            ++i2;
        }
        sw.copyAndClose();
    }

    private void writeDescriptionSource(FileWriter fw, EJBDescription ejbDesc) throws IOException {
        String name = ejbDesc.getBeanName();
        if (EJBSourceGenerator.version < 4) {
            fw.write("runstats on table ejb." + name + " and indexes all\n");
        } else {
            fw.write("runstats on table " + name + " and indexes all\n");
        }
    }

    private void writeRelationSource(FileWriter fw, EJBRelation ejbRel) throws IOException {
        String name = ejbRel.getBeanName();
        if (EJBSourceGenerator.version < 4) {
            fw.write("runstats on table ejb." + name + " and indexes all\n");
        } else {
            fw.write("runstats on table " + name + " and indexes all\n");
        }
    }
}

