/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.almaden.ejbmaker;

import com.ibm.almaden.ejbmaker.EJBCollection;
import com.ibm.almaden.ejbmaker.EJBDescription;
import com.ibm.almaden.ejbmaker.EJBGenerator;
import com.ibm.almaden.ejbmaker.EJBRelation;
import com.ibm.almaden.ejbmaker.EJBSourceGenerator;
import com.ibm.almaden.ejbmaker.SmartWriter;
import com.ibm.almaden.ejbmaker.SourceFooterWriter;
import com.ibm.almaden.ejbmaker.SourceHeaderWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class HomePoolGenerator
implements EJBGenerator {
    private String java_source_folder;
    private String package_name;
    private EJBCollection ejbCollection;

    public HomePoolGenerator(String source, String pname, EJBCollection coll) {
        this.java_source_folder = source;
        this.package_name = pname;
        this.ejbCollection = coll;
    }

    public void generate() throws IOException {
        String java_file_name = this.java_source_folder + File.separator + "HomePool" + File.separator + "HomeObjectPool.java";
        SmartWriter sw = new SmartWriter(java_file_name);
        FileWriter fw = sw.createFile();
        this.writeSource(fw);
        sw.copyAndClose();
    }

    private void writeSource(FileWriter fw) throws IOException {
        fw.write("package " + this.package_name + ".HomePool;\n\n");
        SourceHeaderWriter.writeHeader(fw);
        fw.write("\n");
        fw.write("\timport java.io.*;\n");
        fw.write("\timport javax.naming.*;\n");
        fw.write("\timport javax.ejb.*;\n");
        fw.write("\timport java.util.*;\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* HomeObjectPool. \n");
        fw.write("\t* \n");
        fw.write("\t* The home object pool initializes a pool containing client side home objects for all beans in a project.\n");
        fw.write("\t* It enables quick retrieval and release of home objects when required by client applications.\n");
        fw.write("\t* \n");
        fw.write("\t* @author This file was generated\n");
        fw.write("\t*/\n");
        fw.write("\tpublic class HomeObjectPool\n");
        fw.write("\t{\n");
        int i = 0;
        while (i < this.ejbCollection.getNufDescriptions()) {
            EJBDescription desc = this.ejbCollection.getNthDescription(i);
            String name = desc.getBeanName();
            fw.write("\t\tprivate java.util.Vector " + name + "HomeObjects = new java.util.Vector();\n");
            ++i;
        }
        int i2 = 0;
        while (i2 < this.ejbCollection.getNufRelations()) {
            EJBRelation rel = this.ejbCollection.getNthRelation(i2);
            String name = rel.getBeanName();
            fw.write("\t\tprivate java.util.Vector " + name + "HomeObjects = new java.util.Vector();\n");
            ++i2;
        }
        fw.write("\t\tprivate javax.naming.InitialContext ic;\n");
        fw.write("\t\tprivate int initial_size;\n");
        fw.write("\t\tprivate static HomeObjectPool instance;\n\n");
        fw.write("\t\t/**\n");
        fw.write("\t\t* Constructor. Takes the size as argument\n");
        fw.write("\t\t* \n");
        fw.write("\t\t* @param size Size of pool (in instances for each bean type)\n");
        fw.write("\t\t*/\n");
        fw.write("\t\tprivate HomeObjectPool(int size) {\n");
        fw.write("\t\tinitial_size = size;\n");
        if (EJBSourceGenerator.version == 3) {
            fw.write("\t\tProperties p = new Properties();\n");
            fw.write("\t\tp.put(Context.INITIAL_CONTEXT_FACTORY, \"com.ibm.ejs.ns.jndi.CNInitialContextFactory\");\n");
            fw.write("\t\tp.put(Context.PROVIDER_URL, \"IIOP:///\");\n");
            fw.write("\t\ttry { \n");
            fw.write("\t\t\tic = new InitialContext(p);\n\n");
            fw.write("\t\t} catch(javax.naming.NamingException ne) {\n");
            fw.write("\t\t\tne.printStackTrace();\n");
            fw.write("\t\t}\n");
        } else {
            fw.write("\t\ttry {\n");
            fw.write("\t\t\tHashtable env = new Hashtable();\n");
            fw.write("\t\t\tenv.put(Context.INITIAL_CONTEXT_FACTORY, \"com.ibm.websphere.naming.WsnInitialContextFactory\");\n");
            fw.write("\t\t\tenv.put(Context.PROVIDER_URL, \"iiop:///\");\n");
            fw.write("\t\t\tic = new InitialContext(env);\n");
            fw.write("\t\t}\t\t\t\t\t\t\t\t\t\t// end try\n");
            fw.write("\t\t\tcatch (Exception ex)\n");
            fw.write("\t\t{\n");
            fw.write("\t\t\tex.printStackTrace();\n");
            fw.write("\t\t}\t\t\n");
        }
        int i3 = 0;
        while (i3 < this.ejbCollection.getNufDescriptions()) {
            EJBDescription desc = this.ejbCollection.getNthDescription(i3);
            String name = desc.getBeanName();
            fw.write("\t\texpandPool(\"" + name + "\", " + this.package_name + "." + name + "." + name + "Home.class, " + name + "HomeObjects, size);\n");
            ++i3;
        }
        int i4 = 0;
        while (i4 < this.ejbCollection.getNufRelations()) {
            EJBRelation rel = this.ejbCollection.getNthRelation(i4);
            String name = rel.getBeanName();
            fw.write("\t\texpandPool(\"" + name + "\", " + this.package_name + "." + name + "." + name + "Home.class, " + name + "HomeObjects, size);\n");
            ++i4;
        }
        fw.write("\t} //HomeObjectPool\n");
        fw.write("\t/**\n");
        fw.write("\t* getInstance. Use default size of 50\n");
        fw.write("\t* \n");
        fw.write("\t* @return HomeObjectPool\n");
        fw.write("\t*/\n\n");
        fw.write("\tpublic static HomeObjectPool getInstance() {\n");
        fw.write("\tif(instance == null)\n");
        fw.write("\t\tinstance = new HomeObjectPool(50);\n");
        fw.write("\treturn instance;\n");
        fw.write("\t}\n\n");
        fw.write("\t/**\n");
        fw.write("\t* getInstance. Get instance using the specified pool size. \n");
        fw.write("\t* \n");
        fw.write("\t* @param size Size of pool (in number of home objects for each bean)\n");
        fw.write("\t* @return HomeObjectPool\n");
        fw.write("\t*/\n\n");
        fw.write("\tpublic static HomeObjectPool getInstance(int size) {\n");
        fw.write("\t\tif(instance == null)\n");
        fw.write("\t\t\tinstance = new HomeObjectPool(size);\n");
        fw.write("\t\treturn instance;\n");
        fw.write("\t}\n\n");
        fw.write("\t/**\n");
        fw.write("\t* get. Return a home interface for the specified bean (JNDI name)\n");
        fw.write("\t* \n");
        fw.write("\t* @param bean (JNDI name)\n");
        fw.write("\t* @return javax.ejb.EJBHome Home interface\n");
        fw.write("\t*/\n\n");
        fw.write("\tpublic javax.ejb.EJBHome get(String jndi) {\n");
        int i5 = 0;
        while (i5 < this.ejbCollection.getNufDescriptions()) {
            EJBDescription desc = this.ejbCollection.getNthDescription(i5);
            String name = desc.getBeanName();
            fw.write("\tif(jndi.equals(\"" + name + "\")) {\n");
            fw.write("\t\tif(" + name + "HomeObjects.size() == 0) \n");
            fw.write("\t\t\texpandPool(\"" + name + "\", " + this.package_name + "." + name + "." + name + "Home.class, " + name + "HomeObjects, initial_size);\n");
            fw.write("\t\tjavax.ejb.EJBHome home = (javax.ejb.EJBHome)" + name + "HomeObjects.get(" + name + "HomeObjects.size()-1);\n");
            fw.write("\t\treturn home;\n");
            if (i5 < this.ejbCollection.getNufDescriptions() - 1) {
                fw.write("\t} else\n");
            } else {
                fw.write("}\n");
            }
            ++i5;
        }
        int i6 = 0;
        while (i6 < this.ejbCollection.getNufRelations()) {
            EJBRelation rel = this.ejbCollection.getNthRelation(i6);
            String name = rel.getBeanName();
            if (this.ejbCollection.getNufDescriptions() > 0) {
                fw.write("\telse if(jndi.equals(\"" + name + "\")) {\n");
            } else {
                fw.write("\tif(jndi.equals(\"" + name + "\")) {\n");
            }
            fw.write("\t\tif(" + name + "HomeObjects.size() == 0) \n");
            fw.write("\t\t\texpandPool(\"" + name + "\", " + this.package_name + "." + name + "." + name + "Home.class, " + name + "HomeObjects, initial_size);\n");
            fw.write("\t\tjavax.ejb.EJBHome home = (javax.ejb.EJBHome)" + name + "HomeObjects.get(" + name + "HomeObjects.size()-1);\n");
            fw.write("\t\treturn home;\n");
            fw.write("\t}\n");
            ++i6;
        }
        fw.write("\treturn null;\n");
        fw.write("\t}\n\n");
        int i7 = 0;
        while (i7 < this.ejbCollection.getNufDescriptions()) {
            EJBDescription desc = this.ejbCollection.getNthDescription(i7);
            String name = desc.getBeanName();
            fw.write("\n\t/**\n");
            fw.write("\t* release. Return a " + name + " home interface to the pool when it's not used anymore.\n");
            fw.write("\t* \n");
            fw.write("\t* @param home Home interface\n");
            fw.write("\t*/\n\n");
            fw.write("\tpublic void release(" + this.package_name + "." + name + "." + name + "Home home) {\n");
            fw.write("\t\t" + name + "HomeObjects.add(home);\n");
            fw.write("\t}\n");
            ++i7;
        }
        int i8 = 0;
        while (i8 < this.ejbCollection.getNufRelations()) {
            EJBRelation rel = this.ejbCollection.getNthRelation(i8);
            String name = rel.getBeanName();
            fw.write("\n\t/**\n");
            fw.write("\t* release. Return a " + name + " home interface to the pool when it's not used anymore.\n");
            fw.write("\t* \n");
            fw.write("\t* @param home Home interface\n");
            fw.write("\t*/\n\n");
            fw.write("\tpublic void release(" + this.package_name + "." + name + "." + name + "Home home) {\n");
            fw.write("\t\t" + name + "HomeObjects.add(home);\n");
            fw.write("\t}\n");
            ++i8;
        }
        fw.write("\t/**\n");
        fw.write("\t* expandPool. Expand the pool size for a home container\n");
        fw.write("\t* \n");
        fw.write("\t* @param name\n");
        fw.write("\t* @param home_class\n");
        fw.write("\t* @param container\n");
        fw.write("\t* @param size Size of increment\n");
        fw.write("\t*/\n\n");
        fw.write("\tprivate void expandPool(String name, Class home_class, java.util.Vector container, int size) {\n");
        fw.write("\tfor(int i=0;i<size;++i) {\n");
        fw.write("\t\ttry {\n");
        fw.write("\t\t\tObject obj = ic.lookup(name);\n");
        if (EJBSourceGenerator.version == 3) {
            fw.write("\t\t\tjavax.ejb.EJBHome home = (javax.ejb.EJBHome)javax.rmi.PortableRemoteObject.narrow(obj, home_class);\n");
        } else {
            fw.write("\t\t\tjavax.ejb.EJBHome home = (javax.ejb.EJBHome)javax.rmi.PortableRemoteObject.narrow((org.omg.CORBA.Object)obj, home_class);\n");
        }
        fw.write("\t\t\tcontainer.addElement(home);\n");
        fw.write("\t\t} catch(javax.naming.NamingException ne) {\n");
        fw.write("\t\t\tne.printStackTrace();\n");
        fw.write("\t\t}\n");
        fw.write("\t}\n");
        fw.write("\t}\n");
        fw.write("} // HomeObjectPool\n");
        SourceFooterWriter.writeFooter(fw);
    }
}

