/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.almaden.ejbmaker;

import com.ibm.almaden.ejbmaker.EJBCollection;
import com.ibm.almaden.ejbmaker.EJBDescription;
import com.ibm.almaden.ejbmaker.EJBGenerator;
import com.ibm.almaden.ejbmaker.EJBRelation;
import com.ibm.almaden.ejbmaker.EJBSourceGenerator;
import com.ibm.almaden.ejbmaker.PersistantField;
import com.ibm.almaden.ejbmaker.PersistantFieldCollection;
import com.ibm.almaden.ejbmaker.SmartWriter;
import com.ibm.almaden.ejbmaker.SourceFooterWriter;
import com.ibm.almaden.ejbmaker.SourceHeaderWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public class HelperGenerator
implements EJBGenerator {
    private String java_source_folder;
    private String package_name;
    private EJBCollection ejbCollection;

    public HelperGenerator(String source, String pname, EJBCollection coll) {
        this.java_source_folder = source;
        this.package_name = pname;
        this.ejbCollection = coll;
    }

    public void generate() throws IOException {
        int i = 0;
        while (i < this.ejbCollection.getNufDescriptions()) {
            EJBDescription ejbDesc = this.ejbCollection.getNthDescription(i);
            String bean_name = ejbDesc.getBeanName();
            String java_file_name = this.java_source_folder + File.separator + bean_name + File.separator + bean_name + "Helper.java";
            SmartWriter sw = new SmartWriter(java_file_name);
            FileWriter fw = sw.createFile();
            this.writeDescriptionSouce(fw, ejbDesc);
            sw.copyAndClose();
            ++i;
        }
        int i2 = 0;
        while (i2 < this.ejbCollection.getNufRelations()) {
            EJBRelation ejbRel = this.ejbCollection.getNthRelation(i2);
            String bean_name = ejbRel.getBeanName();
            String java_file_name = this.java_source_folder + File.separator + bean_name + File.separator + bean_name + "Helper.java";
            SmartWriter sw = new SmartWriter(java_file_name);
            FileWriter fw = sw.createFile();
            this.writeRelationSouce(fw, ejbRel);
            sw.copyAndClose();
            ++i2;
        }
    }

    private void writeDescriptionSouce(FileWriter fw, EJBDescription ejbDesc) throws IOException {
        String name = ejbDesc.getBeanName();
        fw.write("package " + this.package_name + "." + name + ";\n\n");
        SourceHeaderWriter.writeHeader(fw);
        fw.write("import java.util.*;\n");
        fw.write("import java.io.*;\n");
        fw.write("import " + this.package_name + ".HomePool.*;\n");
        PersistantFieldCollection col = ejbDesc.getPersistantFieldCollection();
        int i = 0;
        while (i < col.getNufPersistantFields()) {
            PersistantField f = col.getNthPersistantField(i);
            String fkey = f.getFKey();
            if (fkey != null && !fkey.trim().equals("")) {
                fw.write("import " + this.package_name + "." + fkey + ".*;\n");
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.ejbCollection.getNufRelations()) {
            EJBRelation rel = this.ejbCollection.getNthRelation(i2);
            String _name = rel.getBeanName();
            if (rel.getFirstBean().equals(name) || rel.getSecondBean().equals(name)) {
                fw.write("import " + this.package_name + "." + _name + ".*;\n");
            }
            ++i2;
        }
        fw.write("import com.ibm.almaden.ejbmaker.KeyGenerator;\n");
        fw.write("/**\n");
        fw.write("* " + name + "Helper. Helper class for " + name + " bean\n");
        fw.write("* \n");
        fw.write("*/\n\n");
        fw.write("public class " + name + "Helper extends com.ibm.almaden.ejbmaker.Helper\n");
        fw.write("{\n");
        fw.write("\tprivate static " + name + "Helper instance;\n\n");
        fw.write("\t/**\n");
        fw.write("\t* Constructor. Private\n");
        fw.write("\t*/\n\n");
        fw.write("\tprivate " + name + "Helper() {\n");
        fw.write("\t}\n\n");
        fw.write("\t/**\n");
        fw.write("\t* getInstance\n");
        fw.write("\t*/\n\n");
        fw.write("\tpublic static " + name + "Helper getInstance() {\n");
        fw.write("\tif (instance == null) \n");
        fw.write("\t\tinstance = new " + name + "Helper();\n");
        fw.write("\treturn instance;\n");
        fw.write("\t}\n\n");
        fw.write("\t/**\n");
        fw.write("\t* expand. Expand an " + name + "XMLAdaptor to the level specified\n");
        fw.write("\t* \n");
        fw.write("\t* @param adaptor " + name + "XMLadaptor to expand\n");
        fw.write("\t* @param level Expansion level\n");
        fw.write("\t*/\n\n");
        fw.write("\tpublic " + name + "XMLAdaptor expand(" + name + "XMLAdaptor adaptor, int level) throws javax.ejb.FinderException, java.rmi.RemoteException {\n");
        fw.write("\tif(level < 0) return adaptor; // no change\n");
        fw.write("\tHomeObjectPool pool = HomeObjectPool.getInstance();\n\n");
        fw.write("\t" + name + "Home " + name + "HomeObj = (" + name + "Home)pool.get(\"" + name + "\");\n");
        ArrayList<String> included = new ArrayList<String>();
        int i3 = 0;
        while (i3 < col.getNufPersistantFields()) {
            PersistantField f = col.getNthPersistantField(i3);
            String fkey = f.getFKey();
            if (!(this.ejbCollection.containsConstantDescription(fkey) || fkey == null || fkey.trim().equals("") || included.contains(fkey))) {
                fw.write("\t" + fkey + "Home " + fkey + "HomeObj = (" + fkey + "Home)pool.get(\"" + fkey + "\");\n");
                included.add(fkey);
            }
            ++i3;
        }
        int i4 = 0;
        while (i4 < this.ejbCollection.getNufRelations()) {
            EJBRelation rel = this.ejbCollection.getNthRelation(i4);
            String _name = rel.getBeanName();
            if (rel.getFirstBean().equals(name) || rel.getSecondBean().equals(name)) {
                fw.write("\t" + _name + "Home " + _name + "HomeObj = (" + _name + "Home)pool.get(\"" + _name + "\");\n");
            }
            ++i4;
        }
        fw.write("\tString primaryKey = adaptor.getPrimaryKey();\n");
        fw.write("\t" + name + " " + name + "_obj = " + name + "HomeObj.findByPrimaryKey(new " + name + "Key(primaryKey));\n\n");
        fw.write("\t// This is level 0.\n");
        fw.write("\t" + name + "XMLAdaptor " + name + "Adaptor = new " + name + "XMLAdaptor(" + name + "_obj);\n\n");
        fw.write("\t--level;\n");
        fw.write("\tif(level < 0) return adaptor;\n");
        int i5 = 0;
        while (i5 < col.getNufPersistantFields()) {
            PersistantField f = col.getNthPersistantField(i5);
            String fkey = f.getFKey();
            String pf_name = f.getFieldName();
            if (fkey != null && !fkey.trim().equals("")) {
                if (!this.ejbCollection.containsConstantDescription(fkey)) {
                    fw.write("\tif(" + name + "Adaptor.get" + f.getFieldName() + "() != null) { \n");
                    fw.write("\t\t" + fkey + " " + fkey + "Obj = " + fkey + "HomeObj.findByPrimaryKey(new " + fkey + "Key(" + name + "Adaptor.get" + f.getFieldName() + "()));\n");
                    fw.write("\t\t" + fkey + "XMLAdaptor " + fkey + "Adaptor = new " + fkey + "XMLAdaptor(" + fkey + "Obj);\n");
                    fw.write("\t\t" + fkey + "Helper " + fkey + "HelperObj = " + fkey + "Helper.getInstance();\n");
                    fw.write("\t\t" + fkey + "XMLAdaptor new" + fkey + "XMLAdaptor = " + fkey + "HelperObj.expand(" + fkey + "Adaptor, level);\n");
                    fw.write("\t\t" + name + "Adaptor.set" + pf_name + "Adaptor(new" + fkey + "XMLAdaptor);\n");
                    fw.write("\t}\n");
                } else {
                    fw.write("\tif(" + name + "Adaptor.get" + f.getFieldName() + "() != null) { \n");
                    fw.write("\t\t" + fkey + "XMLAdaptor " + fkey + "Adaptor = " + fkey + "XMLAdaptor.findByPrimaryKey(" + name + "Adaptor.get" + f.getFieldName() + "());\n");
                    fw.write("\t\t" + name + "Adaptor.set" + pf_name + "Adaptor(" + fkey + "Adaptor);\n");
                    fw.write("\t}\n");
                }
            }
            ++i5;
        }
        fw.write("\tEnumeration en;\n");
        int i6 = 0;
        while (i6 < this.ejbCollection.getNufRelations()) {
            EJBRelation rel = this.ejbCollection.getNthRelation(i6);
            String _name = rel.getBeanName();
            String suffix0 = "";
            String suffix1 = "";
            if (rel.getFirstBean().equals(rel.getSecondBean())) {
                suffix0 = "0";
                suffix1 = "1";
            }
            if (rel.getFirstBean().equals(name)) {
                fw.write("\ten = " + _name + "HomeObj.findBy" + name + suffix0 + "Ref(primaryKey);\n");
                fw.write("\twhile(en.hasMoreElements()) {\n");
                fw.write("\t\t" + _name + " " + _name + "Obj = (" + _name + ")javax.rmi.PortableRemoteObject.narrow(en.nextElement(), " + _name + ".class);\n");
                fw.write("\t\t" + _name + "XMLAdaptor " + _name + "Adaptor = new " + _name + "XMLAdaptor(" + _name + "Obj);\n");
                fw.write("\t\t" + _name + "Helper " + _name + "HelperObj = " + _name + "Helper.getInstance();\n");
                fw.write("\t\t" + _name + "XMLAdaptor expandedAdaptor = " + _name + "HelperObj.expand(" + _name + "Adaptor, level, adaptor);\n");
                fw.write("\t\t" + name + "Adaptor.add" + _name + suffix0 + "(expandedAdaptor);\n");
                fw.write("\t}\n");
            } else if (rel.getSecondBean().equals(name)) {
                fw.write("\ten = " + _name + "HomeObj.findBy" + name + suffix1 + "Ref(primaryKey);\n");
                fw.write("\twhile(en.hasMoreElements()) {\n");
                fw.write("\t\t" + _name + " " + _name + "Obj = (" + _name + ")javax.rmi.PortableRemoteObject.narrow(en.nextElement(), " + _name + ".class);\n");
                fw.write("\t\t" + _name + "XMLAdaptor " + _name + "Adaptor = new " + _name + "XMLAdaptor(" + _name + "Obj);\n");
                fw.write("\t\t" + _name + "Helper " + _name + "HelperObj = " + _name + "Helper.getInstance();\n");
                fw.write("\t\t" + _name + "XMLAdaptor expandedAdaptor = " + _name + "HelperObj.expand(" + _name + "Adaptor, level, adaptor);\n");
                fw.write("\t\t" + name + "Adaptor.add" + _name + suffix1 + "(expandedAdaptor);\n");
                fw.write("\t}\n");
            }
            ++i6;
        }
        fw.write("\tpool.release(" + name + "HomeObj);\n");
        int i7 = 0;
        while (i7 < this.ejbCollection.getNufRelations()) {
            EJBRelation rel = this.ejbCollection.getNthRelation(i7);
            String _name = rel.getBeanName();
            if (rel.getFirstBean().equals(name) || rel.getSecondBean().equals(name)) {
                fw.write("\tpool.release(" + _name + "HomeObj);\n");
            }
            ++i7;
        }
        included = new ArrayList();
        int i8 = 0;
        while (i8 < col.getNufPersistantFields()) {
            PersistantField f = col.getNthPersistantField(i8);
            String fkey = f.getFKey();
            if (!(this.ejbCollection.containsConstantDescription(fkey) || fkey == null || fkey.trim().equals("") || included.contains(fkey))) {
                fw.write("\tpool.release(" + fkey + "HomeObj);\n");
                included.add(fkey);
            }
            ++i8;
        }
        fw.write("\treturn " + name + "Adaptor;\n");
        fw.write("\t} // expand\n");
        fw.write("/**\n");
        fw.write("* remove. Remove instance of " + name + "\n");
        fw.write("*\n");
        fw.write("* @param " + name + " " + name + "XMLAdaptor\n");
        fw.write("*/\n\n");
        fw.write("public void remove(" + name + "XMLAdaptor " + name + ") throws javax.ejb.RemoveException, java.rmi.RemoteException, javax.ejb.FinderException {\n");
        fw.write("\tHomeObjectPool pool = HomeObjectPool.getInstance();\n");
        fw.write("\t" + name + "Home " + name + "HomeObj = (" + name + "Home)pool.get(\"" + name + "\");\n");
        int i9 = 0;
        while (i9 < this.ejbCollection.getNufRelations()) {
            EJBRelation rel = this.ejbCollection.getNthRelation(i9);
            String _name = rel.getBeanName();
            if (rel.getFirstBean().equals(name) || rel.getSecondBean().equals(name)) {
                fw.write("\t" + _name + "Home " + _name + "HomeObj = (" + _name + "Home)pool.get(\"" + _name + "\");\n");
            }
            ++i9;
        }
        fw.write("\t// Remove links first\n\n");
        fw.write("\tjava.util.Enumeration enum;\n");
        int i10 = 0;
        while (i10 < this.ejbCollection.getNufRelations()) {
            EJBRelation rel = this.ejbCollection.getNthRelation(i10);
            String _name = rel.getBeanName();
            String suffix0 = "";
            String suffix1 = "";
            if (rel.getFirstBean().equals(rel.getSecondBean())) {
                suffix0 = "0";
                suffix1 = "1";
            }
            if (rel.getFirstBean().equals(name)) {
                fw.write("\tenum = " + _name + "HomeObj.findBy" + name + suffix0 + "Ref(" + name + ".getPrimaryKey());\n");
                fw.write("\twhile(enum.hasMoreElements()) {\n");
                fw.write("\t\t" + _name + " " + _name + "Obj = (" + _name + ")javax.rmi.PortableRemoteObject.narrow(enum.nextElement(), " + _name + ".class);\n");
                fw.write("\t\t" + _name + "Obj.remove();\n");
                fw.write("\t};\n");
            }
            if (rel.getSecondBean().equals(name)) {
                fw.write("\tenum = " + _name + "HomeObj.findBy" + name + suffix1 + "Ref(" + name + ".getPrimaryKey());\n");
                fw.write("\twhile(enum.hasMoreElements()) {\n");
                fw.write("\t\t" + _name + " " + _name + "Obj = (" + _name + ")javax.rmi.PortableRemoteObject.narrow(enum.nextElement(), " + _name + ".class);\n");
                fw.write("\t\t" + _name + "Obj.remove();\n");
                fw.write("\t};\n");
            }
            ++i10;
        }
        fw.write("\t// finally remove the bean itself \n");
        fw.write("\t" + name + ".remove();\n");
        fw.write("\tpool.release(" + name + "HomeObj);\n");
        int i11 = 0;
        while (i11 < this.ejbCollection.getNufRelations()) {
            EJBRelation rel = this.ejbCollection.getNthRelation(i11);
            String _name = rel.getBeanName();
            if (rel.getFirstBean().equals(name) || rel.getSecondBean().equals(name)) {
                fw.write("\tpool.release(" + _name + "HomeObj);\n");
            }
            ++i11;
        }
        fw.write(" }//remove\n\n");
        fw.write("/**\n");
        fw.write("* create. Create new instance of an " + name + "\n");
        fw.write("*\n");
        fw.write("* @param " + name + " " + name + "XMLAdaptor\n");
        fw.write("* @return " + name + "XMLAdaptor with keys initialized. The method changes the\n");
        fw.write("*   " + name + " parameter and returns it.\n");
        fw.write("*/\n\n");
        if (EJBSourceGenerator.version < 4) {
            fw.write("public " + name + "XMLAdaptor create(" + name + "XMLAdaptor " + name + ") throws javax.ejb.CreateException, java.rmi.RemoteException {\n");
        } else {
            fw.write("public " + name + "XMLAdaptor create(" + name + "XMLAdaptor " + name + ") throws javax.ejb.CreateException, java.rmi.RemoteException, javax.ejb.EJBException {\n");
        }
        fw.write("\tHomeObjectPool pool = HomeObjectPool.getInstance();\n");
        fw.write("\t" + name + "Home " + name + "HomeObj = (" + name + "Home)pool.get(\"" + name + "\");\n");
        int i12 = 0;
        while (i12 < this.ejbCollection.getNufRelations()) {
            EJBRelation rel = this.ejbCollection.getNthRelation(i12);
            String _name = rel.getBeanName();
            if (rel.getFirstBean().equals(name) || rel.getSecondBean().equals(name)) {
                fw.write("\t" + _name + "Home " + _name + "HomeObj = (" + _name + "Home)pool.get(\"" + _name + "\");\n");
            }
            ++i12;
        }
        fw.write("\tKeyGenerator gen = KeyGenerator.getInstance();\n");
        fw.write("  String primaryKey = gen.generateNewKey();\n");
        fw.write("\t" + name + " " + name + "Obj = " + name + "HomeObj.create(new " + name + "Key(primaryKey));\n");
        fw.write("\t" + name + "Obj.initialize(" + name + ");\n\n");
        fw.write("\t" + name + ".initialize(" + name + "Obj);\n\n");
        fw.write("\t// Now initialize relationships\n\n");
        fw.write("\tjava.util.Iterator iter;\n");
        int i13 = 0;
        while (i13 < this.ejbCollection.getNufRelations()) {
            String pf_name;
            PersistantField f;
            int j;
            PersistantFieldCollection rcol;
            EJBRelation rel = this.ejbCollection.getNthRelation(i13);
            String _name = rel.getBeanName();
            String suffix0 = "";
            String suffix1 = "";
            if (rel.getFirstBean().equals(rel.getSecondBean())) {
                suffix0 = "0";
                suffix1 = "1";
            }
            if (rel.getFirstBean().equals(name)) {
                fw.write("\titer = " + name + ".get" + _name + suffix0 + "();\n");
                fw.write("\twhile(iter.hasNext()) {\n");
                fw.write("\t\t" + _name + "XMLAdaptor " + _name + "Adaptor = (" + _name + "XMLAdaptor)iter.next();\n");
                fw.write("\t\t" + _name + " " + _name + "Obj = " + _name + "HomeObj.create(new " + _name + "Key(gen.generateNewKey()));\n");
                fw.write("\t\t" + _name + "Obj.set" + rel.getSecondBean() + suffix0 + "Ref(" + _name + "Adaptor.get" + rel.getSecondBean() + suffix0 + "Ref());\n");
                fw.write("\t\t" + _name + "Obj.set" + rel.getFirstBean() + suffix1 + "Ref(primaryKey);\n");
                rcol = rel.getPersistantFieldCollection();
                j = 0;
                while (j < rcol.getNufPersistantFields()) {
                    f = rcol.getNthPersistantField(j);
                    pf_name = f.getFieldName();
                    fw.write("\t" + _name + "Obj.set" + pf_name + "(" + _name + "Adaptor.get" + pf_name + "());\n");
                    ++j;
                }
                fw.write("\t\t" + _name + "Adaptor.initialize(" + _name + "Obj);\n");
                fw.write("\t}\n");
            }
            if (rel.getSecondBean().equals(name)) {
                fw.write("\titer = " + name + ".get" + _name + suffix1 + "();\n");
                fw.write("\twhile(iter.hasNext()) {\n");
                fw.write("\t\t" + _name + "XMLAdaptor " + _name + "Adaptor = (" + _name + "XMLAdaptor)iter.next();\n");
                fw.write("\t\t" + _name + " " + _name + "Obj = " + _name + "HomeObj.create(new " + _name + "Key(gen.generateNewKey()));\n");
                fw.write("\t\t" + _name + "Obj.set" + rel.getSecondBean() + suffix0 + "Ref(primaryKey);\n");
                fw.write("\t\t" + _name + "Obj.set" + rel.getFirstBean() + suffix1 + "Ref(" + _name + "Adaptor.get" + rel.getFirstBean() + suffix1 + "Ref());\n");
                rcol = rel.getPersistantFieldCollection();
                j = 0;
                while (j < rcol.getNufPersistantFields()) {
                    f = rcol.getNthPersistantField(j);
                    pf_name = f.getFieldName();
                    fw.write("\t" + _name + "Obj.set" + pf_name + "(" + _name + "Adaptor.get" + pf_name + "());\n");
                    ++j;
                }
                fw.write("\t\t" + _name + "Adaptor.initialize(" + _name + "Obj);\n");
                fw.write("\t}\n");
            }
            ++i13;
        }
        fw.write("\tpool.release(" + name + "HomeObj);\n");
        int i14 = 0;
        while (i14 < this.ejbCollection.getNufRelations()) {
            EJBRelation rel = this.ejbCollection.getNthRelation(i14);
            String _name = rel.getBeanName();
            if (rel.getFirstBean().equals(name) || rel.getSecondBean().equals(name)) {
                fw.write("\tpool.release(" + _name + "HomeObj);\n");
            }
            ++i14;
        }
        fw.write("\treturn " + name + ";\n");
        fw.write(" }//create\n\n");
        fw.write("/**\n");
        fw.write("* update. Update top level " + name + ", remove and recreate all relationships\n");
        fw.write("*\n");
        fw.write("* @param " + name + " " + name + "XMLAdaptor\n");
        fw.write("* @param update " + name + "XMLAdaptor\n");
        fw.write("* @return " + name + "XMLAdaptor with keys and attributes updated. The method\n");
        fw.write("*   changes the update parameter and returns it. All relationships of " + name + "\n");
        fw.write("*   parameter, that should not be removed, must be part of the update parameter.\n");
        fw.write("*/\n\n");
        if (EJBSourceGenerator.version < 4) {
            fw.write("public " + name + "XMLAdaptor update(" + name + "XMLAdaptor " + name + ", " + name + "XMLAdaptor update) throws javax.ejb.FinderException, javax.ejb.CreateException, javax.ejb.RemoveException, java.rmi.RemoteException {\n");
        } else {
            fw.write("public " + name + "XMLAdaptor update(" + name + "XMLAdaptor " + name + ", " + name + "XMLAdaptor update) throws javax.ejb.FinderException, javax.ejb.CreateException, javax.ejb.RemoveException, java.rmi.RemoteException, javax.ejb.EJBException {\n");
        }
        fw.write("\tHomeObjectPool pool = HomeObjectPool.getInstance();\n");
        fw.write("\t" + name + "Home " + name + "HomeObj = (" + name + "Home)pool.get(\"" + name + "\");\n");
        int i15 = 0;
        while (i15 < this.ejbCollection.getNufRelations()) {
            EJBRelation rel = this.ejbCollection.getNthRelation(i15);
            String _name = rel.getBeanName();
            if (rel.getFirstBean().equals(name) || rel.getSecondBean().equals(name)) {
                fw.write("\t" + _name + "Home " + _name + "HomeObj = (" + _name + "Home)pool.get(\"" + _name + "\");\n");
            }
            ++i15;
        }
        fw.write("\tKeyGenerator gen = KeyGenerator.getInstance();\n\n");
        fw.write("  // update the top level " + name + "\n\n");
        fw.write("  " + name + " " + name + "Obj = " + name + "HomeObj.findByPrimaryKey(new " + name + "Key(" + name + ".getPrimaryKey()));\n");
        fw.write("  " + name + "Obj.initialize(update);\n");
        fw.write("  update.initialize(" + name + "Obj);\n\n");
        fw.write("  // remove relationships from " + name + "\n\n");
        fw.write("\tjava.util.Enumeration enum;\n");
        int i16 = 0;
        while (i16 < this.ejbCollection.getNufRelations()) {
            EJBRelation rel = this.ejbCollection.getNthRelation(i16);
            String _name = rel.getBeanName();
            String suffix0 = "";
            String suffix1 = "";
            if (rel.getFirstBean().equals(rel.getSecondBean())) {
                suffix0 = "0";
                suffix1 = "1";
            }
            if (rel.getFirstBean().equals(name)) {
                fw.write("\tenum = " + _name + "HomeObj.findBy" + name + suffix0 + "Ref(" + name + ".getPrimaryKey());\n");
                fw.write("\twhile(enum.hasMoreElements()) {\n");
                fw.write("\t\t" + _name + " " + _name + "Obj = (" + _name + ")javax.rmi.PortableRemoteObject.narrow(enum.nextElement(), " + _name + ".class);\n");
                fw.write("\t\t" + _name + "Obj.remove();\n");
                fw.write("\t};\n");
            }
            if (rel.getSecondBean().equals(name)) {
                fw.write("\tenum = " + _name + "HomeObj.findBy" + name + suffix1 + "Ref(" + name + ".getPrimaryKey());\n");
                fw.write("\twhile(enum.hasMoreElements()) {\n");
                fw.write("\t\t" + _name + " " + _name + "Obj = (" + _name + ")javax.rmi.PortableRemoteObject.narrow(enum.nextElement(), " + _name + ".class);\n");
                fw.write("\t\t" + _name + "Obj.remove();\n");
                fw.write("\t};\n");
            }
            ++i16;
        }
        fw.write("\n  // recreate relationships from update\n\n");
        fw.write("\tjava.util.Iterator iter;\n");
        int i17 = 0;
        while (i17 < this.ejbCollection.getNufRelations()) {
            String pf_name;
            PersistantField f;
            int j;
            PersistantFieldCollection rcol;
            EJBRelation rel = this.ejbCollection.getNthRelation(i17);
            String _name = rel.getBeanName();
            String suffix0 = "";
            String suffix1 = "";
            if (rel.getFirstBean().equals(rel.getSecondBean())) {
                suffix0 = "0";
                suffix1 = "1";
            }
            if (rel.getFirstBean().equals(name)) {
                fw.write("\titer = " + name + ".get" + _name + suffix0 + "();\n");
                fw.write("\twhile(iter.hasNext()) {\n");
                fw.write("\t\t" + _name + "XMLAdaptor " + _name + "Adaptor = (" + _name + "XMLAdaptor)iter.next();\n");
                fw.write("\t\t" + _name + " " + _name + "Obj = " + _name + "HomeObj.create(new " + _name + "Key(gen.generateNewKey()));\n");
                fw.write("\t\t" + _name + "Obj.set" + rel.getSecondBean() + suffix0 + "Ref(" + _name + "Adaptor.get" + rel.getSecondBean() + suffix0 + "Ref());\n");
                fw.write("\t\t" + _name + "Obj.set" + rel.getFirstBean() + suffix1 + "Ref(" + name + ".getPrimaryKey());\n");
                rcol = rel.getPersistantFieldCollection();
                j = 0;
                while (j < rcol.getNufPersistantFields()) {
                    f = rcol.getNthPersistantField(j);
                    pf_name = f.getFieldName();
                    fw.write("\t" + _name + "Obj.set" + pf_name + "(" + _name + "Adaptor.get" + pf_name + "());\n");
                    ++j;
                }
                fw.write("\t\t" + _name + "Adaptor.initialize(" + _name + "Obj);\n");
                fw.write("\t}\n");
            }
            if (rel.getSecondBean().equals(name)) {
                fw.write("\titer = " + name + ".get" + _name + suffix1 + "();\n");
                fw.write("\twhile(iter.hasNext()) {\n");
                fw.write("\t\t" + _name + "XMLAdaptor " + _name + "Adaptor = (" + _name + "XMLAdaptor)iter.next();\n");
                fw.write("\t\t" + _name + " " + _name + "Obj = " + _name + "HomeObj.create(new " + _name + "Key(gen.generateNewKey()));\n");
                fw.write("\t\t" + _name + "Obj.set" + rel.getSecondBean() + suffix0 + "Ref(" + name + ".getPrimaryKey());\n");
                fw.write("\t\t" + _name + "Obj.set" + rel.getFirstBean() + suffix1 + "Ref(" + _name + "Adaptor.get" + rel.getFirstBean() + suffix1 + "Ref());\n");
                rcol = rel.getPersistantFieldCollection();
                j = 0;
                while (j < rcol.getNufPersistantFields()) {
                    f = rcol.getNthPersistantField(j);
                    pf_name = f.getFieldName();
                    fw.write("\t" + _name + "Obj.set" + pf_name + "(" + _name + "Adaptor.get" + pf_name + "());\n");
                    ++j;
                }
                fw.write("\t\t" + _name + "Adaptor.initialize(" + _name + "Obj);\n");
                fw.write("\t}\n");
            }
            ++i17;
        }
        fw.write("\tpool.release(" + name + "HomeObj);\n");
        int i18 = 0;
        while (i18 < this.ejbCollection.getNufRelations()) {
            EJBRelation rel = this.ejbCollection.getNthRelation(i18);
            String _name = rel.getBeanName();
            if (rel.getFirstBean().equals(name) || rel.getSecondBean().equals(name)) {
                fw.write("\tpool.release(" + _name + "HomeObj);\n");
            }
            ++i18;
        }
        fw.write("\treturn update;\n");
        fw.write(" }//update\n\n");
        fw.write("/**\n");
        fw.write("* updateFields. Update top level " + name + " only, primary key, fields that are null, and relationships are IGNORED!\n");
        fw.write("*\n");
        fw.write("* @param " + name + " " + name + "XMLAdaptor\n");
        fw.write("* @param update " + name + "XMLAdaptor\n");
        fw.write("* @return " + name + "XMLAdaptor with keys and attributes updated. The method\n");
        fw.write("*   changes the " + name + " parameter and returns it (unlike update()).\n");
        fw.write("*/\n\n");
        fw.write("public " + name + "XMLAdaptor updateFields(" + name + "XMLAdaptor " + name + ", " + name + "XMLAdaptor update) throws javax.ejb.FinderException, java.rmi.RemoteException {\n");
        fw.write("\tHomeObjectPool pool = HomeObjectPool.getInstance();\n");
        fw.write("\t" + name + "Home " + name + "HomeObj = (" + name + "Home)pool.get(\"" + name + "\");\n");
        fw.write("  // update the top level " + name + "\n\n");
        fw.write("  " + name + " " + name + "Obj = " + name + "HomeObj.findByPrimaryKey(new " + name + "Key(" + name + ".getPrimaryKey()));\n");
        fw.write("  " + name + "Obj.initialize(update);\n");
        fw.write("  " + name + ".initialize(" + name + "Obj);\n");
        fw.write("\tpool.release(" + name + "HomeObj);\n");
        fw.write("\treturn " + name + ";\n");
        fw.write(" }//updateFields\n");
        fw.write("}\n");
        SourceFooterWriter.writeFooter(fw);
    }

    private void writeRelationSouce(FileWriter fw, EJBRelation ejbRel) throws IOException {
        String name = ejbRel.getBeanName();
        PersistantFieldCollection pfc = ejbRel.getPersistantFieldCollection();
        fw.write("package " + this.package_name + "." + name + ";\n\n");
        SourceHeaderWriter.writeHeader(fw);
        fw.write("import java.util.*;\n");
        fw.write("import java.io.*;\n");
        fw.write("import com.ibm.almaden.ejbmaker.*;\n");
        fw.write("import " + this.package_name + ".HomePool.*;\n");
        String firstBean = ejbRel.getFirstBean();
        String secondBean = ejbRel.getSecondBean();
        int i = 0;
        while (i < pfc.getNufPersistantFields()) {
            PersistantField pf = pfc.getNthPersistantField(i);
            String fkey = pf.getFKey();
            if (fkey != null && !fkey.trim().equals("")) {
                fw.write("import " + this.package_name + "." + fkey + ".*;\n");
            }
            ++i;
        }
        fw.write("import " + this.package_name + "." + firstBean + ".*;\n");
        fw.write("import " + this.package_name + "." + secondBean + ".*;\n");
        fw.write("/**\n");
        fw.write("* " + name + "Helper. Helper class for " + name + " bean\n");
        fw.write("* \n");
        fw.write("*/\n\n");
        fw.write("public class " + name + "Helper extends com.ibm.almaden.ejbmaker.Helper\n");
        fw.write("{\n");
        fw.write("\tprivate static " + name + "Helper instance;\n\n");
        fw.write("\t/**\n");
        fw.write("\t* Constructor. Private\n");
        fw.write("\t*/\n\n");
        fw.write("\tprivate " + name + "Helper() {\n");
        fw.write("\t}\n\n");
        fw.write("\t/**\n");
        fw.write("\t* getInstance\n");
        fw.write("\t*/\n\n");
        fw.write("\tpublic static " + name + "Helper getInstance() {\n");
        fw.write("\tif (instance == null) \n");
        fw.write("\t\tinstance = new " + name + "Helper();\n");
        fw.write("\treturn instance;\n");
        fw.write("\t}\n\n");
        fw.write("\t/**\n");
        fw.write("\t* expand. Expand an " + name + "XMLAdaptor to the level specified\n");
        fw.write("\t* \n");
        fw.write("\t* @param adaptor " + name + "XMLadaptor to expand\n");
        fw.write("\t* @param level Expansion level\n");
        fw.write("\t* @param caller XMLAdaptor of caller object.\n");
        fw.write("\t*/\n\n");
        fw.write("\tpublic " + name + "XMLAdaptor expand(" + name + "XMLAdaptor adaptor, int level, com.ibm.almaden.ejbmaker.XMLAdaptor caller) throws javax.ejb.FinderException, java.rmi.RemoteException {\n");
        fw.write("\tif(level < 0) return adaptor; // no change\n");
        fw.write("\tHomeObjectPool pool = HomeObjectPool.getInstance();\n\n");
        fw.write("\t" + name + "Home " + name + "HomeObj = (" + name + "Home)pool.get(\"" + name + "\");\n");
        String suffix0 = "";
        String suffix1 = "";
        if (firstBean.equals(secondBean)) {
            suffix0 = "0";
            suffix1 = "1";
        }
        if (!this.ejbCollection.containsConstantDescription(firstBean)) {
            fw.write("\t" + firstBean + "Home " + firstBean + suffix0 + "HomeObj = (" + firstBean + "Home)pool.get(\"" + firstBean + "\");\n");
        }
        if (!this.ejbCollection.containsConstantDescription(secondBean)) {
            fw.write("\t" + secondBean + "Home " + secondBean + suffix1 + "HomeObj = (" + secondBean + "Home)pool.get(\"" + secondBean + "\");\n");
        }
        ArrayList<String> included = new ArrayList<String>();
        int i2 = 0;
        while (i2 < pfc.getNufPersistantFields()) {
            PersistantField pf = pfc.getNthPersistantField(i2);
            String fkey = pf.getFKey();
            if (!(fkey == null || fkey.trim().equals("") || this.ejbCollection.containsConstantDescription(fkey) || included.contains(fkey))) {
                fw.write("\t" + fkey + "Home " + fkey + "HomeObj = (" + fkey + "Home)pool.get(\"" + fkey + "\");\n");
                included.add(fkey);
            }
            ++i2;
        }
        fw.write("\tString primaryKey = adaptor.getPrimaryKey();\n");
        fw.write("\t" + name + " " + name + "_obj = " + name + "HomeObj.findByPrimaryKey(new " + name + "Key(primaryKey));\n\n");
        fw.write("\t// This is level 0.\n");
        fw.write("\t" + name + "XMLAdaptor " + name + "Adaptor = new " + name + "XMLAdaptor(" + name + "_obj);\n\n");
        fw.write("\t--level;\n");
        fw.write("\tif(level < 0) return adaptor;\n");
        if (!this.ejbCollection.containsConstantDescription(firstBean)) {
            fw.write("\tif(!caller.getPrimaryKey().equals(" + name + "Adaptor.get" + firstBean + suffix0 + "Ref())) {\n");
            fw.write("\t\t" + firstBean + " " + firstBean + suffix0 + "Obj = " + firstBean + suffix0 + "HomeObj.findByPrimaryKey(new " + firstBean + "Key(" + name + "Adaptor.get" + firstBean + suffix0 + "Ref()));\n");
            fw.write("\t\t" + firstBean + "XMLAdaptor " + firstBean + suffix0 + "Adaptor = new " + firstBean + "XMLAdaptor(" + firstBean + suffix0 + "Obj);\n");
            fw.write("\t\t" + firstBean + "Helper " + firstBean + suffix0 + "HelperObj = " + firstBean + "Helper.getInstance();\n");
            fw.write("\t\t" + firstBean + "XMLAdaptor " + firstBean + suffix0 + "ExpandedAdaptor = " + firstBean + suffix0 + "HelperObj.expand(" + firstBean + suffix0 + "Adaptor, level);\n");
            fw.write("\t\t" + name + "Adaptor.set" + firstBean + suffix0 + "Adaptor(" + firstBean + suffix0 + "ExpandedAdaptor);\n\n");
            fw.write("\t} else " + name + "Adaptor.set" + firstBean + suffix0 + "Adaptor((" + firstBean + "XMLAdaptor)caller);\n");
        } else {
            fw.write("\t" + firstBean + "XMLAdaptor " + firstBean + suffix0 + "Adaptor = " + firstBean + "XMLAdaptor.findByPrimaryKey(" + name + "Adaptor.get" + firstBean + suffix0 + "Ref());\n");
            fw.write("\t" + name + "Adaptor.set" + firstBean + suffix0 + "Adaptor(" + firstBean + suffix0 + "Adaptor);\n\n");
        }
        if (!this.ejbCollection.containsConstantDescription(secondBean)) {
            fw.write("\tif(!caller.getPrimaryKey().equals(" + name + "Adaptor.get" + secondBean + suffix1 + "Ref())) {\n");
            fw.write("\t\t" + secondBean + " " + secondBean + suffix1 + "Obj = " + secondBean + suffix1 + "HomeObj.findByPrimaryKey(new " + secondBean + "Key(" + name + "Adaptor.get" + secondBean + suffix1 + "Ref()));\n");
            fw.write("\t\t" + secondBean + "XMLAdaptor " + secondBean + suffix1 + "Adaptor = new " + secondBean + "XMLAdaptor(" + secondBean + suffix1 + "Obj);\n");
            fw.write("\t\t" + secondBean + "Helper " + secondBean + suffix1 + "HelperObj = " + secondBean + "Helper.getInstance();\n");
            fw.write("\t\t" + secondBean + "XMLAdaptor " + secondBean + suffix1 + "ExpandedAdaptor = " + secondBean + suffix1 + "HelperObj.expand(" + secondBean + suffix1 + "Adaptor, level);\n");
            fw.write("\t\t" + name + "Adaptor.set" + secondBean + suffix1 + "Adaptor(" + secondBean + suffix1 + "ExpandedAdaptor);\n");
            fw.write("\t} else " + name + "Adaptor.set" + secondBean + suffix1 + "Adaptor((" + secondBean + "XMLAdaptor) caller);\n");
        } else {
            fw.write("\t" + secondBean + "XMLAdaptor " + secondBean + suffix1 + "Adaptor = " + secondBean + "XMLAdaptor.findByPrimaryKey(" + name + "Adaptor.get" + secondBean + suffix0 + "Ref());\n");
            fw.write("\t" + name + "Adaptor.set" + secondBean + suffix1 + "Adaptor(" + secondBean + suffix1 + "Adaptor);\n\n");
        }
        int i3 = 0;
        while (i3 < pfc.getNufPersistantFields()) {
            PersistantField pf = pfc.getNthPersistantField(i3);
            String fkey = pf.getFKey();
            String field_name = pf.getFieldName();
            if (fkey != null && !fkey.trim().equals("")) {
                fw.write("\tif(" + name + "Adaptor.get" + field_name + "() != null) { \n");
                if (!this.ejbCollection.containsConstantDescription(fkey)) {
                    fw.write("\t\t" + fkey + " " + fkey + "Obj = " + fkey + "HomeObj.findByPrimaryKey(new " + fkey + "Key(" + name + "Adaptor.get" + field_name + "()));\n");
                    fw.write("\t\t" + fkey + "XMLAdaptor " + fkey + "Adaptor = new " + fkey + "XMLAdaptor(" + fkey + "Obj);\n");
                    fw.write("\t\t" + fkey + "Helper " + fkey + "HelperObj = " + fkey + "Helper.getInstance();\n");
                    fw.write("\t\t" + fkey + "XMLAdaptor " + fkey + "ExpandedAdaptor = " + fkey + "HelperObj.expand(" + fkey + "Adaptor, level);\n");
                    fw.write("\t\t" + name + "Adaptor.set" + field_name + "Adaptor(" + fkey + "ExpandedAdaptor);\n");
                } else {
                    fw.write("\t\t" + fkey + "XMLAdaptor " + fkey + "Adaptor = " + fkey + "XMLAdaptor.findByPrimaryKey(" + name + "Adaptor.get" + field_name + "());\n");
                    fw.write("\t\t" + name + "Adaptor.set" + field_name + "Adaptor(" + fkey + "Adaptor);\n");
                }
                fw.write("\t}\n");
            }
            ++i3;
        }
        fw.write("\tpool.release(" + name + "HomeObj);\n");
        if (!this.ejbCollection.containsConstantDescription(firstBean)) {
            fw.write("\tpool.release(" + firstBean + suffix0 + "HomeObj);\n");
        }
        if (!this.ejbCollection.containsConstantDescription(secondBean)) {
            fw.write("\tpool.release(" + secondBean + suffix1 + "HomeObj);\n");
        }
        included = new ArrayList();
        int i4 = 0;
        while (i4 < pfc.getNufPersistantFields()) {
            PersistantField pf = pfc.getNthPersistantField(i4);
            String fkey = pf.getFKey();
            if (!(fkey == null || fkey.trim().equals("") || this.ejbCollection.containsConstantDescription(fkey) || included.contains(fkey))) {
                fw.write("\tpool.release(" + fkey + "HomeObj);\n");
                included.add(fkey);
            }
            ++i4;
        }
        fw.write("\treturn " + name + "Adaptor;\n");
        fw.write("\t} // expand\n");
        fw.write("/**\n");
        fw.write("* remove. Remove instance of " + name + "\n");
        fw.write("*\n");
        fw.write("* @param " + name + " " + name + "XMLAdaptor\n");
        fw.write("*/\n\n");
        fw.write("public void remove(" + name + "XMLAdaptor " + name + ") throws javax.ejb.RemoveException, java.rmi.RemoteException, javax.ejb.FinderException {\n");
        fw.write("\t" + name + ".remove();\n");
        fw.write(" }//remove\n\n");
        fw.write("/**\n");
        fw.write("* create. Create new instance of an " + name + "\n");
        fw.write("*\n");
        fw.write("* @param " + name + " " + name + "XMLAdaptor\n");
        fw.write("* @return " + name + "XMLAdaptor with keys initialized. The method changes the\n");
        fw.write("*   " + name + " parameter and returns it.\n");
        fw.write("*/\n\n");
        if (EJBSourceGenerator.version < 4) {
            fw.write("public " + name + "XMLAdaptor create(" + name + "XMLAdaptor " + name + ") throws javax.ejb.CreateException, java.rmi.RemoteException {\n");
        } else {
            fw.write("public " + name + "XMLAdaptor create(" + name + "XMLAdaptor " + name + ") throws javax.ejb.CreateException, java.rmi.RemoteException, javax.ejb.EJBException {\n");
        }
        fw.write("\tHomeObjectPool pool = HomeObjectPool.getInstance();\n");
        fw.write("\t" + name + "Home " + name + "HomeObj = (" + name + "Home)pool.get(\"" + name + "\");\n");
        fw.write("\tKeyGenerator gen = KeyGenerator.getInstance();\n");
        fw.write("  String primaryKey = gen.generateNewKey();\n");
        fw.write("\t" + name + " " + name + "Obj = " + name + "HomeObj.create(new " + name + "Key(primaryKey));\n");
        fw.write("\t" + name + "Obj.initialize(" + name + ");\n\n");
        fw.write("\t" + name + ".initialize(" + name + "Obj);\n\n");
        fw.write("\tpool.release(" + name + "HomeObj);\n");
        fw.write("\treturn " + name + ";\n");
        fw.write(" }//create\n\n");
        fw.write("}\n");
        SourceFooterWriter.writeFooter(fw);
    }
}

