/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.almaden.ejbmaker;

import com.ibm.almaden.ejbmaker.BeanXMLFileGenerator;
import com.ibm.almaden.ejbmaker.EJBCollection;
import com.ibm.almaden.ejbmaker.EJBConstantDescription;
import com.ibm.almaden.ejbmaker.EJBDeploymentDescriptorGenerator;
import com.ibm.almaden.ejbmaker.EJBDescription;
import com.ibm.almaden.ejbmaker.EJBFinderHelperGenerator;
import com.ibm.almaden.ejbmaker.EJBGenerator;
import com.ibm.almaden.ejbmaker.EJBHomeInterfaceGenerator;
import com.ibm.almaden.ejbmaker.EJBKeyGenerator;
import com.ibm.almaden.ejbmaker.EJBMaker;
import com.ibm.almaden.ejbmaker.EJBMakerFactory;
import com.ibm.almaden.ejbmaker.EJBRelation;
import com.ibm.almaden.ejbmaker.EJBRemoteImplementationGenerator;
import com.ibm.almaden.ejbmaker.EJBRemoteInterfaceGenerator;
import com.ibm.almaden.ejbmaker.HelperGenerator;
import com.ibm.almaden.ejbmaker.HomePoolGenerator;
import com.ibm.almaden.ejbmaker.SQLCreateIndexGenerator;
import com.ibm.almaden.ejbmaker.SQLCreateIndexStatGenerator;
import com.ibm.almaden.ejbmaker.SQLCreateStatementGenerator;
import com.ibm.almaden.ejbmaker.SQLDropTablesGenerator;
import com.ibm.almaden.ejbmaker.SQLDropViewsGenerator;
import com.ibm.almaden.ejbmaker.SQLExporterGenerator;
import com.ibm.almaden.ejbmaker.SQLImporterGenerator;
import com.ibm.almaden.ejbmaker.XMLAdaptorGenerator;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class EJBSourceGenerator
implements EJBGenerator,
ErrorHandler {
    private static String ATTR_TRUE = "true";
    private static String ATTR_FALSE = "false";
    private static EJBSourceGenerator ejbSourceGen = null;
    private static String java_source_folder;
    private static String package_name;
    private static String monitor_package;
    private static boolean encrypt;
    public static int version;
    private static String database_folder;
    private static String xml_inp_file;
    private EJBCollection ejbCollection;

    public static EJBSourceGenerator getInstance() {
        if (ejbSourceGen == null) {
            ejbSourceGen = new EJBSourceGenerator();
        }
        return ejbSourceGen;
    }

    private EJBSourceGenerator() {
    }

    public void generate() throws IOException {
        try {
            FileReader fr = new FileReader(xml_inp_file);
            DOMParser xmlparser = new DOMParser();
            xmlparser.setFeature("http://xml.org/sax/features/validation", true);
            xmlparser.setErrorHandler((ErrorHandler)this);
            InputSource xmlin = new InputSource(fr);
            xmlparser.parse(xmlin);
            Document doc = xmlparser.getDocument();
            EJBMakerFactory ejbmFactory = EJBMakerFactory.getInstance();
            EJBMaker ejbMaker = ejbmFactory.createEJBMaker();
            this.ejbCollection = ejbMaker.generateCollection(doc);
            this.createFolders();
            EJBHomeInterfaceGenerator homeinterfacegen = new EJBHomeInterfaceGenerator(java_source_folder, package_name, this.ejbCollection);
            homeinterfacegen.generate();
            EJBFinderHelperGenerator finderHelperGenerator = new EJBFinderHelperGenerator(java_source_folder, package_name, this.ejbCollection);
            finderHelperGenerator.generate();
            EJBRemoteInterfaceGenerator remoteInterfaceGenerator = new EJBRemoteInterfaceGenerator(java_source_folder, package_name, this.ejbCollection);
            remoteInterfaceGenerator.generate();
            EJBRemoteImplementationGenerator remoteImplementationGenerator = new EJBRemoteImplementationGenerator(java_source_folder, package_name, monitor_package, encrypt, this.ejbCollection);
            remoteImplementationGenerator.generate();
            EJBKeyGenerator keyGenerator = new EJBKeyGenerator(java_source_folder, package_name, this.ejbCollection);
            keyGenerator.generate();
            XMLAdaptorGenerator adaptorGenerator = new XMLAdaptorGenerator(java_source_folder, package_name, this.ejbCollection);
            adaptorGenerator.generate();
            HelperGenerator helperGenerator = new HelperGenerator(java_source_folder, package_name, this.ejbCollection);
            helperGenerator.generate();
            HomePoolGenerator homePoolGenerator = new HomePoolGenerator(java_source_folder, package_name, this.ejbCollection);
            homePoolGenerator.generate();
            EJBDeploymentDescriptorGenerator deplDescGenerator = new EJBDeploymentDescriptorGenerator(java_source_folder, package_name, this.ejbCollection);
            deplDescGenerator.generate();
            SQLCreateStatementGenerator sqlCreateGen = new SQLCreateStatementGenerator(database_folder, this.ejbCollection);
            sqlCreateGen.generate();
            SQLDropTablesGenerator sqlDropTablesGen = new SQLDropTablesGenerator(database_folder, this.ejbCollection);
            sqlDropTablesGen.generate();
            SQLDropViewsGenerator sqlDropViewsGen = new SQLDropViewsGenerator(database_folder, this.ejbCollection);
            sqlDropViewsGen.generate();
            SQLExporterGenerator sqlExpGen = new SQLExporterGenerator(database_folder, this.ejbCollection);
            sqlExpGen.generate();
            SQLImporterGenerator sqlImpGen = new SQLImporterGenerator(database_folder, this.ejbCollection);
            sqlImpGen.generate();
            BeanXMLFileGenerator beanXMLFileGen = new BeanXMLFileGenerator(database_folder, package_name, this.ejbCollection);
            beanXMLFileGen.generate();
            SQLCreateIndexGenerator indexGen = new SQLCreateIndexGenerator(database_folder, this.ejbCollection);
            indexGen.generate();
            SQLCreateIndexStatGenerator indexStatGen = new SQLCreateIndexStatGenerator(database_folder, this.ejbCollection);
            indexStatGen.generate();
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
    }

    private void createFolders() {
        File dir;
        String folder_name;
        int i = 0;
        while (i < this.ejbCollection.getNufDescriptions()) {
            EJBDescription ejbDesc = this.ejbCollection.getNthDescription(i);
            String bean_name = ejbDesc.getBeanName();
            folder_name = java_source_folder + File.separator + bean_name;
            dir = new File(java_source_folder + File.separator + bean_name);
            if (!dir.exists()) {
                dir.mkdirs();
            } else if (!dir.isDirectory()) {
                System.err.println("Error, cannot create folder " + folder_name + ", it already exists as a file!");
                return;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.ejbCollection.getNufRelations()) {
            EJBRelation ejbRel = this.ejbCollection.getNthRelation(i2);
            String bean_name = ejbRel.getBeanName();
            String folder_name2 = java_source_folder + File.separator + bean_name;
            File dir2 = new File(java_source_folder + File.separator + bean_name);
            if (!dir2.exists()) {
                dir2.mkdirs();
            } else if (!dir2.isDirectory()) {
                System.err.println("Error, cannot create folder " + folder_name2 + ", it already exists as a file!");
                return;
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.ejbCollection.getNufConstantDescriptions()) {
            EJBConstantDescription ejbConst = this.ejbCollection.getNthConstantDescription(i3);
            String bean_name = ejbConst.getBeanName();
            String folder_name3 = java_source_folder + File.separator + bean_name;
            File dir3 = new File(java_source_folder + File.separator + bean_name);
            if (!dir3.exists()) {
                dir3.mkdirs();
            } else if (!dir3.isDirectory()) {
                System.err.println("Error, cannot create folder " + folder_name3 + ", it already exists as a file!");
                return;
            }
            ++i3;
        }
        folder_name = java_source_folder + File.separator + "HomePool";
        dir = new File(folder_name);
        if (!dir.exists()) {
            dir.mkdirs();
        } else if (!dir.isDirectory()) {
            System.err.println("Error, cannot create folder " + folder_name + ", it already exists as a file!");
            return;
        }
    }

    public void warning(SAXParseException e) throws SAXException {
        System.err.println("Warning:  " + e.getLineNumber() + " column: " + e.getColumnNumber());
    }

    public void error(SAXParseException e) throws SAXException {
        System.err.println("Error:  " + e + " line " + e.getLineNumber() + " column: " + e.getColumnNumber());
    }

    public void fatalError(SAXParseException e) throws SAXException {
        System.err.println("Fatal Error:  " + e.getLineNumber() + " column: " + e.getColumnNumber());
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: EJBSourceGenerator [-d <java source dir>] [-p <package name>] [-db <database folder>] [-e] [-v <3 | 4>] <xml bean descriptor>");
            return;
        }
        java_source_folder = ".";
        package_name = "";
        database_folder = ".";
        monitor_package = null;
        encrypt = false;
        version = 4;
        int i = 0;
        while (i < args.length) {
            if (args[i].equalsIgnoreCase("-d")) {
                java_source_folder = args[i + 1];
            }
            if (args[i].equalsIgnoreCase("-p")) {
                package_name = args[i + 1];
            }
            if (args[i].equalsIgnoreCase("-db")) {
                database_folder = args[i + 1];
            }
            if (args[i].equalsIgnoreCase("-m")) {
                monitor_package = args[i + 1];
            }
            if (args[i].equalsIgnoreCase("-e")) {
                encrypt = true;
            }
            if (args[i].equalsIgnoreCase("-v")) {
                version = Integer.parseInt(args[i + 1]);
            }
            ++i;
        }
        StringBuffer sb = new StringBuffer(package_name);
        int i2 = 0;
        while (i2 < sb.length()) {
            if (sb.charAt(i2) == '.') {
                sb.setCharAt(i2, File.separatorChar);
            }
            ++i2;
        }
        java_source_folder = java_source_folder + File.separatorChar + sb.toString();
        xml_inp_file = args[args.length - 1];
        EJBSourceGenerator sourcegen = EJBSourceGenerator.getInstance();
        try {
            sourcegen.generate();
        }
        catch (IOException ioe) {
            System.out.println("**** IOException caugt: " + ioe.getMessage() + " (Make sure the file is write enabled)");
        }
    }

    static {
        package_name = null;
        monitor_package = null;
        encrypt = false;
        database_folder = null;
    }
}

