/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.almaden.ejbmaker;

import com.ibm.almaden.ejbmaker.EJBCollection;
import com.ibm.almaden.ejbmaker.EJBDescription;
import com.ibm.almaden.ejbmaker.EJBGenerator;
import com.ibm.almaden.ejbmaker.EJBRelation;
import com.ibm.almaden.ejbmaker.PersistantField;
import com.ibm.almaden.ejbmaker.PersistantFieldCollection;
import com.ibm.almaden.ejbmaker.SmartWriter;
import com.ibm.almaden.ejbmaker.SourceFooterWriter;
import com.ibm.almaden.ejbmaker.SourceHeaderWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class EJBRemoteInterfaceGenerator
implements EJBGenerator {
    private String java_source_folder;
    private String package_name;
    private EJBCollection ejbCollection;

    public EJBRemoteInterfaceGenerator(String source, String pname, EJBCollection coll) {
        this.java_source_folder = source;
        this.package_name = pname;
        this.ejbCollection = coll;
    }

    public void generate() {
        try {
            int i = 0;
            while (i < this.ejbCollection.getNufDescriptions()) {
                EJBDescription ejbDesc = this.ejbCollection.getNthDescription(i);
                String bean_name = ejbDesc.getBeanName();
                String java_file_name = this.java_source_folder + File.separator + bean_name + File.separator + bean_name + ".java";
                SmartWriter sw = new SmartWriter(java_file_name);
                FileWriter fw = sw.createFile();
                this.writeDescriptionSource(fw, ejbDesc);
                sw.copyAndClose();
                ++i;
            }
            int i2 = 0;
            while (i2 < this.ejbCollection.getNufRelations()) {
                EJBRelation ejbRel = this.ejbCollection.getNthRelation(i2);
                String bean_name = ejbRel.getBeanName();
                String java_file_name = this.java_source_folder + File.separator + bean_name + File.separator + bean_name + ".java";
                SmartWriter sw = new SmartWriter(java_file_name);
                FileWriter fw = sw.createFile();
                this.writeRelationSource(fw, ejbRel);
                sw.copyAndClose();
                ++i2;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void writeDescriptionSource(FileWriter fw, EJBDescription ejbDesc) throws IOException {
        String name = ejbDesc.getBeanName();
        fw.write("package " + this.package_name + "." + name + ";\n\n");
        SourceHeaderWriter.writeHeader(fw);
        fw.write("\n");
        fw.write("/**\n");
        fw.write("* Remote interface for " + name + "\n");
        fw.write("*\n");
        fw.write("* @author Not known, this file was generated automatically\n");
        fw.write("**/\n");
        fw.write("\n");
        fw.write("public interface " + name + " extends javax.ejb.EJBObject { \n\n");
        PersistantFieldCollection pfColl = ejbDesc.getPersistantFieldCollection();
        int i = 0;
        while (i < pfColl.getNufPersistantFields()) {
            PersistantField pf = pfColl.getNthPersistantField(i);
            String field_name = pf.getFieldName();
            String field_type = pf.getJavaDT();
            fw.write("\t/**\n");
            fw.write("\t* Get the " + field_name + " value of the " + name + " bean\n");
            fw.write("\t*\n");
            fw.write("\t* @return " + field_type + " Current value of the " + field_name + " field\n");
            fw.write("\t*/\n");
            fw.write("\n");
            fw.write("\t" + field_type + " get" + field_name + "() throws java.rmi.RemoteException;\n");
            fw.write("\n");
            fw.write("\t/**\n");
            fw.write("\t* Set the " + field_name + " value of the " + name + " bean\n");
            fw.write("\t*\n");
            fw.write("\t* @param val New value of the " + field_name + " field\n");
            fw.write("\t*/\n");
            fw.write("\n");
            fw.write("\tvoid set" + field_name + "(" + field_type + " val) throws java.rmi.RemoteException;\n");
            fw.write("\n");
            ++i;
        }
        if (ejbDesc.getBeanType().equalsIgnoreCase("topic")) {
            fw.write("\t/**\n");
            fw.write("\t* Get the record created timestamp\n");
            fw.write("\t*\n");
            fw.write("\t* @return java.sql.Timestamp When was the record created?\n");
            fw.write("\t* @exception java.rmi.RemoteException Typically thrown when network problems occur\n");
            fw.write("\t*/\n");
            fw.write("\n");
            fw.write("\tjava.sql.Timestamp getRecordCreated() throws java.rmi.RemoteException;\n");
            fw.write("\n");
            fw.write("\t/**\n");
            fw.write("\t* Set the record created timestamp\n");
            fw.write("\t*\n");
            fw.write("\t* @param val New value of the record created timestamp\n");
            fw.write("\t* @exception java.rmi.RemoteException Typically thrown when network problems occur\n");
            fw.write("\t*/\n");
            fw.write("\n");
            fw.write("\tvoid setRecordCreated(java.sql.Timestamp val) throws java.rmi.RemoteException;\n");
            fw.write("\n");
        }
        fw.write("\t/**\n");
        fw.write("\t* getKey. Retrive the primary key of the bean as a String\n");
        fw.write("\t* @return String The primary key\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic String getKey() throws java.rmi.RemoteException; \n\n");
        fw.write("\t/**\n");
        fw.write("\t* initialize. Quickly initialize the bean from an XML document\n");
        fw.write("\t* @param doc XML document instance\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic void initialize(org.w3c.dom.Document doc) throws java.rmi.RemoteException; \n\n");
        fw.write("\t/**\n");
        fw.write("\t* initialize. Quickly initialize the bean from an adaptor instance\n");
        fw.write("\t* @param adapt Adaptor class\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic void initialize(" + name + "XMLAdaptor adapt) throws java.rmi.RemoteException; \n\n");
        fw.write("\t/**\n");
        fw.write("\t* getXML. Convert the bean into an XML document\n");
        fw.write("\t* @return org.w3c.dom.Document XML document instance\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic org.w3c.dom.Document getXML() throws java.rmi.RemoteException; \n");
        if (ejbDesc.getBeanType().equalsIgnoreCase("topic")) {
            fw.write("\t/**\n");
            fw.write("\t* onMessage. Method automatically for JMS messaging. \n");
            fw.write("\t*@param doc XML document instance\n");
            fw.write("\t*/\n");
            fw.write("\n");
            fw.write("\tpublic void onMessage(org.w3c.dom.Document __doc) throws java.rmi.RemoteException; \n");
        }
        fw.write("} // " + name + "\n");
        SourceFooterWriter.writeFooter(fw);
    }

    private void writeRelationSource(FileWriter fw, EJBRelation ejbRel) throws IOException {
        String name = ejbRel.getBeanName();
        fw.write("package " + this.package_name + "." + name + ";\n\n");
        SourceHeaderWriter.writeHeader(fw);
        fw.write("\n");
        fw.write("/**\n");
        fw.write("* Remote interface for " + name + "\n");
        fw.write("*\n");
        fw.write("* @author Not known, this file was generated automatically\n");
        fw.write("**/\n");
        fw.write("\n");
        fw.write("public interface " + name + " extends javax.ejb.EJBObject { \n\n");
        String bean1 = ejbRel.getFirstBean();
        String bean2 = ejbRel.getSecondBean();
        fw.write("\t/**\n");
        fw.write("\t* Get the " + ejbRel.getFirstPField() + " value of the " + name + " bean\n");
        fw.write("\t*\n");
        fw.write("\t* @return String Primary key value for bean " + bean1 + "\n");
        fw.write("\t* @exception java.rmi.RemoteException Typically thrown when network problems occurs\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tString get" + ejbRel.getFirstPField() + "() throws java.rmi.RemoteException;\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* Get the " + ejbRel.getSecondPField() + " value of the " + name + " bean\n");
        fw.write("\t*\n");
        fw.write("\t* @return String Primary key value for bean " + bean2 + "\n");
        fw.write("\t* @exception java.rmi.RemoteException Typically thrown when network problems occurs\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tString get" + ejbRel.getSecondPField() + "() throws java.rmi.RemoteException;\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* Set the " + ejbRel.getFirstPField() + " value of the " + name + " bean\n");
        fw.write("\t*\n");
        fw.write("\t* @param ref Primary key value for bean " + bean1 + "\n");
        fw.write("\t* @exception java.rmi.RemoteException Typically thrown when network problems occurs\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tvoid set" + ejbRel.getFirstPField() + "(String __ref) throws java.rmi.RemoteException;\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* Set the " + ejbRel.getSecondPField() + " value of the " + name + " bean\n");
        fw.write("\t*\n");
        fw.write("\t* @param ref Primary key value for bean " + bean2 + "\n");
        fw.write("\t* @exception java.rmi.RemoteException Typically thrown when network problems occurs\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tvoid set" + ejbRel.getSecondPField() + "(String __ref) throws java.rmi.RemoteException;\n");
        fw.write("\n");
        PersistantFieldCollection pfColl = ejbRel.getPersistantFieldCollection();
        int i = 0;
        while (i < pfColl.getNufPersistantFields()) {
            PersistantField pf = pfColl.getNthPersistantField(i);
            String field_name = pf.getFieldName();
            String field_type = pf.getJavaDT();
            fw.write("\t/**\n");
            fw.write("\t* Get the " + field_name + " value of the " + name + " bean\n");
            fw.write("\t*\n");
            fw.write("\t* @return " + field_type + " Current value of the " + field_name + " field\n");
            fw.write("\t*/\n");
            fw.write("\n");
            fw.write("\t" + field_type + " get" + field_name + "() throws java.rmi.RemoteException;\n");
            fw.write("\n");
            fw.write("\t/**\n");
            fw.write("\t* Set the " + field_name + " value of the " + name + " bean\n");
            fw.write("\t*\n");
            fw.write("\t* @param val New value of the " + field_name + " field\n");
            fw.write("\t*/\n");
            fw.write("\n");
            fw.write("\tvoid set" + field_name + "(" + field_type + " val) throws java.rmi.RemoteException;\n");
            fw.write("\n");
            ++i;
        }
        fw.write("\t/**\n");
        fw.write("\t* getKey. Retrive the primary key of the bean as a String\n");
        fw.write("\t* @return String The primary key\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic String getKey() throws java.rmi.RemoteException; \n\n");
        fw.write("\t/**\n");
        fw.write("\t* initialize. Quickly initialize the bean from an XML document\n");
        fw.write("\t* @param doc XML document instance\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic void initialize(org.w3c.dom.Document doc) throws java.rmi.RemoteException; \n\n");
        fw.write("\t/**\n");
        fw.write("\t* initialize. Quickly initialize the bean from an adaptor instance\n");
        fw.write("\t* @param adapt Adaptor class\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic void initialize(" + name + "XMLAdaptor adapt) throws java.rmi.RemoteException; \n\n");
        fw.write("\t/**\n");
        fw.write("\t* getXML. Convert the bean into an XML document\n");
        fw.write("\t* @return org.w3c.dom.Document XML document instance\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic org.w3c.dom.Document getXML() throws java.rmi.RemoteException; \n");
        fw.write("\n} // " + name);
        SourceFooterWriter.writeFooter(fw);
    }
}

