/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.almaden.ejbmaker;

import com.ibm.almaden.ejbmaker.EJBCollection;
import com.ibm.almaden.ejbmaker.EJBDescription;
import com.ibm.almaden.ejbmaker.EJBGenerator;
import com.ibm.almaden.ejbmaker.EJBRelation;
import com.ibm.almaden.ejbmaker.EJBSourceGenerator;
import com.ibm.almaden.ejbmaker.PersistantField;
import com.ibm.almaden.ejbmaker.PersistantFieldCollection;
import com.ibm.almaden.ejbmaker.SmartWriter;
import com.ibm.almaden.ejbmaker.SourceFooterWriter;
import com.ibm.almaden.ejbmaker.SourceHeaderWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class EJBRemoteImplementationGenerator
implements EJBGenerator {
    private static String ATTR_TRUE = "true";
    private String java_source_folder;
    private String package_name;
    private String monitor_package;
    private boolean encrypt;
    private boolean monitorUpdates = false;
    private EJBCollection ejbCollection;

    public EJBRemoteImplementationGenerator(String source, String pname, String mon_pack, boolean enc, EJBCollection coll) {
        this.java_source_folder = source;
        this.package_name = pname;
        this.monitor_package = mon_pack;
        this.encrypt = enc;
        this.ejbCollection = coll;
        if (this.monitor_package != null) {
            this.monitorUpdates = true;
        }
    }

    public void generate() throws IOException {
        int i = 0;
        while (i < this.ejbCollection.getNufDescriptions()) {
            EJBDescription ejbDesc = this.ejbCollection.getNthDescription(i);
            String bean_name = ejbDesc.getBeanName();
            String java_file_name = this.java_source_folder + File.separator + bean_name + File.separator + bean_name + "Bean.java";
            SmartWriter sw = new SmartWriter(java_file_name);
            FileWriter fw = sw.createFile();
            this.writeDescriptionSource(fw, ejbDesc);
            sw.copyAndClose();
            ++i;
        }
        int i2 = 0;
        while (i2 < this.ejbCollection.getNufRelations()) {
            EJBRelation ejbRel = this.ejbCollection.getNthRelation(i2);
            String bean_name = ejbRel.getBeanName();
            String java_file_name = this.java_source_folder + File.separator + bean_name + File.separator + bean_name + "Bean.java";
            SmartWriter sw = new SmartWriter(java_file_name);
            FileWriter fw = sw.createFile();
            this.writeRelationSource(fw, ejbRel);
            sw.copyAndClose();
            ++i2;
        }
    }

    private void writeDescriptionSource(FileWriter fw, EJBDescription ejbDesc) throws IOException {
        String name = ejbDesc.getBeanName();
        fw.write("package " + this.package_name + "." + name + ";\n\n");
        SourceHeaderWriter.writeHeader(fw);
        if (this.monitorUpdates) {
            fw.write("\nimport " + this.monitor_package + ".*;\n");
        }
        if (this.encrypt) {
            fw.write("\nimport javax.crypto.*;\n");
        }
        fw.write("\n");
        fw.write("/**\n");
        fw.write("* Remote implementation of " + name + "\n");
        fw.write("*\n");
        fw.write("* @author Not known, this file was generated automatically\n");
        fw.write("**/\n");
        fw.write("\n");
        fw.write("public class " + name + "Bean implements javax.ejb.EntityBean { \n\n");
        if (this.encrypt) {
            fw.write("\tprivate com.ibm.almaden.ejbmaker.CryptTools crypto = null;\n");
        }
        fw.write("\tprivate javax.ejb.EntityContext entityContext = null;\n");
        fw.write("\tpublic String primaryKey;\n");
        PersistantFieldCollection pfColl = ejbDesc.getPersistantFieldCollection();
        int i = 0;
        while (i < pfColl.getNufPersistantFields()) {
            PersistantField pf = pfColl.getNthPersistantField(i);
            String field_name = pf.getFieldName();
            String field_type = pf.getJavaDT();
            fw.write("\tpublic " + field_type + " " + field_name + ";\n");
            ++i;
        }
        if (ejbDesc.needsEncryption()) {
            fw.write("\tpublic java.lang.String CRYPTKEY;\n");
        }
        fw.write("\n");
        if (ejbDesc.getBeanType().equalsIgnoreCase("topic")) {
            fw.write(" public java.sql.Timestamp REC_CRTD;\n");
        }
        int i2 = 0;
        while (i2 < pfColl.getNufPersistantFields()) {
            PersistantField pf = pfColl.getNthPersistantField(i2);
            String field_name = pf.getFieldName();
            String field_type = pf.getJavaDT();
            boolean fieldToBeEncrypted = pf.getEncrypt();
            fw.write("\t/**\n");
            fw.write("\t* Get the " + field_name + " value of the " + name + " bean\n");
            fw.write("\t*\n");
            fw.write("\t* @return " + field_type + " Current value of the " + field_name + " field\n");
            fw.write("\t*/\n");
            fw.write("\n");
            fw.write("\tpublic " + field_type + " get" + field_name + "() {\n");
            if (this.encrypt && fieldToBeEncrypted) {
                fw.write("\t\tString decryptedText;\n");
                fw.write("\t\tif (crypto == null)\n");
                fw.write("\t\t\tcrypto = new com.ibm.almaden.ejbmaker.CryptTools();\n");
                fw.write("\t\tdecryptedText = crypto.decrypt(" + field_name + ", " + "CRYPTKEY" + ");\n");
                fw.write("\t\treturn decryptedText;\n");
                fw.write("\t}\n");
            } else {
                fw.write("\t\treturn " + field_name + ";\n");
                fw.write("\t}\n");
            }
            fw.write("\n");
            fw.write("\t/**\n");
            fw.write("\t* Set the " + field_name + " value of the " + name + " bean\n");
            fw.write("\t*\n");
            fw.write("\t* @param val New value of the " + field_name + " field\n");
            fw.write("\t*/\n");
            fw.write("\n");
            fw.write("\tpublic void set" + field_name + "(" + field_type + " val) {\n");
            if (this.encrypt && fieldToBeEncrypted) {
                fw.write("\t\tString encryptedText;\n");
                fw.write("\t\tif (crypto == null)\n");
                fw.write("\t\t\tcrypto = new com.ibm.almaden.ejbmaker.CryptTools();\n");
                fw.write("\t\tencryptedText = crypto.encrypt(val, CRYPTKEY);\n");
                fw.write("\t\tif ((CRYPTKEY == null) || (CRYPTKEY.equals(\"\")))\n");
                fw.write("\t\t\tCRYPTKEY = crypto.getKey();\n");
                fw.write("\t\t" + field_name + " = encryptedText;\n");
                fw.write("\t}\n");
            } else {
                fw.write("\t\t" + field_name + " = val;\n");
                fw.write("\t}\n");
            }
            fw.write("\n");
            ++i2;
        }
        if (ejbDesc.getBeanType().equalsIgnoreCase("topic")) {
            fw.write("\t/**\n");
            fw.write("\t* Get the record created timestamp\n");
            fw.write("\t*\n");
            fw.write("\t* @return java.sql.Timestamp When was the record created?\n");
            fw.write("\t*/\n");
            fw.write("\n");
            fw.write("\tpublic java.sql.Timestamp getRecordCreated()  {\n");
            fw.write("\t\treturn REC_CRTD;\n");
            fw.write("\t}\n");
            fw.write("\n");
            fw.write("\t/**\n");
            fw.write("\t* Set the record created timestamp\n");
            fw.write("\t*\n");
            fw.write("\t* @param val New value of the record created timestamp\n");
            fw.write("\t*/\n");
            fw.write("\n");
            fw.write("\t public void setRecordCreated(java.sql.Timestamp val) {\n");
            fw.write("\t\tREC_CRTD = val;\n");
            fw.write("\t}\n");
            fw.write("\n");
        }
        fw.write("\t/**\n");
        fw.write("\t* getKey. Retrieve the primary key of the bean as a String\n");
        fw.write("\t* @return String The primary key\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic String getKey() { \n");
        fw.write("\t\treturn primaryKey;\n");
        fw.write("\t}\n\n");
        fw.write("\t/**\n");
        fw.write("\t* initialize. Quickly initialize the bean from an XML document\n");
        fw.write("\t*@param doc XML document instance\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic void initialize(org.w3c.dom.Document doc) {\n");
        fw.write("\t\t" + name + "XMLAdaptor adaptor = new " + name + "XMLAdaptor(doc);\n");
        fw.write("\t\tthis.initialize(adaptor);\n");
        fw.write("\t} // initialize\n\n");
        fw.write("\t/**\n");
        fw.write("\t* initialize. Quickly initialize the bean from an adaptor instance\n");
        fw.write("\t* @param adapt Adaptor class\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic void initialize(" + name + "XMLAdaptor adaptor) { \n");
        int i3 = 0;
        while (i3 < ejbDesc.getPersistantFieldCollection().getNufPersistantFields()) {
            PersistantField pf = ejbDesc.getPersistantFieldCollection().getNthPersistantField(i3);
            String fname = pf.getFieldName();
            String ftype = pf.getJavaDT();
            if (ftype.equalsIgnoreCase("boolean")) {
                fw.write("\t\tif(adaptor.get" + fname + "() != null) set" + fname + "(adaptor.get" + fname + "().booleanValue());\n");
            }
            if (ftype.equalsIgnoreCase("short")) {
                fw.write("\t\tif(adaptor.get" + fname + "() != null) set" + fname + "(adaptor.get" + fname + "().shortValue());\n");
            } else if (ftype.equalsIgnoreCase("int")) {
                fw.write("\t\tif(adaptor.get" + fname + "() != null) set" + fname + "(adaptor.get" + fname + "().intValue());\n");
            } else if (ftype.equalsIgnoreCase("long")) {
                fw.write("\t\tif(adaptor.get" + fname + "() != null) set" + fname + "(adaptor.get" + fname + "().longValue());\n");
            } else if (ftype.equalsIgnoreCase("byte")) {
                fw.write("\t\tif(adaptor.get" + fname + "() != null) set" + fname + "(adaptor.get" + fname + "().byteValue());\n");
            } else if (ftype.equalsIgnoreCase("char")) {
                fw.write("\t\tif(adaptor.get" + fname + "() != null) set" + fname + "(adaptor.get" + fname + "().charValue());\n");
            } else if (ftype.equalsIgnoreCase("double")) {
                fw.write("\t\tif(adaptor.get" + fname + "() != null) set" + fname + "(adaptor.get" + fname + "().doubleValue());\n");
            } else if (ftype.equalsIgnoreCase("float")) {
                fw.write("\t\tif(adaptor.get" + fname + "() != null) set" + fname + "(adaptor.get" + fname + "().floatValue());\n");
            } else {
                fw.write("\t\tif(adaptor.get" + fname + "() != null) set" + fname + "(adaptor.get" + fname + "());\n");
            }
            ++i3;
        }
        if (ejbDesc.getBeanType().equalsIgnoreCase("topic")) {
            fw.write("\t\tif(adaptor.getREC_CRTD() != null) REC_CRTD = adaptor.getREC_CRTD();\n");
        }
        if (this.monitorUpdates) {
            fw.write("\t\ttry {\n");
            fw.write("\t\t\tCacheManager.getInstance().invalidate(this);\n");
            fw.write("\t\t}catch(com.ibm.almaden.cachemanager.MonitorInstantiationException mie) {mie.printStackTrace();}\n");
        }
        fw.write("\t} // initialize\n\n");
        fw.write("\t/**\n");
        fw.write("\t* getXML. Convert the bean into an XML document\n");
        fw.write("\t*@return org.w3c.dom.Document XML document instance\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic org.w3c.dom.Document getXML() {\n");
        fw.write("\t\t" + name + "XMLAdaptor adaptor = new " + name + "XMLAdaptor();\n");
        int i4 = 0;
        while (i4 < ejbDesc.getPersistantFieldCollection().getNufPersistantFields()) {
            PersistantField pf = ejbDesc.getPersistantFieldCollection().getNthPersistantField(i4);
            String fname = pf.getFieldName();
            String ftype = pf.getJavaDT();
            if (ftype.equalsIgnoreCase("boolean")) {
                fw.write("\t\tadaptor.set" + fname + "(new Boolean(" + fname + "));\n");
            } else if (ftype.equalsIgnoreCase("short")) {
                fw.write("\t\tadaptor.set" + fname + "(new Short(" + fname + "));\n");
            } else if (ftype.equalsIgnoreCase("int")) {
                fw.write("\t\tadaptor.set" + fname + "(new Integer(" + fname + "));\n");
            } else if (ftype.equalsIgnoreCase("long")) {
                fw.write("\t\tadaptor.set" + fname + "(new Long(" + fname + "));\n");
            } else if (ftype.equalsIgnoreCase("byte")) {
                fw.write("\t\tadaptor.set" + fname + "(new Byte(" + fname + "));\n");
            } else if (ftype.equalsIgnoreCase("char")) {
                fw.write("\t\tadaptor.set" + fname + "(new Char(" + fname + "));\n");
            } else if (ftype.equalsIgnoreCase("double")) {
                fw.write("\t\tadaptor.set" + fname + "(new Double(" + fname + "));\n");
            } else if (ftype.equalsIgnoreCase("float")) {
                fw.write("\t\tadaptor.set" + fname + "(new Float(" + fname + "));\n");
            } else {
                fw.write("\t\tif(" + fname + " != null) adaptor.set" + fname + "(" + fname + ");\n");
            }
            ++i4;
        }
        if (ejbDesc.getBeanType().equalsIgnoreCase("topic")) {
            fw.write("\t\tadaptor.setREC_CRTD(REC_CRTD);\n");
        }
        fw.write("\t\tadaptor.setPrimaryKey(primaryKey);\n");
        fw.write("\treturn adaptor.getXML();\n");
        fw.write("\t} // getXML\n");
        if (ejbDesc.getBeanType().equalsIgnoreCase("topic")) {
            fw.write("\t/**\n");
            fw.write("\t* onMessage. Method automatically for JMS messaging. \n");
            fw.write("\t*@param doc XML document instance\n");
            fw.write("\t*/\n");
            fw.write("\n");
            fw.write("\tpublic void onMessage(org.w3c.dom.Document __doc) {\n");
            fw.write("\t\tthis.initialize(__doc);\n");
            fw.write("\t} // onMessage\n\n");
        }
        fw.write("\t/**\n");
        fw.write("\t* ejbActivate Automatically called by container when bean is being activated\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic void ejbActivate() throws java.rmi.RemoteException {\n");
        fw.write("\t}\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* ejbCreate method. Create a new instance of the bean. Initialize using default values if possible.\n");
        fw.write("\t* Always initialize java.sql.Timestamp and java.sql.Time fields\n");
        fw.write("\t*@param key The " + name + " key\n");
        fw.write("\t*\n");
        fw.write("\t*/\n");
        fw.write("\n");
        if (EJBSourceGenerator.version < 4) {
            fw.write("\tpublic void ejbCreate(" + name + "Key key)  {\n");
        } else {
            fw.write("\tpublic " + name + "Key ejbCreate(" + name + "Key key)  {\n");
        }
        fw.write("\t\tprimaryKey = key.primaryKey;\n");
        int i5 = 0;
        while (i5 < pfColl.getNufPersistantFields()) {
            PersistantField pf = pfColl.getNthPersistantField(i5);
            String field_name = pf.getFieldName();
            String field_type = pf.getJavaDT();
            String def = pf.getDefault();
            if (field_type.equals("java.sql.Timestamp")) {
                fw.write("\t\t" + field_name + " = new java.sql.Timestamp(new java.util.Date().getTime());\n");
            }
            if (field_type.equals("java.sql.Time")) {
                fw.write("\t\t" + field_name + " = new java.sql.Time(new java.util.Date().getTime());\n");
            }
            if (def != null) {
                if (field_type.equals("java.lang.String")) {
                    fw.write("\t\t" + field_name + " = new java.lang.String(\"" + def + "\");\n");
                } else if (field_type.equals("java.lang.String")) {
                    fw.write("\t\t" + field_name + " = new java.lang.String(" + def + ");\n");
                } else if (field_type.equals("char")) {
                    fw.write("\t\t" + field_name + " = '" + def + "';\n");
                } else if (field_type.equals("byte")) {
                    fw.write("\t\t" + field_name + " = " + def + ";\n");
                } else if (field_type.equals("short")) {
                    fw.write("\t\t" + field_name + " = " + def + ";\n");
                } else if (field_type.equals("int")) {
                    fw.write("\t\t" + field_name + " = " + def + ";\n");
                } else if (field_type.equals("long")) {
                    fw.write("\t\t" + field_name + " = " + def + ";\n");
                } else if (field_type.equals("float")) {
                    fw.write("\t\t" + field_name + " = " + def + ";\n");
                } else if (field_type.equals("double")) {
                    fw.write("\t\t" + field_name + " = " + def + ";\n");
                }
            }
            ++i5;
        }
        if (EJBSourceGenerator.version >= 4) {
            fw.write("\treturn null;\n");
        }
        fw.write("\t}\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* ejbLoad. Called automatically by container\n");
        fw.write("\t*@exception java.rmi.RemoteException Network problems\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic void ejbLoad () throws java.rmi.RemoteException {\n");
        fw.write("\t}\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* ejbPassivate: Called automatically by container when bean is passivated (not for CMP beans)\n");
        fw.write("\t*@exception java.rmi.RemoteException Network problems\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic void ejbPassivate() throws java.rmi.RemoteException {\n");
        fw.write("\t}\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* ejbPostCreate. Called automatcally by container after bean creation\n");
        fw.write("\t*@param key The " + name + " key\n");
        if (EJBSourceGenerator.version < 4) {
            fw.write("\t*@exception java.rmi.RemoteException Network problems\n");
        } else {
            fw.write("\t*@exception javax.ejb.EJBException EJB problem \n");
        }
        fw.write("\t*/\n");
        fw.write("\n");
        if (EJBSourceGenerator.version < 4) {
            fw.write("\tpublic void ejbPostCreate(" + name + "Key key) throws java.rmi.RemoteException {\n");
        } else {
            fw.write("\tpublic void ejbPostCreate(" + name + "Key key) throws javax.ejb.EJBException {\n");
        }
        fw.write("\t}\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* ejbStore: Called automatically by container\n");
        fw.write("\t*@exception java.rmi.RemoteException Network problems\n");
        fw.write("   */\n");
        fw.write("\n");
        fw.write("\tpublic void ejbStore () throws java.rmi.RemoteException {\n");
        fw.write("\t}\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* ejbRemove. Bean is being removed. Called automatically by container\n");
        fw.write("\t*@exception java.rmi.RemoteException Network problems\n");
        fw.write("\t*/\n");
        fw.write("\tpublic void ejbRemove() throws java.rmi.RemoteException {\n");
        if (this.monitorUpdates) {
            fw.write("\t\ttry {\n");
            fw.write("\t\t\tCacheManager.getInstance().invalidate(this);\n");
            fw.write("\t\t}catch(com.ibm.almaden.cachemanager.MonitorInstantiationException mie) {mie.printStackTrace();}\n");
        }
        fw.write("\t}\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* setEntityContext Called by container when the bean is initialized (i.e. moved into the pool)\n");
        fw.write("\t*\n");
        fw.write("\t*@param ctx The Entity Context\n");
        fw.write("\t*@exception java.rmi.RemoteException Network problems\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic void setEntityContext(javax.ejb.EntityContext ctx) throws java.rmi.RemoteException {\n");
        fw.write("\t\tentityContext = ctx;\n");
        fw.write("\t}\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* unsetEntityContext. Called by container when the beans leave the pooled state.\n");
        fw.write("\t*@exception java.rmi.RemoteException Network problems\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic void unsetEntityContext() throws java.rmi.RemoteException {\n");
        fw.write("\tentityContext = null;\n");
        fw.write("\t}\n");
        fw.write("\n} // " + name + "Bean");
        SourceFooterWriter.writeFooter(fw);
    }

    private void writeRelationSource(FileWriter fw, EJBRelation ejbRel) throws IOException {
        String name = ejbRel.getBeanName();
        fw.write("package " + this.package_name + "." + name + ";\n\n");
        SourceHeaderWriter.writeHeader(fw);
        if (this.monitorUpdates) {
            fw.write("\nimport " + this.monitor_package + ".*;\n");
        }
        fw.write("\n");
        fw.write("/**\n");
        fw.write("* Remote implementation of " + name + "\n");
        fw.write("*\n");
        fw.write("* @author Not known, this file was generated automatically\n");
        fw.write("**/\n");
        fw.write("\n");
        fw.write("public class " + name + "Bean implements javax.ejb.EntityBean { \n\n");
        fw.write("\tprivate javax.ejb.EntityContext entityContext = null;\n");
        fw.write("\tpublic String primaryKey;\n");
        fw.write("\tpublic String " + ejbRel.getFirstPField() + ";\n");
        fw.write("\tpublic String " + ejbRel.getSecondPField() + ";\n");
        int i = 0;
        while (i < ejbRel.getPersistantFieldCollection().getNufPersistantFields()) {
            PersistantField pf = ejbRel.getPersistantFieldCollection().getNthPersistantField(i);
            String field_name = pf.getFieldName();
            String field_type = pf.getJavaDT();
            fw.write("\tpublic " + field_type + " " + field_name + ";\n");
            ++i;
        }
        if (ejbRel.needsEncryption()) {
            fw.write("\tpublic java.lang.String CRYPTKEY;\n");
        }
        fw.write("\n");
        String bean1 = ejbRel.getFirstBean();
        String bean2 = ejbRel.getSecondBean();
        fw.write("\t/**\n");
        fw.write("\t* Get the " + ejbRel.getFirstPField() + " value of the " + name + " bean\n");
        fw.write("\t*\n");
        fw.write("\t* @return String Primary key value for bean " + bean1 + "\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic String get" + ejbRel.getFirstPField() + "() {\n");
        fw.write("\t\treturn " + ejbRel.getFirstPField() + ";\n");
        fw.write("\t}\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* Get the " + ejbRel.getSecondPField() + " value of the " + name + " bean\n");
        fw.write("\t*\n");
        fw.write("\t* @return String Primary key value for bean " + bean2 + "\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic String get" + ejbRel.getSecondPField() + "() {\n");
        fw.write("\t\treturn " + ejbRel.getSecondPField() + ";\n");
        fw.write("\t}\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* Set the " + ejbRel.getFirstPField() + " value of the " + name + " bean\n");
        fw.write("\t*\n");
        fw.write("\t* @param ref Primary key value for bean " + bean1 + "\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic void set" + ejbRel.getFirstPField() + "(String __ref) {\n");
        fw.write("\t\t" + ejbRel.getFirstPField() + " = __ref;\n");
        fw.write("\t}\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* Set the " + ejbRel.getSecondPField() + " value of the " + name + " bean\n");
        fw.write("\t*\n");
        fw.write("\t* @param ref Primary key value for bean " + bean2 + "\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic void set" + ejbRel.getSecondPField() + "(String __ref) {\n");
        fw.write("\t\t" + ejbRel.getSecondPField() + " = __ref;\n");
        fw.write("\t}\n");
        fw.write("\n");
        PersistantFieldCollection pfColl = ejbRel.getPersistantFieldCollection();
        int i2 = 0;
        while (i2 < pfColl.getNufPersistantFields()) {
            PersistantField pf = pfColl.getNthPersistantField(i2);
            String field_name = pf.getFieldName();
            String field_type = pf.getJavaDT();
            fw.write("\t/**\n");
            fw.write("\t* Get the " + field_name + " value of the " + name + " bean\n");
            fw.write("\t*\n");
            fw.write("\t* @return " + field_type + " Current value of the " + field_name + " field\n");
            fw.write("\t*/\n");
            fw.write("\n");
            fw.write("\tpublic " + field_type + " get" + field_name + "() {\n");
            fw.write("\t\treturn " + field_name + ";\n");
            fw.write("\t}\n");
            fw.write("\n");
            fw.write("\t/**\n");
            fw.write("\t* Set the  " + field_name + " value of the " + name + " bean\n");
            fw.write("\t*\n");
            fw.write("\t* @param val New value of the " + field_name + " field\n");
            fw.write("\t*/\n");
            fw.write("\n");
            fw.write("\tpublic void set" + field_name + "(" + field_type + " val) {\n");
            fw.write("\t\t" + field_name + " = val;\n");
            fw.write("\t}\n");
            fw.write("\n");
            ++i2;
        }
        fw.write("\t/**\n");
        fw.write("\t* getKey. Retrieve the primary key of the bean as a String\n");
        fw.write("\t* @return String The primary key\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic String getKey() { \n");
        fw.write("\t\treturn primaryKey;\n");
        fw.write("\t}\n\n");
        fw.write("\t/**\n");
        fw.write("\t* initialize. Quickly initialize the bean from an XML document\n");
        fw.write("\t*@param doc XML document instance\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic void initialize(org.w3c.dom.Document doc) {\n");
        fw.write("\t\t" + name + "XMLAdaptor adaptor = new " + name + "XMLAdaptor(doc);\n");
        fw.write("\t\tthis.initialize(adaptor);\n");
        fw.write("\t} // initialize\n\n");
        fw.write("\t/**\n");
        fw.write("\t* initialize. Quickly initialize the bean from a XML adaptor\n");
        fw.write("\t*@param adaptor adaptor instance\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic void initialize(" + name + "XMLAdaptor adaptor) {\n");
        String fname1 = ejbRel.getFirstPField();
        String fname2 = ejbRel.getSecondPField();
        fw.write("\t\tif(adaptor.get" + fname1 + "() != null) " + fname1 + " = adaptor.get" + fname1 + "();\n");
        fw.write("\t\tif(adaptor.get" + fname2 + "() != null) " + fname2 + " = adaptor.get" + fname2 + "();\n");
        int i3 = 0;
        while (i3 < ejbRel.getPersistantFieldCollection().getNufPersistantFields()) {
            PersistantField pf = ejbRel.getPersistantFieldCollection().getNthPersistantField(i3);
            String fname = pf.getFieldName();
            String ftype = pf.getJavaDT();
            if (ftype.equalsIgnoreCase("boolean")) {
                fw.write("\t\tif(adaptor.get" + fname + "() != null) " + fname + " = adaptor.get" + fname + "().booleanValue();\n");
            }
            if (ftype.equalsIgnoreCase("short")) {
                fw.write("\t\tif(adaptor.get" + fname + "() != null) " + fname + " = adaptor.get" + fname + "().shortValue();\n");
            } else if (ftype.equalsIgnoreCase("int")) {
                fw.write("\t\tif(adaptor.get" + fname + "() != null) " + fname + " = adaptor.get" + fname + "().intValue();\n");
            } else if (ftype.equalsIgnoreCase("long")) {
                fw.write("\t\tif(adaptor.get" + fname + "() != null) " + fname + " = adaptor.get" + fname + "().longValue();\n");
            } else if (ftype.equalsIgnoreCase("byte")) {
                fw.write("\t\tif(adaptor.get" + fname + "() != null) " + fname + " = adaptor.get" + fname + "().byteValue();\n");
            } else if (ftype.equalsIgnoreCase("char")) {
                fw.write("\t\tif(adaptor.get" + fname + "() != null) " + fname + " = adaptor.get" + fname + "().charValue();\n");
            } else if (ftype.equalsIgnoreCase("double")) {
                fw.write("\t\tif(adaptor.get" + fname + "() != null) " + fname + " = adaptor.get" + fname + "().doubleValue();\n");
            } else if (ftype.equalsIgnoreCase("float")) {
                fw.write("\t\tif(adaptor.get" + fname + "() != null) " + fname + " = adaptor.get" + fname + "().floatValue();\n");
            } else {
                fw.write("\t\tif(adaptor.get" + fname + "() != null) " + fname + " = adaptor.get" + fname + "();\n");
            }
            ++i3;
        }
        if (this.monitorUpdates) {
            fw.write("\t\ttry {\n");
            fw.write("\t\t\tCacheManager.getInstance().invalidate(this);\n");
            fw.write("\t\t}catch(com.ibm.almaden.cachemanager.MonitorInstantiationException mie) {mie.printStackTrace();}\n");
        }
        fw.write("\t} // initialize\n\n");
        fw.write("\t/**\n");
        fw.write("\t* getXML. Convert the bean into an XML document\n");
        fw.write("\t*@return org.w3c.dom.Document XML document instance\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic org.w3c.dom.Document getXML() {\n");
        fw.write("\t\t" + name + "XMLAdaptor adaptor = new " + name + "XMLAdaptor();\n");
        fw.write("\t\tif(" + fname1 + " != null) adaptor.set" + fname1 + "(" + fname1 + ");\n");
        fw.write("\t\tif(" + fname2 + " != null) adaptor.set" + fname2 + "(" + fname2 + ");\n");
        fw.write("\t\tadaptor.setPrimaryKey(primaryKey);\n");
        int i4 = 0;
        while (i4 < ejbRel.getPersistantFieldCollection().getNufPersistantFields()) {
            PersistantField pf = ejbRel.getPersistantFieldCollection().getNthPersistantField(i4);
            String fname = pf.getFieldName();
            String ftype = pf.getJavaDT();
            if (ftype.equalsIgnoreCase("boolean")) {
                fw.write("\t\tadaptor.set" + fname + "(new Boolean(" + fname + "));\n");
            } else if (ftype.equalsIgnoreCase("short")) {
                fw.write("\t\tadaptor.set" + fname + "(new Short(" + fname + "));\n");
            } else if (ftype.equalsIgnoreCase("int")) {
                fw.write("\t\tadaptor.set" + fname + "(new Integer(" + fname + "));\n");
            } else if (ftype.equalsIgnoreCase("long")) {
                fw.write("\t\tadaptor.set" + fname + "(new Long(" + fname + "));\n");
            } else if (ftype.equalsIgnoreCase("byte")) {
                fw.write("\t\tadaptor.set" + fname + "(new Byte(" + fname + "));\n");
            } else if (ftype.equalsIgnoreCase("char")) {
                fw.write("\t\tadaptor.set" + fname + "(new Char(" + fname + "));\n");
            } else if (ftype.equalsIgnoreCase("double")) {
                fw.write("\t\tadaptor.set" + fname + "(new Double(" + fname + "));\n");
            } else if (ftype.equalsIgnoreCase("float")) {
                fw.write("\t\tadaptor.set" + fname + "(new Float(" + fname + "));\n");
            } else {
                fw.write("\t\tif(" + fname + " != null) adaptor.set" + fname + "(" + fname + ");\n");
            }
            ++i4;
        }
        fw.write("\treturn adaptor.getXML();\n");
        fw.write("\t} // getXML\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* ejbActivate Automatically called by container when bean is being activated\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic void ejbActivate() throws java.rmi.RemoteException {\n");
        fw.write("\t}\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* ejbCreate method. Init primary key \n");
        fw.write("\t*@param key The " + name + " key\n");
        fw.write("\t*\n");
        fw.write("\t*/\n");
        fw.write("\n");
        if (EJBSourceGenerator.version < 4) {
            fw.write("\tpublic void ejbCreate(" + name + "Key key)  {\n");
        } else {
            fw.write("\tpublic " + name + "Key ejbCreate(" + name + "Key key)  {\n");
        }
        fw.write("\t\tprimaryKey = key.primaryKey;\n");
        int i5 = 0;
        while (i5 < pfColl.getNufPersistantFields()) {
            PersistantField pf = pfColl.getNthPersistantField(i5);
            String field_name = pf.getFieldName();
            String field_type = pf.getJavaDT();
            String def = pf.getDefault();
            if (field_type.equals("java.sql.Timestamp")) {
                fw.write("\t\t" + field_name + " = new java.sql.Timestamp(new java.util.Date().getTime());\n");
            }
            if (field_type.equals("java.sql.Time")) {
                fw.write("\t\t" + field_name + " = new java.sql.Time(new java.util.Date().getTime());\n");
            }
            if (def != null) {
                if (field_type.equals("java.lang.String")) {
                    fw.write("\t\t" + field_name + " = new java.lang.String(\"" + def + "\");\n");
                } else if (field_type.equals("java.lang.String")) {
                    fw.write("\t\t" + field_name + " = new java.lang.String(" + def + ");\n");
                } else if (field_type.equals("char")) {
                    fw.write("\t\t" + field_name + " = '" + def + "';\n");
                } else if (field_type.equals("byte")) {
                    fw.write("\t\t" + field_name + " = " + def + ";\n");
                } else if (field_type.equals("short")) {
                    fw.write("\t\t" + field_name + " = " + def + ";\n");
                } else if (field_type.equals("int")) {
                    fw.write("\t\t" + field_name + " = " + def + ";\n");
                } else if (field_type.equals("long")) {
                    fw.write("\t\t" + field_name + " = " + def + ";\n");
                } else if (field_type.equals("float")) {
                    fw.write("\t\t" + field_name + " = " + def + ";\n");
                } else if (field_type.equals("double")) {
                    fw.write("\t\t" + field_name + " = " + def + ";\n");
                }
            }
            ++i5;
        }
        if (EJBSourceGenerator.version >= 4) {
            fw.write("\treturn null;\n");
        }
        fw.write("   }\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* ejbLoad. Called automatically by container\n");
        fw.write("\t*@exception java.rmi.RemoteException Network problems\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic void ejbLoad () throws java.rmi.RemoteException {\n");
        fw.write("\t}\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* ejbPassivate: Called automatically by container when bean is passivated (not for CMP beans)\n");
        fw.write("\t*@exception java.rmi.RemoteException Network problems\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic void ejbPassivate() throws java.rmi.RemoteException {\n");
        fw.write("\t}\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* ejbPostCreate. Called automatcally by container after bean creation\n");
        fw.write("\t*@param key The " + name + " key\n");
        if (EJBSourceGenerator.version < 4) {
            fw.write("\t*@exception java.rmi.RemoteException Network problems\n");
        } else {
            fw.write("\t*@exception javax.ejb.EJBException EJB problems\n");
        }
        fw.write("\t*/\n");
        fw.write("\n");
        if (EJBSourceGenerator.version < 4) {
            fw.write("\tpublic void ejbPostCreate(" + name + "Key key) throws java.rmi.RemoteException {\n");
        } else {
            fw.write("\tpublic void ejbPostCreate(" + name + "Key key) throws javax.ejb.EJBException {\n");
        }
        fw.write("\t}\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* ejbStore: Called automatically by container\n");
        fw.write("\t*@exception java.rmi.RemoteException Network problems\n");
        fw.write("   */\n");
        fw.write("\n");
        fw.write("\tpublic void ejbStore () throws java.rmi.RemoteException {\n");
        fw.write("\t}\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* ejbRemove. Bean is being removed. Called automatically by container\n");
        fw.write("\t*@exception java.rmi.RemoteException Network problems\n");
        fw.write("\t*/\n");
        fw.write("\tpublic void ejbRemove() throws java.rmi.RemoteException {\n");
        if (this.monitorUpdates) {
            fw.write("\t\ttry {\n");
            fw.write("\t\t\tCacheManager.getInstance().invalidate(this);\n");
            fw.write("\t\t}catch(com.ibm.almaden.cachemanager.MonitorInstantiationException mie) {mie.printStackTrace();}\n");
        }
        fw.write("\t}\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* setEntityContext Called by container when the bean is initialized (i.e. moved into the pool)\n");
        fw.write("\t*\n");
        fw.write("\t*@param ctx The Entity Context\n");
        fw.write("\t*@exception java.rmi.RemoteException Network problems\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic void setEntityContext(javax.ejb.EntityContext ctx) throws java.rmi.RemoteException {\n");
        fw.write("\t\tentityContext = ctx;\n");
        fw.write("\t}\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* unsetEntityContext. Called by container when the beans leave the pooled state.\n");
        fw.write("\t*@exception java.rmi.RemoteException Network problems\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic void unsetEntityContext() throws java.rmi.RemoteException {\n");
        fw.write("\tentityContext = null;\n");
        fw.write("\t}\n");
        fw.write("\n} // " + name + "Bean");
        SourceFooterWriter.writeFooter(fw);
    }
}

