/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.almaden.ejbmaker;

import com.ibm.almaden.ejbmaker.EJBCollection;
import com.ibm.almaden.ejbmaker.EJBDescription;
import com.ibm.almaden.ejbmaker.EJBGenerator;
import com.ibm.almaden.ejbmaker.EJBRelation;
import com.ibm.almaden.ejbmaker.SmartWriter;
import com.ibm.almaden.ejbmaker.SourceFooterWriter;
import com.ibm.almaden.ejbmaker.SourceHeaderWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class EJBKeyGenerator
implements EJBGenerator {
    private String java_source_folder;
    private String package_name;
    private EJBCollection ejbCollection;

    public EJBKeyGenerator(String source, String pname, EJBCollection coll) {
        this.java_source_folder = source;
        this.package_name = pname;
        this.ejbCollection = coll;
    }

    public void generate() throws IOException {
        int i = 0;
        while (i < this.ejbCollection.getNufDescriptions()) {
            EJBDescription ejbDesc = this.ejbCollection.getNthDescription(i);
            String bean_name = ejbDesc.getBeanName();
            String java_file_name = this.java_source_folder + File.separator + bean_name + File.separator + bean_name + "Key.java";
            SmartWriter sw = new SmartWriter(java_file_name);
            FileWriter fw = sw.createFile();
            this.writeDescriptionSouce(fw, ejbDesc);
            sw.copyAndClose();
            ++i;
        }
        int i2 = 0;
        while (i2 < this.ejbCollection.getNufRelations()) {
            EJBRelation ejbRel = this.ejbCollection.getNthRelation(i2);
            String bean_name = ejbRel.getBeanName();
            String java_file_name = this.java_source_folder + File.separator + bean_name + File.separator + bean_name + "Key.java";
            SmartWriter sw = new SmartWriter(java_file_name);
            FileWriter fw = sw.createFile();
            this.writeRelationSouce(fw, ejbRel);
            sw.copyAndClose();
            ++i2;
        }
    }

    private void writeDescriptionSouce(FileWriter fw, EJBDescription ejbDesc) throws IOException {
        String name = ejbDesc.getBeanName();
        fw.write("package " + this.package_name + "." + name + ";\n\n");
        SourceHeaderWriter.writeHeader(fw);
        fw.write("\n");
        fw.write("/**\n");
        fw.write("* Key class of " + name + "\n");
        fw.write("*\n");
        fw.write("* @author Not known, this file was generated automatically\n");
        fw.write("**/\n");
        fw.write("\n");
        fw.write("public class " + name + "Key implements java.io.Serializable { \n\n");
        fw.write("\tpublic java.lang.String primaryKey;\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* Default constructor\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic " + name + "Key() {\n");
        fw.write("\t\tsuper();\n");
        fw.write("\t}\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* Initialize a key from the passed values\n");
        fw.write("\t* @param argPrimaryKey java.lang.String\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic " + name + "Key(java.lang.String argPrimaryKey) {\n");
        fw.write("\t\tprimaryKey = argPrimaryKey;\n");
        fw.write("\t}\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* equals method\n");
        fw.write("\t* @return boolean\n");
        fw.write("\t* @param o java.lang.Object\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic boolean equals(Object o) {\n");
        fw.write("\t\tif (o instanceof " + name + "Key) {\n");
        fw.write("\t\t\t" + name + "Key otherKey = (" + name + "Key) o;\n");
        fw.write("\t\t\treturn ((primaryKey.equals(otherKey.primaryKey)));\n");
        fw.write("\t\t}\n");
        fw.write("\t\telse\n");
        fw.write("\t\treturn false;\n");
        fw.write("\t}\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* hashCode method\n");
        fw.write("\t* @return int\n");
        fw.write("\t*/\n");
        fw.write("\tpublic int hashCode() {\n");
        fw.write("\t\treturn (primaryKey.hashCode());\n");
        fw.write("\t}\n");
        fw.write("\n} // " + name + "Key");
        SourceFooterWriter.writeFooter(fw);
    }

    private void writeRelationSouce(FileWriter fw, EJBRelation ejbRel) throws IOException {
        String name = ejbRel.getBeanName();
        fw.write("package " + this.package_name + "." + name + ";\n\n");
        SourceHeaderWriter.writeHeader(fw);
        fw.write("\n");
        fw.write("/**\n");
        fw.write("* Key class of " + name + "\n");
        fw.write("*\n");
        fw.write("* @author Not known, this file was generated automatically\n");
        fw.write("**/\n");
        fw.write("\n");
        fw.write("public class " + name + "Key implements java.io.Serializable { \n\n");
        fw.write("\tpublic java.lang.String primaryKey;\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* Default constructor\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic " + name + "Key() {\n");
        fw.write("\t\tsuper();\n");
        fw.write("\t}\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* Initialize a key from the passed values\n");
        fw.write("\t* @param argPrimaryKey java.lang.String\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic " + name + "Key(java.lang.String argPrimaryKey) {\n");
        fw.write("\t\tprimaryKey = argPrimaryKey;\n");
        fw.write("\t}\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* equals method\n");
        fw.write("\t* @return boolean\n");
        fw.write("\t* @param o java.lang.Object\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic boolean equals(Object o) {\n");
        fw.write("\t\tif (o instanceof " + name + "Key) {\n");
        fw.write("\t\t\t" + name + "Key otherKey = (" + name + "Key) o;\n");
        fw.write("\t\t\treturn ((primaryKey.equals(otherKey.primaryKey)));\n");
        fw.write("\t\t}\n");
        fw.write("\t\telse\n");
        fw.write("\t\treturn false;\n");
        fw.write("\t}\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* hashCode method\n");
        fw.write("\t* @return int\n");
        fw.write("\t*/\n");
        fw.write("\tpublic int hashCode() {\n");
        fw.write("\t\treturn (primaryKey.hashCode());\n");
        fw.write("\t}\n");
        fw.write("\n} // " + name + "Key");
        SourceFooterWriter.writeFooter(fw);
    }
}

