/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.almaden.ejbmaker;

import com.ibm.almaden.ejbmaker.EJBCollection;
import com.ibm.almaden.ejbmaker.EJBDescription;
import com.ibm.almaden.ejbmaker.EJBGenerator;
import com.ibm.almaden.ejbmaker.EJBRelation;
import com.ibm.almaden.ejbmaker.EJBSourceGenerator;
import com.ibm.almaden.ejbmaker.FinderMethod;
import com.ibm.almaden.ejbmaker.FinderMethodCollection;
import com.ibm.almaden.ejbmaker.PersistantField;
import com.ibm.almaden.ejbmaker.PersistantFieldCollection;
import com.ibm.almaden.ejbmaker.SmartWriter;
import com.ibm.almaden.ejbmaker.SourceFooterWriter;
import com.ibm.almaden.ejbmaker.SourceHeaderWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class EJBHomeInterfaceGenerator
implements EJBGenerator {
    private String java_source_folder;
    private String package_name;
    private EJBCollection ejbCollection;

    public EJBHomeInterfaceGenerator(String source, String pname, EJBCollection coll) {
        this.java_source_folder = source;
        this.package_name = pname;
        this.ejbCollection = coll;
    }

    public void generate() throws IOException {
        int i = 0;
        while (i < this.ejbCollection.getNufDescriptions()) {
            EJBDescription ejbDesc = this.ejbCollection.getNthDescription(i);
            String bean_name = ejbDesc.getBeanName();
            String java_file_name = this.java_source_folder + File.separator + bean_name + File.separator + bean_name + "Home.java";
            SmartWriter sw = new SmartWriter(java_file_name);
            FileWriter fw = sw.createFile();
            this.writeDescriptionSouce(fw, ejbDesc);
            sw.copyAndClose();
            ++i;
        }
        int i2 = 0;
        while (i2 < this.ejbCollection.getNufRelations()) {
            EJBRelation ejbRel = this.ejbCollection.getNthRelation(i2);
            String bean_name = ejbRel.getBeanName();
            String java_file_name = this.java_source_folder + File.separator + bean_name + File.separator + bean_name + "Home.java";
            SmartWriter sw = new SmartWriter(java_file_name);
            FileWriter fw = sw.createFile();
            this.writeRelationSouce(fw, ejbRel);
            sw.copyAndClose();
            ++i2;
        }
    }

    private void writeDescriptionSouce(FileWriter fw, EJBDescription ejbDesc) throws IOException {
        String name = ejbDesc.getBeanName();
        fw.write("package " + this.package_name + "." + name + ";\n\n");
        SourceHeaderWriter.writeHeader(fw);
        fw.write("\n");
        fw.write("/**\n");
        fw.write("* Home interface for " + name + "\n");
        fw.write("*\n");
        fw.write("* @author Not known, this file was generated automatically\n");
        fw.write("**/\n");
        fw.write("\n");
        fw.write("public interface " + name + "Home" + " extends javax.ejb.EJBHome  { \n\n");
        fw.write("\t/**\n");
        fw.write("\t* Create a new " + name + " with default field values. \n");
        fw.write("\t*/\n");
        fw.write("\n");
        if (EJBSourceGenerator.version < 4) {
            fw.write("\tpublic " + name + " create ( " + this.package_name + "." + name + "." + name + "Key primaryKey)  throws javax.ejb.CreateException, java.rmi.RemoteException;\n");
        } else {
            fw.write("\tpublic " + name + " create ( " + this.package_name + "." + name + "." + name + "Key primaryKey)  throws javax.ejb.CreateException, javax.ejb.EJBException, java.rmi.RemoteException;\n");
        }
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* findByPrimaryKey Retrieve a " + name + " by its primary key\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic " + name + " findByPrimaryKey (" + this.package_name + "." + name + "." + name + "Key primaryKey) throws java.rmi.RemoteException, javax.ejb.FinderException;\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* findAllInstances Retrieve all instances of the bean \n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic java.util.Enumeration findAllInstances () throws java.rmi.RemoteException, javax.ejb.FinderException;\n");
        fw.write("\n");
        PersistantFieldCollection pfColl = ejbDesc.getPersistantFieldCollection();
        int i = 0;
        while (i < pfColl.getNufPersistantFields()) {
            PersistantField pf = pfColl.getNthPersistantField(i);
            fw.write("\t/**\n");
            fw.write("\t* Retrieve " + name + " instances matching the " + pf.getFieldName() + " persistant field\n");
            fw.write("\t*\n");
            fw.write("\t* @return java.util.Enumeration Enumeration of instances of matching " + name + " instances\n");
            fw.write("\t* @exception java.rmi.RemoteException Typically thrown when network problems occur\n");
            fw.write("\t* @exception javax.ejb.FinderException Thrown when the find fails\n");
            fw.write("\t*/\n");
            fw.write("\n");
            fw.write("\tjava.util.Enumeration findBy" + pf.getFieldName() + "(" + pf.getJavaDT() + " ___val) throws java.rmi.RemoteException, javax.ejb.FinderException;\n");
            fw.write("\n");
            ++i;
        }
        if (ejbDesc.getBeanType().equalsIgnoreCase("topic")) {
            fw.write("\t/**\n");
            fw.write("\t* Retrieve " + name + " instances in the order they were created\n");
            fw.write("\t*\n");
            fw.write("\t* @return java.util.Enumeration Enumeration of " + name + " instances\n");
            fw.write("\t* @exception java.rmi.RemoteException Typically thrown when network problems occur\n");
            fw.write("\t* @exception javax.ejb.FinderException Thrown when the find fails\n");
            fw.write("\t*/\n");
            fw.write("\n");
            fw.write("\tjava.util.Enumeration findByRecordCreated() throws java.rmi.RemoteException, javax.ejb.FinderException;\n");
            fw.write("\n");
        }
        int i2 = 0;
        while (i2 < this.ejbCollection.getNufRelations()) {
            EJBRelation rel = this.ejbCollection.getNthRelation(i2);
            String related_bean = null;
            if (rel.getFirstBean().equals(name)) {
                related_bean = rel.getSecondBean();
            }
            if (rel.getSecondBean().equals(name)) {
                related_bean = rel.getFirstBean();
            }
            if (related_bean != null) {
                String relation_name = rel.getBeanName();
                if (related_bean.equals(name)) {
                    fw.write("\t/**\n");
                    fw.write("\t* Retrieve " + name + " instances related to the " + relation_name + " bean\n");
                    fw.write("\t*\n");
                    fw.write("\t* @return java.util.Enumeration Enumeration of instances related to the " + relation_name + " bean\n");
                    fw.write("\t* @exception java.rmi.RemoteException Typically thrown when network problems occur\n");
                    fw.write("\t* @exception javax.ejb.FinderException Thrown when the find fails\n");
                    fw.write("\t*/\n");
                    fw.write("\n");
                    fw.write("\tjava.util.Enumeration findBy" + relation_name + "From(String __ptr) throws java.rmi.RemoteException, javax.ejb.FinderException;\n");
                    fw.write("\n");
                    fw.write("\t/**\n");
                    fw.write("\t* Retrieve " + name + " instances related to the " + relation_name + " bean\n");
                    fw.write("\t*\n");
                    fw.write("\t* @return java.util.Enumeration Enumeration of instances related to the " + relation_name + " bean\n");
                    fw.write("\t* @exception java.rmi.RemoteException Typically thrown when network problems occur\n");
                    fw.write("\t* @exception javax.ejb.FinderException Thrown when the find fails\n");
                    fw.write("\t*/\n");
                    fw.write("\n");
                    fw.write("\tjava.util.Enumeration findBy" + relation_name + "To(String __ptr) throws java.rmi.RemoteException, javax.ejb.FinderException;\n");
                    fw.write("\n");
                } else {
                    fw.write("\t/**\n");
                    fw.write("\t* Retrieve " + name + " instances related to the " + relation_name + " bean\n");
                    fw.write("\t*\n");
                    fw.write("\t* @return java.util.Enumeration Enumeration of instances related to the " + relation_name + " bean\n");
                    fw.write("\t* @exception java.rmi.RemoteException Typically thrown when network problems occur\n");
                    fw.write("\t* @exception javax.ejb.FinderException Thrown when the find fails\n");
                    fw.write("\t*/\n");
                    fw.write("\n");
                    fw.write("\tjava.util.Enumeration findBy" + relation_name + "(String __ptr) throws java.rmi.RemoteException, javax.ejb.FinderException;\n");
                    fw.write("\n");
                }
            }
            ++i2;
        }
        FinderMethodCollection fmc = ejbDesc.getFinderMethodCollection();
        int i3 = 0;
        while (i3 < fmc.getNufFinderMethods()) {
            FinderMethod fm = fmc.getNthFinderMethod(i3);
            String fname = fm.getMethodName();
            fw.write("\t/**\n");
            fw.write("\t* User defined finder method\n");
            fw.write("\t*\n");
            fw.write("\t* @return java.util.Enumeration of " + name + " beans\n");
            fw.write("\t* @exception java.rmi.RemoteException Typically thrown when network problems occur\n");
            fw.write("\t* @exception javax.ejb.FinderException Thrown when the find fails\n");
            fw.write("\t*/\n");
            fw.write("\n");
            fw.write("\tjava.util.Enumeration " + fname + "(");
            int j = 0;
            while (j < fm.getNufArguments()) {
                String arg_type = fm.getNthArgType(j);
                fw.write(arg_type + " arg" + j);
                if (j < fm.getNufArguments() - 1) {
                    fw.write(", ");
                }
                ++j;
            }
            fw.write(") throws java.rmi.RemoteException, javax.ejb.FinderException;\n");
            fw.write("\n");
            ++i3;
        }
        fw.write("} // " + name + "Home");
        SourceFooterWriter.writeFooter(fw);
    }

    private void writeRelationSouce(FileWriter fw, EJBRelation ejbRel) throws IOException {
        String name = ejbRel.getBeanName();
        fw.write("package " + this.package_name + "." + name + ";\n\n");
        SourceHeaderWriter.writeHeader(fw);
        fw.write("\n");
        fw.write("/**\n");
        fw.write("* Home interface for " + name + "\n");
        fw.write("*\n");
        fw.write("* @author Not known, this file was generated automatically\n");
        fw.write("**/\n");
        fw.write("\n");
        fw.write("public interface " + name + "Home" + " extends javax.ejb.EJBHome  { \n\n");
        fw.write("\t/**\n");
        fw.write("\t* Create a new " + name + " with default field values. \n");
        fw.write("\t*/\n");
        fw.write("\n");
        if (EJBSourceGenerator.version < 4) {
            fw.write("\tpublic " + name + " create ( " + this.package_name + "." + name + "." + name + "Key primaryKey)  throws javax.ejb.CreateException, java.rmi.RemoteException;\n");
        } else {
            fw.write("\tpublic " + name + " create ( " + this.package_name + "." + name + "." + name + "Key primaryKey)  throws javax.ejb.CreateException, javax.ejb.EJBException, java.rmi.RemoteException;\n");
        }
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* findByPrimaryKey Retrieve a " + name + " by its primary key\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic " + name + " findByPrimaryKey (" + this.package_name + "." + name + "." + name + "Key primaryKey) throws java.rmi.RemoteException, javax.ejb.FinderException;\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* findAllInstances Retrieve all instances of the bean \n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic java.util.Enumeration findAllInstances () throws java.rmi.RemoteException, javax.ejb.FinderException;\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* Retrieve " + name + " instances matching the " + ejbRel.getFirstBean() + " pointer\n");
        fw.write("\t*\n");
        fw.write("\t* @return java.util.Enumeration Enumeration of instances of matching " + name + " instances\n");
        fw.write("\t* @exception java.rmi.RemoteException Typically thrown when network problems occur\n");
        fw.write("\t* @exception javax.ejb.FinderException Thrown when the find fails\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tjava.util.Enumeration findBy" + ejbRel.getFirstPField() + "(String __val) throws java.rmi.RemoteException, javax.ejb.FinderException;\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* Retrieve " + name + " instances matching the " + ejbRel.getSecondBean() + " pointer\n");
        fw.write("\t*\n");
        fw.write("\t* @return java.util.Enumeration Enumeration of instances of matching " + name + " instances\n");
        fw.write("\t* @exception java.rmi.RemoteException Typically thrown when network problems occur\n");
        fw.write("\t* @exception javax.ejb.FinderException Thrown when the find fails\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tjava.util.Enumeration findBy" + ejbRel.getSecondPField() + "(String __val) throws java.rmi.RemoteException, javax.ejb.FinderException;\n");
        fw.write("\t/**\n");
        fw.write("\t* Retrive " + name + " instances matching both the " + ejbRel.getFirstBean() + " pointer and the " + ejbRel.getSecondBean() + " pointer \n");
        fw.write("\t*\n");
        fw.write("\t* @return java.util.Enumeration Enumeration of instances of matching " + name + " instances\n");
        fw.write("\t* @exception java.rmi.RemoteException Typically thrown when network problems occur\n");
        fw.write("\t* @exception javax.ejb.FinderException Thrown when the find fails\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tjava.util.Enumeration findBy" + ejbRel.getFirstPField() + "And" + ejbRel.getSecondPField() + "(String __val1, String __val2) throws java.rmi.RemoteException, javax.ejb.FinderException;\n");
        fw.write("\n");
        fw.write("} // " + name + "Home");
        SourceFooterWriter.writeFooter(fw);
    }
}

