/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.almaden.ejbmaker;

import com.ibm.almaden.ejbmaker.EJBCollection;
import com.ibm.almaden.ejbmaker.EJBDescription;
import com.ibm.almaden.ejbmaker.EJBGenerator;
import com.ibm.almaden.ejbmaker.EJBRelation;
import com.ibm.almaden.ejbmaker.EJBSourceGenerator;
import com.ibm.almaden.ejbmaker.FinderMethod;
import com.ibm.almaden.ejbmaker.FinderMethodCollection;
import com.ibm.almaden.ejbmaker.PersistantField;
import com.ibm.almaden.ejbmaker.PersistantFieldCollection;
import com.ibm.almaden.ejbmaker.SmartWriter;
import com.ibm.almaden.ejbmaker.SourceFooterWriter;
import com.ibm.almaden.ejbmaker.SourceHeaderWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class EJBFinderHelperGenerator
implements EJBGenerator {
    private String java_source_folder;
    private String package_name;
    private EJBCollection ejbCollection;

    public EJBFinderHelperGenerator(String source, String pname, EJBCollection coll) {
        this.java_source_folder = source;
        this.package_name = pname;
        this.ejbCollection = coll;
    }

    public void generate() throws IOException {
        int i = 0;
        while (i < this.ejbCollection.getNufDescriptions()) {
            EJBDescription ejbDesc = this.ejbCollection.getNthDescription(i);
            String bean_name = ejbDesc.getBeanName();
            String java_file_name = this.java_source_folder + File.separator + bean_name + File.separator + bean_name + "BeanFinderHelper.java";
            SmartWriter sw = new SmartWriter(java_file_name);
            FileWriter fw = sw.createFile();
            this.writeDescriptionSouce(fw, ejbDesc);
            sw.copyAndClose();
            ++i;
        }
        int i2 = 0;
        while (i2 < this.ejbCollection.getNufRelations()) {
            EJBRelation ejbRel = this.ejbCollection.getNthRelation(i2);
            String bean_name = ejbRel.getBeanName();
            String java_file_name = this.java_source_folder + File.separator + bean_name + File.separator + bean_name + "BeanFinderHelper.java";
            SmartWriter sw = new SmartWriter(java_file_name);
            FileWriter fw = sw.createFile();
            this.writeRelationSouce(fw, ejbRel);
            sw.copyAndClose();
            ++i2;
        }
    }

    private void writeDescriptionSouce(FileWriter fw, EJBDescription ejbDesc) throws IOException {
        String name = ejbDesc.getBeanName();
        fw.write("package " + this.package_name + "." + name + ";\n\n");
        SourceHeaderWriter.writeHeader(fw);
        fw.write("\n");
        fw.write("/**\n");
        fw.write("* FinderHelper interface for " + name + "\n");
        fw.write("*\n");
        fw.write("* @author Not known, this file was generated automatically\n");
        fw.write("**/\n");
        fw.write("\n");
        fw.write("public interface " + name + "BeanFinderHelper" + " { \n\n");
        if (EJBSourceGenerator.version < 4) {
            fw.write("\tfinal static String findAllInstancesQueryString  = \"SELECT * FROM EJB." + name + "BEANTBL\";\n");
        } else {
            fw.write("\tfinal static String findAllInstancesQueryString  = \"SELECT * FROM " + name + "\";\n");
        }
        PersistantFieldCollection pfColl = ejbDesc.getPersistantFieldCollection();
        int i = 0;
        while (i < pfColl.getNufPersistantFields()) {
            PersistantField pf = pfColl.getNthPersistantField(i);
            if (EJBSourceGenerator.version < 4) {
                fw.write("\tfinal static String findBy" + pf.getFieldName() + "QueryString  = \"SELECT * FROM EJB." + name + "BEANTBL WHERE " + pf.getFieldName() + " = ?\";\n");
            } else {
                fw.write("\tfinal static String findBy" + pf.getFieldName() + "QueryString  = \"SELECT * FROM " + name + " WHERE " + pf.getFieldName() + " = ?\";\n");
            }
            ++i;
        }
        if (ejbDesc.getBeanType().equalsIgnoreCase("topic")) {
            if (EJBSourceGenerator.version < 4) {
                fw.write("   final static String findByRecordCreatedQueryString = \"SELECT * FROM EJB." + name + "BEANTBL ORDER BY REC_CRTD DESC\";\n");
            } else {
                fw.write("   final static String findByRecordCreatedQueryString = \"SELECT * FROM " + name + " ORDER BY REC_CRTD DESC\";\n");
            }
        }
        int i2 = 0;
        while (i2 < this.ejbCollection.getNufRelations()) {
            EJBRelation rel = this.ejbCollection.getNthRelation(i2);
            String related_bean = null;
            String pfield = null;
            String otherpfield = null;
            if (rel.getFirstBean().equals(name)) {
                related_bean = rel.getSecondBean();
                pfield = rel.getFirstPField();
                otherpfield = rel.getSecondPField();
            }
            if (rel.getSecondBean().equals(name)) {
                related_bean = rel.getFirstBean();
                pfield = rel.getSecondPField();
                otherpfield = rel.getFirstPField();
            }
            if (related_bean != null) {
                String relation_name = rel.getBeanName();
                if (related_bean.equals(name)) {
                    if (EJBSourceGenerator.version < 4) {
                        fw.write("\tfinal static String findBy" + relation_name + "FromQueryString  = \"SELECT * FROM EJB." + name + "BEANTBL T1, EJB." + relation_name + "BEANTBL T2 WHERE T2." + pfield + " = ? AND T1.PRIMARYKEY = T2." + otherpfield + "\";\n");
                        fw.write("\tfinal static String findBy" + relation_name + "ToQueryString  = \"SELECT * FROM EJB." + name + "BEANTBL T1, EJB." + relation_name + "BEANTBL T2 WHERE T2." + otherpfield + " = ? AND T1.PRIMARYKEY = T2." + pfield + "\";\n");
                    } else {
                        fw.write("\tfinal static String findBy" + relation_name + "FromQueryString  = \"SELECT * FROM " + name + " T1, " + relation_name + " T2 WHERE T2." + pfield + " = ? AND T1.PRIMARYKEY = T2." + otherpfield + "\";\n");
                        fw.write("\tfinal static String findBy" + relation_name + "ToQueryString  = \"SELECT * FROM " + name + " T1, " + relation_name + " T2 WHERE T2." + otherpfield + " = ? AND T1.PRIMARYKEY = T2." + pfield + "\";\n");
                    }
                } else if (EJBSourceGenerator.version < 4) {
                    fw.write("\tfinal static String findBy" + relation_name + "QueryString  = \"SELECT * FROM EJB." + name + "BEANTBL T1, EJB." + relation_name + "BEANTBL T2 WHERE T2." + otherpfield + " = ? AND T1.PRIMARYKEY = T2." + pfield + "\";\n");
                } else {
                    fw.write("\tfinal static String findBy" + relation_name + "QueryString  = \"SELECT * FROM " + name + " T1, " + relation_name + " T2 WHERE T2." + otherpfield + " = ? AND T1.PRIMARYKEY = T2." + pfield + "\";\n");
                }
            }
            ++i2;
        }
        FinderMethodCollection fmc = ejbDesc.getFinderMethodCollection();
        int i3 = 0;
        while (i3 < fmc.getNufFinderMethods()) {
            FinderMethod fm = fmc.getNthFinderMethod(i3);
            String fname = fm.getMethodName();
            fw.write("\tfinal static String " + fname + "QueryString = \"" + fm.getSQL() + "\";\n");
            ++i3;
        }
        fw.write("\n} // " + name + "FinderHelper");
        SourceFooterWriter.writeFooter(fw);
    }

    private void writeRelationSouce(FileWriter fw, EJBRelation ejbRel) throws IOException {
        String name = ejbRel.getBeanName();
        fw.write("package " + this.package_name + "." + name + ";\n\n");
        SourceHeaderWriter.writeHeader(fw);
        fw.write("\n");
        fw.write("/**\n");
        fw.write("* FinderHelper interface for " + name + "\n");
        fw.write("*\n");
        fw.write("* @author Not known, this file was generated automatically\n");
        fw.write("**/\n");
        fw.write("\n");
        fw.write("public interface " + name + "BeanFinderHelper" + " { \n\n");
        if (EJBSourceGenerator.version < 4) {
            fw.write("\tfinal static String findAllInstancesQueryString  = \"SELECT * FROM EJB." + name + "BEANTBL\";\n");
            fw.write("\tfinal static String findBy" + ejbRel.getFirstPField() + "QueryString = \"SELECT * FROM EJB." + name + "BEANTBL WHERE " + ejbRel.getFirstPField() + " = ?\";\n");
            fw.write("\tfinal static String findBy" + ejbRel.getSecondPField() + "QueryString = \"SELECT * FROM EJB." + name + "BEANTBL WHERE " + ejbRel.getSecondPField() + " = ?\";\n");
            fw.write("\tfinal static String findBy" + ejbRel.getFirstPField() + "And" + ejbRel.getSecondPField() + "QueryString = \"SELECT * FROM EJB." + name + "BEANTBL WHERE " + ejbRel.getFirstPField() + " = ? AND " + ejbRel.getSecondPField() + "= ? \";\n");
        } else {
            fw.write("\tfinal static String findAllInstancesQueryString  = \"SELECT * FROM " + name + "\";\n");
            fw.write("\tfinal static String findBy" + ejbRel.getFirstPField() + "QueryString = \"SELECT * FROM " + name + " WHERE " + ejbRel.getFirstPField() + " = ?\";\n");
            fw.write("\tfinal static String findBy" + ejbRel.getSecondPField() + "QueryString = \"SELECT * FROM " + name + " WHERE " + ejbRel.getSecondPField() + " = ?\";\n");
            fw.write("\tfinal static String findBy" + ejbRel.getFirstPField() + "And" + ejbRel.getSecondPField() + "QueryString = \"SELECT * FROM " + name + " WHERE " + ejbRel.getFirstPField() + " = ? AND " + ejbRel.getSecondPField() + "= ? \";\n");
        }
        fw.write("} // " + name + "BeanFinderHelper\n");
        SourceFooterWriter.writeFooter(fw);
    }
}

