/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.almaden.ejbmaker;

import com.ibm.almaden.ejbmaker.FinderMethod;
import com.ibm.almaden.ejbmaker.FinderMethodCollection;
import com.ibm.almaden.ejbmaker.PersistantField;
import com.ibm.almaden.ejbmaker.PersistantFieldCollection;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class EJBDescription {
    private String transaction_attr = null;
    private String isolation_level = null;
    private String run_as_mode_value = null;
    private boolean needsEncryption = false;
    private String reentrant = null;
    public static final String FINDER_METHOD_ELM = "finder-method";
    public static final String PERSISTANT_FIELD_ELM = "persistent-field";
    public static final String BEAN_NAME_ATTR = "name";
    public static final String BEAN_TYPE_ATTR = "type";
    private String bean_jndi_name;
    private String bean_type;
    private PersistantFieldCollection ejbFieldCollection;
    private FinderMethodCollection ejbMethodCollection;

    public EJBDescription() {
    }

    public EJBDescription(Element bean_elm) {
        this.initialize(bean_elm);
    }

    public void initialize(Element bean_elm) {
        this.bean_jndi_name = bean_elm.getAttribute(BEAN_NAME_ATTR);
        this.bean_type = bean_elm.getAttribute(BEAN_TYPE_ATTR);
        PersistantFieldCollection pfc = new PersistantFieldCollection();
        NodeList pf_nl = bean_elm.getElementsByTagName(PERSISTANT_FIELD_ELM);
        int i = 0;
        while (i < pf_nl.getLength()) {
            Element pf_elm = (Element)pf_nl.item(i);
            PersistantField pf = new PersistantField(pf_elm);
            if (pf.getEncrypt()) {
                this.needsEncryption = true;
            }
            pfc.addPersistantField(pf);
            ++i;
        }
        this.ejbFieldCollection = pfc;
        FinderMethodCollection fmc = new FinderMethodCollection();
        NodeList fm_nl = bean_elm.getElementsByTagName(FINDER_METHOD_ELM);
        int i2 = 0;
        while (i2 < fm_nl.getLength()) {
            Element fm_elm = (Element)fm_nl.item(i2);
            FinderMethod fm = new FinderMethod(fm_elm);
            fmc.addFinderMethod(fm);
            ++i2;
        }
        this.ejbMethodCollection = fmc;
    }

    public String getBeanName() {
        return this.bean_jndi_name;
    }

    public String getBeanType() {
        return this.bean_type;
    }

    public PersistantFieldCollection getPersistantFieldCollection() {
        return this.ejbFieldCollection;
    }

    public FinderMethodCollection getFinderMethodCollection() {
        return this.ejbMethodCollection;
    }

    public void setTransactionAttribute(String attr) {
        this.transaction_attr = attr;
    }

    public void setIsolationLevel(String il) {
        this.isolation_level = il;
    }

    public void setRunAsMode(String ram) {
        this.run_as_mode_value = ram;
    }

    public void setReentrant(String re) {
        this.reentrant = re;
    }

    public String getTransactionAttribute() {
        return this.transaction_attr;
    }

    public String getIsolationLevel() {
        return this.isolation_level;
    }

    public String getRunAsMode() {
        return this.run_as_mode_value;
    }

    public String getReentrant() {
        return this.reentrant;
    }

    public boolean needsEncryption() {
        return this.needsEncryption;
    }
}

