/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.almaden.ejbmaker;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class CreateSQLViews {
    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: CreateSQLViews <xml file> <ddl file>");
            System.exit(-1);
        }
        String ddlfilename = args.length == 2 ? args[1] : "CreateViews.ddl";
        FileReader fr = null;
        try {
            fr = new FileReader(args[0]);
        }
        catch (Exception e) {
            System.out.println("Cannot open " + args[0]);
            System.exit(-1);
        }
        FileWriter fw = null;
        PrintWriter pw = null;
        try {
            fw = new FileWriter(ddlfilename);
            pw = new PrintWriter(fw);
        }
        catch (Exception e) {
            System.out.println("Cannot write " + ddlfilename);
            System.exit(-1);
        }
        DOMParser parser = new DOMParser();
        InputSource inputXML = new InputSource(fr);
        try {
            parser.parse(inputXML);
        }
        catch (Exception e) {
            System.out.println("Error parsing XML file: " + e.getMessage());
            System.exit(-1);
        }
        Document doc = parser.getDocument();
        String package_name = null;
        NodeList package_nl = doc.getElementsByTagName("PACKAGE");
        if (package_nl.getLength() > 0) {
            Element pack_el = (Element)package_nl.item(0);
            package_name = pack_el.getFirstChild().getNodeValue();
        }
        NodeList name_tags = doc.getElementsByTagName("NAME");
        int i = 0;
        while (i < name_tags.getLength()) {
            Element name_el = (Element)name_tags.item(i);
            Text name_text = (Text)name_el.getFirstChild();
            String name = name_text.getData();
            if (name == null || name.equals("")) {
                System.err.println("Error, bean has empty name, exiting ... ");
                System.exit(-1);
            }
            String classname = package_name + "." + name + ".EJSJDBCPersister" + name + "Bean";
            System.out.println("Loading class: " + classname);
            Class<?> persisterClass = null;
            try {
                persisterClass = Class.forName(classname);
            }
            catch (Exception e) {
                System.err.println("Error, cannot load class " + classname + " " + e.getMessage());
                System.exit(-1);
            }
            Method method = null;
            try {
                method = persisterClass.getMethod("getCreateTableSQLStrings_DB2", null);
            }
            catch (Exception e) {
                System.err.println("Error, problems getting method getCreateTableSQLStrings_DB2: " + e.getClass() + e.getMessage());
                System.exit(-1);
            }
            Object obj = null;
            try {
                obj = method.invoke(null, null);
            }
            catch (Exception e) {
                System.err.println("Problems invoking method getCreateTableSQLStrings_DB2: " + e.getClass() + " " + e.getMessage());
                System.exit(-1);
            }
            String[] sql_str = (String[])obj;
            String sql = sql_str[0];
            int p_ind = sql.indexOf("(");
            StringBuffer sb = new StringBuffer("create view ejb." + name + "beantbl as select ");
            sql = sql.substring(p_ind + 1).trim();
            while (true) {
                int cind = sql.indexOf(",");
                int spind = sql.indexOf(" ");
                String cname = sql.substring(0, spind);
                if (cname.equalsIgnoreCase("primary")) break;
                sb.append(cname + ", ");
                sql = sql.substring(cind + 1).trim();
            }
            sb = new StringBuffer(sb.toString().substring(0, sb.length() - 2));
            sb.append(" from ejb." + name);
            pw.println("-- " + name + "\n" + sb.toString() + "\n");
            ++i;
        }
        try {
            fw.close();
            fr.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

