/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.almaden.ejbmaker;

import com.ibm.almaden.ejbmaker.EJBCollection;
import com.ibm.almaden.ejbmaker.EJBDescription;
import com.ibm.almaden.ejbmaker.EJBGenerator;
import com.ibm.almaden.ejbmaker.EJBRelation;
import com.ibm.almaden.ejbmaker.SmartWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class BeanXMLFileGenerator
implements EJBGenerator {
    private String rdb_source_folder;
    private EJBCollection ejbCollection;
    private String package_name;

    public BeanXMLFileGenerator(String source, String packagen, EJBCollection coll) {
        this.rdb_source_folder = source;
        this.ejbCollection = coll;
        this.package_name = packagen;
    }

    public void generate() throws IOException {
        String merged_file_name = this.rdb_source_folder + File.separator + "beans.xml";
        SmartWriter merged_sw = new SmartWriter(merged_file_name);
        FileWriter mfw = merged_sw.createFile();
        mfw.write("<?xml version = \"1.0\" ?>\n");
        mfw.write("<!DOCTYPE BEANS [<!ELEMENT BEANS (NAME*)><!ELEMENT NAME (#PCDATA)>]>\n");
        mfw.write("<BEANS>\n");
        mfw.write("\t<PACKAGE>" + this.package_name + "</PACKAGE>\n");
        int i = 0;
        while (i < this.ejbCollection.getNufDescriptions()) {
            EJBDescription ejbDesc = this.ejbCollection.getNthDescription(i);
            String bean_name = ejbDesc.getBeanName();
            mfw.write("      <NAME>" + bean_name + "</NAME>\n");
            ++i;
        }
        int i2 = 0;
        while (i2 < this.ejbCollection.getNufRelations()) {
            EJBRelation ejbRel = this.ejbCollection.getNthRelation(i2);
            String bean_name = ejbRel.getBeanName();
            mfw.write("      <NAME>" + bean_name + "</NAME>\n");
            ++i2;
        }
        mfw.write("</BEANS>\n");
        merged_sw.copyAndClose();
    }
}

