/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.almaden.ejbmaker;

import com.ibm.almaden.ejbmaker.ConstantField;
import com.ibm.almaden.ejbmaker.ConstantInitializer;
import com.ibm.almaden.ejbmaker.ConstantInstance;
import com.ibm.almaden.ejbmaker.EJBCollection;
import com.ibm.almaden.ejbmaker.EJBConstantDescription;
import com.ibm.almaden.ejbmaker.EJBDescription;
import com.ibm.almaden.ejbmaker.EJBGenerator;
import com.ibm.almaden.ejbmaker.EJBRelation;
import com.ibm.almaden.ejbmaker.PersistantField;
import com.ibm.almaden.ejbmaker.SmartWriter;
import com.ibm.almaden.ejbmaker.SourceFooterWriter;
import com.ibm.almaden.ejbmaker.SourceHeaderWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class XMLAdaptorGenerator
implements EJBGenerator {
    private String java_source_folder;
    private String package_name;
    private EJBCollection ejbCollection;

    public XMLAdaptorGenerator(String source, String pname, EJBCollection coll) {
        this.java_source_folder = source;
        this.package_name = pname;
        this.ejbCollection = coll;
    }

    public void generate() throws IOException {
        int i = 0;
        while (i < this.ejbCollection.getNufDescriptions()) {
            EJBDescription ejbDesc = this.ejbCollection.getNthDescription(i);
            String bean_name = ejbDesc.getBeanName();
            String java_file_name = this.java_source_folder + File.separator + bean_name + File.separator + bean_name + "XMLAdaptor.java";
            SmartWriter sw = new SmartWriter(java_file_name);
            FileWriter fw = sw.createFile();
            this.writeDescriptionSource(fw, ejbDesc);
            sw.copyAndClose();
            ++i;
        }
        int i2 = 0;
        while (i2 < this.ejbCollection.getNufRelations()) {
            EJBRelation ejbRel = this.ejbCollection.getNthRelation(i2);
            String bean_name = ejbRel.getBeanName();
            String java_file_name = this.java_source_folder + File.separator + bean_name + File.separator + bean_name + "XMLAdaptor.java";
            SmartWriter sw = new SmartWriter(java_file_name);
            FileWriter fw = sw.createFile();
            this.writeRelationSource(fw, ejbRel);
            sw.copyAndClose();
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.ejbCollection.getNufConstantDescriptions()) {
            EJBConstantDescription ejbConst = this.ejbCollection.getNthConstantDescription(i3);
            String bean_name = ejbConst.getBeanName();
            String java_file_name = this.java_source_folder + File.separator + bean_name + File.separator + bean_name + "XMLAdaptor.java";
            SmartWriter sw = new SmartWriter(java_file_name);
            FileWriter fw = sw.createFile();
            this.writeConstantSource(fw, ejbConst);
            sw.copyAndClose();
            ++i3;
        }
    }

    private void writeDescriptionSource(FileWriter fw, EJBDescription ejbDesc) throws IOException {
        String name = ejbDesc.getBeanName();
        fw.write("package " + this.package_name + "." + name + ";\n\n");
        SourceHeaderWriter.writeHeader(fw);
        fw.write("\n");
        fw.write("import java.net.*;\n");
        fw.write("import java.util.*;\n");
        fw.write("import org.w3c.dom.*;\n");
        fw.write("import " + this.package_name + ".HomePool.*;\n");
        fw.write("\n");
        fw.write("/**\n");
        fw.write("* XML Adaptor class for " + name + "\n");
        fw.write("*\n");
        fw.write("* @author Not known, this file was generated automatically\n");
        fw.write("**/\n");
        fw.write("\n");
        fw.write("public class " + name + "XMLAdaptor extends com.ibm.almaden.ejbmaker.XMLAdaptor implements java.io.Serializable { \n\n");
        fw.write("\t/**\n");
        fw.write("\t* Field instances\n");
        fw.write("\t*/\n");
        int i = 0;
        while (i < ejbDesc.getPersistantFieldCollection().getNufPersistantFields()) {
            PersistantField pf = ejbDesc.getPersistantFieldCollection().getNthPersistantField(i);
            String pf_name = pf.getFieldName();
            String pf_type = pf.getJavaDT();
            String fkey = pf.getFKey();
            pf_type = this.getNonPrimitiveClass(pf_type);
            fw.write("\tprivate " + pf_type + " " + pf_name + ";\n");
            if (fkey != null && !fkey.trim().equals("")) {
                fw.write("\tprivate " + this.package_name + "." + fkey + "." + fkey + "XMLAdaptor " + pf_name + "Adaptor = null;\n");
            }
            ++i;
        }
        fw.write("\tprivate String primaryKey;\n");
        if (ejbDesc.getBeanType().equalsIgnoreCase("topic")) {
            fw.write("\tprivate java.sql.Timestamp REC_CRTD;\n");
        }
        int i2 = 0;
        while (i2 < this.ejbCollection.getNufRelations()) {
            EJBRelation rel = this.ejbCollection.getNthRelation(i2);
            Object related_bean = null;
            Object pfield = null;
            Object otherpfield = null;
            if (rel.getFirstBean().equals(name)) {
                fw.write("\tprivate ArrayList " + rel.getBeanName() + "XMLAdaptors2 = new ArrayList();\n");
            }
            if (rel.getSecondBean().equals(name)) {
                fw.write("\tprivate ArrayList " + rel.getBeanName() + "XMLAdaptors1 = new ArrayList();\n");
            }
            if (related_bean == null) {
                // empty if block
            }
            ++i2;
        }
        fw.write("\n\tpublic " + name + "XMLAdaptor()  {\n");
        fw.write("\t} // XMLAdaptor\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* Constructor. Constructed from an XML Document\n");
        fw.write("\t* \n");
        fw.write("\t* @param doc XML document description\n");
        fw.write("\t*/\n");
        fw.write("\tpublic " + name + "XMLAdaptor(Document doc) {\n");
        fw.write("\t\tthis.initialize(doc);\n");
        fw.write("\t} // " + name + "XMLAdaptor\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* Constructor. Constructed from an EJB instance\n");
        fw.write("\t* \n");
        fw.write("\t* @param ejb Ejb instance\n");
        fw.write("\t*/\n");
        fw.write("\tpublic " + name + "XMLAdaptor(javax.ejb.EJBObject ejb) throws java.rmi.RemoteException {\n");
        fw.write("\t\tthis.initialize(ejb);\n");
        fw.write("\t} // " + name + "XMLAdaptor\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* getXML. Transform into XML (for passing over a network for instance)\n");
        fw.write("\t* \n");
        fw.write("\t* @return Document\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic Document getXML() {\n");
        fw.write("\t\treturn this.getXML(new java.util.ArrayList());\n");
        fw.write("\t}\n");
        fw.write("\t/**\n");
        fw.write("\t* getXML. Transform into XML (for passing over a network for instance)\n");
        fw.write("\t* \n");
        fw.write("\t*@param traversed_object Objects already visited\n");
        fw.write("\t* @return Document\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic Document getXML(java.util.ArrayList traversed_objects) {\n");
        fw.write("\t\ttraversed_objects.add(primaryKey);\n");
        fw.write("\t\tDocument doc = this.createDocument();\n");
        fw.write("\n");
        fw.write("\t\tElement root = doc.createElement(\"" + name + "\");\n");
        fw.write("\t\tif(primaryKey != null) root.setAttribute(\"key\", primaryKey);\n");
        fw.write("\t\tdoc.appendChild(root);\n");
        fw.write("\n");
        int i3 = 0;
        while (i3 < ejbDesc.getPersistantFieldCollection().getNufPersistantFields()) {
            PersistantField pf = ejbDesc.getPersistantFieldCollection().getNthPersistantField(i3);
            String pf_name = pf.getFieldName();
            String pf_type = pf.getJavaDT();
            String fkey = pf.getFKey();
            pf_type = this.getNonPrimitiveClass(pf_type);
            fw.write("\t\t// " + pf_name + "\n");
            if (fkey != null && !fkey.trim().equals("")) {
                fw.write("\t\tif(" + pf_name + "Adaptor != null && traversed_objects.contains(" + pf_name + "Adaptor.getPrimaryKey()) == false) {\t\n");
                fw.write("\t\t\ttraversed_objects.add(" + pf_name + "Adaptor.getPrimaryKey());\n");
                fw.write("\t\t\tElement " + pf_name + "_elm = doc.createElement(\"" + pf_name + "\");\n");
                fw.write("\t\t\tDocument _d = " + pf_name + "Adaptor.getXML(traversed_objects);\n");
                fw.write("\t\t\tElement _elm = _d.getDocumentElement();\n");
                fw.write("\t\t\tNode _n = doc.importNode(_elm, true);\n");
                fw.write("\t\t\t" + pf_name + "_elm.appendChild(_n);\n");
                fw.write("\t\t\troot.appendChild(" + pf_name + "_elm);\n");
                fw.write("\t\t} else {\n");
                fw.write("\t\t\tif(" + pf_name + " != null) {\n");
                fw.write("\t\t\t\tElement " + pf_name + "_elm = doc.createElement(\"" + pf_name + "\");\n");
                fw.write("\t\t\t\tText " + pf_name + "_text = doc.createTextNode(super.createXMLText(" + pf_name + "));\n");
                fw.write("\t\t\t\t" + pf_name + "_elm.appendChild(" + pf_name + "_text);\n");
                fw.write("\t\t\t\troot.appendChild(" + pf_name + "_elm);\n");
                fw.write("\t\t\t}\n\n");
                fw.write("\t\t}\n");
            } else {
                fw.write("\t\tif(" + pf_name + " != null) {\n");
                fw.write("\t\t\tElement " + pf_name + "_elm = doc.createElement(\"" + pf_name + "\");\n");
                fw.write("\t\t\tText " + pf_name + "_text = doc.createTextNode(super.createXMLText(" + pf_name + "));\n");
                fw.write("\t\t\t" + pf_name + "_elm.appendChild(" + pf_name + "_text);\n");
                fw.write("\t\t\troot.appendChild(" + pf_name + "_elm);\n");
                fw.write("\t\t}\n\n");
            }
            ++i3;
        }
        if (ejbDesc.getBeanType().equalsIgnoreCase("topic")) {
            fw.write("\t\t// REC_CRTD \n");
            fw.write("\t\tif(REC_CRTD != null) {\n");
            fw.write("\t\t\tElement crtd_elm = doc.createElement(\"REC_CRTD\");\n");
            fw.write("\t\t\tText crtd_text = doc.createTextNode(super.createXMLText(REC_CRTD));\n");
            fw.write("\t\t\tcrtd_elm.appendChild(crtd_text);\n");
            fw.write("\t\t\troot.appendChild(crtd_elm);\n");
            fw.write("\t\t}\n\n");
        }
        fw.write("\t\tElement list_elem;\n");
        int i4 = 0;
        while (i4 < this.ejbCollection.getNufRelations()) {
            EJBRelation rel = this.ejbCollection.getNthRelation(i4);
            String rname = rel.getBeanName();
            if (rel.getFirstBean().equals(name)) {
                fw.write("\t\tif(" + rname + "XMLAdaptors2.size() > 0) {\n");
                fw.write("\t\t\tlist_elem = doc.createElement(\"" + rname + "-list\");\n");
                fw.write("\t\t\troot.appendChild(list_elem);\n");
                fw.write("\t\t\tfor(int i=0;i<" + rname + "XMLAdaptors2.size();++i) {\n");
                fw.write("\t\t\t\t" + this.package_name + "." + rname + "." + rname + "XMLAdaptor adapt = (" + this.package_name + "." + rname + "." + rname + "XMLAdaptor)" + rname + "XMLAdaptors2.get(i);\n");
                fw.write("\t\t\t\tDocument _doc = adapt.getXML(traversed_objects);\n");
                fw.write("\t\t\t\tElement _elm = _doc.getDocumentElement();\n");
                fw.write("\t\t\t\tNode n = doc.importNode(_elm, true);\n");
                fw.write("\t\t\t\tlist_elem.appendChild(n);\n");
                fw.write("\t\t\t}\n");
                fw.write("\t\t}//if\n");
            }
            if (rel.getSecondBean().equals(name)) {
                fw.write("\t\tif(" + rname + "XMLAdaptors1.size() > 0) {\n");
                fw.write("\t\t\tlist_elem = doc.createElement(\"" + rname + "-list\");\n");
                fw.write("\t\t\troot.appendChild(list_elem);\n");
                fw.write("\t\t\tfor(int i=0;i<" + rname + "XMLAdaptors1.size();++i) {\n");
                fw.write("\t\t\t\t" + this.package_name + "." + rname + "." + rname + "XMLAdaptor adapt = (" + this.package_name + "." + rname + "." + rname + "XMLAdaptor)" + rname + "XMLAdaptors1.get(i);\n");
                fw.write("\t\t\t\tDocument _doc = adapt.getXML(traversed_objects);\n");
                fw.write("\t\t\t\tElement _elm = _doc.getDocumentElement();\n");
                fw.write("\t\t\t\tNode n = doc.importNode(_elm, true);\n");
                fw.write("\t\t\t\tlist_elem.appendChild(n);\n");
                fw.write("\t\t\t}\n");
                fw.write("\t\t}//if\n");
            }
            ++i4;
        }
        fw.write("\t\treturn doc;\n");
        fw.write("\t} // getXML\n");
        fw.write("\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* initialize. Initialize the adaptor using another adaptor. The handle is not set by this methid \n");
        fw.write("\t* @param _adaptor Another XMLAdaptor instancet\n");
        fw.write("\t* \n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic void initialize(com.ibm.almaden.ejbmaker.XMLAdaptor _adaptor)  {\n");
        fw.write("\t\t" + name + "XMLAdaptor adaptor = (" + name + "XMLAdaptor)_adaptor;\n");
        fw.write("\t\tif(adaptor.getPrimaryKey() != null && adaptor.getPrimaryKey().equals(\"\") == false) primaryKey = adaptor.getPrimaryKey();\n");
        int i5 = 0;
        while (i5 < ejbDesc.getPersistantFieldCollection().getNufPersistantFields()) {
            PersistantField pf = ejbDesc.getPersistantFieldCollection().getNthPersistantField(i5);
            String pf_name = pf.getFieldName();
            String pf_type = pf.getJavaDT();
            fw.write("\t\t" + pf_name + " = adaptor.get" + pf_name + "();\n");
            ++i5;
        }
        fw.write("\t}\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* initialize. Initialize the adaptor using XML. Observe: The handle reference is not set by this method \n");
        fw.write("\t* @param doc Document\n");
        fw.write("\t* \n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic void initialize(Document doc)  {\n");
        fw.write("\t\tElement root = doc.getDocumentElement();\n");
        fw.write("\t\tString _key = root.getAttribute(\"key\");\n");
        fw.write("\t\tif(_key != null && _key.trim().equals(\"\") == false) primaryKey = _key;\n");
        fw.write("\t\tNodeList nl = null;\n");
        int i6 = 0;
        while (i6 < ejbDesc.getPersistantFieldCollection().getNufPersistantFields()) {
            PersistantField pf = ejbDesc.getPersistantFieldCollection().getNthPersistantField(i6);
            String pf_name = pf.getFieldName();
            String pf_type = pf.getJavaDT();
            pf_type = this.getNonPrimitiveClass(pf_type);
            fw.write("\t\t//\t" + pf_name + "\n");
            fw.write("\t\tnl = root.getElementsByTagName(\"" + pf_name + "\");\n");
            fw.write("\t\t// should be only one\n");
            fw.write("\t\tif(nl.getLength() > 0) {\n");
            fw.write("\t\t\tElement " + pf_name + "_el = (Element)nl.item(0);\n");
            fw.write("\t\t\tText " + pf_name + "_text = (Text)" + pf_name + "_el.getFirstChild();\n");
            fw.write("\t\t\tif(" + pf_name + "_text != null) " + pf_name + " = (" + pf_type + ") createNewInstance(\"" + pf_type + "\", " + pf_name + "_text.getData());\n");
            fw.write("\t\t}\n\n");
            ++i6;
        }
        if (ejbDesc.getBeanType().equalsIgnoreCase("topic")) {
            fw.write("\t\t//  REC_CRTD field \n");
            fw.write("\t\tnl = root.getElementsByTagName(\"REC_CRTD\");\n");
            fw.write("\t\t// should be only one\n");
            fw.write("\t\tif(nl.getLength() > 0) {\n");
            fw.write("\t\t\tElement crtd_el = (Element)nl.item(0);\n");
            fw.write("\t\t\tText crtd_text = (Text)crtd_el.getFirstChild();\n");
            fw.write("\t\t\tREC_CRTD = (java.sql.Timestamp) createNewInstance(\"java.sql.Timestamp\", crtd_text.getData());\n");
            fw.write("\t\t}\n\n");
        }
        fw.write("\t} // initialize\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* initialize. Initialize the adaptor from ejb instance. This also sets the handle reference and the primary key \n");
        fw.write("\t* @param _ejb EJB instance\n");
        fw.write("\t* \n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic void initialize(javax.ejb.EJBObject _ejb) throws java.rmi.RemoteException {\n");
        fw.write("\t\tif(_ejb == null) return;\n");
        fw.write("\t" + name + " ejb = (" + name + ") _ejb;\n");
        int i7 = 0;
        while (i7 < ejbDesc.getPersistantFieldCollection().getNufPersistantFields()) {
            PersistantField pf = ejbDesc.getPersistantFieldCollection().getNthPersistantField(i7);
            String pf_name = pf.getFieldName();
            String pf_type = pf.getJavaDT();
            if (this.isPrimitive(pf_type)) {
                fw.write("\t\tthis.set" + pf_name + "(this.getNonPrimitiveInstance(ejb.get" + pf_name + "()));\n");
            } else {
                fw.write("\t\tthis.set" + pf_name + "((" + pf_type + ")this.getNonPrimitiveInstance(ejb.get" + pf_name + "()));\n");
            }
            ++i7;
        }
        if (ejbDesc.getBeanType().equalsIgnoreCase("topic")) {
            fw.write("\t\tthis.setREC_CRTD(ejb.getRecordCreated());\n");
        }
        fw.write("\t\t\tthis.setPrimaryKey(ejb.getKey());\n");
        fw.write("\t\t\tthis.setHandle(ejb.getHandle());\n");
        fw.write("\t}\n");
        int i8 = 0;
        while (i8 < ejbDesc.getPersistantFieldCollection().getNufPersistantFields()) {
            PersistantField pf = ejbDesc.getPersistantFieldCollection().getNthPersistantField(i8);
            String pf_name = pf.getFieldName();
            String pf_type = pf.getJavaDT();
            String fkey = pf.getFKey();
            pf_type = this.getNonPrimitiveClass(pf_type);
            fw.write("\t/**\n");
            fw.write("\t* set" + pf_name + "\n");
            fw.write("\t* \n");
            fw.write("\t* @param val New value for " + pf_name + "\n");
            fw.write("\t*/\n");
            fw.write("\n");
            fw.write("\tpublic void set" + pf_name + "(" + pf_type + " val) {\n");
            fw.write("\t\t" + pf_name + " = val;\n");
            fw.write("\t} // set" + pf_name + "\n");
            fw.write("\n");
            fw.write("\t/**\t\n");
            fw.write("\t* get" + pf_name + "\n");
            fw.write("\t* \n");
            fw.write("\t* @return " + pf_type + " Current value of " + pf_name + "\n");
            fw.write("\t*/\n");
            fw.write("\n");
            fw.write("\tpublic " + pf_type + " get" + pf_name + "() {\n");
            fw.write("\t\treturn " + pf_name + ";\n");
            fw.write("\t} // get" + pf_name + "\n\n");
            if (fkey != null && !fkey.trim().equals("")) {
                fw.write("\t/**\n");
                fw.write("\t* set" + pf_name + "Adaptor\n");
                fw.write("\t* \n");
                fw.write("\t* @param a New value for " + pf_name + "Adaptor\n");
                fw.write("\t*/\n");
                fw.write("\n");
                fw.write("\tprotected void set" + pf_name + "Adaptor(" + this.package_name + "." + fkey + "." + fkey + "XMLAdaptor a) {\n");
                fw.write("\t\t" + pf_name + "Adaptor = a;\n");
                fw.write("\t} // set" + pf_name + "\n");
                fw.write("\n");
                fw.write("\t/**\n");
                fw.write("\t* get" + pf_name + "Adaptor\n");
                fw.write("\t* \n");
                fw.write("\t* @return " + pf_name + "XMLAdaptor instance (null if not set)\n");
                fw.write("\t*/\n");
                fw.write("\n");
                fw.write("\tpublic " + this.package_name + "." + fkey + "." + fkey + "XMLAdaptor get" + pf_name + "Adaptor() {\n");
                fw.write("\t\treturn " + pf_name + "Adaptor;\n");
                fw.write("\t} // get" + pf_name + "Adaptor\n");
                fw.write("\n");
            }
            ++i8;
        }
        fw.write("\t/**\n");
        fw.write("\t* setPrimaryKey\n");
        fw.write("\t* \n");
        fw.write("\t* @param val New value for primaryKey\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tprotected void setPrimaryKey(String val) {\n");
        fw.write("\t\tprimaryKey = val;\n");
        fw.write("\t} // setPrimaryKey\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* getPrimaryKey\n");
        fw.write("\t* \n");
        fw.write("\t* @return String primaryKey\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic String getPrimaryKey() {\n");
        fw.write("\t\treturn primaryKey;\n");
        fw.write("\t} // getPrimaryKey\n");
        fw.write("\n");
        int i9 = 0;
        while (i9 < this.ejbCollection.getNufRelations()) {
            EJBRelation rel = this.ejbCollection.getNthRelation(i9);
            String pfield1 = rel.getFirstPField();
            String pfield2 = rel.getSecondPField();
            String rname = rel.getBeanName();
            Object related_bean = null;
            Object pfield = null;
            Object otherpfield = null;
            String suffix0 = "";
            String suffix1 = "";
            if (rel.getFirstBean().equals(rel.getSecondBean())) {
                suffix0 = "0";
                suffix1 = "1";
            }
            if (rel.getFirstBean().equals(name)) {
                fw.write("\t/**\n");
                fw.write("\t* Add " + rname + " adds a new link to the object specified by the key\n");
                fw.write("\t* \n");
                fw.write("\t* @param key Primary key\n");
                fw.write("\t* @return " + rname + "XMLAdaptor adaptor instance\n");
                fw.write("\t*/\n");
                fw.write("\n");
                fw.write("\tpublic  " + this.package_name + "." + rname + "." + rname + "XMLAdaptor add" + rname + suffix1 + "(String key) {\n");
                fw.write("\t\t" + this.package_name + "." + rname + "." + rname + "XMLAdaptor adapt = new " + this.package_name + "." + rname + "." + rname + "XMLAdaptor();\n");
                fw.write("\t\tadapt.set" + pfield1 + "(primaryKey);\n");
                fw.write("\t\tadapt.set" + pfield2 + "(key);\n");
                fw.write("\t\t" + rname + "XMLAdaptors2.add(adapt);\n");
                fw.write("\t\treturn adapt;\n");
                fw.write("\t}\n\n");
                fw.write("\t/**\n");
                fw.write("\t* Add " + rname + " adds a new link to the object specified by the adaptor\n");
                fw.write("\t* \n");
                fw.write("\t* @param a Adaptor\n");
                fw.write("\t* @return " + rname + "XMLAdaptor adaptor instance\n");
                fw.write("\t*/\n");
                fw.write("\n");
                fw.write("\tprotected  " + this.package_name + "." + rname + "." + rname + "XMLAdaptor add" + rname + suffix1 + "(" + this.package_name + "." + rname + "." + rname + "XMLAdaptor a) {\n");
                fw.write("\t\t" + rname + "XMLAdaptors2.add(a);\n");
                fw.write("\t\treturn a;\n");
                fw.write("\t}\n");
                fw.write("\t/**\n");
                fw.write("\t* Get " + rname + " Retrive an enumeration of relationships\n");
                fw.write("\t* \n");
                fw.write("\t* @return Iterator Iterator instance\n");
                fw.write("\t*/\n");
                fw.write("\n");
                fw.write("\tpublic  java.util.Iterator get" + rname + suffix1 + "() {\n");
                fw.write("\t\tif(" + rname + "XMLAdaptors2 != null) \n");
                fw.write("\t\t\treturn " + rname + "XMLAdaptors2.iterator();\n");
                fw.write("\t\telse return null;\n");
                fw.write("\t}\n\n");
            }
            if (rel.getSecondBean().equals(name)) {
                fw.write("\t/**\n");
                fw.write("\t* Add " + rname + " adds a new link to the object specified by the key\n");
                fw.write("\t* \n");
                fw.write("\t* @param key Primary key\n");
                fw.write("\t* @return " + rname + "XMLAdaptor adaptor instance\n");
                fw.write("\t*/\n");
                fw.write("\tpublic  " + this.package_name + "." + rname + "." + rname + "XMLAdaptor add" + rname + suffix0 + "(String key) {\n");
                fw.write("\t\t" + this.package_name + "." + rname + "." + rname + "XMLAdaptor adapt = new " + this.package_name + "." + rname + "." + rname + "XMLAdaptor();\n");
                fw.write("\t\tadapt.set" + pfield2 + "(primaryKey);\n");
                fw.write("\t\tadapt.set" + pfield1 + "(key);\n");
                fw.write("\t\t" + rname + "XMLAdaptors1.add(adapt);\n");
                fw.write("\t\treturn adapt;\n");
                fw.write("\t}\n\n");
                fw.write("\t/**\n");
                fw.write("\t* Add " + rname + " adds a new link to the object specified by the key\n");
                fw.write("\t* \n");
                fw.write("\t* @param key Primary key\n");
                fw.write("\t* @return " + rname + "XMLAdaptor adaptor instance\n");
                fw.write("\t*/\n");
                fw.write("\tprotected  " + this.package_name + "." + rname + "." + rname + "XMLAdaptor add" + rname + suffix0 + "(" + this.package_name + "." + rname + "." + rname + "XMLAdaptor a) {\n");
                fw.write("\t\t" + rname + "XMLAdaptors1.add(a);\n");
                fw.write("\t\treturn a;\n");
                fw.write("\t}\n");
                fw.write("\t/**\n");
                fw.write("\t* Get " + rname + " Retrive an enumeration of relationships\n");
                fw.write("\t* \n");
                fw.write("\t* @return Iterator Iterator instance\n");
                fw.write("\t*/\n");
                fw.write("\n");
                fw.write("\tpublic  java.util.Iterator get" + rname + suffix0 + "() {\n");
                fw.write("\t\tif(" + rname + "XMLAdaptors1 != null) \n");
                fw.write("\t\t\treturn " + rname + "XMLAdaptors1.iterator();\n");
                fw.write("\t\telse return null;\n");
                fw.write("\t}\n\n");
            }
            ++i9;
        }
        fw.write("\t/**\n");
        fw.write("\t* synchronize. Synchronize the Adaptor with its associated EJB\n");
        fw.write("\t* \n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic void synchronize() throws java.rmi.RemoteException {\n");
        fw.write("    " + name + " bean = null;\n");
        fw.write("\t  if(handle == null) {\n");
        fw.write("      System.err.println(\"??? " + name + "XMLAdaptor: EJB handle is null in synchronize(), primary key is '\"+primaryKey+\"'.\");\n");
        fw.write("      try {\n");
        fw.write("\t      bean = (" + name + ") this.findByPrimaryKey();\n");
        fw.write("      } catch (javax.ejb.FinderException fx) {\n");
        fw.write("        throw new java.rmi.RemoteException(\"javax.ejb.FinderException retrieving " + name + " bean by primary key \"+primaryKey+\": \" + fx.getMessage());\n");
        fw.write("      }\n");
        fw.write("    } else {\n");
        fw.write("\t    bean = (" + name + ") handle.getEJBObject();\n");
        fw.write("    }\n");
        fw.write("\t  if (bean!=null) bean.initialize(this);\n");
        fw.write("\t} // synchronize\n\n");
        fw.write("\t/**\n");
        fw.write("\t* findByPrimaryKey. Find the EJB object by this adaptor's primary key.\n");
        fw.write("\t* \n");
        fw.write("\t* @return EJBObject the bean\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tprotected javax.ejb.EJBObject findByPrimaryKey() throws java.rmi.RemoteException, javax.ejb.FinderException {\n");
        fw.write("    if(primaryKey==null || primaryKey.equals(\"\")) {\n");
        fw.write("      return null; // no associated ejb\n");
        fw.write("    }\n");
        fw.write("    javax.ejb.EJBObject bean = null;\n");
        fw.write("\tHomeObjectPool pool = HomeObjectPool.getInstance();\n\n");
        fw.write("\t" + name + "Home " + name + "HomeObj = (" + name + "Home)pool.get(\"" + name + "\");\n");
        fw.write("  " + name + "Key pkey = new " + name + "Key(primaryKey);\n");
        fw.write("   bean = " + name + "HomeObj.findByPrimaryKey(pkey);\n");
        fw.write("\tpool.release(" + name + "HomeObj);\n");
        fw.write("    return bean;\n");
        fw.write("  } // findByPrimaryKey\n\n");
        if (ejbDesc.getBeanType().equalsIgnoreCase("topic")) {
            fw.write("\t/**\n");
            fw.write("\t* setREC_CRTD\n");
            fw.write("\t* \n");
            fw.write("\t* @param val New value for REC_CRTD\n");
            fw.write("\t*/\n");
            fw.write("\n");
            fw.write("\tpublic void setREC_CRTD(java.sql.Timestamp val) {\n");
            fw.write("\t\tREC_CRTD = val;\n");
            fw.write("\t} // setREC_CRTD\n");
            fw.write("\n");
            fw.write("\t/**\t\n");
            fw.write("\t* getREC_CRTD\n");
            fw.write("\t* \n");
            fw.write("\t* @return java.sql.Timestamp Current value of REC_CRTD\n");
            fw.write("\t*/\n");
            fw.write("\n");
            fw.write("\tpublic java.sql.Timestamp getREC_CRTD() {\n");
            fw.write("\t\treturn REC_CRTD;\n");
            fw.write("\t} // getREC_CRTD\n\n");
        }
        fw.write("\n} // " + name + "XMLAdaptor");
        SourceFooterWriter.writeFooter(fw);
    }

    private void writeRelationSource(FileWriter fw, EJBRelation ejbRel) throws IOException {
        String name = ejbRel.getBeanName();
        String firstBean = ejbRel.getFirstBean();
        String secondBean = ejbRel.getSecondBean();
        fw.write("package " + this.package_name + "." + name + ";\n\n");
        SourceHeaderWriter.writeHeader(fw);
        fw.write("\n");
        fw.write("import java.net.*;\n");
        fw.write("import java.util.*;\n");
        fw.write("import org.w3c.dom.*;\n");
        fw.write("import " + this.package_name + ".HomePool.*;\n");
        fw.write("\n");
        fw.write("/**\n");
        fw.write("* XML Adaptor class for " + name + "\n");
        fw.write("*\n");
        fw.write("* @author Not known, this file was generated automatically\n");
        fw.write("**/\n");
        fw.write("\n");
        fw.write("public class " + name + "XMLAdaptor extends com.ibm.almaden.ejbmaker.XMLAdaptor implements java.io.Serializable { \n\n");
        fw.write("\t/**\n");
        fw.write("\t* Field instances\n");
        fw.write("\t*/\n");
        String pf_name1 = ejbRel.getFirstPField();
        String pf_name2 = ejbRel.getSecondPField();
        fw.write("\tprivate String " + pf_name1 + ";\n");
        fw.write("\tprivate String " + pf_name2 + ";\n");
        int i = 0;
        while (i < ejbRel.getPersistantFieldCollection().getNufPersistantFields()) {
            PersistantField pf = ejbRel.getPersistantFieldCollection().getNthPersistantField(i);
            String pf_name = pf.getFieldName();
            String pf_type = pf.getJavaDT();
            String fkey = pf.getFKey();
            pf_type = this.getNonPrimitiveClass(pf_type);
            fw.write("\tprivate " + pf_type + " " + pf_name + ";\n");
            if (fkey != null && !fkey.trim().equals("")) {
                fw.write("\tprivate " + this.package_name + "." + fkey + "." + fkey + "XMLAdaptor " + pf_name + "Adaptor = null;\n");
            }
            ++i;
        }
        String suffix0 = "";
        String suffix1 = "";
        if (ejbRel.getFirstBean().equals(ejbRel.getSecondBean())) {
            suffix0 = "0";
            suffix1 = "1";
        }
        fw.write("\tprivate " + this.package_name + "." + ejbRel.getFirstBean() + "." + ejbRel.getFirstBean() + "XMLAdaptor " + ejbRel.getFirstBean() + suffix0 + "Adaptor = null;\n");
        fw.write("\tprivate " + this.package_name + "." + ejbRel.getSecondBean() + "." + ejbRel.getSecondBean() + "XMLAdaptor " + ejbRel.getSecondBean() + suffix1 + "Adaptor = null;\n");
        fw.write("\tprivate String primaryKey;\n");
        fw.write("\n\tpublic " + name + "XMLAdaptor()  {\n");
        fw.write("\t} // XMLAdaptor\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* Constructor. Constructed from an XML Document\n");
        fw.write("\t* \n");
        fw.write("\t* @param doc XML document description\n");
        fw.write("\t*/\n");
        fw.write("\tpublic " + name + "XMLAdaptor(Document doc) {\n");
        fw.write("\t\tthis.initialize(doc);\n");
        fw.write("\t} // " + name + "XMLAdaptor\n");
        fw.write("\t/**\n");
        fw.write("\t* Constructor. Constructed from an EJB instance\n");
        fw.write("\t* \n");
        fw.write("\t* @param ejb Ejb instance\n");
        fw.write("\t*/\n");
        fw.write("\tpublic " + name + "XMLAdaptor(javax.ejb.EJBObject ejb) throws java.rmi.RemoteException {\n");
        fw.write("\t\tthis.initialize(ejb);\n");
        fw.write("\t} // " + name + "XMLAdaptor\n");
        fw.write("\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* getXML. Transform into XML (for passing over a network for instance)\n");
        fw.write("\t* \n");
        fw.write("\t* @return Document\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic Document getXML() {\n");
        fw.write("\t\treturn this.getXML(new ArrayList());\n");
        fw.write("\t}\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* getXML. Transform into XML (for passing over a network for instance)\n");
        fw.write("\t* \n");
        fw.write("\t*@param traversed_objects Traversed objects\n");
        fw.write("\t* @return Document\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic Document getXML(ArrayList traversed_objects) {\n");
        fw.write("\t\tDocument doc = this.createDocument();\n");
        fw.write("\t\ttraversed_objects.add(primaryKey);\n");
        fw.write("\n");
        fw.write("\t\tElement root = doc.createElement(\"" + name + "\");\n");
        fw.write("\t\tif(primaryKey != null) root.setAttribute(\"key\", primaryKey);\n");
        fw.write("\t\tdoc.appendChild(root);\n");
        fw.write("\n");
        fw.write("\t\t// " + pf_name1 + "\n");
        fw.write("\t\tif(" + pf_name1 + " != null) {\n");
        fw.write("\t\t\tElement " + pf_name1 + "_elm = doc.createElement(\"" + pf_name1 + "\");\n");
        fw.write("\t\t\tif(" + firstBean + suffix0 + "Adaptor != null && traversed_objects.contains(" + firstBean + suffix0 + "Adaptor.getPrimaryKey()) == false) {\n");
        fw.write("\t\t\t\ttraversed_objects.add(" + firstBean + suffix0 + "Adaptor.getPrimaryKey());\n");
        fw.write("\t\t\t\tDocument _d = " + firstBean + suffix0 + "Adaptor.getXML(traversed_objects);\n");
        fw.write("\t\t\t\tElement _e = _d.getDocumentElement();\n");
        fw.write("\t\t\t\tNode _n = doc.importNode(_e, true);\n");
        fw.write("\t\t\t\t" + pf_name1 + "_elm.appendChild(_n);\n");
        fw.write("\t\t\t} else {\n");
        fw.write("\t\t\t\tText " + pf_name1 + "_text = doc.createTextNode(super.createXMLText(" + pf_name1 + "));\n");
        fw.write("\t\t\t\t" + pf_name1 + "_elm.appendChild(" + pf_name1 + "_text);\n");
        fw.write("\t\t\t}\n");
        fw.write("\t\t\troot.appendChild(" + pf_name1 + "_elm);\n");
        fw.write("\t\t}\n\n");
        fw.write("\t\t// " + pf_name2 + "\n");
        fw.write("\t\tif(" + pf_name2 + " != null) {\n");
        fw.write("\t\t\tElement " + pf_name2 + "_elm = doc.createElement(\"" + pf_name2 + "\");\n");
        fw.write("\t\t\tif(" + secondBean + suffix1 + "Adaptor != null && traversed_objects.contains(" + secondBean + suffix1 + "Adaptor.getPrimaryKey()) == false) {\n");
        fw.write("\t\t\t\ttraversed_objects.add(" + secondBean + suffix1 + "Adaptor.getPrimaryKey());\n");
        fw.write("\t\t\t\tDocument _d = " + secondBean + suffix1 + "Adaptor.getXML(traversed_objects);\n");
        fw.write("\t\t\t\tElement _e = _d.getDocumentElement();\n");
        fw.write("\t\t\t\tNode _n = doc.importNode(_e, true);\n");
        fw.write("\t\t\t\t" + pf_name2 + "_elm.appendChild(_n);\n");
        fw.write("\t\t\t} else {\n");
        fw.write("\t\t\t\tText " + pf_name2 + "_text = doc.createTextNode(super.createXMLText(" + pf_name2 + "));\n");
        fw.write("\t\t\t\t" + pf_name2 + "_elm.appendChild(" + pf_name2 + "_text);\n");
        fw.write("\t\t\t}\n");
        fw.write("\t\t\troot.appendChild(" + pf_name2 + "_elm);\n");
        fw.write("\t\t}\n\n");
        int i2 = 0;
        while (i2 < ejbRel.getPersistantFieldCollection().getNufPersistantFields()) {
            PersistantField pf = ejbRel.getPersistantFieldCollection().getNthPersistantField(i2);
            String pf_name = pf.getFieldName();
            String pf_type = pf.getJavaDT();
            String fkey = pf.getFKey();
            pf_type = this.getNonPrimitiveClass(pf_type);
            fw.write("\t\t// " + pf_name + "\n");
            if (fkey != null && !fkey.trim().equals("")) {
                fw.write("\t\tif(" + pf_name + "Adaptor != null && traversed_objects.contains(" + pf_name + "Adaptor.getPrimaryKey()) == false) {\t\n");
                fw.write("\t\t\ttraversed_objects.add(" + pf_name + "Adaptor.getPrimaryKey());\n");
                fw.write("\t\t\tElement " + pf_name + "_elm = doc.createElement(\"" + pf_name + "\");\n");
                fw.write("\t\t\tDocument _d = " + pf_name + "Adaptor.getXML(traversed_objects);\n");
                fw.write("\t\t\tElement _elm = _d.getDocumentElement();\n");
                fw.write("\t\t\tNode _n = doc.importNode(_elm, true);\n");
                fw.write("\t\t\t" + pf_name + "_elm.appendChild(_n);\n");
                fw.write("\t\t\troot.appendChild(" + pf_name + "_elm);\n");
                fw.write("\t\t} else {\n");
                fw.write("\t\t\tif(" + pf_name + " != null) {\n");
                fw.write("\t\t\t\tElement " + pf_name + "_elm = doc.createElement(\"" + pf_name + "\");\n");
                fw.write("\t\t\t\tText " + pf_name + "_text = doc.createTextNode(super.createXMLText(" + pf_name + "));\n");
                fw.write("\t\t\t\t" + pf_name + "_elm.appendChild(" + pf_name + "_text);\n");
                fw.write("\t\t\t\troot.appendChild(" + pf_name + "_elm);\n");
                fw.write("\t\t\t}\n\n");
                fw.write("\t\t}\n");
            } else {
                fw.write("\t\tif(" + pf_name + " != null) {\n");
                fw.write("\t\t\tElement " + pf_name + "_elm = doc.createElement(\"" + pf_name + "\");\n");
                fw.write("\t\t\tText " + pf_name + "_text = doc.createTextNode(super.createXMLText(" + pf_name + "));\n");
                fw.write("\t\t\t" + pf_name + "_elm.appendChild(" + pf_name + "_text);\n");
                fw.write("\t\t\troot.appendChild(" + pf_name + "_elm);\n");
                fw.write("\t\t}\n\n");
            }
            ++i2;
        }
        fw.write("\t\treturn doc;\n");
        fw.write("\t} // getXML\n");
        fw.write("\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* initialize. Initialize the adaptor using another adaptor. The handle is not set by this methid \n");
        fw.write("\t* @param _adaptor Another XMLAdaptor instancet\n");
        fw.write("\t* \n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic void initialize(com.ibm.almaden.ejbmaker.XMLAdaptor _adaptor) {\n");
        fw.write("\t\t" + name + "XMLAdaptor adaptor = (" + name + "XMLAdaptor)_adaptor;\n");
        fw.write("\t\tif(adaptor.getPrimaryKey() != null && adaptor.getPrimaryKey().equals(\"\") == false) primaryKey = adaptor.getPrimaryKey();\n");
        fw.write("\t\t" + pf_name1 + " = adaptor.get" + pf_name1 + "();\n");
        fw.write("\t\t" + pf_name2 + " = adaptor.get" + pf_name2 + "();\n");
        int i3 = 0;
        while (i3 < ejbRel.getPersistantFieldCollection().getNufPersistantFields()) {
            PersistantField pf = ejbRel.getPersistantFieldCollection().getNthPersistantField(i3);
            String pf_name = pf.getFieldName();
            String pf_type = pf.getJavaDT();
            fw.write("\t\t" + pf_name + " = adaptor.get" + pf_name + "();\n");
            ++i3;
        }
        fw.write("\t}\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* initialize. Initialize the adaptor using XML. Observe: The handle reference is not set by this method \n");
        fw.write("\t* @param doc Document\n");
        fw.write("\t* \n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic void initialize(Document doc) {\n");
        fw.write("\t\tElement root = doc.getDocumentElement();\n");
        fw.write("\t\tString _key = root.getAttribute(\"key\");\n");
        fw.write("\t\tif(_key != null && _key.trim().equals(\"\") == false) primaryKey = _key;\n");
        fw.write("\t\tNodeList nl = null;\n");
        fw.write("\t\t//\t" + pf_name1 + "\n");
        fw.write("\t\tnl = root.getElementsByTagName(\"" + pf_name1 + "\");\n");
        fw.write("\t\t// should be only one\n");
        fw.write("\t\tif(nl.getLength() > 0) {\n");
        fw.write("\t\t\tElement " + pf_name1 + "_el = (Element)nl.item(0);\n");
        fw.write("\t\t\tText " + pf_name1 + "_text = (Text)" + pf_name1 + "_el.getFirstChild();\n");
        fw.write("\t\t\tif(" + pf_name1 + "_text != null) " + pf_name1 + " = " + pf_name1 + "_text.getData();\n");
        fw.write("\t\t}\n\n");
        fw.write("\t\t//\t" + pf_name2 + "\n");
        fw.write("\t\tnl = root.getElementsByTagName(\"" + pf_name2 + "\");\n");
        fw.write("\t\t// should be only one\n");
        fw.write("\t\tif(nl.getLength() > 0) {\n");
        fw.write("\t\t\tElement " + pf_name2 + "_el = (Element)nl.item(0);\n");
        fw.write("\t\t\tText " + pf_name2 + "_text = (Text)" + pf_name2 + "_el.getFirstChild();\n");
        fw.write("\t\t\tif(" + pf_name2 + "_text != null) " + pf_name2 + " = " + pf_name2 + "_text.getData();\n");
        fw.write("\t\t}\n\n");
        int i4 = 0;
        while (i4 < ejbRel.getPersistantFieldCollection().getNufPersistantFields()) {
            PersistantField pf = ejbRel.getPersistantFieldCollection().getNthPersistantField(i4);
            String pf_name = pf.getFieldName();
            String pf_type = pf.getJavaDT();
            pf_type = this.getNonPrimitiveClass(pf_type);
            fw.write("\t\t//\t" + pf_name + "\n");
            fw.write("\t\tnl = root.getElementsByTagName(\"" + pf_name + "\");\n");
            fw.write("\t\t// should be only one\n");
            fw.write("\t\tif(nl.getLength() > 0) {\n");
            fw.write("\t\t\tElement " + pf_name + "_el = (Element)nl.item(0);\n");
            fw.write("\t\t\tText " + pf_name + "_text = (Text)" + pf_name + "_el.getFirstChild();\n");
            fw.write("\t\t\tif(" + pf_name + "_text != null) " + pf_name + " = (" + pf_type + ") createNewInstance(\"" + pf_type + "\", " + pf_name + "_text.getData());\n");
            fw.write("\t\t}\n\n");
            ++i4;
        }
        fw.write("\t} //  initialize\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* initialize. Initialize the adaptor from ejb instance \n");
        fw.write("\t* @param _ejb EJB instance\n");
        fw.write("\t* \n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic void initialize(javax.ejb.EJBObject _ejb) throws java.rmi.RemoteException {\n");
        fw.write("\t\tif(_ejb == null) return;\n");
        fw.write("\t" + name + " ejb = (" + name + ") _ejb;\n");
        fw.write("\t\tthis.set" + pf_name1 + "(ejb.get" + pf_name1 + "());\n");
        fw.write("\t\tthis.set" + pf_name2 + "(ejb.get" + pf_name2 + "());\n");
        fw.write("\t\t\tthis.setPrimaryKey(ejb.getKey());\n");
        fw.write("\t\t\tthis.setHandle(ejb.getHandle());\n");
        int i5 = 0;
        while (i5 < ejbRel.getPersistantFieldCollection().getNufPersistantFields()) {
            PersistantField pf = ejbRel.getPersistantFieldCollection().getNthPersistantField(i5);
            String pf_name = pf.getFieldName();
            String pf_type = pf.getJavaDT();
            if (this.isPrimitive(pf_type)) {
                fw.write("\t\tthis.set" + pf_name + "(this.getNonPrimitiveInstance(ejb.get" + pf_name + "()));\n");
            } else {
                fw.write("\t\tthis.set" + pf_name + "((" + pf_type + ")this.getNonPrimitiveInstance(ejb.get" + pf_name + "()));\n");
            }
            ++i5;
        }
        fw.write("\t}\n");
        fw.write("\t/**\n");
        fw.write("\t* set" + pf_name1 + "\n");
        fw.write("\t* \n");
        fw.write("\t* @param val New value for " + pf_name1 + "\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic void set" + pf_name1 + "(String val) {\n");
        fw.write("\t\t" + pf_name1 + " = val;\n");
        fw.write("\t} // set" + pf_name1 + "\n");
        fw.write("\n");
        fw.write("\t/**\t\n");
        fw.write("\t* get" + pf_name1 + "\n");
        fw.write("\t* \n");
        fw.write("\t* @return String Current value of " + pf_name1 + "\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic String get" + pf_name1 + "() {\n");
        fw.write("\t\treturn " + pf_name1 + ";\n");
        fw.write("\t} // get" + pf_name1 + "\n\n");
        fw.write("\t/**\n");
        fw.write("\t* set" + pf_name2 + "\n");
        fw.write("\t* \n");
        fw.write("\t* @param val New value for " + pf_name2 + "\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic void set" + pf_name2 + "(String val) {\n");
        fw.write("\t\t" + pf_name2 + " = val;\n");
        fw.write("\t} // set" + pf_name2 + "\n");
        fw.write("\n");
        fw.write("\t/**\t\n");
        fw.write("\t* get" + pf_name2 + "\n");
        fw.write("\t* \n");
        fw.write("\t* @return String Current value of " + pf_name2 + "\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic String get" + pf_name2 + "() {\n");
        fw.write("\t\treturn " + pf_name2 + ";\n");
        fw.write("\t} // get" + pf_name2 + "\n\n");
        int i6 = 0;
        while (i6 < ejbRel.getPersistantFieldCollection().getNufPersistantFields()) {
            PersistantField pf = ejbRel.getPersistantFieldCollection().getNthPersistantField(i6);
            String pf_name = pf.getFieldName();
            String pf_type = pf.getJavaDT();
            pf_type = this.getNonPrimitiveClass(pf_type);
            fw.write("\t/**\n");
            fw.write("\t* set" + pf_name + "\n");
            fw.write("\t* \n");
            fw.write("\t* @param val New value for " + pf_name + "\n");
            fw.write("\t*/\n");
            fw.write("\n");
            fw.write("\tpublic void set" + pf_name + "(" + pf_type + " val) {\n");
            fw.write("\t\t" + pf_name + " = val;\n");
            fw.write("\t} // set" + pf_name + "\n");
            fw.write("\n");
            fw.write("\t/**\t\n");
            fw.write("\t* get" + pf_name + "\n");
            fw.write("\t* \n");
            fw.write("\t* @return " + pf_type + " Current value of " + pf_name + "\n");
            fw.write("\t*/\n");
            fw.write("\n");
            fw.write("\tpublic " + pf_type + " get" + pf_name + "() {\n");
            fw.write("\t\treturn " + pf_name + ";\n");
            fw.write("\t} // get" + pf_name + "\n\n");
            ++i6;
        }
        suffix1 = "";
        suffix0 = "";
        if (firstBean.equals(secondBean)) {
            suffix0 = "0";
            suffix1 = "1";
        }
        fw.write("\t/**\n");
        fw.write("\t* set" + firstBean + "Adaptor\n");
        fw.write("\t* \n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tprotected void set" + firstBean + suffix0 + "Adaptor(" + this.package_name + "." + firstBean + "." + firstBean + "XMLAdaptor adapt) {\n");
        fw.write("\t\t" + firstBean + suffix0 + "Adaptor = adapt;\n");
        fw.write("\t} // set" + firstBean + "\n");
        fw.write("\n\n");
        fw.write("\t/**\n");
        fw.write("\t* set" + secondBean + "Adaptor\n");
        fw.write("\t* \n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tprotected void set" + secondBean + suffix1 + "Adaptor(" + this.package_name + "." + secondBean + "." + secondBean + "XMLAdaptor adapt) {\n");
        fw.write("\t\t" + secondBean + suffix1 + "Adaptor = adapt;\n");
        fw.write("\t} // set" + secondBean + "\n");
        fw.write("\n\n");
        int i7 = 0;
        while (i7 < ejbRel.getPersistantFieldCollection().getNufPersistantFields()) {
            PersistantField pf = ejbRel.getPersistantFieldCollection().getNthPersistantField(i7);
            String pf_name = pf.getFieldName();
            String fkey = pf.getFKey();
            if (fkey != null && !fkey.trim().equals("")) {
                fw.write("\t/**\n");
                fw.write("\t* set" + pf_name + "Adaptor\n");
                fw.write("\t* \n");
                fw.write("\t*/\n");
                fw.write("\n");
                fw.write("\tprotected void set" + pf_name + "Adaptor(" + this.package_name + "." + fkey + "." + fkey + "XMLAdaptor adapt) {\n");
                fw.write("\t\t" + pf_name + "Adaptor = adapt;\n");
                fw.write("\t} // set" + fkey + "\n");
                fw.write("\n\n");
                fw.write("\t/**\n");
                fw.write("\t* get" + pf_name + "Adaptor\n");
                fw.write("\t* @return " + pf_name + "XMLAdaptor (null if not expanded)\n");
                fw.write("\t*/\n");
                fw.write("\n");
                fw.write("\tpublic " + this.package_name + "." + fkey + "." + fkey + "XMLAdaptor get" + pf_name + "Adaptor() {\n");
                fw.write("\t\treturn " + pf_name + "Adaptor;\n");
                fw.write("\t} // get" + fkey + "\n");
                fw.write("\n\n");
            }
            ++i7;
        }
        fw.write("\t/**\n");
        fw.write("\t* setPrimaryKey\n");
        fw.write("\t* \n");
        fw.write("\t* @param val New value for primaryKey\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tprotected void setPrimaryKey(String val) {\n");
        fw.write("\t\tprimaryKey = val;\n");
        fw.write("\t} // setPrimaryKey\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* getPrimaryKey\n");
        fw.write("\t* \n");
        fw.write("\t* @return String primaryKey\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic String getPrimaryKey() {\n");
        fw.write("\t\treturn primaryKey;\n");
        fw.write("\t} // getPrimaryKey\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* synchronize. Synchronize the Adaptor with its associated EJB\n");
        fw.write("\t* \n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic void synchronize() throws java.rmi.RemoteException {\n");
        fw.write("    " + name + " bean = null;\n");
        fw.write("\t  if(handle == null) {\n");
        fw.write("      System.err.println(\"??? " + name + "XMLAdaptor: EJB handle is null in synchronize(), primary key is '\"+primaryKey+\"'.\");\n");
        fw.write("      try {\n");
        fw.write("\t      bean = (" + name + ") this.findByPrimaryKey();\n");
        fw.write("      } catch (javax.ejb.FinderException fx) {\n");
        fw.write("        throw new java.rmi.RemoteException(\"javax.ejb.FinderException retrieving " + name + " bean by primary key \"+primaryKey+\": \" + fx.getMessage());\n");
        fw.write("      }\n");
        fw.write("    } else {\n");
        fw.write("\t    bean = (" + name + ") handle.getEJBObject();\n");
        fw.write("    }\n");
        fw.write("\t  if (bean!=null) bean.initialize(this);\n");
        fw.write("\t} // synchronize\n\n");
        fw.write("\t/**\n");
        fw.write("\t* findByPrimaryKey. Find the EJB object by this adaptor's primary key.\n");
        fw.write("\t* \n");
        fw.write("\t* @return EJBObject the bean\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tprotected javax.ejb.EJBObject findByPrimaryKey() throws java.rmi.RemoteException, javax.ejb.FinderException {\n");
        fw.write("    if(primaryKey==null || primaryKey.equals(\"\")) {\n");
        fw.write("      return null; // no associated ejb\n");
        fw.write("    }\n");
        fw.write("    javax.ejb.EJBObject bean = null;\n");
        fw.write("\tHomeObjectPool pool = HomeObjectPool.getInstance();\n\n");
        fw.write("\t" + name + "Home " + name + "HomeObj = (" + name + "Home)pool.get(\"" + name + "\");\n");
        fw.write("  " + name + "Key pkey = new " + name + "Key(primaryKey);\n");
        fw.write("   bean = " + name + "HomeObj.findByPrimaryKey(pkey);\n");
        fw.write("\tpool.release(" + name + "HomeObj);\n");
        fw.write("    return bean;\n");
        fw.write("  } // findByPrimaryKey\n\n");
        fw.write("\n} // " + name + "XMLAdaptor");
        SourceFooterWriter.writeFooter(fw);
    }

    private void writeConstantSource(FileWriter fw, EJBConstantDescription ejbConst) throws IOException {
        String name = ejbConst.getBeanName();
        fw.write("package " + this.package_name + "." + name + ";\n\n");
        SourceHeaderWriter.writeHeader(fw);
        fw.write("\n");
        fw.write("import java.util.*;\n");
        fw.write("import org.w3c.dom.*;\n");
        fw.write("import com.ibm.almaden.ejbmaker.*;\n");
        fw.write("\n");
        fw.write("/**\n");
        fw.write("* XML Adaptor class for " + name + "\n");
        fw.write("*\n");
        fw.write("* @author Not known, this file was generated automatically\n");
        fw.write("**/\n");
        fw.write("\n");
        fw.write("public class " + name + "XMLAdaptor extends com.ibm.almaden.ejbmaker.XMLAdaptor implements java.io.Serializable { \n\n");
        fw.write("\t/**\n");
        fw.write("\t* static collection of constant and final instances\n");
        fw.write("\t*/\n");
        fw.write("\tprivate static java.util.ArrayList _instances;\n");
        fw.write("\t/**\n");
        fw.write("\t* static initializer. Initialize constant instances\n");
        fw.write("\t*/\n");
        fw.write("\tstatic {\n");
        fw.write("\t\t_instances = new java.util.ArrayList();\n");
        int i = 0;
        while (i < ejbConst.getConstantInstanceCollection().getNufInstances()) {
            ConstantInstance ci = ejbConst.getConstantInstanceCollection().getNthConstantInstance(i);
            fw.write("\t\t" + name + "XMLAdaptor instance" + i + " = new " + name + "XMLAdaptor();\n");
            int key = 0;
            int j = 0;
            while (j < ci.getNufInitializers()) {
                ConstantInitializer cinit = ci.getNthInitializer(j);
                String field_name = cinit.getFieldName();
                String type = null;
                int k = 0;
                while (k < ejbConst.getConstantFieldCollection().getNufConstantFields()) {
                    ConstantField cf = ejbConst.getConstantFieldCollection().getNthConstantField(k);
                    if (cf.getFieldName().equals(field_name)) {
                        type = cf.getJavaDT();
                        break;
                    }
                    ++k;
                }
                if (type == null) {
                    System.err.println(" Error, constant initializer for " + name + " references unknown constant field :" + field_name);
                    return;
                }
                fw.write("\t\tinstance" + i + "." + cinit.getFieldName() + "=(" + type + ")createNewInstance(\"" + type + "\", \"" + cinit.getFieldValue() + "\");\n");
                key += cinit.getFieldName().hashCode() + cinit.getFieldValue().hashCode() + type.hashCode();
                ++j;
            }
            String skey = Integer.toHexString(key + name.hashCode()).toUpperCase();
            fw.write("\t\tinstance" + i + ".primaryKey = \"" + skey + "\";\n");
            fw.write("\t\t_instances.add(instance" + i + ");\n");
            ++i;
        }
        fw.write("\t} // static initializer\n\n");
        fw.write("\t/**\n");
        fw.write("\t* Field instances\n");
        fw.write("\t*/\n");
        fw.write("\t// Primary key \n");
        fw.write("\tprivate java.lang.String primaryKey;\n\n");
        int i2 = 0;
        while (i2 < ejbConst.getConstantFieldCollection().getNufConstantFields()) {
            ConstantField cf = ejbConst.getConstantFieldCollection().getNthConstantField(i2);
            String cf_name = cf.getFieldName();
            String cf_type = cf.getJavaDT();
            cf_type = this.getNonPrimitiveClass(cf_type);
            fw.write("\tprivate " + cf_type + " " + cf_name + ";\n");
            ++i2;
        }
        int i3 = 0;
        while (i3 < ejbConst.getConstantFieldCollection().getNufConstantFields()) {
            ConstantField cf = ejbConst.getConstantFieldCollection().getNthConstantField(i3);
            String cf_name = cf.getFieldName();
            String cf_type = cf.getJavaDT();
            cf_type = this.getNonPrimitiveClass(cf_type);
            fw.write("\t/**\t\n");
            fw.write("\t* get" + cf_name + "\n");
            fw.write("\t* \n");
            fw.write("\t* @return " + cf_type + " Current value of " + cf_name + "\n");
            fw.write("\t*/\n");
            fw.write("\n");
            fw.write("\tpublic " + cf_type + " get" + cf_name + "() {\n");
            fw.write("\t\treturn " + cf_name + ";\n");
            fw.write("\t} // get" + cf_name + "\n\n");
            ++i3;
        }
        fw.write("\t/**\t\n");
        fw.write("\t* findByPrimaryKey. Find an instance by its primary key\n");
        fw.write("\t* \n");
        fw.write("\t*@param pkey Primary key to match\n");
        fw.write("\t* @return " + name + "XMLAdaptor Instance matching the primary key, null if no match\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic static " + name + "XMLAdaptor findByPrimaryKey(String pkey) {\n");
        fw.write("\t\tfor(int i=0;i<_instances.size();++i) {\n");
        fw.write("\t\t\t" + name + "XMLAdaptor " + name + "Adaptor = (" + name + "XMLAdaptor)_instances.get(i);\n");
        fw.write("\t\t\tif(" + name + "Adaptor.getPrimaryKey().equals(pkey)) return " + name + "Adaptor;\n");
        fw.write("\t\t}\n");
        fw.write("\t\treturn null;\n");
        fw.write("\t} // findByPrimaryKey\n\n");
        fw.write("\t/**\n");
        fw.write("\t* findByPrimaryKey. Find the EJB object by this adaptor's primary key. NOT SUPPORTED FOR CONSTANT BEANS.\n");
        fw.write("\t* \n");
        fw.write("\t* @return EJBObject the bean\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tprotected javax.ejb.EJBObject findByPrimaryKey() throws java.rmi.RemoteException, javax.ejb.FinderException {\n");
        fw.write("    return null;\n");
        fw.write("  } // findByPrimaryKey\n\n");
        int i4 = 0;
        while (i4 < ejbConst.getConstantFieldCollection().getNufConstantFields()) {
            ConstantField cf = ejbConst.getConstantFieldCollection().getNthConstantField(i4);
            String cf_name = cf.getFieldName();
            String cf_type = cf.getJavaDT();
            fw.write("\t/**\n");
            fw.write("\t* findBy" + cf_name + ". Find instances matching the " + cf_name + " field.\n");
            fw.write("\t* \n");
            fw.write("\t* @return java.util.Enumeration Enumeration of matches\n");
            fw.write("\t*/\n");
            fw.write("\n");
            fw.write("\tpublic static java.util.Enumeration findBy" + cf_name + "(" + cf_type + " match) {\n");
            fw.write("\t\tSerializableEnumeration result = new SerializableEnumeration();\n");
            fw.write("\t\tfor(int i=0;i<_instances.size();++i) {\n");
            fw.write("\t\t\t" + name + "XMLAdaptor " + name + "Adaptor = (" + name + "XMLAdaptor)_instances.get(i);\n");
            fw.write("\t\t\tif(" + name + "Adaptor.get" + cf_name + "().equals(match)) result.add(" + name + "Adaptor);\n");
            fw.write("\t\t}\n");
            fw.write("\t\treturn result;\n");
            fw.write("  } // findBy" + cf_name + "\n\n");
            ++i4;
        }
        fw.write("\t/**\n");
        fw.write("\t* findAllInstances Return all instances of the bean \n");
        fw.write("\t* \n");
        fw.write("\t* @return java.util.Enumeration Enumeration of all instances\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic static java.util.Enumeration findAllInstances() {\n");
        fw.write("\t\tSerializableEnumeration result = new SerializableEnumeration();\n");
        fw.write("\t\tfor(int i=0;i<_instances.size();++i) {\n");
        fw.write("\t\t\t" + name + "XMLAdaptor " + name + "Adaptor = (" + name + "XMLAdaptor)_instances.get(i);\n");
        fw.write("\t\t\tresult.add(" + name + "Adaptor);\n");
        fw.write("\t\t}\n");
        fw.write("\t\treturn result;\n");
        fw.write("  } // findAllInstances\n\n");
        fw.write("\t/**\t\n");
        fw.write("\t* getPrimaryKey Get primary key (String)\n");
        fw.write("\t* \n");
        fw.write("\t* @return String PrimaryKey\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic String getPrimaryKey() {\n");
        fw.write("\t\treturn primaryKey;\n");
        fw.write("\t} // getPrimaryKey\n\n");
        fw.write("\t/**\n");
        fw.write("\t* getXML. Transform into XML (for passing over a network for instance)\n");
        fw.write("\t* \n");
        fw.write("\t* @return Document\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic Document getXML() {\n");
        fw.write("\t\treturn this.getXML(new java.util.ArrayList());\n");
        fw.write("\t}\n");
        fw.write("\t/**\n");
        fw.write("\t* getXML. Transform into XML (for passing over a network for instance)\n");
        fw.write("\t* \n");
        fw.write("\t*@param traversed_object Objects already visited\n");
        fw.write("\t* @return Document\n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic Document getXML(java.util.ArrayList traversed_objects) {\n");
        fw.write("\t\ttraversed_objects.add(primaryKey);\n");
        fw.write("\t\tDocument doc = this.createDocument();\n");
        fw.write("\n");
        fw.write("\t\tElement root = doc.createElement(\"" + name + "\");\n");
        fw.write("\t\tif(primaryKey != null) root.setAttribute(\"key\", primaryKey);\n");
        fw.write("\t\tdoc.appendChild(root);\n");
        fw.write("\n");
        int i5 = 0;
        while (i5 < ejbConst.getConstantFieldCollection().getNufConstantFields()) {
            ConstantField cf = ejbConst.getConstantFieldCollection().getNthConstantField(i5);
            String cf_name = cf.getFieldName();
            String cf_type = cf.getJavaDT();
            cf_type = this.getNonPrimitiveClass(cf_type);
            fw.write("\t\t// " + cf_name + "\n");
            fw.write("\t\tif(" + cf_name + " != null) {\n");
            fw.write("\t\t\tElement " + cf_name + "_elm = doc.createElement(\"" + cf_name + "\");\n");
            fw.write("\t\t\tText " + cf_name + "_text = doc.createTextNode(super.createXMLText(" + cf_name + "));\n");
            fw.write("\t\t\t" + cf_name + "_elm.appendChild(" + cf_name + "_text);\n");
            fw.write("\t\t\troot.appendChild(" + cf_name + "_elm);\n");
            fw.write("\t\t}\n\n");
            ++i5;
        }
        fw.write("\t\treturn doc;\n");
        fw.write("\t} // getXML\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* initialize. NOT POSSIBLE FOR CONSTANTS\n");
        fw.write("\t* @param _adaptor Another XMLAdaptor instancet\n");
        fw.write("\t* \n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic void initialize(com.ibm.almaden.ejbmaker.XMLAdaptor _adaptor)  {\n");
        fw.write("\t\treturn; // not supported\n");
        fw.write("\t}\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* initialize. NOT POSSIBLE FOR CONSTANTS!\n");
        fw.write("\t* @param doc Document\n");
        fw.write("\t* \n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic void initialize(Document doc)  {\n");
        fw.write("\t\treturn; // not supported\n");
        fw.write("\t} // initialize\n");
        fw.write("\n");
        fw.write("\t/**\n");
        fw.write("\t* initialize. NOT POSSIBLE FOR CONSTANTS\n");
        fw.write("\t* @param _ejb EJB instance\n");
        fw.write("\t* \n");
        fw.write("\t*/\n");
        fw.write("\n");
        fw.write("\tpublic void initialize(javax.ejb.EJBObject _ejb) throws java.rmi.RemoteException {\n");
        fw.write("\t\treturn;\n");
        fw.write("\t} // initialize\n");
        fw.write("\n");
        fw.write("};\n");
        SourceFooterWriter.writeFooter(fw);
    }

    private String getNonPrimitiveClass(String primclass) {
        String sname = primclass;
        if (primclass.startsWith("java.lang.")) {
            sname = primclass.substring(10);
        }
        if (sname.equals("boolean")) {
            return "Boolean";
        }
        if (sname.equals("short")) {
            return "Short";
        }
        if (sname.equals("int")) {
            return "Integer";
        }
        if (sname.equals("long")) {
            return "Long";
        }
        if (sname.equals("byte")) {
            return "Byte";
        }
        if (sname.equals("char")) {
            return "Char";
        }
        if (sname.equals("double")) {
            return "Double";
        }
        if (sname.equals("float")) {
            return "Float";
        }
        return primclass;
    }

    public boolean isPrimitive(String s) {
        return s.equals("boolean") || s.equals("char") || s.equals("byte") || s.equals("short") || s.equals("int") || s.equals("long") || s.equals("float") || s.equals("double");
    }
}

