/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.almaden.ejbmaker;

import com.ibm.almaden.ejbmaker.EJBCollection;
import com.ibm.almaden.ejbmaker.EJBDescription;
import com.ibm.almaden.ejbmaker.EJBGenerator;
import com.ibm.almaden.ejbmaker.EJBRelation;
import com.ibm.almaden.ejbmaker.EJBSourceGenerator;
import com.ibm.almaden.ejbmaker.PersistantField;
import com.ibm.almaden.ejbmaker.PersistantFieldCollection;
import com.ibm.almaden.ejbmaker.SmartWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class SQLExporterGenerator
implements EJBGenerator {
    private String rdb_source_folder;
    private EJBCollection ejbCollection;

    public SQLExporterGenerator(String source, EJBCollection coll) {
        this.rdb_source_folder = source;
        this.ejbCollection = coll;
    }

    public void generate() throws IOException {
        String bean_name;
        String merged_file_name = this.rdb_source_folder + File.separator + "Export.ddl";
        SmartWriter merged_sw = new SmartWriter(merged_file_name);
        FileWriter mfw = merged_sw.createFile();
        int i = 0;
        while (i < this.ejbCollection.getNufDescriptions()) {
            EJBDescription ejbDesc = this.ejbCollection.getNthDescription(i);
            PersistantFieldCollection pfc = ejbDesc.getPersistantFieldCollection();
            bean_name = ejbDesc.getBeanName();
            mfw.write("export to " + bean_name + ".ixf of ixf select primarykey, ");
            int n = 0;
            while (n < pfc.getNufPersistantFields()) {
                PersistantField pf = pfc.getNthPersistantField(n);
                mfw.write(pf.getFieldName());
                if (n < pfc.getNufPersistantFields() - 1) {
                    mfw.write(", ");
                }
                ++n;
            }
            if (ejbDesc.getBeanType().equalsIgnoreCase("topic")) {
                mfw.write(", REC_CRTD ");
            }
            if (EJBSourceGenerator.version < 4) {
                mfw.write(" from ejb." + bean_name + "\n");
            } else {
                mfw.write(" from " + bean_name + "\n");
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.ejbCollection.getNufRelations()) {
            EJBRelation ejbRel = this.ejbCollection.getNthRelation(i2);
            bean_name = ejbRel.getBeanName();
            if (EJBSourceGenerator.version < 4) {
                mfw.write("export to " + bean_name + ".ixf of ixf select primarykey, " + ejbRel.getFirstPField() + ", " + ejbRel.getSecondPField() + " from ejb." + bean_name + "\n");
            } else {
                mfw.write("export to " + bean_name + ".ixf of ixf select primarykey, " + ejbRel.getFirstPField() + ", " + ejbRel.getSecondPField() + " from " + bean_name + "\n");
            }
            ++i2;
        }
        merged_sw.copyAndClose();
    }
}

