/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.almaden.ejbmaker;

import com.ibm.almaden.ejbmaker.EJBCollection;
import com.ibm.almaden.ejbmaker.EJBDescription;
import com.ibm.almaden.ejbmaker.EJBGenerator;
import com.ibm.almaden.ejbmaker.EJBRelation;
import com.ibm.almaden.ejbmaker.EJBSourceGenerator;
import com.ibm.almaden.ejbmaker.SmartWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class SQLCreateIndexGenerator
implements EJBGenerator {
    private String rdb_source_folder;
    private EJBCollection ejbCollection;

    public SQLCreateIndexGenerator(String source, EJBCollection coll) {
        this.rdb_source_folder = source;
        this.ejbCollection = coll;
    }

    public void generate() throws IOException {
        String file_name = this.rdb_source_folder + File.separator + "CreateIndexes.ddl";
        SmartWriter sw = new SmartWriter(file_name);
        FileWriter mfw = sw.createFile();
        int i = 0;
        while (i < this.ejbCollection.getNufDescriptions()) {
            EJBDescription ejbDesc = this.ejbCollection.getNthDescription(i);
            String bean_name = ejbDesc.getBeanName();
            this.writeDescriptionSouce(mfw, ejbDesc);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.ejbCollection.getNufRelations()) {
            EJBRelation ejbRel = this.ejbCollection.getNthRelation(i2);
            String bean_name = ejbRel.getBeanName();
            this.writeRelationSouce(mfw, ejbRel);
            ++i2;
        }
        sw.copyAndClose();
    }

    private void writeDescriptionSouce(FileWriter fw, EJBDescription ejbDesc) throws IOException {
    }

    private void writeRelationSouce(FileWriter fw, EJBRelation ejbRel) throws IOException {
        String name = ejbRel.getBeanName();
        if (EJBSourceGenerator.version < 4) {
            fw.write("CREATE INDEX EJB." + name + "00 ON EJB." + name + " (" + ejbRel.getFirstPField() + " ASC) PCTFREE 10 MINPCTUSED 10 ALLOW REVERSE SCANS\n");
            fw.write("CREATE INDEX EJB." + name + "01 ON EJB." + name + " (" + ejbRel.getSecondPField() + " ASC) PCTFREE 10 MINPCTUSED 10 ALLOW REVERSE SCANS\n");
        } else {
            fw.write("CREATE INDEX " + name + "00 ON " + name + " (" + ejbRel.getFirstPField() + " ASC) PCTFREE 10 MINPCTUSED 10 ALLOW REVERSE SCANS\n");
            fw.write("CREATE INDEX " + name + "01 ON " + name + " (" + ejbRel.getSecondPField() + " ASC) PCTFREE 10 MINPCTUSED 10 ALLOW REVERSE SCANS\n");
        }
    }
}

