/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.almaden.ejbmaker;

import com.ibm.almaden.ejbmaker.EJBCollection;
import com.ibm.almaden.ejbmaker.EJBDescription;
import com.ibm.almaden.ejbmaker.EJBGenerator;
import com.ibm.almaden.ejbmaker.EJBRelation;
import com.ibm.almaden.ejbmaker.EJBSourceGenerator;
import com.ibm.almaden.ejbmaker.PersistantField;
import com.ibm.almaden.ejbmaker.SmartWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class EJBDeploymentDescriptorGenerator
implements EJBGenerator {
    private String java_source_folder;
    private String package_name;
    private EJBCollection ejbCollection;

    public EJBDeploymentDescriptorGenerator(String source, String pname, EJBCollection coll) {
        this.java_source_folder = source;
        this.package_name = pname;
        this.ejbCollection = coll;
    }

    public void generate() throws IOException {
        String merged_file_name = EJBSourceGenerator.version < 4 ? this.java_source_folder + File.separator + "ejbs.xml" : this.java_source_folder + File.separator + "ejb-jar.xml";
        SmartWriter merged_sw = new SmartWriter(merged_file_name);
        FileWriter mfw = merged_sw.createFile();
        if (EJBSourceGenerator.version < 4) {
            mfw.write("<?xml version='1.0' encoding=\"ISO-8859-1\" ?>\n");
            mfw.write("<!DOCTYPE ejb-JAR SYSTEM \"JetAceDTD.dtd\">\n");
            mfw.write("<ejb-JAR>\n");
            mfw.write("<input-file>ejbs_ACE.jar</input-file>\n");
            mfw.write("<output-file>ejbs.jar</output-file>\n");
        } else {
            mfw.write("<?xml version='1.0' encoding=\"UTF-8\" ?>\n");
            mfw.write("<!DOCTYPE ejb-jar PUBLIC \"-//Sun Microsystems Inc.//DTD Enterprise JavaBeans 1.1//EN\" \"http://java.sun.com/j2ee/dtds/ejb-jar_1_1.dtd\">\n");
            mfw.write("<ejb-jar>\n");
            mfw.write("   <description>Generated deployment descriptors</description>\n");
            mfw.write("\t  <enterprise-beans>\n");
        }
        int i = 0;
        while (i < this.ejbCollection.getNufDescriptions()) {
            EJBDescription ejbDesc = this.ejbCollection.getNthDescription(i);
            String bean_name = ejbDesc.getBeanName();
            String java_file_name = null;
            java_file_name = EJBSourceGenerator.version < 4 ? this.java_source_folder + File.separator + bean_name + File.separator + bean_name + ".xml" : this.java_source_folder + File.separator + bean_name + File.separator + "ejb-jar.xml";
            SmartWriter sw = new SmartWriter(java_file_name);
            FileWriter fw = sw.createFile();
            this.writeDescriptionSouce(fw, mfw, ejbDesc);
            sw.copyAndClose();
            ++i;
        }
        int i2 = 0;
        while (i2 < this.ejbCollection.getNufRelations()) {
            EJBRelation ejbRel = this.ejbCollection.getNthRelation(i2);
            String bean_name = ejbRel.getBeanName();
            String java_file_name = null;
            java_file_name = EJBSourceGenerator.version < 4 ? this.java_source_folder + File.separator + bean_name + File.separator + bean_name + ".xml" : this.java_source_folder + File.separator + bean_name + File.separator + "ejb-jar.xml";
            SmartWriter sw = new SmartWriter(java_file_name);
            FileWriter fw = sw.createFile();
            this.writeRelationSouce(fw, mfw, ejbRel);
            sw.copyAndClose();
            ++i2;
        }
        if (EJBSourceGenerator.version < 4) {
            mfw.write("</ejb-JAR>\n");
        } else {
            mfw.write("\t</enterprise-beans>\n");
            mfw.write("\t<assembly-descriptor>\n");
            int i3 = 0;
            while (i3 < this.ejbCollection.getNufDescriptions()) {
                EJBDescription ejbDesc = this.ejbCollection.getNthDescription(i3);
                String bean_name = ejbDesc.getBeanName();
                mfw.write("\t\t<container-transaction>\n");
                mfw.write("\t\t\t<method>\n");
                mfw.write("\t\t\t\t<ejb-name>" + bean_name + "</ejb-name>\n");
                mfw.write("\t\t\t\t<method-name>*</method-name>\n");
                mfw.write("\t\t\t</method>\n");
                mfw.write("\t\t\t<trans-attribute>" + ejbDesc.getTransactionAttribute() + "</trans-attribute>\n");
                mfw.write("\t\t</container-transaction>\n");
                ++i3;
            }
            int i4 = 0;
            while (i4 < this.ejbCollection.getNufRelations()) {
                EJBRelation ejbRel = this.ejbCollection.getNthRelation(i4);
                String bean_name = ejbRel.getBeanName();
                mfw.write("\t\t<container-transaction>\n");
                mfw.write("\t\t\t<method>\n");
                mfw.write("\t\t\t\t<ejb-name>" + bean_name + "</ejb-name>\n");
                mfw.write("\t\t\t\t<method-name>*</method-name>\n");
                mfw.write("\t\t\t</method>\n");
                mfw.write("\t\t\t<trans-attribute>" + ejbRel.getTransactionAttribute() + "</trans-attribute>\n");
                mfw.write("\t\t</container-transaction>\n");
                ++i4;
            }
            mfw.write("\t</assembly-descriptor>\n");
            mfw.write("</ejb-jar>\n");
        }
        merged_sw.copyAndClose();
    }

    private void writeDescriptionSouce(FileWriter fw, FileWriter mfw, EJBDescription ejbDesc) throws IOException {
        String name = ejbDesc.getBeanName();
        if (EJBSourceGenerator.version < 4) {
            fw.write("<?xml version='1.0' encoding=\"ISO-8859-1\" ?>\n");
            fw.write("<!DOCTYPE ejb-JAR SYSTEM \"JetAceDTD.dtd\">\n");
            fw.write("<ejb-JAR>\n");
            fw.write("\t<input-file>" + name + "_ACE.jar</input-file>\n");
            fw.write("\t<output-file>" + name + ".jar</output-file>\n");
            fw.write("\t<entity-bean dname=\"" + name + ".ser\">\n");
            mfw.write("\t<entity-bean dname=\"" + name + ".ser\">\n");
            fw.write("\t\t<primary-key>" + this.package_name + "." + name + "." + name + "Key</primary-key>\n");
            mfw.write("\t\t<primary-key>" + this.package_name + "." + name + "." + name + "Key</primary-key>\n");
            fw.write("\t\t<re-entrant value=\"" + ejbDesc.getReentrant() + "\"/>\n");
            mfw.write("\t\t<re-entrant value=\"" + ejbDesc.getReentrant() + "\"/>\n");
            fw.write("\t\t<container-managed>primaryKey</container-managed>\n");
            mfw.write("\t\t<container-managed>primaryKey</container-managed>\n");
        } else {
            fw.write("<?xml version='1.0' encoding=\"UTF-8\" ?>\n");
            fw.write("<!DOCTYPE ejb-jar PUBLIC \"-//Sun Microsystems Inc.//DTD Enterprise JavaBeans 1.1//EN\" \"http://java.sun.com/j2ee/dtds/ejb-jar_1_1.dtd\">\n");
            fw.write("<ejb-jar>\n");
            fw.write("\t<description>Generated deployment descriptor for " + name + " CMP EJB</description>\n");
            fw.write("\t<enterprise-beans>\n");
            fw.write("\t\t<entity>\n");
            mfw.write("\t\t<entity>\n");
            fw.write("\t\t\t<ejb-name>" + name + "</ejb-name>\n");
            mfw.write("\t\t\t<ejb-name>" + name + "</ejb-name>\n");
            fw.write("\t\t\t<home>" + this.package_name + "." + name + "." + name + "Home</home>\n");
            mfw.write("\t\t\t<home>" + this.package_name + "." + name + "." + name + "Home</home>\n");
            fw.write("\t\t\t<remote>" + this.package_name + "." + name + "." + name + "</remote>\n");
            mfw.write("\t\t\t<remote>" + this.package_name + "." + name + "." + name + "</remote>\n");
            fw.write("\t\t\t<ejb-class>" + this.package_name + "." + name + "." + name + "Bean</ejb-class>\n");
            mfw.write("\t\t\t<ejb-class>" + this.package_name + "." + name + "." + name + "Bean</ejb-class>\n");
            fw.write("\t\t\t<persistence-type>Container</persistence-type>\n");
            mfw.write("\t\t\t<persistence-type>Container</persistence-type>\n");
            fw.write("\t\t\t<prim-key-class>" + this.package_name + "." + name + "." + name + "Key</prim-key-class>\n");
            mfw.write("\t\t\t<prim-key-class>" + this.package_name + "." + name + "." + name + "Key</prim-key-class>\n");
            fw.write("\t\t\t<reentrant>" + ejbDesc.getReentrant() + "</reentrant>\n");
            mfw.write("\t\t\t<reentrant>" + ejbDesc.getReentrant() + "</reentrant>\n");
            fw.write("\t\t\t<cmp-field><field-name>primaryKey</field-name></cmp-field>\n");
            mfw.write("\t\t\t<cmp-field><field-name>primaryKey</field-name></cmp-field>\n");
        }
        int i = 0;
        while (i < ejbDesc.getPersistantFieldCollection().getNufPersistantFields()) {
            PersistantField pf = ejbDesc.getPersistantFieldCollection().getNthPersistantField(i);
            if (EJBSourceGenerator.version < 4) {
                fw.write("\t\t<container-managed>" + pf.getFieldName() + "</container-managed>\n");
                mfw.write("\t\t<container-managed>" + pf.getFieldName() + "</container-managed>\n");
            } else {
                fw.write("\t\t\t<cmp-field><field-name>" + pf.getFieldName() + "</field-name></cmp-field>\n");
                mfw.write("\t\t\t<cmp-field><field-name>" + pf.getFieldName() + "</field-name></cmp-field>\n");
            }
            ++i;
        }
        if (ejbDesc.needsEncryption() && EJBSourceGenerator.version < 4) {
            fw.write("\t\t<container-managed>CRYPTKEY</container-managed>\n");
            mfw.write("\t\t<container-managed>CRYPTKEY</container-managed>\n");
        } else if (ejbDesc.needsEncryption() && EJBSourceGenerator.version >= 4) {
            fw.write("\t\t\t<cmp-field><field-name>CRYPTKEY</field-name></cmp-field>\n");
            mfw.write("\t\t\t<cmp-field><field-name>CRYPTKEY</field-name></cmp-field>\n");
        }
        if (ejbDesc.getBeanType().equalsIgnoreCase("topic")) {
            if (EJBSourceGenerator.version < 4) {
                fw.write("\t\t<container-managed>REC_CRTD</container-managed>\n");
                mfw.write("\t\t<container-managed>REC_CRTD</container-managed>\n");
            } else {
                fw.write("\t\t\t<cmp-field><field-name>REC_CRTD</field-name></cmp-field>\n");
                mfw.write("\t\t\t<cmp-field><field-name>REC_CRTD</field-name></cmp-field>\n");
            }
        }
        if (EJBSourceGenerator.version < 4) {
            fw.write("\t\t<home-interface>" + this.package_name + "." + name + "." + name + "Home</home-interface>\n");
            mfw.write("\t\t<home-interface>" + this.package_name + "." + name + "." + name + "Home</home-interface>\n");
            fw.write("\t\t<remote-interface>" + this.package_name + "." + name + "." + name + "</remote-interface>\n");
            mfw.write("\t\t<remote-interface>" + this.package_name + "." + name + "." + name + "</remote-interface>\n");
            fw.write("\t\t<enterprise-bean>" + this.package_name + "." + name + "." + name + "Bean</enterprise-bean>\n");
            mfw.write("\t\t<enterprise-bean>" + this.package_name + "." + name + "." + name + "Bean</enterprise-bean>\n");
            fw.write("\t\t<jndi-name>" + name + "</jndi-name>\n");
            mfw.write("\t\t<jndi-name>" + name + "</jndi-name>\n");
            fw.write("\t\t<transaction-attr value=\"" + ejbDesc.getTransactionAttribute() + "\"/>\n");
            mfw.write("\t\t<transaction-attr value=\"" + ejbDesc.getTransactionAttribute() + "\"/>\n");
            fw.write("\t\t<isolation-level value=\"" + ejbDesc.getIsolationLevel() + "\"/>\n");
            mfw.write("\t\t<isolation-level value=\"" + ejbDesc.getIsolationLevel() + "\"/>\n");
            fw.write("\t\t<run-as-mode value=\"" + ejbDesc.getRunAsMode() + "\"/>\n");
            mfw.write("\t\t<run-as-mode value=\"" + ejbDesc.getRunAsMode() + "\"/>\n");
            fw.write("\t</entity-bean>\n");
            mfw.write("\t</entity-bean>\n");
            fw.write("</ejb-JAR>\n");
            mfw.write("\n\n");
        } else {
            fw.write("\t\t\t<primkey-field>primaryKey</primkey-field>\n");
            mfw.write("\t\t\t<primkey-field>primaryKey</primkey-field>\n");
            fw.write("\t\t</entity>\n");
            mfw.write("\t\t</entity>\n");
            fw.write("\t</enterprise-beans>\n");
            fw.write("\t<assembly-descriptor>\n");
            fw.write("\t\t<container-transaction>\n");
            fw.write("\t\t\t<method>\n");
            fw.write("\t\t\t\t<ejb-name>" + name + "</ejb-name>\n");
            fw.write("\t\t\t\t<method-name>*</method-name>\n");
            fw.write("\t\t\t</method>\n");
            fw.write("\t\t\t<trans-attribute>" + ejbDesc.getTransactionAttribute() + "</trans-attribute>\n");
            fw.write("\t\t</container-transaction>\n");
            fw.write("\t</assembly-descriptor>\n");
            fw.write("</ejb-jar>\n");
            mfw.write("\n\n");
        }
    }

    private void writeRelationSouce(FileWriter fw, FileWriter mfw, EJBRelation ejbRel) throws IOException {
        String name = ejbRel.getBeanName();
        if (EJBSourceGenerator.version < 4) {
            fw.write("<?xml version='1.0' encoding=\"ISO-8859-1\" ?>\n");
            fw.write("<!DOCTYPE ejb-JAR SYSTEM \"JetAceDTD.dtd\">\n");
            fw.write("<ejb-JAR>\n");
            fw.write("\t<input-file>" + name + "_ACE.jar</input-file>\n");
            fw.write("\t<output-file>" + name + ".jar</output-file>\n");
            fw.write("\t<entity-bean dname=\"" + name + ".ser\">\n");
            mfw.write("\t<entity-bean dname=\"" + name + ".ser\">\n");
            fw.write("\t\t<primary-key>" + this.package_name + "." + name + "." + name + "Key</primary-key>\n");
            mfw.write("\t\t<primary-key>" + this.package_name + "." + name + "." + name + "Key</primary-key>\n");
            fw.write("\t\t<re-entrant value=\"" + ejbRel.getReentrant() + "\"/>\n");
            mfw.write("\t\t<re-entrant value=\"" + ejbRel.getReentrant() + "\"/>\n");
            fw.write("\t\t<container-managed>primaryKey</container-managed>\n");
            mfw.write("\t\t<container-managed>primaryKey</container-managed>\n");
        } else {
            fw.write("<?xml version='1.0' encoding=\"UTF-8\" ?>\n");
            fw.write("<!DOCTYPE ejb-jar PUBLIC \"-//Sun Microsystems Inc.//DTD Enterprise JavaBeans 1.1//EN\" \"http://java.sun.com/j2ee/dtds/ejb-jar_1_1.dtd\">\n");
            fw.write("<ejb-jar>\n");
            fw.write("\t<description>Generated deployment descriptor for " + name + " CMP EJB</description>\n");
            fw.write("\t<enterprise-beans>\n");
            fw.write("\t\t<entity>\n");
            mfw.write("\t\t<entity>\n");
            fw.write("\t\t\t<ejb-name>" + name + "</ejb-name>\n");
            mfw.write("\t\t\t<ejb-name>" + name + "</ejb-name>\n");
            fw.write("\t\t\t<home>" + this.package_name + "." + name + "." + name + "Home</home>\n");
            mfw.write("\t\t\t<home>" + this.package_name + "." + name + "." + name + "Home</home>\n");
            fw.write("\t\t\t<remote>" + this.package_name + "." + name + "." + name + "</remote>\n");
            mfw.write("\t\t\t<remote>" + this.package_name + "." + name + "." + name + "</remote>\n");
            fw.write("\t\t\t<ejb-class>" + this.package_name + "." + name + "." + name + "Bean</ejb-class>\n");
            mfw.write("\t\t\t<ejb-class>" + this.package_name + "." + name + "." + name + "Bean</ejb-class>\n");
            fw.write("\t\t\t<persistence-type>Container</persistence-type>\n");
            mfw.write("\t\t\t<persistence-type>Container</persistence-type>\n");
            fw.write("\t\t\t<prim-key-class>" + this.package_name + "." + name + "." + name + "Key</prim-key-class>\n");
            mfw.write("\t\t\t<prim-key-class>" + this.package_name + "." + name + "." + name + "Key</prim-key-class>\n");
            fw.write("\t\t\t<reentrant>" + ejbRel.getReentrant() + "</reentrant>\n");
            mfw.write("\t\t\t<reentrant>" + ejbRel.getReentrant() + "</reentrant>\n");
            fw.write("\t\t\t<cmp-field><field-name>primaryKey</field-name></cmp-field>\n");
            mfw.write("\t\t\t<cmp-field><field-name>primaryKey</field-name></cmp-field>\n");
            fw.write("\t\t\t<cmp-field><field-name>" + ejbRel.getFirstPField() + "</field-name></cmp-field>\n");
            mfw.write("\t\t\t<cmp-field><field-name>" + ejbRel.getFirstPField() + "</field-name></cmp-field>\n");
            fw.write("\t\t\t<cmp-field><field-name>" + ejbRel.getSecondPField() + "</field-name></cmp-field>\n");
            mfw.write("\t\t\t<cmp-field><field-name>" + ejbRel.getSecondPField() + "</field-name></cmp-field>\n");
        }
        int i = 0;
        while (i < ejbRel.getPersistantFieldCollection().getNufPersistantFields()) {
            PersistantField pf = ejbRel.getPersistantFieldCollection().getNthPersistantField(i);
            if (EJBSourceGenerator.version < 4) {
                fw.write("\t\t<container-managed>" + pf.getFieldName() + "</container-managed>\n");
                mfw.write("\t\t<container-managed>" + pf.getFieldName() + "</container-managed>\n");
            } else {
                fw.write("\t\t\t<cmp-field><field-name>" + pf.getFieldName() + "</field-name></cmp-field>\n");
                mfw.write("\t\t\t<cmp-field><field-name>" + pf.getFieldName() + "</field-name></cmp-field>\n");
            }
            ++i;
        }
        if (ejbRel.needsEncryption() && EJBSourceGenerator.version < 4) {
            fw.write("\t\t<container-managed>CRYPTKEY</container-managed>\n");
            mfw.write("\t\t<container-managed>CRYPTKEY</container-managed>\n");
        } else if (ejbRel.needsEncryption() && EJBSourceGenerator.version >= 4) {
            fw.write("\t\t\t<cmp-field><field-name>CRYPTKEY</field-name></cmp-field>\n");
            mfw.write("\t\t\t<cmp-field><field-name>CRYPTKEY</field-name></cmp-field>\n");
        }
        if (EJBSourceGenerator.version < 4) {
            fw.write("\t\t<container-managed>" + ejbRel.getFirstPField() + "</container-managed>\n");
            mfw.write("\t\t<container-managed>" + ejbRel.getFirstPField() + "</container-managed>\n");
            fw.write("\t\t<container-managed>" + ejbRel.getSecondPField() + "</container-managed>\n");
            mfw.write("\t\t<container-managed>" + ejbRel.getSecondPField() + "</container-managed>\n");
            fw.write("\t\t<home-interface>" + this.package_name + "." + name + "." + name + "Home</home-interface>\n");
            mfw.write("\t\t<home-interface>" + this.package_name + "." + name + "." + name + "Home</home-interface>\n");
            fw.write("\t\t<remote-interface>" + this.package_name + "." + name + "." + name + "</remote-interface>\n");
            mfw.write("\t\t<remote-interface>" + this.package_name + "." + name + "." + name + "</remote-interface>\n");
            fw.write("\t\t<enterprise-bean>" + this.package_name + "." + name + "." + name + "Bean</enterprise-bean>\n");
            mfw.write("\t\t<enterprise-bean>" + this.package_name + "." + name + "." + name + "Bean</enterprise-bean>\n");
            fw.write("\t\t<jndi-name>" + name + "</jndi-name>\n");
            mfw.write("\t\t<jndi-name>" + name + "</jndi-name>\n");
            fw.write("\t\t<transaction-attr value=\"" + ejbRel.getTransactionAttribute() + "\"/>\n");
            mfw.write("\t\t<transaction-attr value=\"" + ejbRel.getTransactionAttribute() + "\"/>\n");
            fw.write("\t\t<isolation-level value=\"" + ejbRel.getIsolationLevel() + "\"/>\n");
            mfw.write("\t\t<isolation-level value=\"" + ejbRel.getIsolationLevel() + "\"/>\n");
            fw.write("\t\t<run-as-mode value=\"" + ejbRel.getRunAsMode() + "\"/>\n");
            mfw.write("\t\t<run-as-mode value=\"" + ejbRel.getRunAsMode() + "\"/>\n");
            fw.write("\t</entity-bean>\n");
            mfw.write("\t</entity-bean>\n");
            fw.write("</ejb-JAR>\n");
            mfw.write("\n\n");
        } else {
            fw.write("\t\t\t<primkey-field>primaryKey</primkey-field>\n");
            mfw.write("\t\t\t<primkey-field>primaryKey</primkey-field>\n");
            fw.write("\t\t</entity>\n");
            mfw.write("\t\t</entity>\n");
            fw.write("\t</enterprise-beans>\n");
            fw.write("\t<assembly-descriptor>\n");
            fw.write("\t\t<container-transaction>\n");
            fw.write("\t\t\t<method>\n");
            fw.write("\t\t\t\t<ejb-name>" + name + "</ejb-name>\n");
            fw.write("\t\t\t\t<method-name>*</method-name>\n");
            fw.write("\t\t\t</method>\n");
            fw.write("\t\t\t<trans-attribute>" + ejbRel.getTransactionAttribute() + "</trans-attribute>\n");
            fw.write("\t\t</container-transaction>\n");
            fw.write("\t</assembly-descriptor>\n");
            fw.write("</ejb-jar>\n");
            mfw.write("\n\n");
        }
    }
}

