/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.almaden.ejbmaker;

import com.ibm.almaden.ejbmaker.EJBConstantDescription;
import com.ibm.almaden.ejbmaker.EJBDescription;
import com.ibm.almaden.ejbmaker.EJBRelation;
import java.util.Vector;
import org.w3c.dom.Element;

public class EJBCollection {
    private String transaction_attr = null;
    private String isolation_level = null;
    private String run_as_mode_value = null;
    private String reentrant = null;
    private Vector ejbDescriptions = new Vector();
    private Vector ejbRelations = new Vector();
    private Vector ejbConstantBeans = new Vector();

    public void addBean(Element bean_elm) {
        EJBDescription desc = new EJBDescription(bean_elm);
        if (desc.getBeanName() == null || desc.getBeanName().equals("")) {
            return;
        }
        desc.setTransactionAttribute(this.getDefaultTransactionAttribute());
        desc.setIsolationLevel(this.getDefaultIsolationLevel());
        desc.setRunAsMode(this.getDefaultRunAsMode());
        desc.setReentrant(this.getDefaultReentrant());
        this.ejbDescriptions.addElement(desc);
    }

    public void addRelation(Element relation_elm) {
        EJBRelation rel = new EJBRelation(relation_elm);
        if (rel.getBeanName() == null || rel.getBeanName().equals("")) {
            return;
        }
        rel.setTransactionAttribute(this.getDefaultTransactionAttribute());
        rel.setIsolationLevel(this.getDefaultIsolationLevel());
        rel.setRunAsMode(this.getDefaultRunAsMode());
        rel.setReentrant(this.getDefaultReentrant());
        this.ejbRelations.addElement(rel);
    }

    public void addConstantBean(Element constant_elm) {
        EJBConstantDescription desc = new EJBConstantDescription(constant_elm);
        if (desc.getBeanName() == null || desc.getBeanName().equals("")) {
            return;
        }
        this.ejbConstantBeans.addElement(desc);
    }

    public void setDefaultTransactionAttribute(String attr) {
        this.transaction_attr = attr;
    }

    public void setDefaultIsolationLevel(String il) {
        this.isolation_level = il;
    }

    public void setDefaultRunAsMode(String ram) {
        this.run_as_mode_value = ram;
    }

    public void setDefaultReentrant(String re) {
        this.reentrant = re;
    }

    public String getDefaultTransactionAttribute() {
        return this.transaction_attr;
    }

    public String getDefaultIsolationLevel() {
        return this.isolation_level;
    }

    public String getDefaultRunAsMode() {
        return this.run_as_mode_value;
    }

    public String getDefaultReentrant() {
        return this.reentrant;
    }

    public int getNufDescriptions() {
        return this.ejbDescriptions.size();
    }

    public EJBDescription getNthDescription(int n) {
        return (EJBDescription)this.ejbDescriptions.elementAt(n);
    }

    public int getNufRelations() {
        return this.ejbRelations.size();
    }

    public EJBRelation getNthRelation(int n) {
        return (EJBRelation)this.ejbRelations.elementAt(n);
    }

    public int getNufConstantDescriptions() {
        return this.ejbConstantBeans.size();
    }

    public EJBConstantDescription getNthConstantDescription(int n) {
        return (EJBConstantDescription)this.ejbConstantBeans.elementAt(n);
    }

    public boolean containsDescription(String name) {
        int i = 0;
        while (i < this.getNufDescriptions()) {
            EJBDescription desc = this.getNthDescription(i);
            if (desc.getBeanName().equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean containsConstantDescription(String name) {
        int i = 0;
        while (i < this.getNufConstantDescriptions()) {
            EJBConstantDescription desc = this.getNthConstantDescription(i);
            if (desc.getBeanName().equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean containsRelation(String name) {
        int i = 0;
        while (i < this.getNufDescriptions()) {
            EJBRelation rel = this.getNthRelation(i);
            if (rel.getBeanName().equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

