/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.almaden.ejbmaker;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class CryptTools {
    private final char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String ALGORITHM_DES = "DES";
    private static final String ALGORITHM_DES_ECB_PADDING = "DES/ECB/PKCS5Padding";
    private String algorithm;
    private byte[] keyEncoding = null;
    private String keyAsString;
    private Cipher encryptCipher = null;
    private Cipher decryptCipher = null;

    public CryptTools() {
        this.algorithm = ALGORITHM_DES;
    }

    public CryptTools(String alg) {
        this.algorithm = alg;
    }

    public String encrypt(String clearText, String keyString) {
        String encryptedText = null;
        SecretKey key = null;
        boolean success = false;
        if (clearText != null && clearText.length() > 0) {
            try {
                if (this.keyEncoding == null) {
                    if (this.isKeyValid(keyString)) {
                        this.keyEncoding = this.hexToByteArray(keyString);
                        this.keyAsString = keyString;
                    } else {
                        KeyGenerator keygen = KeyGenerator.getInstance(this.algorithm);
                        key = keygen.generateKey();
                        this.keyEncoding = key.getEncoded();
                        this.keyAsString = this.byteArrayToHex(this.keyEncoding);
                    }
                }
                if (this.encryptCipher == null) {
                    this.encryptCipher = Cipher.getInstance(this.algorithm);
                    this.encryptCipher.init(1, key);
                }
                byte[] encryptedTextAsBytes = this.encryptCipher.doFinal(clearText.getBytes());
                encryptedText = this.byteArrayToHex(encryptedTextAsBytes);
                success = true;
            }
            catch (NoSuchAlgorithmException nsae) {
                System.out.println("Exception thrown from KeyGenerator.getInstance - NoSuchAlgorithmException: " + nsae.getMessage());
            }
            catch (NoSuchPaddingException nspe) {
                System.out.println("Exception thrown from Cipher.getInstance - NoSuchPaddingException: " + nspe.getMessage());
            }
            catch (InvalidKeyException ike) {
                System.out.println("Exception thrown from ciper.init - InvalidKeyException: " + ike.getMessage());
            }
            catch (BadPaddingException bpe) {
                System.out.println("Exception thrown from cipher.doFinal - BadPaddingException: " + bpe.getMessage());
            }
            catch (IllegalBlockSizeException ibse) {
                System.out.println("Exception thrown from cipher.doFinal - IllegalBlockSizeException: " + ibse.getMessage());
            }
        }
        if (success) {
            return encryptedText;
        }
        System.out.println("encrypt failure: " + clearText);
        return clearText;
    }

    public String decrypt(String encryptedText, String keyString) {
        String clearText = null;
        boolean success = false;
        if (encryptedText != null && encryptedText.length() > 0 && this.isKeyValid(keyString)) {
            try {
                if (this.keyEncoding == null) {
                    this.keyEncoding = this.hexToByteArray(keyString);
                    this.keyAsString = keyString;
                }
                SecretKeySpec key = new SecretKeySpec(this.keyEncoding, this.algorithm);
                if (this.decryptCipher == null) {
                    this.decryptCipher = Cipher.getInstance(this.algorithm);
                    this.decryptCipher.init(2, key);
                }
                byte[] encryptedTextAsBytes = this.hexToByteArray(encryptedText);
                byte[] clearTextAsBytes = this.decryptCipher.doFinal(encryptedTextAsBytes);
                clearText = new String(clearTextAsBytes);
                success = true;
            }
            catch (NoSuchAlgorithmException nsae) {
                System.out.println("Exception thrown from KeyGenerator.getInstance - NoSuchAlgorithmException: " + nsae.getMessage());
            }
            catch (NoSuchPaddingException nspe) {
                System.out.println("Exception thrown from Cipher.getInstance - NoSuchPaddingException: " + nspe.getMessage());
            }
            catch (InvalidKeyException ike) {
                System.out.println("Exception thrown from ciper.init - InvalidKeyException: " + ike.getMessage());
            }
            catch (BadPaddingException bpe) {
                System.out.println("Exception thrown from cipher.doFinal - BadPaddingException: " + bpe.getMessage());
            }
            catch (IllegalBlockSizeException ibse) {
                System.out.println("Exception thrown from cipher.doFinal - IllegalBlockSizeException: " + ibse.getMessage());
            }
        }
        if (success) {
            return clearText;
        }
        System.out.println("decrypt failure: " + encryptedText);
        return encryptedText;
    }

    public String getKey() {
        return this.keyAsString;
    }

    public boolean isKeyValid(String key) {
        boolean validFlag = false;
        if (key != null && !key.equals("") && this.algorithm.equals(ALGORITHM_DES) && key.length() == 16) {
            validFlag = true;
        }
        return validFlag;
    }

    private String byteArrayToHex(byte[] block) {
        StringBuffer buf = new StringBuffer();
        int len = block.length;
        int index = 0;
        while (index < len) {
            this.byteToHex(block[index], buf);
            if (index < len - 1) {
                // empty if block
            }
            ++index;
        }
        return new String(buf.toString());
    }

    private byte[] hexToByteArray(String hexString) {
        StringBuffer b = new StringBuffer(hexString);
        int j = b.length();
        byte[] c = new byte[j / 2];
        int i = 0;
        int k = 0;
        while (i < j) {
            c[k] = this.hexToByte(b.charAt(i), b.charAt(i + 1));
            i += 2;
            ++k;
        }
        return c;
    }

    private void byteToHex(byte b, StringBuffer buf) {
        char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int high = (b & 0xF0) >> 4;
        int low = b & 0xF;
        buf.append(hexChars[high]);
        buf.append(hexChars[low]);
    }

    private byte hexToByte(char high, char low) {
        int l = 17;
        int h = 17;
        int i = 0;
        while (i < 16) {
            if (high == this.hexChars[i]) {
                h = i;
            }
            ++i;
        }
        i = 0;
        while (i < 16) {
            if (low == this.hexChars[i]) {
                l = i;
            }
            ++i;
        }
        return (byte)(l | h << 4);
    }

    private void dumpBytes(byte[] bytes) {
        System.out.println("Dump bytes");
        int length = bytes.length;
        System.out.println("Bytes length: " + length);
        int index = 0;
        while (index < length) {
            System.out.println("Byte: " + index + ": " + bytes[index]);
            ++index;
        }
    }

    public static void main(String[] argv) {
        System.out.println("main here");
        System.out.println(" ");
        String key = null;
        CryptTools crypto = new CryptTools();
        int index = 0;
        while (index < argv.length) {
            String original = argv[index];
            String encrypted = crypto.encrypt(original, key);
            key = crypto.getKey();
            String decrypted = crypto.decrypt(encrypted, key);
            ++index;
        }
        System.exit(0);
    }
}

