#!/usr/bin/perl
##########################################################################
#
#  DForum 1.01 (11/02/1999)
#  http://www.dansteinman.com/dforum
#  
#  Copyright (C) 1998 Dan Steinman
#  
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  any later version.
#  
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License (license.txt) for more details.
#  
##########################################################################
#
# Forum Administration Script
# filename:     forum-admin.pl
# description:  Deletes or edits the messages in the forum
#
##########################################################################

# Set-Up Variables

$root = "$ENV{'DOCUMENT_ROOT'}";
$forumdir = "$root/cgi-bin/dforum/forumdata";

# username and password are needed to enter the admin area, they're just hard-coded.
$username = "username";  # change this to something else
$password = "password";  # change this to something else


##########################################################################
# parse form values
read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@pairs = split(/&/, $buffer);
foreach $pair (@pairs) {
	local($name, $value) = split(/=/, $pair);
	$value =~ tr/+/ /;
	$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
	$value =~ s/<!--(.|\n)*-->//g;
	$in{$name} = $value;
}

##########################################################################
# miscellaneous values
$command = $in{'command'};
@months = ("January","February","March","April","May","June","July","August","September","October","November","December");

##########################################################################
# determine what sub-routine to run based on the $command form value
if ($command eq '') {&login;}
elsif ($command eq 'displayList') {&displayList;}
elsif ($command eq 'displayThreads') {&displayThreads;}
elsif ($command eq 'deleteThreads') {&deleteThreads;}
elsif ($command eq 'displayEditThread') {&displayEditThread;}
elsif ($command eq 'editThread') {&editThread;}

##########################################################################
# prints the login page
sub login {
	&printHeader("Forum - [Admin Login]");
	print <<"EOF";
	<FORM ACTION="forum-admin.pl" METHOD="POST">
	<INPUT TYPE="Hidden" NAME="command" VALUE="displayList">
	<TABLE BORDER=0 CELLSPACING=1 CELLPADDING=1>
	<TR><TD BGCOLOR="#99AFD9" CLASS="headers">Username:</TD><TD BGCOLOR="#D1D7E0"><INPUT TYPE="Text" NAME="username" SIZE="20"></TD></TR>
	<TR><TD BGCOLOR="#99AFD9" CLASS="headers">Password:</TD><TD BGCOLOR="#D1D7E0"><INPUT TYPE="Password" NAME="password" SIZE="20"></TD></TR>
	<TR><TD BGCOLOR="#D1D7E0" CLASS="headers"><INPUT TYPE="Submit" VALUE="Login"></TD></TR>
	</TABLE>
	</FORM>
EOF
	&printFooter;
}

##########################################################################
# checks username and password, called from every sub-routine
sub checkAccess {
	if ($in{'username'} ne $username || $in{'password'} ne $password) {
		print "Content-type: text/html\n\n";
		print "Access Denied";
		exit(0);
	}
}

##########################################################################
# prints a list of months that have been archived
sub displayList {
	&checkAccess;
	&printHeader("Forum - [Choose Month To Edit]");
	print "<FORM ACTION=\"forum-admin.pl\" METHOD=\"POST\">\n";
	open(MONTHS,"$forumdir/months.txt");
	@headerfiles = <MONTHS>;
	close(MONTHS);
	print <<"EOF";
	<TABLE BORDER=0 CELLSPACING=1 CELLPADDING=1>
	<TR BGCOLOR="#99AFD9"><TD CLASS="headers">Month</TD><TD CLASS="headers">Year</TD></TR>
EOF
	foreach $headerfile (@headerfiles) {
		if ($headerfile ne '') {
			$year = substr ($headerfile,0,4);
			$month = substr ($headerfile,4,5);
			$month = sprintf("%5.0f", $month);
			$monthname = $months[$month-1];
			$headerfile = substr ($headerfile,0,6);
			print "<TR BGCOLOR=\"#D1D7E0\"><TD><INPUT TYPE=\"Radio\" NAME=\"headerfile\" VALUE=\"$headerfile\">$monthname&nbsp;&nbsp;</TD><TD>$year</TD></TR>\n";
		}
	}
	print <<"EOF";
	<INPUT TYPE="Hidden" NAME="username" VALUE="$in{username}">
	<INPUT TYPE="Hidden" NAME="password" VALUE="$in{password}">
	<INPUT TYPE="Hidden" NAME="command" VALUE="displayThreads">
	<TR BGCOLOR="#D1D7E0"><TD><INPUT TYPE="Submit" VALUE="Edit Month"></TD></TR>
	</TABLE>
	</FORM>
EOF
	&printFooter;
}

##########################################################################
# print the headers for a particular month
sub displayThreads {
	&checkAccess;
	$headerfile = $in{'headerfile'};

	$year = substr ($headerfile,0,4);
	$month = substr ($headerfile,4,5);
	$month = sprintf("%5.0f", $month);
	$monthname = $months[$month-1];
	
	open(DATA,"$forumdir/$headerfile.txt");
	@headerlines = <DATA>;
	close(DATA);
	$length = @headerlines;

	&printHeader("Forum - Edit/Delete Threads");
	print <<"EOF";
	<SCRIPT LANGUAGE="JavaScript">
	<!--
	
	function submitForm(which) {
		df = document.forum
		if (which == 'delete') {
			var str = ""
			for (var i=0; i<$length; i++) {
				if (eval('df.delete'+i+'.checked == true')) {
					str += eval('df.delete'+i+'.value')+","
				}
			}
			if (str!="") {
				df.todelete.value = str.substring(0,str.length-1)
				df.command.value = "deleteThreads"
				df.submit()
			}
			else alert('Error: no threads to delete are selected')
		}
		else if (which == 'edit') {
			var editselected = false
			for (var i=0; i<df.toedit.length; i++) {
				if (df.toedit[i].checked == true) {
					editselected = true
					break
				}
			}
			if (editselected == false) alert('Error: no thread to edit is selected')
			else {
				df.command.value = "displayEditThread"
				df.submit()
			}
		}
	}
	
	//-->
	</SCRIPT>
	<B>$monthname $year</B>
	<TABLE BORDER=0 CELLSPACING=1 CELLPADDING=1>
	<TR BGCOLOR="#99AFD9"><TD CLASS="headers">&nbsp;Delete</TD><TD CLASS="headers">&nbsp;Edit</TD><TD CLASS="headers">Num</TD><TD CLASS="headers">&nbsp;Subject</TD><TD CLASS="headers">&nbsp;Author</TD><TD CLASS="headers">Responses</TD><TD CLASS="headers">Date</TD></TR>
	<FORM NAME="forum" ACTION="forum-admin.pl" METHOD="POST">
EOF
	for ($i=0;$i<@headerlines;$i++) {
		if ($headerlines[$i] ne '') {
			@info = split (/_/, $headerlines[$i]);
			$num = $info[0];
			$subject = $info[1];
			$name = $info[2];
			$date = $info[3];
			$responses = $info[4];
			print <<"EOF";
			<TR BGCOLOR="#D1D7E0"><TD ALIGN="CENTER"><INPUT TYPE="Checkbox" NAME="delete$i" VALUE="$num"></TD>
			<TD ALIGN="CENTER"><INPUT TYPE="Radio" NAME="toedit" VALUE="$num"></TD>
			<TD ALIGN="CENTER">$num</TD><TD>&nbsp;$subject&nbsp;</TD><TD>&nbsp;$name&nbsp;</TD><TD ALIGN="CENTER">$responses</TD><TD>$date</TD></TR>
EOF
		}
	}
	print <<"EOF";
	<TR BGCOLOR="#D1D7E0">
	<TD><INPUT TYPE="BUTTON" VALUE="Delete" onClick="submitForm('delete')"></TD>
	<TD><INPUT TYPE="BUTTON" VALUE="Edit" onClick="submitForm('edit')"></TD>
	</TR>
	</TABLE>
	<INPUT TYPE="HIDDEN" NAME="todelete">
	<INPUT TYPE="HIDDEN" NAME="headerfile" VALUE="$headerfile">
	<INPUT TYPE="HIDDEN" NAME="username" VALUE="$in{username}">
	<INPUT TYPE="HIDDEN" NAME="password" VALUE="$in{password}">
	<INPUT TYPE="HIDDEN" NAME="command" VALUE="">
	</FORM>
EOF
	&printFooter;
}

##########################################################################
# prints the edit thread page, where you edit the source file to a message
sub displayEditThread {
	&checkAccess;
	$headerfile = $in{'headerfile'};
	$toedit = $in{'toedit'};
	$toedit =~ s/[\x00-\x20<>\|;\(\)\$^\+!\^\[\]\?\"\'\`]//g;
	&printHeader("Forum - Edit Thread");
	print <<"EOF";
	<B>Thread Number $toedit</B>
	<FORM NAME="forum" ACTION="forum-admin.pl" METHOD="POST">
	<TEXTAREA NAME="body" ROWS=20 COLS=65>
EOF
	open(DATA,"$forumdir/messages/$toedit.txt");
	@msglines = <DATA>;
	close(DATA);
	foreach $msgline (@msglines) {
		print $msgline;
	}
	print "</TEXTAREA>\n";
	print <<"EOF";
	<BR>
	<INPUT TYPE="HIDDEN" NAME="toedit" VALUE="$toedit">
	<INPUT TYPE="HIDDEN" NAME="headerfile" VALUE="$headerfile">
	<INPUT TYPE="HIDDEN" NAME="username" VALUE="$in{username}">
	<INPUT TYPE="HIDDEN" NAME="password" VALUE="$in{password}">
	<INPUT TYPE="HIDDEN" NAME="command" VALUE="editThread">
	<INPUT TYPE="Submit" VALUE="Save Message">
	</FORM>
EOF
	&printFooter;
}

##########################################################################
# saves the message that was being edited
sub editThread {
	&checkAccess;
	&printHeader("Forum - Thread Edited Successfully");
	$headerfile = $in{'headerfile'};
	$toedit = $in{'toedit'};
	$body = $in{'body'};
	@msglines = split(/\n/,$body);

	open(DATA,">$forumdir/messages/$toedit.txt");
	foreach $msgline (@msglines) {
		if ($msgline !~ /<\/msg>/) {chop($msgline);}
		print DATA "$msgline\n";
	}
	close(DATA);

	for ($i=0; $i<@msglines; $i++) {
		if ($msglines[$i] =~ /<subject>(.*)<\/subject>/) {
			$subject = $1;
		}
		if ($msglines[$i] =~ /<name>(.*)<\/name>/) {
			$name = $1;
		}
		if ($msglines[$i] =~ /<date>(.*)<\/date>/) {
			$date = $1;
			last;
		}
	}
	$replies = -1;
	for ($i=0; $i<@msglines; $i++) {
		if ($msglines[$i] =~ /<msg>/) {
			$replies += 1;
		}
	}
	open(HEADER,"$forumdir/$headerfile.txt");
	@headers = <HEADER>;
	close(HEADER);

	open(HEADER,">$forumdir/$headerfile.txt");
	foreach $headerline (@headers) {
		if ($headerline ne '') {
			@parts = split (/_/, $headerline);
			if ($parts[0] == $toedit) {
				print HEADER "$toedit\_$subject\_$name\_$date\_$replies\n";
			}
			else {
				print HEADER $headerline;
			}
		}
	}
	close(HEADER);


	print <<"EOF";
	<P>Message number $toedit has been saved
	<TABLE BORDER="0" CELLSPACING="1" CELLPADDING="1"><TR>
	<FORM NAME="forum" ACTION="forum-admin.pl" METHOD="POST">
	<INPUT TYPE="HIDDEN" NAME="username" VALUE="$in{username}">
	<INPUT TYPE="HIDDEN" NAME="password" VALUE="$in{password}">
	<INPUT TYPE="HIDDEN" NAME="command" VALUE="displayList">
	<TD><INPUT TYPE="Submit" VALUE="Choose Different Month"></TD>
	</FORM>
	<FORM NAME="forum" ACTION="forum-admin.pl" METHOD="POST">
	<INPUT TYPE="HIDDEN" NAME="username" VALUE="$in{username}">
	<INPUT TYPE="HIDDEN" NAME="password" VALUE="$in{password}">
	<INPUT TYPE="HIDDEN" NAME="headerfile" VALUE="$headerfile">
	<INPUT TYPE="HIDDEN" NAME="command" VALUE="displayThreads">
	<TD><INPUT TYPE="Submit" VALUE="Edit This Month Again"></TD>
	</FORM>
	</TR></TABLE>
	<FORM>
	<INPUT TYPE="BUTTON" VALUE="View Forum" onClick="document.location.href='forum.pl'">
	</FORM>
EOF
	&printFooter;
}

##########################################################################
# deletes the messages that were selected in the &displayThreads page
sub deleteThreads {
	&checkAccess;
	&printHeader("Forum - Threads Removed Successfully");
	$headerfile = $in{'headerfile'};
	$todelete = $in{'todelete'};
	@threads = split (/,/, $todelete);
	
	open(HEADER,"$forumdir/$headerfile.txt");
	@headerlines = <HEADER>;
	close(HEADER);

	open(HEADER,">$forumdir/$headerfile.txt");
	for ($i=0; $i<@headerlines; $i++) {
		$remove = "false";
		for ($j=0; $j<@threads; $j++) {
			if ($headerlines[$i] =~ /$threads[$j]_/) {
				$remove = "true";
			}
		}
		if ($remove eq "false") {print HEADER "$headerlines[$i]";}
	}
	close(HEADER);
	
	foreach $thread (@threads) {
		unlink ("$forumdir/messages/$thread.txt");
	}

	print "The following threads were removed:<BR>";	
	foreach $thread (@threads) {
		print "$thread,";
	}
	print <<"EOF";
	<P><TABLE BORDER="0" CELLSPACING="1" CELLPADDING="1"><TR>
	<FORM NAME="forum" ACTION="forum-admin.pl" METHOD="POST">
	<INPUT TYPE="HIDDEN" NAME="username" VALUE="$in{username}">
	<INPUT TYPE="HIDDEN" NAME="password" VALUE="$in{password}">
	<INPUT TYPE="HIDDEN" NAME="command" VALUE="displayList">
	<TD><INPUT TYPE="Submit" VALUE="Choose Different Month"></TD>
	</FORM>
	<FORM NAME="forum" ACTION="forum-admin.pl" METHOD="POST">
	<INPUT TYPE="HIDDEN" NAME="username" VALUE="$in{username}">
	<INPUT TYPE="HIDDEN" NAME="password" VALUE="$in{password}">
	<INPUT TYPE="HIDDEN" NAME="headerfile" VALUE="$headerfile">
	<INPUT TYPE="HIDDEN" NAME="command" VALUE="displayThreads">
	<TD><INPUT TYPE="Submit" VALUE="Edit This Month Again"></TD>
	</FORM>
	</TR></TABLE>
	<FORM>
	<INPUT TYPE="BUTTON" VALUE="View Forum" onClick="document.location.href='forum.pl'">
	</FORM>
EOF
	&printFooter;
}

##########################################################################
# common HTML header for all pages (same as in forum.pl)
sub printHeader {
	my($title) = @_;
	print "Content-type: text/html\n\n";
	print <<"EOF";
	<HTML>
	<HEAD>
	<TITLE>$title</TITLE>
	<STYLE TYPE="text/css">
	<!--
	.headers {font-weight:bold;}
	.items {text-decoration:none; color:#000000;}
	-->
	</STYLE>
	</HEAD>
	<BODY BGCOLOR="#FFFFFF">
	<H3>$title</H3>
	<P>
EOF
}

##########################################################################
# common HTML footer for all pages
sub printFooter {
	print <<"EOF";
	<!-- Please keep the following link so that visitors can also obtain the script if they wish -->
	<P><A CLASS="items" HREF="http://www.dansteinman.com/dforum"><FONT SIZE="1" FACE="Arial,Helvetica">DForum 1.0</FONT></A>
	<BR><BR>
	</BODY>
	</HTML>
EOF
}
