#!/usr/bin/perl
##############################################################################
# Cliff's Message Board Script Version 1.51                                  # 
# Copyright 1998 Shaven Ferret Productions                                   #
# Created 6/4/98                      Last Modified 1/6/2000                 #
# Available at http://www.shavenferret.com/scripts                           #
##############################################################################
# COPYRIGHT NOTICE                                                           #
# Copyright 1998 Shaven Ferret Productions All Rights Reserved.              #
#                                                                            #
# This script can be used\modified free of charge as long as you don't       #
# change this header, the parts that generate the return link, or the parts  #
# that mention me in the e-mail.  If you really need to change these parts,  #
# go to http://www.shaveneferret.com/scripts/register.shtml .  By using this #
# script you agree to indemnify me from any liability that might arise from  #
# its use.  In simple English, if this script somehow makes your computer    #
# run amuck and kill the pope, it's not my fault.                            #
#                                                                            #
# Redistributing\selling the code for this program without prior written     #
# consent is expressly forbidden.                                            #
##############################################################################
# Paths
##############################################################################

# Set this to the path of the directory where the forums will be kept.  Do not
# include a trailing slash.
$path = "/server/path/to/message";

# Set this to the path of the directory where all the messages will be kept.
# Do not include a trailing slash.  Do not make this the same directory
# as the forums directory.
$post = "/server/path/to/message/posts";

# Set this to the path of the admin.html file.  You should put this where
# no one will find it.
$adminpath = "/server/path/to/admin.html";

##############################################################################
# URLs
##############################################################################

# Set this to the URL of the message board directory.  Do not include a
# trailing slash
$mainurl = "http://www.yourdomain.com/message";

# Set this to the URL of the directory where all the messages will be kept.
# Do not include a trailing slash.
$posturl = "http://www.yourdomain.com/message/posts";

# Set this to the file name of the main message page
$mainpage = "index.html";

# Set this to the URL of the message.cgi file once uploaded
$script_url = "/cgi-bin/message.cgi";

##############################################################################
# Mail Stuff 
##############################################################################

# Enter the location of your mail program.
$mailprogram = "/usr/lib/sendmail";

# Enter your e-mail address.  Be sure to put a \ in front of the @.
# (user@domain.com becomes user\@domain.com)
$youremail = "you\@yourdomain.com";

# If you don't want to be notified every time someone posts a message, put a #
# in front of the next line.
$notifyme = -1;

##############################################################################
# Other Stuff 
##############################################################################

# Set the next variable to whatever you want your password to be.  You will
# need the password to create\delete forums and message.
$password = "shavenferret.com";

# Enter the name of your message board
$title = "My Message Board";

# If you'd like to lock out HTML, leave this next variable as 1.  If you'd
# like to allow HTML, change it to 0.  If you leave it as 1, anything in
# a message between < and > will be removed.
$nohtml = 1;

##############################################################################
# Congratulations!  You've finished defining the variables.  If you want to, #
# you can continue screwing with the script, but it isn't necessary.         #
##############################################################################

# Put the posted data into variables

read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@pairs = split(/&/, $buffer);
foreach $pair (@pairs) {
        ($name, $value) = split(/=/, $pair);
        $value =~ tr/+/ /;
        $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
        if ($nohtml == 1) {
                $value =~ s/<([^>]|\n)*>//g;
                $value =~ s/<//g;
                $value =~ s/>//g;
        }
        $value =~ s/"/'/g;
        $FORM{$name} = $value;
}

# Define $date and $time

        @months = ('January','February','March','April','May','June','July','August','September','October','November','December');
        @days = ('Sunday','Monday','Tuesday','Wednesday','Thursday','Friday','Saturday');
        ($sec,$min,$hour,$mday,$mon,$year,$wday) = (localtime(time))[0,1,2,3,4,5,6];
        if ($sec < 10) { $sec = "0$sec"; }
        if ($min < 10) { $min = "0$min"; }
        if ($hour < 10) { $hour = "0$hour"; }
        if ($mday < 10) { $mday = "0$mday"; }
        $year += 1900;
        $date = "$days[$wday], $months[$mon] $mday, $year";
        $time = "$hour:$min:$sec";


# This script runs every part of the message board.  To find out what it is
# doing, it looks at $FORM{'action'}, which is a hidden input thing in all
# the files it creates.  The next line examines $FORM{'action'} to find out
# what to do.

print "Content-type: text/html\n\n";
if ($FORM{'action'} eq "new_forum") { &new_forum; }
if ($FORM{'action'} eq "add_music") { &new_songicon("song"); }
if ($FORM{'action'} eq "add_icon") { &new_songicon("icon"); }
if ($FORM{'action'} eq "new_message") { &new_message; }
if ($FORM{'action'} eq "preview_message") { &preview_message; }
if ($FORM{'action'} eq "del_songicon") { &delmi; }
if ($FORM{'action'} eq "remove_message") { &delmessage; }

# If nothing has been done, then the action thing has been removed,
# implying that the file has been corrupted.  The next few lines print a 
# message that lets the user know this.

print "<html><head><title>This could be a problem</title></head><body>\n";
print "<h1>D'oh!</h1>It would appear that the variable that lets this\n";
print "script know what to do has mysteriously disappeared or been altered.  This could\n";
print "mean that the page you were just at has become corrupted.</body></html>";

sub new_forum {

        &checkpassword;

        # Make sure you've picked a name for the forum

        unless ($FORM{'forum_name'}) {
                print "<html><title>You forgot the forum name</title></head><body>\n";
                print "<h1>You forgot the forum name</h1>Please enter the name of\n";
                print "the forum you wish to create...\n";
                &missing('forum_name');
        }

        # Get the name of the forum and update the data

        open (DATA, "$path/nums.txt");
        $data = <DATA>;
        ($forum_num,$message_num) = split(/\|/,$data);
        close(DATA);
        $forum_num++;
        open (DATA, ">$path/nums.txt");
        print DATA "$forum_num|$message_num";
        close(DATA);

        # Create the html file that will be used as the forum.

        open (FILE, ">$path/$forum_num.html");
        print FILE "<html><head><title>$title :: $FORM{'forum_name'} Forum</title>\n";
        print FILE "</head><body><h1><a href=\"$mainurl/$mainpage\">$title</a> :: ";
        print FILE "$FORM{'forum_name'} Forum</h1>\n";
        &sig;
        print FILE "<b><i>$FORM{'desc'}<br>\n";
        if ($FORM{'require'} == 0) { print FILE "You can post here anonymously\n"; }
        if ($FORM{'require'} == 1) { print FILE "You need to enter your name to post here\n"; }
        if ($FORM{'require'} == 2) { print FILE "You need to enter your e-mail address to post here\n"; }
        if ($FORM{'require'} == 3) { print FILE "You need to enter your name and e-mail address to post here\n"; }
        print FILE "</i></b><p>\n";
        print FILE "Messages: (click <a href=\"#post\">here</a> to post a message.)\n";
        print FILE "<ul>\n<!-- begin -->\n</ul>\n<center><a name=\"post\"><hr width=";
        print FILE "\"70%\"></a>\n";
        &posthtml;
        print FILE "<input type=\"hidden\" name=\"history\" value=\"\">\n";
        print FILE "<input type=\"hidden\" name=\"forum\" value=\"$forum_num.html\">\n";
        print FILE "<input type=\"hidden\" name=\"required\" value=\"$FORM{'require'}\">\n";
        print FILE "<input type=\"hidden\" name=\"reply\" value=\"no\">\n";
        &sig;
        print FILE "</form></body></html>\n";

        # Add the forum to the administrative file.

        open (FILE, "$adminpath");
        @lines = <FILE>;
        close(FILE);
        open (FILE, ">$adminpath");
        foreach $line(@lines) {
                if (substr($line,0,14) eq "<!-- begin -->") { 
                        print FILE "<!-- begin -->\n";
                        print FILE "<li><input type=\"checkbox\" value=\"delete\"";
                        print FILE " name=\"f$forum_num\"><a href=\"$mainurl/";
                        print FILE "$forum_num.html\">$FORM{'forum_name'}</a> -- Forum";
                        print FILE "<ul>\n</ul><!-- $mainurl/$forum_num.html -->\n";
                }
                elsif (substr($line,0,6) eq "<form>") { print FILE "<form method=\"POST\" action=\"$script_url\">\n"; }
                else { print FILE "$line"; }
        }
        close(FILE);

        # Add the forum to the main page

        open (FILE, "$path/$mainpage");
        @lines = <FILE>;
        close(FILE);
        open (FILE, ">$path/$mainpage");
        foreach $line(@lines) {
                if (substr($line,0,14) eq "<!-- begin -->") {
                        print FILE "<!-- begin -->\n<tr><td align=\"right\"><center><a href=\"";
                        print FILE "$mainurl/$forum_num.html\">$FORM{'forum_name'}</a>";
                        print FILE "</td><td>\n<!-- $forum_num.html -->NA</td></tr>\n";
                }
                elsif (substr($line,0,7) eq "<title>") { print FILE "<title>$title</title>\n"; }
                elsif (substr($line,0,14) eq "<!-- title -->") { print FILE "$title\n"; }                
                else { print FILE "$line"; }
        }
        close(FILE);

        # If everything went ok, display the following and exit.

        print "<html><head><title>Forum Added</title></head>\n";
        print "<h1>Forum Added</h1>The $FORM{'forum_name'} forum has been\n";
        print "added.  Your description of it reads: $FORM{'desc'}.  It is\n";
        print "located at <a href=\"$mainurl/$forum_num.html\">";
        print "$mainurl/$forum_num.html</a></body></html>\n";
        exit;
}

sub checkpassword {
        unless ($FORM{'password'} eq $password) {
                print "<html><head><title>Bad password</title></head>\n";
                print "<body><h1>Bad Password</h1><br>\n";
                print "The password you entered, $FORM{'password'}, is incorrect.\n";
                print "The following information has been mailed to the owner of\n";
                print "the message board...<ul>\n";
                print "<li>Date/Time: $date $time\n";
                print "<li>Domain: $ENV{'REMOTE_HOST'}\n";
                print "<li>IP Address: $ENV{'REMOTE_ADDR'}\n";
                print "<li>Password: $FORM{'password'}\n";
                print "</ul></body></html>\n";
                open (MAIL,"|$mailprogram -t");
                print MAIL "To: $youremail\n";
                print MAIL "From: bad\@password.xxx\n";
                print MAIL "Subject: bad password\n";
                print MAIL "Just a quick note to let you know that someone\n";
                print MAIL "has entered the wrong password for your message\n";
                print MAIL "board.  Here's the\n";
                print MAIL "information...\n\n";
                print MAIL "  Date/Time:  $date $time\n";
                print MAIL "  Domain:     $ENV{'REMOTE_HOST'}\n";
                print MAIL "  IP Address: $ENV{'REMOTE_ADDR'}\n";
                print MAIL "  Password:   $FORM{'password'}\n";
                close(MAIL);
                exit;        
        }
}

sub sig {

# Please do NOT change this sub or any place in this script where this sub
# is called
        print FILE "<center><hr width=\"70%\">Message Board Script by <a hr";
        print FILE "ef=\"http://www.shavenferret.com/cliff/\" target=\"new\">Cli";
        print FILE "ff(tm)</a>, <a href=\"http://www.shavenferret.com\" ta";
        print FILE "rget=\"new\">Shaven Ferret Productions</a>, and availab";
        print FILE "le at <a href=\"http://www.shavenferret.com/scripts\" t";
        print FILE "arget=\"new\">http://www.shavenferret.com/scripts</a><h";
        print FILE "r width=\"70%\"></center>\n";       
}

sub posthtml {
        print FILE "<form method=\"post\" action=\"$script_url\">\n";
        print FILE "<center><table width=\"400\" border=\"5\"><tr><td><h1>Post\n";
        print FILE "a Message</h1><table width=\"100%\" col=\"2\"><tr><td align=\"right\">\n";
        print FILE "Your name:</td><td><input type=\"text\" name=\"name\"></td></tr>\n";
        print FILE "<tr><td align=\"right\">Your e-mail address:</td><td><input type=\"";
        print FILE "text\" name=\"email\"></td></tr><tr><td align=\"right\">Subject</td>\n";
        print FILE "<td><input type=\"text\" name=\"subject\"";
        if ($FORM{'subject'}) {
                print FILE " value=\"";
                unless (substr($FORM{'subject'},0,3) eq "Re:") { print FILE "Re: "; }
                print FILE "$FORM{'subject'}\"";
        }
        print FILE "></td></tr><tr><td align=\"right\" valign=\"top\">\n";
        print FILE "Message:</td><td><textarea name=\"body\" cols=\"30\" rows=\"7\"";
        print FILE " wrap=\"true\"></textarea></td></tr>\n";
        &musicicon("song");
        &musicicon("icon");
        if ($FORM{'email'}) {
                print FILE "<tr><td valign=\"top\" align=\"right\">E-mail response to\n";
                print FILE "original poster?</td><td>\n";
                print FILE "<input type=\"radio\" name=\"email_reply\" value=\"yes\" CHECKED>Yes<br>\n";
                print FILE "<input type=\"radio\" name=\"email_reply\" value=\"no\">No</td></tr>\n";
        }        
        print FILE "<tr><td align=\"right\"><input type=\"submit\" value=\" Post \"></td>\n";
        print FILE "<td><input type=\"reset\"></td></tr></table></td></tr></table></table>\n";
        print FILE "<input type=\"hidden\" name=\"action\" value=\"preview_message\">\n";
        unless ($FORM{'email'}) { print FILE "<input type=\"hidden\" name=\"email_reply\" value=\"no\">\n"; }
}

sub new_songicon {
        $which = shift(@_);
        &checkpassword;

        # make sure everything's filled out

        if ($FORM{'url'} eq "http://" || $FORM{'url'} eq "" || substr($FORM{'url'},0,7) ne "http://") {
                print "<html><head><title>Please enter the full URL of the $which</title>\n";
                print "</head><body><h1>Please enter the full URL of the $which</h1>";
                &missing("url");
        }
        unless ($FORM{'title'}) {
                print "<html><head><title>Please enter the title of the $which</title>\n";
                print "</head><body><h1>Please enter the title of the $which</h1>";
                &missing("title");
        }

        # Add the song or icon to the data

        &update($which);

        # add it to the admin file

        open (FILE, "$adminpath");
        @lines = <FILE>;
        close(FILE);
        open (FILE, ">$adminpath");
        foreach $line(@lines) {
                if (substr($line,0,13) eq "<!-- $which -->") {
                        print FILE "<!-- $which -->\n";
                        print FILE "<li><input type=\"radio\" name=\"delete\" value=\"$FORM{'url'}\">$FORM{'title'}";
                        if ($which eq "song") { print FILE "(<a href=\"$FORM{'url'}\">song</a>)\n"; }
                        if ($which eq "icon") { print FILE "(<img src=\"$FORM{'url'}\" height=\"15\" width=\"15\">)\n"; }
                }
                else { print FILE "$line"; }
        }

        print "<html><head><title>$which added</title></head><body>\n";
        print "The $which has been added.  Please click back\n";
        print "</body></html>\n";
        exit;
}

sub missing {
        $dontprint = shift(@_);
        print "<form method=\"POST\" action=\"$script_url\">\n";
        foreach $pair (@pairs) {
                ($name, $value) = split(/=/, $pair);
                $value =~ tr/+/ /;
                $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
                if ($nohtml == 1) {
                        $value =~ s/<([^>]|\n)*>//g;
                        $value =~ s/<//g;
                        $value =~ s/>//g;
                }
                unless ($name eq $dontprint) {
                        print "<input type=\"hidden\" name=\"$name\" value=\"";
                        print "$value\">\n";
                }
        }
        print "<input type=\"text\" name=\"$dontprint\" value=";
        print "\"$FORM{$dontprint}\">\n";
        print "<input type=\"submit\" value=\" Try again \"></form></body></html>\n";
        exit;
}

sub musicicon { 
        $which = shift(@_);
        print FILE "<!-- $which -->\n";
        open (DATA, "$path/$which.txt");
        @bgmusic = <DATA>;
        close(DATA);
        if ($#bgmusic >= 0) {
                if ($which eq "song") {
                        print FILE "<tr><td align=\"right\">Background Music:</td><td>\n\n";
                        print FILE "<select name=\"$which\">\n";
                        print FILE "<option value=\"\" SELECTED>No Music\n"; 
                }
                else {
                        print FILE "<tr><td align=\"right\">How would you describe\n";
                        print FILE "the &quot;mood&quot; of this message?</td><td>\n";
                        print FILE "<select name=\"$which\">\n";
                }
                foreach $music(@bgmusic) {
                        print FILE "$music\n"; 
                }
                print FILE "</select>\n";        
                print FILE "\n</td></tr>\n";
        }
        print FILE "<!-- /$which -->\n";
}


sub preview_message {

        # Make sure required fields are filled out
        
        if ($FORM{'required'} == 1 || $FORM{'required'} == 3) {
                unless($FORM{'name'}) {
                        print "<html><head><title>You must give your name to post here\n";
                        print "</title></head><body><h1>Please enter your name</h1>\n";
                        &missing("name");
                }
        }
        if ($FORM{'required'} > 1 && $FORM{'email'} eq "") { 
                print "<html><head><title>E-mail address required</title>\n";
                print "</head><body><h1>I'm sorry, but you must enter an\n";
                print "e-mail address to post here</h1>\n";
                &missing("email");                
        }
        if ($FORM{'email'} && ($FORM{'email'}) !~ /.+@.+\.\w\w+/) {
                print "<html><head><title>Bad e-mail address</title>\n";
                print "</head><body><h1>Bad E-mail</h1>I'm sorry, but the e-mail\n";
                print "address you've entered, $FORM{'email'}, is invalid.  Please\n";
                print "try again.\n";
                &missing("email");
        }
        unless ($FORM{'body'}) {
                print "<html><head><title>Please write something</title></head>\n";
                print "<h1>You didn't write anything!</h1>Please click back and\n";
                print "try again.</body></html>\n";
                exit;
        }
        if ($FORM{'subject'} eq "") { $FORM{'subject'} = "[ No Subject ]"; }
        if ($FORM{'name'} eq "") { $FORM{'name'} = "anonymous"; }

        # show a preview of the message

        $message_preview = &message_html;
        print "<html><head><title>Preview your message...</title></head><body>\n";
        print "<h1>Preview your message:</h1>\n";
        print "This is what your message will look like when posted.  If you want\n";
        print "to change anything, please click back now.  To post it, click the button\n";
        print "below the message.<p>\n";
        print "$message_preview\n";
        print "<form method=\"POST\" action=\"$script_url\">\n";
        foreach $pair (@pairs) {
                ($name, $value) = split(/=/, $pair);
                $value =~ tr/+/ /;
                $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
                if ($nohtml == 1) {
                        $value =~ s/<([^>]|\n)*>//g;
                        $value =~ s/<//g;
                        $value =~ s/>//g;
                }
                unless ($name eq "action") {
                        print "<input type=\"hidden\" name=\"$name\" ";
                        print "value=\"$value\">\n";
                }
                $FORM{$name} = $value;
        }
        print "<input type=\"hidden\" name=\"action\" value=\"new_message\">\n";
        print "<center><input type=\"submit\" value=\"Looks fine to me, go ahead and post it!\">\n";
        print "</form></body></html>\n";
        exit;
}


sub new_message {

        # get the number for the message and update the data file

        open (DATA, "$path/nums.txt");
        $data = <DATA>;
        ($forum_num,$message_num) = split(/\|/,$data);
        close(DATA);
        $message_num++;
        open (DATA, ">$path/nums.txt");
        print DATA "$forum_num|$message_num";
        close(DATA);

        # Create the message

        if ($FORM{'subject'} eq "") { $FORM{'subject'} = "[ No Subject ]"; }
        if ($FORM{'name'} eq "") { $FORM{'name'} = "anonymous"; }
        open (FILE, ">$post/$message_num.html");
        print FILE "<html><head><title>$FORM{'subject'}</title></head><body>\n";
        &sig;
        $message = &message_html;
        print FILE "$message\n";
        print FILE "<center><hr width=\"70%\"></center>\n";
        print FILE "<font size=\"+2\">Replies:</font>\n<ul><!-- <a href=\"$posturl/$message_num.html\"> -->\n";
        print FILE "</ul>\n";
        print FILE "<center><hr width=\"70%\"></center>\n";
        print FILE "<font size=\"+2\">Post a Reply:</font>\n";
        &posthtml;
        if ($FORM{'reply'} eq "yes") { $FORM{'history'} .= "x"; }
        $FORM{'history'} .= $message_num;
        print FILE "<input type=\"hidden\" name=\"history\" value=\"$FORM{'history'}\">\n";
        print FILE "<input type=\"hidden\" name=\"forum\" value=\"$FORM{'forum'}\">\n";
        print FILE "<input type=\"hidden\" name=\"required\" value=\"$FORM{'require'}\">\n";
        print FILE "<input type=\"hidden\" name=\"reply\" value=\"yes\">\n";
        print FILE "<input type=\"hidden\" name=\"omessage\" value=\"$FORM{'body'}\">\n";
        print FILE "<input type=\"hidden\" name=\"oname\" value=\"$FORM{'name'}\">\n";
        print FILE "<input type=\"hidden\" name=\"oemail\" value=\"$FORM{'email'}\">\n";
        &sig;
        print FILE "</form></body></html>\n";
        close(FILE);

        # put a link on any message this is a reply to

        if ($FORM{'icon'}) { $icon = "<img src=\"$FORM{'icon'}\" height=\"15\" width=\"15\">"; }
        if ($FORM{'reply'} eq "yes") {
                @replies = split(/x/, $FORM{'history'});
                $search = "$posturl/$replies[$#replies - 1].html";
                foreach $reply(@replies) {
                        open (FILE, "$post/$reply.html");
                        @lines = <FILE>;
                        close(FILE);
                        open (FILE, ">$post/$reply.html");
                        foreach $line(@lines) {
                                if ($line =~ /<!-- <a href="$search"> -->/) {
                                        print FILE "<li>$icon<a href=\"$posturl/$message_num.html\">$FORM{'subject'}</a>";
                                        print FILE "$icon<ul>\n";
                                        print FILE "</ul><!-- <a href=\"$posturl/$message_num.html\"> -->\n";
                                        print FILE "$line";
                                }
                                else { print FILE "$line"; }
                        }
                        close(FILE);
                } 
        }

        # Put a link on the forum page
        
        open (FILE, "$path/$FORM{'forum'}");
        @lines = <FILE>;
        close(FILE);
        open (FILE, ">$path/$FORM{'forum'}");
        foreach $line(@lines) {
                print FILE "$line";
                if (($FORM{'reply'} eq "no" && substr($line,0,14) eq "<!-- begin -->") || ($FORM{'reply'} ne "no" && $line =~ /<li>.*<a href="$posturl\/$replies[$#replies - 1].html">/)) {
                        print FILE "<li>$icon";
                        print FILE "<a href=\"$posturl/$message_num.html\">$FORM{'subject'}</a>";
                        print FILE "$icon<ul>\n";
                        print FILE "</ul><!-- <a href=\"$posturl/$message_num.html\"> -->\n";
                }                
        }
        close(FILE);

        # Update the "last post" part of the main page

        open (FILE, "$path/$mainpage");
        @lines = <FILE>;
        close(FILE);
        open (FILE, ">$path/$mainpage");
        foreach $line(@lines) {
                if ($line =~ /<!-- $FORM{'forum'} -->/) {
                        print FILE "<!-- $FORM{'forum'} -->$date $time </td></tr>\n";
                }
                else { print FILE "$line"; }
        }
        close(FILE);

        # Put the message on the administrative page

        open (FILE, "$adminpath");
        @lines = <FILE>;
        close(FILE);
        open (FILE, ">$adminpath");
        foreach $line(@lines) {
                print FILE "$line";
                if ($FORM{'reply'} eq "yes") { $i = "<a href=\"$posturl/$replies[$#replies - 1].html\">"; }
                else { $i = "<a href=\"$mainurl/$FORM{'forum'}\">"; }
                if ($line =~ /$i/) {
                        print FILE "<li><input type=\"checkbox\" value=\"delete\" name=\"$message_num\">";
                        print FILE "$icon";
                        print FILE "<a href=\"$posturl/$message_num.html\">$FORM{'subject'}</a>";
                        print FILE "$icon<ul>\n";
                        print FILE "</ul><!-- <a href=\"$posturl/$message_num.html\" -->\n";
                }
        }
        close(FILE);

        if ($FORM{'email_reply'} eq "yes") { &mailposter($message_num); }
        print "<html><head><title>Thank you!</title></head><body><h1>Your\n";
        print "message has been posted!</h1>You can find it <a href=\"$posturl";
        print "/$message_num.html\">here</a>.\n";

        if ($notifyme) {
                open(MAIL,"|$mailprogram -t");
                print MAIL "To: $youremail\n";
                print MAIL "From: \"$FORM{'name'}\" <$FORM{'email'}>\n";
                print MAIL "Subject: $FORM{'subject'}\n";
                print MAIL "Hello.  This is to let you know that $FORM{'name'}\n";
                print MAIL "has posted a message.  You can find it at\n";
                print MAIL "$posturl/$message_num.html\nThe message reads:\n\n";
                print MAIL "";
                print MAIL "$FORM{'body'}\n\n";
                close(MAIL);
        }
        exit;
}


sub loopmusicicon {
        $k = shift(@_);
        $which = shift(@_);
        open (FILE, "$k");
        @lines = <FILE>;
        close(FILE);
        open (FILE, ">$k");                
        $nowrite = 0;
        foreach $line(@lines) {
                if (substr($line,0,13) eq "<!-- $which -->") {
                        &musicicon($which);
                        $nowrite = 1;
                }
                elsif (substr($line,0,14) eq "<!-- /$which -->") {
                        $nowrite = 0;
                }
                else { if ($nowrite == 0) { print FILE "$line"; } }                                
        }
}

sub message_html {
        if ($FORM{'icon'}) { $icon = "<img src=\"$FORM{'icon'}\" height=\"15\" width=\"15\">"; }
        $message = "<center><table width=\"500\" bgcolor=\"#000000\" border=\"5\">\n";
        $message .= "<tr><td><font color=\"#00FF00\"><tt><b><center>$icon";
        $message .= "$FORM{'subject'}\n";
        $message .= "$icon</td></tr>\n";
        if ($FORM{'email'}) {
                $poster = "<a href=\"mailto:$FORM{'email'}\"><font color=\"#FF0000\">";
                $poster .= "$FORM{'name'}</font></a>";
        }
        else { $poster = "$FORM{'name'}"; }
        $message .= "<tr><td><font color=\"#00FF00\"><tt><b><center>Posted by $poster on $date at $time</td></tr>"; 
        $message .= "<tr><td><font color=\"#00FF00\"><tt><b>\n";
        if ($FORM{'reply'} eq "yes") {
                if ($FORM{'oemail'}) { 
                        $poster = "<a href=\"mailto:$FORM{'oemail'}\"><font color=\"#FF0000\">";
                        $poster .= "$FORM{'oname'}</font></a>"; }
                else { $poster = "$FORM{'oname'}"; }
                $message .= "on $date at $time, $poster wrote:<p><i>$FORM{'omessage'}</i>\n";                
                $message .= "<center><hr width=\"50%\"></center>\n";
        }
        $message .= "<font color=\"#FFFFFF\">$FORM{'body'}</font></td></tr></table>\n";
        if ($FORM{'song'}) {
                $message .= "<EMBED src=\"$FORM{'song'}\" autostart=true ";
                $message .= "autoloop=true width=144 height=60>\n";
        }
        $message .= "</center>\n";
        return($message);
}


sub delmi {

        # Remove song\icon from data file

        for ($i = 0; $i < 2; $i++) {
                if ($i == 0) { $which = "song"; }
                if ($i == 1) { $which = "icon"; }
                open (FILE, "$path/$which.txt");
                @lines = <FILE>;
                close(FILE);
                open (FILE, ">$path/$which.txt");
                foreach $line(@lines) {
                        if ($line !~ /"$FORM{'delete'}"/) { print FILE "$line"; }
                        else { $i = 3; }
                }
                close(FILE);
        }

        # Remove song\icon from admin file

        open (FILE, "$adminpath");
        @lines = <FILE>;
        close(FILE);
        open (FILE, ">$adminpath");
        foreach $line(@lines) {
                $test = "<input type=\"radio\" name=\"delete\" value=\"$FORM{'delete'}\">";
                if ($line !~ /$test/) {
                        print FILE "$line"; 
                }
        }
        close (FILE);

        # Loop through messages and forums updating songs or icons
        &update($which);

        # Display a message that says everything went ok
        print "<html><head><title>$which deleted</title></head><body>\n";
        print "The $which has been deleted.  &nbsp;Please click back.\n";
        print "</body></html>\n";
        exit;
}

sub update {
        $which = shift(@_);
        if ($FORM{'url'}) {
                open (DATA, ">>$path/$which.txt");
                print DATA "<option value=\"$FORM{'url'}\">$FORM{'title'}\n";
                close(DATA);
        }

        # Loop through the forums, adding the song
        open (DATA, "$path/nums.txt");
        $data = <DATA>;
        ($forum_num,$message_num) = split(/\|/,$data);
        close(DATA);
        for ($i = 1; $i <= $forum_num; $i++) {
                &loopmusicicon ("$path/$i.html","$which");
        }
        for ($i = 1; $i <= $message_num; $i++) {
                &loopmusicicon ("$post/$i.html","$which");
        }
}

sub delmessage {
        &checkpassword;

        # Loop through each message\forum and see if it's deleted

        open (DATA, "$path/nums.txt");
        $data = <DATA>;
        ($forum_num,$message_num) = split(/\|/,$data);
        close(DATA);
        for ($i = 1; $i <= $message_num; $i++) {
                if ($FORM{$i}) { &killmessage("$i"); }                
        }
        for ($i = 1; $i <= $forum_num; $i++) {
                $f = "f$i";                        
                if ($FORM{$f}) { &killforum("$i"); } 
        }

        # Print a message saying everything worked

        print "<html><head><title>Forums/Messages deleted</title></head><body>\n";
        print "The selected forums and messages have been deleted.  Please click\n";
        print "back.</body>\n";
        exit;
}

sub killmessage {
        $killme = shift(@_);

        # Find out which forum the message is in, and what messages have links
        # to it

        open (FILE, "$post/$killme.html");
        @lines = <FILE>;
        close(FILE);
        foreach $line(@lines) {
                if ($line =~ /name="history" value="(.*)"/) { $history = $1; }
                if ($line =~ /name="forum" value="(.*\.html)"/)   { $forum = $1; }                
        }
        @fixme = split(/x/, $history);
        $search = "<a href=\"$posturl/$killme.html\">";

        # Remove links to this message from other messages

        foreach $fix(@fixme) {
                unless ($fix == $killme) {
                        open (FILE, "$post/$fix.html");
                        @lines = <FILE>;
                        close(FILE);
                        open (FILE, ">$post/$fix.html");
                        foreach $line(@lines) {
                                unless ($line =~ /$search/) { print FILE "$line"; }
                        }
                        close(FILE);
                }
        }

        # Remove the message from the forum

        open (FILE,"$path/$forum");
        @lines = <FILE>;
        close(FILE);
        open (FILE,">$path/$forum");
        foreach $line(@lines) {
                unless ($line =~ /$search/) { print FILE "$line"; }
        }
        close(FILE);
        unlink("$post/$killme.html");

        # Remove the message from the admin page

        open (FILE, "$adminpath");
        @lines = <FILE>;
        close(FILE);
        open (FILE, ">$adminpath");
        foreach $line(@lines) {
                unless ($line =~ /$posturl\/$killme.html/) { print FILE "$line"; }
        }
        close(FILE);

}

sub killforum {

        $killme = shift(@_);

        # Delete all messages in this forum

        open (FILE, "$path/$killme.html");
        @lines = <FILE>;
        close(FILE);
        foreach $line(@lines) {
                if ($line =~ /href="$posturl\/(.*)"/) { unlink("$post/$1"); }
        }

        # Delete the forum itself

        unlink("$path/$killme.html");

        # Remove the forum from the main page

        open (FILE, "$path/$mainpage");
        @lines = <FILE>;
        close(FILE);
        open (FILE, ">$path/$mainpage");
        foreach $line(@lines) {
                unless ($line =~ /href="$mainurl\/$killme.html"/) { print FILE "$line"; }
        }

        # Remove the forum from the admin file

        open (FILE, "$adminpath");
        @lines = <FILE>;
        close(FILE);
        open (FILE, ">$adminpath");
        $nowrite = 0;
        foreach $line(@lines) {
                if ($line =~ /href="$mainurl\/$killme.html"/) { $nowrite = 1; }
                if ($line =~ /!-- $mainurl\/$killme.html --/) { $nowrite = 0; }
                else { if ($nowrite == 0) { print FILE "$line"; } }
        }
        close(FILE);
}

sub mailposter {
        $message_num = shift(@_);
        open(MAIL,"|$mailprogram -t");
        print MAIL "To: \"$FORM{'oname'}\" <$FORM{'oemail'}>\n";
        if ($FORM{'email'}) { print MAIL "From: \"$FORM{'name'}\" <$FORM{'email'}>\n"; }
        else { print MAIL "From: \"$FORM{'name'}\" <anonymous\@some.where>\n"; }
        print MAIL "Subject: $FORM{'subject'}\n";
        print MAIL "Hello.  At some point in your life you visited my message\n";
        print MAIL "board at $mainurl/$mainpage and posted \n";
        print MAIL "the following message:\n\n";
        $FORM{'omessage'} =~ s/<([^>]|\n)*>//g;
        $FORM{'omessage'} =~ s/<//g;
        $FORM{'omessage'} =~ s/>//g;
        print MAIL "$FORM{'omessage'}\n\n";
        print MAIL "On $date at $time, $FORM{'name'} stopped \n";
        print MAIL "by and posted the following response:\n\n";
        $FORM{'body'} =~ s/<([^>]|\n)*>//g;
        $FORM{'body'} =~ s/<//g;
        $FORM{'body'} =~ s/>//g;
        print MAIL "$FORM{'body'}\n\n";
        print MAIL "If you would like to reply to this, go to\n";
        print MAIL "$posturl/$message_num.html\n\n";
        print MAIL "Thanks for your time!\n\n";
        print MAIL "**********************************************\n";
        print MAIL "* I'm using Cliff the Mighty's Message Board *\n";
        print MAIL "*       Script, which can be found at        *\n";
        print MAIL "*    http://www.shavenferret.com/scripts     *\n";
        print MAIL "*  Like all of Cliff's Scripts, it is free.  *\n";
        print MAIL "**********************************************\n";
        close(MAIL);
}   
