<?php
/*
Create buttons on the fly with PHP
---------------------------------------------------------------------------
author:    urs.gehrig@gmx.net, http://www.circle.ch
update:    16-5-2000
PHP:       php-3.0.11-win32
file(s):   button.php
syntax:    for testing:
             http://localhost/button.php?fg=990000&bg=ffffff&txt=button one
           for inclusion (see also test.htm):
             <img src="button.php?fg=990000&bg=ffffff&txt=button one" border="0">
settings:  $bg = background color , hexadecimal
           $fg = foreground color , hexadecimal
           hexadecimal order : RGB (each 2byte)
*/

  define("TextFONT", "3");

  function ConvertColor($hexVal){
    $ColorVal = array(3);
    for($i = 0; $i < 3; $i++)
      $ColorVal[$i] = HexDec(substr($hexVal, $i * 2, 2));
    return $ColorVal;
  }

  $width = strlen($txt) * ImageFontWidth(TextFONT);
  $offset = 2;
  $imgFRAME = ImageCreate($width, ImageFontHeight(TextFONT)+$offset);

  list($red, $green, $blue) = ConvertColor($bg);
  $bgCOLOR = ImageColorAllocate($imgFRAME, $red, $green, $blue);

  list($red, $green, $blue) = ConvertColor($fg);
  $fgCOLOR = ImageColorAllocate($imgFRAME, $red, $green, $blue);

  ImageFill($imgFRAME, 1, 1, $bgCOLOR);
  ImageString($imgFRAME, TextFONT, 1, 1, $txt, $fgCOLOR);

  header("Content-type: image/gif");
  ImageGIF($imgFRAME);
  ImageDestroy($imgFRAME);
?>