<?php
include("prepend.inc.php");

$Server=getData("Server", "integer");
$User=getData("User");
$Tablename=getData("Tablename");
$Sortorder=getData("Sortorder");
$Sortfield=rawurldecode(getData("Sortfield"));

$mode=getData("mode");
$submode=getData("submode");
if(!$mode){
    $mode="main";
}

$defaultget="?Server=$Server&Tablename=$Tablename&User=$User&";

$html.="<table><tr><td align=center>";
$html.="<a href=\"tbl_detail.php".$defaultget."mode=main&submode=truncate1&".SID."\">".
"<img border=0 src=\"images/truncate.gif\" alt=\"Truncate Table $Tablename\" width=32 height=32><br>Truncate</a>";
$html.="</td><td align=center>";
$html.="<a href=\"tbl_detail.php".$defaultget."mode=main&submode=drop1&".SID."\">".
"<img border=0 src=\"images/drop.gif\" alt=\"Drop Table $Tablename\" width=32 height=32><br>Drop</a>";
$html.="</td><td align=center>";
$html.="</td></tr></table>\n";

$menu=new MenuBar();
$menu->registerMenu("main", "Overview", $PHP_SELF.$defaultget."mode=main&".SID);
$menu->registerMenu("column", "Column Data", $PHP_SELF.$defaultget."mode=column&".SID);
$menu->registerMenu("indizes", "Indizes", $PHP_SELF.$defaultget."mode=indizes&".SID);
$menu->registerMenu("info", "Table Info", $PHP_SELF.$defaultget."mode=info&".SID);
$menu->registerMenu("content", "Table Content", $PHP_SELF.$defaultget."mode=content&".SID);
$menu->registerMenu("constraints", "Constraints", $PHP_SELF.$defaultget."mode=constraints&".SID);
$menu->registerMenu("triggers", "Triggers", $PHP_SELF.$defaultget."mode=triggers&".SID);
$menu->selectMenu($mode);
$menu->renderHTML();
$html.=$menu->getHTML();
unset($menu);

$html.= "<h1> Database  ".$DB->Name($Server)." - Table  ".$Tablename."</h1>";

// different views
switch($mode){
 case "column":
     switch($submode){
     default: // COLUMN DEFAULT
	 if(isset($Tablename)){
	     $tbl=new Table($Server);
	     $tbl->setOwner($User);
	     $tbl->setName($Tablename);
	     $tbl->getData();
	     // table comment
	     if($tbl->comments){
		 $html .="<br><table border=0><tr><th bgcolor=\"#DDDDDD\">Comments</th></tr>";
		 $html .="<tr bgcolor=\"#DDDDDD\"><td>".nl2br($tbl->comments)."<td><tr>";
		 $html .="</table><br>";
	     }
	     // table
	     $data=array();
	     if(is_array($tbl->columns)){
		 foreach($tbl->columns as $column){
		     $tmp["Fieldname"]=$column->name;
		     $tmp["Types"]=$column->type;
		     $tmp["Lenght"]=$column->length;
		     $tmp["Scale"]=$column->scale;
		     $tmp["Null"]=$column->nullable;
		     $tmp["Default"]=$column->data_default;
		     $data[]=$tmp;
		 }
		 $tbl=new DataTable($Server);
		 $tbl->setSorting(0);
		 $tbl->setData($data);
		 unset($data);
		 $tbl->setColorToggle(1);
		 $tbl->renderHTML();
		 $html.=$tbl->getHTML();
		 unset($tbl);
	     }
	 }
     }// end submode column
     break;
 case "content":
     switch($submode){
     default: // CONTENT DEFAULT
	 $tbl=new DataTable($Server);
	 $tbl->setSql("SELECT * FROM ".$User.".".$Tablename);
	 $tbl->setSorting(1);
	 $tbl->setSort($Sortfield, $Sortorder);
	 $tbl->loadData();
	 $tbl->setColorToggle(1);
	 $tbl->renderHTML($defaultget."mode=$mode&".SID);
	 $html.=$tbl->getHTML();
	 unset($tbl);
     }// end submode content
     break;
 case "info":
     switch($submode){
     default: 
	 $datatbl=new DataTable($Server);
	 $tbl=new Table($Server);
	 $tbl->setOwner($User);
	 $tbl->setName($Tablename);
	 $data=$tbl->getInfo();
	 unset($tbl);
	 $datatbl->setData($data);
	 $datatbl->setColorToggle(1);
	 $datatbl->renderHTML($defaultget."mode=$mode&".SID);
	 $html.=$datatbl->getHTML();
	 unset($datatbl);
     }// end submode content
     break;
 case "indizes":
     switch($submode){
     default: 
	 $tbl=new DataTable($Server);
	 $tbl->setSql(sprintf("select INDEX_NAME \"Index Name\", status \"Status\", ".
			     "UNIQUENESS \"Uniqueness\" from all_indexes where table_name='%s' and table_owner='%s'",
			     $Tablename, $User));
	 $tbl->setSorting(1);
	 $tbl->setSort($Sortfield, $Sortorder);
	 $tbl->loadData();
	 $tbl->setColorToggle(1);
	 $tbl->renderHTML($defaultget."mode=$mode&".SID);
	 $html.=$tbl->getHTML();
	 unset($tbl);
     }// end submode content
     break;
 case "constraints":
     switch($submode){
     default: 
	 $tbl=new DataTable($Server);
	 $tbl->setSql(sprintf("select CONSTRAINT_NAME \"Constraint Name\", CONSTRAINT_TYPE \"Type\", ".
			      "status \"Status\", deferred \"Deferred\", to_char(last_change,'MM-DD-YYYY') \"Last Changed\"".
			      "from all_constraints where table_name='%s' and owner='%s'",
			      $Tablename, $User));
	 $tbl->setSorting(1);
	 $tbl->setSort($Sortfield, $Sortorder);
	 $tbl->loadData();
	 $tbl->setColorToggle(1);
	 $tbl->renderHTML($defaultget."mode=$mode&".SID);
	 $html.=$tbl->getHTML();
	 unset($tbl);
     }// end submode content
     break;
 case "triggers":
     switch($submode){
     default: 
	 $tbl=new DataTable($Server);
	 $tbl->setSql(sprintf("select TRIGGER_NAME \"Trigger Name\", TRIGGER_TYPE \"Type\", ".
			      "status \"Status\", triggering_event \"Triggering on\" ".
			      "from all_triggers where table_name='%s' and table_owner='%s'",
			      $Tablename, $User));
	 $tbl->setSorting(1);
	 $tbl->setSort($Sortfield, $Sortorder);
	 $tbl->loadData();
	 $tbl->setColorToggle(1);
	 $tbl->renderHTML($defaultget."mode=$mode&".SID);
	 $html.=$tbl->getHTML();
	 unset($tbl);
     }// end submode content
     break;
 case "main":
     switch($submode){
     case "execute":
	 $statement=trim(rawurldecode(getData("statement")));
	 $tbl=new DataTable($Server);
	 $tbl->setSql($statement);
	 $tbl->setSorting(1);
	 $tbl->setSort($Sortfield, $Sortorder);
	 $tbl->loadData();
	 $tbl->setColorToggle(1);
	 $tbl->renderHTML($defaultget."mode=$mode&submode=$submode&statement=".rawurlencode($statement)."&".SID);
	 $html.=$tbl->getHTML();
	 unset($tbl);
	 break;
     case "drop1":
	 $html.="Do you really want to DROP TABLE $User.$Tablename?<br>".
	     "<form action=\"tbl_detail.php\" method=\"post\" enctype=\"application/x-www-form-urlencoded\">".
	     "<input type=\"hidden\" name=\"Tablename\" value=\"$Tablename\">".
	     "<input type=\"hidden\" name=\"Server\" value=\"$Server\">".  
	     "<input type=\"hidden\" name=\"User\" value=\"$User\">".
	     "<input type=\"hidden\" name=\"mode\" value=\"main\">".
	     "<input type=\"hidden\" name=\"submode\" value=\"drop2\">".
	     "<input type=\"Submit\" name=\"DROP\" value=\"yes\">&nbsp;&nbsp;".
	     "<input type=\"Submit\" name=\"DROP\" value=\"no\">";
	 $html.="</form></td></tr></table>";
	 break;
     case "truncate1":
	 $html.="Do you really want to DELETE FROM $User.$Tablename?<br>".
	     "<form action=\"tbl_detail.php\" method=\"post\" enctype=\"application/x-www-form-urlencoded\">".
	     "<input type=\"hidden\" name=\"Tablename\" value=\"$Tablename\">".   
	     "<input type=\"hidden\" name=\"Server\" value=\"$Server\">".  
	     "<input type=\"hidden\" name=\"User\" value=\"$User\">".
	     "<input type=\"hidden\" name=\"mode\" value=\"main\">".
	     "<input type=\"hidden\" name=\"submode\" value=\"truncate2\">";
	 $html.="<input type=\"Submit\" name=\"TRUNCATE\" value=\"yes\">&nbsp;&nbsp;".
	     "<input type=\"Submit\" name=\"TRUNCATE\" value=\"no\">";
	 $html.="</form></td></tr></table>";
	 break;
     case "truncate2":
	 $TRUNCATE=getData("TRUNCATE");
	 if($TRUNCATE=="yes"){
	     $tbl=new Table($Server);
	     $tbl->setOwner($User);
	     $tbl->setName($Tablename);
	     if(!$tbl->Truncate()){  
		 $html.="<P><B>Table truncating failed.</B></P>";
	     }
	 } elseif($TRUNCATE=="no"){ 
	     $html.="<P><B>Table truncating cancelled.</B></P>";
	 }
     case "drop2":
	 $DROP=getData("DROP");
	 if($DROP=="yes"){
	     $tbl=new Table($Server);
	     $tbl->setOwner($User);
	     $tbl->setName($Tablename);
	     if(!$tbl->Drop()){  
		 $html.="<P><B>Table dropping failed.</B></P>";
	     }
	 } elseif($DROP=="no"){ 
	     $html.="<P><B>Table dropping cancelled.</B></P>";
	 }
     default: 
	 $html.="<P>Execute SQL Statement:<br>".
	     "<form action=\"tbl_detail.php\" method=\"post\" enctype=\"application/x-www-form-urlencoded\">".
	     "<input type=\"hidden\" name=\"Tablename\" value=\"$Tablename\">".
	     "<input type=\"hidden\" name=\"Server\" value=\"$Server\">".  
	     "<input type=\"hidden\" name=\"User\" value=\"$User\">".
	     "<input type=\"hidden\" name=\"mode\" value=\"main\">".
	     "<input type=\"hidden\" name=\"submode\" value=\"execute\">".
	     "<textarea name=\"statement\" cols=\"60\" rows=\"4\" wrap=\"VIRTUAL\" style=\"width: 300px\"></textarea><br>".
	     "<input type=\"Submit\" name=\"BUTTON\" value=\"Execute\">";
	 $html.="</form></td></tr></table></p>";
     }// end submode content
     break;
 default:
}// end switch mode


$page=new Page("Table management - ".$User.".".$Tablename);
$page->setHead();
$page->setBody();
$page->setSQL();
$page->setBody($html);
$page->Display();
?>
