<?php
/**
 * @desc this is a newer model of the class object
 * especially for table views
 */
class DataTable extends Database {

    // html data of the table
    var $htmldata;

    var $sql;
    var $data;
    var $colortoggle=FALSE;
    var $sorting=FALSE;
    var $sortorder=FALSE;
    var $sortfield=FALSE;

    /**
     * @desc constructor
     * @param server id
     */
    function DataTable($server){
	Database::Database($server);
    }
    /**
     * @desc sets the sql statement
     * @param sql syntax
     */
    function setSql($sql){
	$sql=trim($sql);
	if(substr($sql,strlen($sql)-1, 1)==";"){
	    $sql=substr($sql, 0, strlen($sql)-1);
	}
	$this->sql=$sql;
    }
    /**
     * @desc set data array of assoc datas
     * @param data
     */
    function setData($data){
	$this->data=$data;
    }

    /**
     * @desc toggle sort support
     * @param toggle TRUE || FALSE
     */
    function setSorting($toggle){
	$this->sorting=$toggle;
    }

    /**
     * @desc sets the sort order
     * @param $field
     * @param $order
     */
    function setSort($field=FALSE, $order){
	$order=strtoupper($order);
	if($field){
	    if($order!="ASC" AND $order!="DESC"){
		$order="ASC";
	    }
	    $this->sortorder=$order;
	    $this->sortfield=$field;
	}
    }
    /**
     * @desc sets color toggle on/off
     * @param toggle TRUE || FALSE
     */
    function setColorToggle($toggle){
	$this->colortoggle=$toggle;
    }
    /**
     * @desc executes the query and form the data array
     */
    function loadData(){
     	if(!$this->sql){
	    trace(2, __LINE__, __FILE__, "No Sql given");
	    return FALSE;
	}
	$sql=$this->sql;
	
	if($this->sorting && $this->sortfield && $this->sortorder){
	    $sql="SELECT * FROM (\n ".$sql." \n) ORDER BY \"".$this->sortfield.
		"\" ".$this->sortorder;
	}
	
	$GLOBALS["SQL_QUERY_TO_SHOW"].="\n".$sql."\n";
	$stmt=$this->parse($sql);
	$this->execute($stmt);
	$this->data=array();
	$count=0;
	
	//$ccount=@OCINumCols($stmt);
	
	while($arr=$this->nextrow($stmt) AND $count<$GLOBALS["CF"]->get("TABLE_ROW_LIMIT")){
	  foreach($arr as $key => $val){
	      $val=is_object($val) ? $val->load() : $val;
	      if(strlen($val)>200){
		  $arr[$key]=substr($val, 0, 200);
	      }
	      $arr[$key]=htmlentities($arr[$key]);
	  }
	  $this->data[]=$arr;
	  $count++;
	}
    }

    /**
     * set data array
     * @param array
     */
    function setData($data){
	if(!is_array($data)){
	    trace(2, __LINE__, __FILE__, "Wrong Dataformat");
	    return FALSE;
	}
	$this->data=$data;
	return TRUE;
    }

    /**
     * @desc render the html table
     * @param side of the tablelist
     * @param additional url params
     */
    function renderHTML($urldata=""){
	if(!is_array($this->data)){
	    trace(2, __LINE__, __FILE__, "No Datas availiable");
	    return FALSE;
	}
	if(count($this->data)==0){
	    $this->htmldata="No entries found.";
	    return TRUE;
	}
	$count=0;
	$html="<TABLE BORDER=0>\n";
	foreach($this->data as $row){
	    if($count==0){
		$html.="<TR>\n";
		foreach($row as $key => $foo){
		    if($this->sorting){
			$html.="<TH><A HREF=\"".$GLOBALS["PHP_SELF"].$urldata."&Sortorder=";
			if($key==$this->sortfield){
			    $html.=($this->sortorder=="ASC") ? "DESC" : "ASC";
			} else {
			    $html.="ASC";
			}
			$html.="&Sortfield=".rawurlencode($key)."\">$key</A></TH>";
		    } else {
			$html.="<TH>$key</TH>";
		    }
		}
		$html.="</TR>\n";
	    }
	    if($this->colortoggle){
		$html .=$count % 2 ? "<TR VALIGN=TOP>" : 
		    "<TR BGCOLOR=\"#CCCCCC\" VALIGN=TOP>";
	    } else {
		$html.="<TR VALIGN=TOP>\n";
	    }
	    foreach($row as $foo => $val){
		$html.="<TD>".($val ? $val : "&nbsp;")."</TD>";
	    }
	    $html.="</TR>\n";
	    ++$count;
	}
	$html.="</TABLE>\n";
	$this->htmldata=$html;
	return TRUE;
    }
    /**
     * @desc returns the datas
     */
    function getData(){
	return $this->data;
    }
    /**
     * @desc returns the html table
     */
    function getHTML(){
	return $this->htmldata;
    }

}
