<?php
$DBDatas="";
$CONFIGURATION="";
// default values
if(!is_array($DBDatas)){
    $DBDatas=array();
}
if(!is_array($CONFIGURATION)){
    $CONFIGURATION=array();
}

// configuration class
class Configuration {
    
    var $ENABLE_SESSION_FUNCTIONS;

    function Configuration(){
	global $CONFIGURATION;
	global $DBDatas;
	include("config.inc.php");
	@include("privat.inc.php");
	$this->ENABLE_SESSION_FUNCTIONS=$ENABLE_SESSION_FUNCTIONS;
	if(function_exists("session_start") && $ENABLE_SESSION_FUNCTIONS){
	    session_start();
	    // register vars
	    session_register("DBDatas");
	    session_register("CONFIGURATION");
	}
	$this->DBUser_C=$DBUser_C;
	$this->DBPass_C=$DBPass_C;
	$this->DBName_C=$DBName_C;
	if(!isset($GLOBALS["CONFIGURATION"]["DEBUG_ECHO_LEVEL"])){
	    $this->DEBUG_ECHO_LEVEL=$DEBUG_ECHO_LEVEL;
	} else {
	    $this->DEBUG_ECHO_LEVEL=$GLOBALS["CONFIGURATION"]["DEBUG_ECHO_LEVEL"];
	}
	if(!isset($GLOBALS["CONFIGURATION"]["USE_ALL_USER_DATA"])){
	    $this->USE_ALL_USER_DATA=$USE_ALL_USER_DATA;
	} else {
	    $this->USE_ALL_USER_DATA=$GLOBALS["CONFIGURATION"]["USE_ALL_USER_DATA"];
	}
	if(!isset($GLOBALS["CONFIGURATION"]["ENABLE_TABLES"])){
	    $this->ENABLE_TABLES=$ENABLE_TABLES;
	} else {
	    $this->ENABLE_TABLES=$GLOBALS["CONFIGURATION"]["ENABLE_TABLES"];
	}
	if(!isset($GLOBALS["CONFIGURATION"]["ENABLE_SEQUENCES"])){
	    $this->ENABLE_SEQUENCES=$ENABLE_SEQUENCES;
	} else {
	    $this->ENABLE_SEQUENCES=$GLOBALS["CONFIGURATION"]["ENABLE_SEQUENCES"];
	}
	if(!isset($GLOBALS["CONFIGURATION"]["ENABLE_TRIGGERS"])){
	    $this->ENABLE_TRIGGERS=$ENABLE_TRIGGERS;
	} else {
	    $this->ENABLE_TRIGGERS=$GLOBALS["CONFIGURATION"]["ENABLE_TRIGGERS"];
	}
	if(!isset($GLOBALS["CONFIGURATION"]["ENABLE_FUNCTIONS"])){
	    $this->ENABLE_FUNCTIONS=$ENABLE_FUNCTIONS;
	} else {
	    $this->ENABLE_FUNCTIONS=$GLOBALS["CONFIGURATION"]["ENABLE_FUNCTIONS"];
	}
	if(!isset($GLOBALS["CONFIGURATION"]["ENABLE_INDEXES"])){
	    $this->ENABLE_INDEXES=$ENABLE_INDEXES;
	} else {
	    $this->ENABLE_INDEXES=$GLOBALS["CONFIGURATION"]["ENABLE_INDEXES"];
	}
	if(!isset($GLOBALS["CONFIGURATION"]["ENABLE_PROCEDURES"])){
	    $this->ENABLE_PROCEDURES=$ENABLE_PROCEDURES;
	} else {
	    $this->ENABLE_PROCEDURES=$GLOBALS["CONFIGURATION"]["ENABLE_PROCEDURES"];
	}
	if(!isset($GLOBALS["CONFIGURATION"]["ENABLE_PACKAGES"])){
	    $this->ENABLE_PACKAGES=$ENABLE_PACKAGES;
	} else {
	    $this->ENABLE_PACKAGES=$GLOBALS["CONFIGURATION"]["ENABLE_PACKAGES"];
	}
	if(!isset($GLOBALS["CONFIGURATION"]["ENABLE_TYPES"])){
	    $this->ENABLE_TYPES=$ENABLE_TYPES;
	} else {
	    $this->ENABLE_TYPES=$GLOBALS["CONFIGURATION"]["ENABLE_TYPES"];
	}
	if(!isset($GLOBALS["CONFIGURATION"]["ENABLE_VIEWS"])){
	    $this->ENABLE_VIEWS=$ENABLE_VIEWS;
	} else {
	    $this->ENABLE_VIEWS=$GLOBALS["CONFIGURATION"]["ENABLE_VIEWS"];
	}
	if(!isset($GLOBALS["CONFIGURATION"]["ENABLE_TABLESPACES"])){
	    $this->ENABLE_TABLESPACES=$ENABLE_TABLESPACES;
	} else {
	    $this->ENABLE_TABLESPACES=$GLOBALS["CONFIGURATION"]["ENABLE_TABLESPACES"];
	}
	if(!isset($GLOBALS["CONFIGURATION"]["ENABLE_VIEW_STATEMENTS"])){
	    $this->ENABLE_VIEW_STATEMENTS=$ENABLE_VIEW_STATEMENTS;
	} else {
	    $this->ENABLE_VIEW_STATEMENTS=$GLOBALS["CONFIGURATION"]["ENABLE_VIEW_STATEMENTS"];
	}
	if(!isset($GLOBALS["CONFIGURATION"]["TABLE_ROW_LIMIT"])){
	    $this->TABLE_ROW_LIMIT=$TABLE_ROW_LIMIT;
	} else {
	    $this->TABLE_ROW_LIMIT=$GLOBALS["CONFIGURATION"]["TABLE_ROW_LIMIT"];
	}
    }

    function get($name){
	return $this->$name;
    }

    function set($name, $value){
	$GLOBALS["CONFIGURATION"][$name]=$value;
	$this->$name=$value;
    }
    
}// end class
$CF=new Configuration();

include("debug.lib.php");
include("functions.lib.php");

// set current version
$VERSION="0.1.1";

$mode=getData("mode");
$submode=getData("submode");
// system actions 
switch($mode){
 case "sessionconfig":
     switch($submode){
     case "submit":
	 // apply datas to the current settings
	 $CF->set("ENABLE_TABLES", getData("FORM_ENABLE_TABLES", "integer"));
	 $CF->set("ENABLE_SEQUENCES", getData("FORM_ENABLE_SEQUENCES", "integer"));
	 $CF->set("ENABLE_TRIGGERS", getData("FORM_ENABLE_TRIGGERS", "integer"));
	 $CF->set("ENABLE_FUNCTIONS", getData("FORM_ENABLE_FUNCTIONS", "integer"));
	 $CF->set("ENABLE_INDEXES", getData("FORM_ENABLE_INDEXES", "integer"));
	 $CF->set("ENABLE_PROCEDURES", getData("FORM_ENABLE_PACKAGES", "integer"));
	 $CF->set("ENABLE_PROCEDURES", getData("FORM_ENABLE_PROCEDURES", "integer"));
	 $CF->set("ENABLE_TYPES", getData("FORM_ENABLE_TYPES", "integer"));
	 $CF->set("ENABLE_VIEWS", getData("FORM_ENABLE_VIEWS", "integer"));
	 $CF->set("ENABLE_TABLESPACES", getData("FORM_ENABLE_TABLESPACES", "integer"));
	 $CF->set("USE_ALL_USER_DATA", getData("FORM_USE_ALL_USER_DATA", "integer"));
	 $CF->set("ENABLE_VIEW_STATEMENTS", getData("FORM_ENABLE_VIEW_STATEMENTS", "integer"));
	 $CF->set("TABLE_ROW_LIMIT", getData("FORM_TABLE_ROW_LIMIT", "integer"));
	 break;
     default:
     }// end switch submode
     break;
 default:
}// end switch


// building availiable dbsarray
class DB_Datas {

    var $DBDatas;

    function DB_Datas($DBDatasession, $DBUser_C=FALSE, $DBPass_C=FALSE, $DBName_C=FALSE){
	$DBDatas=array();
	foreach($DBDatasession as $DBData){
	    $DBDatas[]=$DBData;
	}
	sort($DBDatas);
	if(is_array($DBName_C)){
	    for($x=0; $x < count($DBName_C); $x++){
		if(strlen($DBUser_C[$x])>0 AND strlen($DBName_C[$x])>0){
		    $DBDatas[]=array("DBUser"=>strtoupper($DBUser_C[$x]),
				     "DBPass"=>$DBPass_C[$x],
				     "DBName"=>strtoupper($DBName_C[$x]));
		}
	    }
	}
	sort($DBDatas);
	$this->DBDatas=$DBDatas;
    }

    function Name($Server){
	return $this->DBDatas[$Server]["DBName"];
    }

    function User($Server){
	return $this->DBDatas[$Server]["DBUser"];
    }

    function Pass($Server){
	return $this->DBDatas[$Server]["DBPass"];
    }

    function Drop($User, $Name){
	for($x=0; $x<count($this->DBDatas); $x++){
	    if(($this->DBDatas[$x]["DBUser"]==$User) &&
	       ($this->DBDatas[$x]["DBName"]==$Name)){
		unset($this->DBDatas[$x]);
		continue;
	    }
	}
	// reindex
	$DBDatas=array();
	foreach($this->DBDatas as $DBData){
	    $DBDatas[]=$DBData;
	}
	sort($DBDatas);
	$this->DBDatas=$DBDatas;
    }

    function Add($User, $Pass, $Name){
	if(strlen($User)>0 AND strlen($Name)>0){
	    $this->DBDatas[]=array("DBUser"=>strtoupper($User),
				   "DBPass"=>$Pass,
				   "DBName"=>strtoupper($Name));
	    sort($this->DBDatas);
	}
    }

}// end class

// instance for usage
$DB=new DB_Datas($DBDatas, $CF->get("DBUser_C"), $CF->get("DBPass_C"), $CF->get("DBName_C"));

include("page.lib.php");
include("database.lib.php");
include("object.lib.php");
include("tree.lib.php");
include("datatable.lib.php");
include("menubar.lib.php");

include("user.lib.php");
include("column.lib.php");
if($CF->get("ENABLE_TABLES")){
    include("table.lib.php");
}
if($CF->get("ENABLE_SEQUENCES")){
    include("sequence.lib.php");
}
if($CF->get("ENABLE_TRIGGERS")){
    include("trigger.lib.php");
}
if($CF->get("ENABLE_FUNCTIONS")){
    include("function.lib.php");
}
if($CF->get("ENABLE_INDEXES")){
    include("index.lib.php");
}
if($CF->get("ENABLE_PROCEDURES")){
    include("procedure.lib.php");
}
if($CF->get("ENABLE_PACKAGES")){
    include("package.lib.php");
}
if($CF->get("ENABLE_TYPES")){
    include("type.lib.php");
}
if($CF->get("ENABLE_VIEWS")){
    include("view.lib.php");
}
if($CF->get("ENABLE_TABLESPACES")){
    include("tablespace.lib.php");
}
?>
