<?php
/**
 * @desc class to generate menubar for objects
 *
 */
class MenuBar {

    var $htmldata;

    var $menudata;
    var $selected=FALSE;

    /**
     * @desc constructor
     */
    function MenuBar(){
	$this->menudata=array();
    }

    /**
     * @desc register a new menu
     */
    function registerMenu($ident, $name, $link){
	$this->menudata[]=array("IDENT"=>$ident, "NAME"=>$name, "LINK"=>$link);
    }

    function selectMenu($ident){
	$this->selected=$ident;
    }

    function renderHTML(){
	if(!$this->selected){
	    reset($this->menudata);
	    $this->selected=current($this->menudata);
	    $this->selected=$this->selected["IDENT"];
	}
	$html="<TABLE BORDER=1>\n<TR>\n";
	foreach($this->menudata as $button){
	    if(($button["IDENT"])==($this->selected)){
		$html.="<TD BGCOLOR=\"#D3DCE3\" ALIGN=CENTER WIDTH=60 HEIGHT=30>";
	    } else {
		$html.="<TD BGCOLOR=\"#CCCCCC\" ALIGN=CENTER WIDTH=60 HEIGHT=30>";
	    }
	    $html.="<A HREF=\"".$button["LINK"]."\">".$button["NAME"]."</A></TD>";
	}
	$html.="</TR></TABLE>";
	$this->htmldata=$html;
    }

    function getHTML(){
	return $this->htmldata;
    }
    }// end class
