<?php

class Database {

    // privat
    var $DBName;
    var $DBUser;
    var $DBPass;
    var $conn;
    var $error;
    var $version;
    var $errorcode; // error number
    var $errormessage; // error number

    function Database($Server=0){ 
	global $DB;
	settype($Server, "integer");
	$this->DBName=$DB->Name($Server);
	$this->DBPass=$DB->Pass($Server);
	$this->DBUser=$DB->User($Server);
	$this->conn = @ocilogon($this->DBUser,$this->DBPass,$this->DBName);
	
	if(!$this->conn){
	    $this->error($this->conn);
	}
	
	$this->version=@OCIServerVersion($this->conn);
    }
    
    /**destructor */
    function destruct(){
	@OCIFreeStatement($this->stmt);
	@OCILogoff($this->conn);
	return TRUE;
    }
    
    /** build error output
     *    type can be stmt|conn|global
     */
    function error($type=""){
	if(!$type){
	    $type=$this->stmt;
	}
	
	$error=OCIError($type);

	if($error) {
	    $errorstring="<br>\nOCIError: ".$error["code"]." ".$error["message"]
		." <br>\nAction: ". $this->query."<br>\n";
	    //trace(2,__LINE__,get_class($this), $errorstring);
	    $this->errorcode=$error["code"];
	    $this->errormessage=$error["message"];	
	    $this->error = false;
	} else {
	    $this->errorcode=FALSE;
	    $this->errormessage=FALSE;
	    $this->error = true;
	}
	
	return FALSE;
    }
    
    /** parse a query and return a statement */
    function parse($query){
	$this->query=$query;
	$stmt=@ociparse($this->conn,$query);
	$this->stmt=$stmt;
	$this->error();
	return $stmt;
    }
    
    /** executes a statement */
    function execute($stmt="",$param=OCI_COMMIT_ON_SUCCESS){
	if(!$stmt){
	    $stmt=$this->stmt;
	}
	@OCIExecute($stmt,$param);
	return $this->error();
    }
    
    
    /** returns array of assoc array's */
    function result($stmt=FALSE,$from=FALSE,$to=FALSE){
	if(!$stmt){
	    $stmt=$this->stmt;
	}
	$result=array();
	if (!$from && !$to){
	    while(@ocifetchinto($stmt,$arr,OCI_ASSOC+OCI_RETURN_NULLS)){
		$result[]=$arr;
	    }
	} else {
	    $counter=0;
	    while(@ocifetchinto($stmt,$arr,OCI_ASSOC+OCI_RETURN_NULLS)){
		if($counter>=$from && $counter<=$to){
		    $result[]=$arr;
		}
		$counter++;
	    }
	}
	@OCIFreeStatement($stmt);
	return $result;
    }
    
    /** return thge the next row based upon @ocifetchinto($stmt,$arr,OCI_ASSOC+OCI_RETURN_NULLS) */
    function nextrow($stmt=FALSE, $param=FALSE){
	if(!$stmt){
	    $stmt=$this->stmt;
	}  
	if(!$param){
	    $param=OCI_ASSOC+OCI_RETURN_NULLS;
	}
	if(@ocifetchinto($stmt,$arr,$param)){
	    return $arr;
	} 
	return FALSE;
    }

} //class Database



class Types {
    
    var $typecodes, $conn;
	
    function Types(&$conn) {
	$this->typecodes = explode(",", "CHAR,DATE,FLOAT,LONG,LONG RAW,NUMBER,RAW,ROWID,VARCHAR2");
	$sql = "SELECT TYPECODE FROM USER_TYPES";
	$ra = $conn->DoSelect($sql);
	if (is_array($ra)) {
	    while(list($dummy, $tc) = each ($ra)) {
		$this->typecodes[] = $tc["TYPECODE"];
	    }
	}
    }//function Types->Types

}//class Types


class WhereClause {
 
   var $out, $fname, $fval, $fop, $ftype, $relop;
    
    function Add(&$table, $fname, $fval, $fop, $relop="AND") {
	$this->fname = $fname;
	$this->fval = $fval;
	$this->fop = $fop;
	$this->relop = $relop;
	$this->type = $table->GetFieldType($this->fname);
	if ($this->type) {
	    $del = (preg_match("/(NUMBER|FLOAT)/", $this->type)) ? "" : "'";
	    $ac = sprintf("%s %s %s%s%s", $this->fname, $this->fop, $del, $this->fval, $del);
	    if (strlen($this->out) > 0) {
		$this->out .= sprintf(" %s %s", $this->relop, $ac);
	    } else {
		$this->out .= sprintf(" WHERE %s ", $ac);
	    }
	}
    }
}
	
?>
