<?php
/* WELCOME TO EasySQL! 
Easily connect to your MySQL database with just 1 php file and 3 easy steps!

SETUP
1. go to START OF 'ENTER CONNECT DATA HERE' below 
2. replace "Enter a value" with your data
3. save, upload to your webserver and surf to easysql.php
TEST
1. type in 'SHOW TABLES' without the quotes and click on 'Run My Query'
*/
$installversion = "1.3"; // DO NOT CHANGE
$productname = "EasySQL"; /* DO NOT CHANGE - may be used in remote version checking by you - DO NOT CHANGE */
if (!file_exists("./common.php")) {
	$submitLabel = "Login with Variables";
	 /* if the CONSTANTS are not invoked externally then hard code them
	    CONNECT: if you do NOT have common.php then enter your connect variables below
	    START OF 'ENTER CONNECT DATA HERE'
	    if you do not know what data to enter then contact your database administrator or internet service provider
     */
	$hostname = "localhost"; /* the name of your database server */
	$username = "root"; /* your database username, often the same as your isp account name */
	$password = ""; /* your database password, for security this SHOULD be different from your isp account name */
	$database = "abcsoft_webdb"; /* your database name */
	$adminUser = "admin"; /* the username of an approved administrator, for example, 'admin' */ 
	$adminPassword = "admin"; /* the password for your admin */	
	$bgColor = "Seashell"; /* the color of the page */
	$formColor = "#b3b3b3"; /* the color of the form on the page */
	$modifiedColor = "#ff8c00"; /* the text color to signify records were modified by your query */
	/* END OF 'ENTER CONNECT DATA HERE' */	
}else{
	// for Dreamriver applications - for example phpYellow Pages - we will use these pre-defined constants below, defined in 'common.php'
	$submitLabel = "Login with CONSTANTS";
	include("./common.php");
	$hostname = DBSERVERHOST;
	$username = DBUSERNAME;
	$password = DBPASSWORD;
	$database = DBNAME;
	$adminUser = ADMINUSER;
	$adminPassword = ADMINPASSWORD;
	$bgColor = BGCOLOR;
	$formColor = FORMBACKGROUND;
	$modifiedColor = "#ff8c00";
}?>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<HTML>
<HEAD>
<TITLE>EasySQL - A Dreamriver Software Product - http://www.dreamriver.com</TITLE>


<?php
// START OF application specific Javascript functions
// usually we will want to simply invoke a js external file here, nothing else
/*
if (defined("PREMIUM")) {
	//echo"<script language='JavaScript' src='locationOfJavascriptExternalFile.js' type='text/javascript'></script>";
	echo"You must define the location of your external file for Javascript.";
}
*/
// END OF application specific Javascript functions
?>


<!-- START OF JAVASCRIPT FUNCTIONS FOR ALL easysql.php RELEASES -->
<script language="JavaScript" type="text/javascript">
<!--
/*
This function tests to see if something has been entered in the query. 
If empty then an alert box appears and the form submission is halted 
*/
function isQuery() {
	var myForm = document.myQueryForm;
	if ( myForm.query.value == 0 ) {
		alert("There is no query.\nPlease enter a query.");
		myForm.query.focus();
		return false;
	}
	return true;
}
/* 
June 12, 2000 Last Revised
CHECK EMAIL AND PASSWORD
Credit: This function by dannyg@dannyg.com. All fields are required 
*/
function checkForm(form) {
for (var i=0; i < form.elements.length; i++) {
	if (form.elements[i].value == "") {
		alert("Fill out all fields please.")
		form.elements[i].focus()
		return false
	}
}
return true
}

/* 
This function is for the standard controls on every EasySQL The function 
accepts an argument called 'choice' for the query then switches the user 
choice, and pastes in a valid sql query into the textarea box
*/
function pasteSQL(choice) {
	var sqlQuery = document.myQueryForm.query;
	switch (choice) {
		case "showTables":
			sqlQuery.value="SHOW TABLES";
			break;
		default:
			sqlQuery.value="Enter an SQL query";
	}
}
// -->
</script>
<!-- END OF JAVASCRIPT FUNCTIONS FOR ALL easysql.php RELEASES -->

   
<META NAME="Author" CONTENT="Richard Creech, Web: http://www.dreamriver.com Email: richardc@dreamriver.com">
<META NAME="GENERATOR" CONTENT="Blood, Sweat & Tears">
</HEAD>

<BODY bgcolor="<?php echo($bgColor);?>">

<?php 
if (($formUser != $adminUser) || ($formPassword != $adminPassword)) {
	if ($loginAttempts == 0 ) { /* 3 strikes and they're out */
		$loginAttempts++;
	}else{
		$loginAttempts++;
		if ( $loginAttempts >= 4 ) {echo"Authentication failed.";exit;}
	}	
	?>

	<!--START OF adminLoginForm.php -->
	<form method="post" name="adminLoginForm" onSubmit="return checkForm(this)" action="easysql.php">
	<table 
	<?php if (file_exists ("./common.php")) 
		  {
	  		echo "background=\"" . $formColor . "\"";
		  }else{
			if($formColor) {
	  			echo "bgcolor=\"$formColor\"";
			}else{
				echo "bgcolor=\"silver\"";
			}
		  }?>
	 border="1" cellpadding="5">
	<tr><th colspan=2>EasySQL Login</th>
	</tr>

	<tr><td align="right">Name</td><td>
	<input type="text" name="formUser" value="<?php echo $formUser;?>">
	</td></tr>

	<tr><td align="right">Password</td><td>
	<input type="password" name="formPassword" value="<?php echo $formPassword;?>">
	</td></tr>

	<tr><td colspan=2>
	<input type="hidden" name="loginAttempts" value="<?php echo $loginAttempts;?>">
	<input type="submit" name="submit" value="<?php echo $submitLabel;?>">	
	</td></tr></table>
	</form>
	<!--END of adminLoginForm.php -->
<?php exit;
}else{
	if (isset($hostname)) {
		$rowsModified = 0;
		$rowsSelected = 0;
		if ($mysql = mysql_pconnect($hostname,$username,$password)) {
			if ($select = mysql_select_db($database)) {
				$query = stripslashes($query); // from the Javascript - won't work without this for one command
				$result = mysql_query($query);
				$partialCommand = ltrim($query); // strip leading characters eg. spaces
				$partialCommand = substr ( $partialCommand, 0, 4); /* get first 4 characters for switch()*/
				$partialCommand = strtolower($partialCommand);

				switch($partialCommand) { /* the first 4 letters from each sql statement are used for this switch  */
					case "alte": // zero to nn records are affected with Alter table
					case "dele": // zero to nn records are affected with Delete
					case "inse": // zero to 1 record affected with Insert
					case "upda": // zero to nn records are affected with Update
						if ($result != 0) {
							$rowsModified = mysql_affected_rows();
							$myStatus = "Command valid";
						}else{
							echo("Error " . mysql_errno() . ": " . mysql_error() . "<br>");
						}
						break;

					case "sele": // zero to nn rows returned
						if ($result != 0) {
							$rowsSelected = mysql_num_rows($result);
							$myStatus = "Command valid";
						}else{
							echo("Error " . mysql_errno() . ": " . mysql_error() . "<br>");
						}
					break;

					/* no affected records */
					case "crea": // no records affected
					case "desc":
					case "drop":
					case "load":
					case "show":
						$rowsModified = 0;
						if ($result != 0) {
							$myStatus = "Command valid";
						}else{
						echo("Error " . mysql_errno() . ": " . mysql_error() . "<br>");
						}
						break;

						
					default:
						$myStatus = "ALTER, DELETE, UPDATE, INSERT, CREATE, DESCRIBE, DROP, LOAD, SHOW, &amp; SELECT are the SQL commands currently supported in EasySQL.<br>\n";
				}

				// display results of the submitted query
				echo"<b>Query: </b> $query<br>\n";
				echo"<b>Result: </b> $myStatus<br>\n";
				echo"<b>Rows: </b> ";
				if ($partialCommand == "sele") {
					echo"$rowsSelected selected<p></p>";
				}else{
					echo "<b><font color=\"$modifiedColor\">$rowsModified modified</font></b><p></p>\n";
				}
				if (@mysql_num_rows($result) >= 1){ // if there are rows then show them
					echo"<TABLE BORDER=1><TR>\n";
		           	for ($i = 0; $i < mysql_num_fields($result); $i++) {
    		       		echo("<TH>" . mysql_field_name($result,$i) . "</TH>");
					}
					echo"</TR>\n";
        		   	for ($i = 0; $i < mysql_num_rows($result); $i++) {
			           	echo("<TR>\n");
    			       	$row_array = mysql_fetch_row($result);
            			for ($j = 0; $j < mysql_num_fields($result); $j++) {
       		    	   		echo("<TD>" . $row_array[$j] . "</TD>\n");
           				}
     		      		echo("</TR>\n");
        			}
					echo"</TABLE>";
				}
				if ($query == '' ) {
					echo"<br><b>EasySQL</b> &nbsp;&nbsp;Enter your query into the textarea box then click on &quot;RUN MY QUERY&quot;<br>";
				}
				?>		


				<!-- START OF table to encompass the entire SQL Command entry form -->				
				<br>
				<table <?php if(file_exists("./common.php")){echo "background=\"$formColor\"";}else{echo "bgcolor=\"$formColor\"";}?> cellpadding="5" align="left" border="10"><tr><td>
				<form method="post" name="myQueryForm" action="easysql.php" onsubmit="isQuery()">
				<textarea name="query" cols=75 rows=6 wrap="soft"><?php if ($showLastQuery == "reuse"){echo"$query";}?></textarea><br>

				<!-- ******* START OF STANDARD easysql CONTROLS ******* -->
				<!-- START OF table for standard easysql controls -->
				<table width="100%">
				<tr><td align="right">
				<input type="submit" name="submit" value="RUN MY QUERY">
				</td></tr>
				
				<tr><td align="left">
				<input type="button" name="showTables" value="Show Tables" onclick="pasteSQL('showTables')">
				<input type="checkbox" name="showLastQuery" value="reuse"<?php if($showLastQuery == 'reuse'){echo " CHECKED";}?>> Reuse Query 
				<input type='checkbox' name='showSyntax'<?php if($showSyntax == 'on'){echo " CHECKED";}?>> Syntax | 
				<a href="http://www.mysql.com/documentation/" target="_blank"><b>mySQL Docs</b></a> | 
				<a href="http://www.dreamriver.com/software/checkversion.php3?productname=<?php echo $productname;?>&installversion=<?php echo $installversion;?>" target="_blank">Check Version <?php echo $installversion;?></a>

				
<?php if($showSyntax == 'on'):?>
<p></p>

<b>Syntax</b>

<p></p>

This is quick reference. For official documentation please <a href="http://www.mysql.com/documentation/" target="_blank"><b>read the manual.</b></a>

<p></p>

<font size="2">
<b>SELECT</b><br>
syntax: SELECT <i>field1, field2</i> FROM <i>yourTableName</i> LIMIT 100<br>
example: SELECT firstName, lastName FROM user LIMIT 100<br>
outcome: displays records, does NOT change them
<p></p>

<b>DELETE</b><br>
syntax: DELETE FROM <i>yourTableName</i> WHERE <i>yourField</i> = <i>yourValue</i><br>
example: DELETE FROM User WHERE userid = 1000000<br>
outcome: permanently removes records
<p></p>

<b>INSERT</b><br>
syntax: INSERT INTO <i>yourTableName</i>(<i>yourField1, yourField2</i>) VALUES(<i>'value1', 'value2'</i>)<br>
example: INSERT INTO sduser(firstName, lastName) values('Robin','Creech')<br>
outcome: adds a new record
<p></p>

<b>UPDATE</b><br>
syntax: UPDATE <i>yourTableName</i> SET <i>yourField</i> = '<i>value</i>' WHERE <i>yourField</i> = '<i>value</i>'<br>
example: UPDATE user SET firstName='Richard' where lastName='Creech'<br>
outcome: edits an existing record
<p></p>
</font>
<?php endif;?>
<!-- END OF table for standard easysql controls -->
</td></tr></table>
<!-- ******* END OF STANDARD CONTROLS ******* -->



<!-- ******* INCLUDE APPLICATION SPECIFIC CONTROLS HERE ******* -->			
<!-- ******* End of APPLICATION SPECIFIC CONTROLS *******-->


		
<!-- This is part of the regular distribution package -->
<p align="center">
<i><b>EasySQL by <a href="http://dreamriver.com">Dreamriver</a></i>
</p>
<input type="hidden" name="formUser" value="<?php echo $formUser;?>">
<input type="hidden" name="formPassword" value="<?php echo $formPassword;?>">
</form>
</td></tr></table>
<!-- END OF table to encompass the entire SQL Command entry form -->				

			<?php
			}else{ // in NO select db
		    	echo mysql_error();
			}
		}else{ // if no connect
			echo mysql_error();
		}
	} // if hostname
} // if formuser is authorized
?>

</BODY>
</HTML>

