<?PHP
/************************************************************************/
/* AddressCheck								*/
/* ============								*/
/*									*/
/* Copyright (c) 2001 by Ronnie Indra Kurniawan (ronnie@acid.web.id)	*/
/* http://guide.acid.web.id/download/					*/
/*									*/
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/
$hostsallowFile="hosts.allow.php";

$regex= array(
	"ipaddress" => "((25[0,1,2,3,4,5]|2[0,1,2,3,4][0-9]|1[0-9]{2}|[1-9][0-9]|[0-9])[.]){3}(25[0,1,2,3,4,5]|2[0,1,2,3,4][0-9]|1[0-9]{2}|[1-9][0-9]|[0-9])"
	);

function validIP($IP) {
    global $regex;
    $IP= trim($IP);
    return preg_match("/^".$regex["ipaddress"]."$/",$IP);
}

function validSubnet($SUBNET) {
    global $regex;
    $SUBNET= trim($SUBNET);

    $result= 0;
    if(preg_match("/^".$regex["ipaddress"]."\/([0-9]|[1,2][0-9]|3[0,1,2])$/",$SUBNET))
	{ $result= 1; }
    elseif (preg_match("/^".$regex["ipaddress"]."\/".$regex["ipaddress"]."$/",$SUBNET))
	{ $result= 2; }
    elseif (preg_match("/^".$regex["ipaddress"]."$/",$SUBNET))
	{ $result= 3; }

    return $result;
}

function AddressIsInRange($IP,$SUBNET) {
    if (!validIP($IP)) { return false; };
    if (!($subnetType=validSubnet($SUBNET))) { return false; };

    $IP= ip2long($IP);

    list($ipAddress, $subnetMask)= preg_split("/\//", $SUBNET);
    $ipAddress= ip2long($ipAddress);

    switch ($subnetType) {
	case 1: $netMask = (pow(2,(int)$subnetMask)-1) << (32-(int)$subnetMask);
	    break;
	case 2: $netMask= ip2long($subnetMask);
	    break;
	case 3: $netMask= ip2long("255.255.255.255");
	    break;
	}

    $netAddress= ($ipAddress & $netMask);
    $IPnetAddress= ($IP & $netMask);

    return ($netAddress===$IPnetAddress);
    }

function hostAllowed() {
	global $REMOTE_ADDR, $hostsallowFile;
	
	$fd = fopen($hostsallowFile,"r");
	$match=0;
	
	$result= FALSE;
	//default value is FALSE
	
	while (($temp= fgets($fd, 4096))&& ($match===0)) {
		list($ALLOWDENY,$RANGE)= preg_split('/:/',$temp);
		
		$ALLOWDENY=trim($ALLOWDENY); $RANGE=trim($RANGE);
		if (!$RANGE) { continue; }
		if (strcasecmp($ALLOWDENY, "ALLOW")===0) { $allowhost= 1; } else { $allowhost= 0; }
		if (AddressIsInRange($REMOTE_ADDR,$RANGE)) {
			$match=1;
			if ($allowhost) { $result=1; }
			else { $result=0; }
			}
		}
	fclose ($fd);
	return $result;
	}
?>