#include <ncurses.h>
#include <stdlib.h>
#include "point.h"
#include "ncdrawlib.h"

point *newPoint(void)
{
point *p;
if ((p = (point *)malloc(sizeof(point)))==NULL)
	{
	fprintf(stderr,"\nOut of memory");
	return NULL;
	}
return p;
}

void freePoint(point *p)
{
if (p == NULL)
	{
	fprintf(stderr, "\nMoron alert");
	return;
	}
free(p);
}

point *initPoint(point *p, float x, float y, float xd, float yd, char c, int attr, int t)
{
p->x = x;
p->y = y;
p->xd = xd;
p->yd = yd;
p->xdd = 0.0;
p->ydd = 0.0;
p->c = c;
p->attr = attr;
p->timer = t;
return p;
}

int movePoint(point *p, int ymax, int xmax)
{
p->timer--;
if (p->x >= xmax || p->x <= 0)
	return 1;		// collision
if (p->y >= ymax)
	return 1;		// collision

p->yd += GRAVITY;

p->xd += p->xdd;	// velocity += acceleration
p->yd += p->ydd;
p->x += p->xd;		// position += velocity
p->y += p->yd;
return 0;			// nothing interesting
}

void drawPoint(point *p)
{
if (p->y <= 0)
	return;
attron(p->attr);
mvwaddch(stdscr, (int)p->y, (int)p->x, p->c);
attroff(p->attr);
}


