#include <unistd.h>
#include <time.h>
#include <ncurses.h>
#include <stdlib.h>
#include "point.h"
#include "list.h"
#include "ncdrawlib.h"

#define FREQUENCY 10

void drawAllPoints(list *l);
list *moveAllPoints(list *l, int ymax, int xmax);

int main(int argc, char *argv[])
{
int xmax, ymax;
list *l=NULL;
int counter = 0;

initDisplay(); // fire up curses

getmaxyx(stdscr, ymax, xmax);
ymax--;
xmax--;
srand(time(NULL));

// define a few sets of colours
init_pair(1, COLOR_RED, COLOR_BLACK);
init_pair(2, COLOR_YELLOW, COLOR_BLACK);

//l = newList();

while(cursGetch(NULL)==-1) // do a getch that'll return quickly (-1==nothing)
	{
	wclear(stdscr);	// clear the screen
	drawAllPoints(l);	

	wrefresh(stdscr);	// blit the graphics to the screen
	usleep(80000);		// wait a bit

	l = moveAllPoints(l, ymax, xmax);
	if (counter==0)
		l = addToList(l, initPoint(newPoint(), rand()%xmax, ymax-1, ((rand()%400)/100.0)-2.0, -(((rand()%200)/100.0)+1), '*', COLOR_PAIR(1), (rand()%5)+6));
	counter++;
	if (counter>FREQUENCY)
		counter=0;
	}

closeDisplay();	// end curses nicely
return 0;
}


void drawAllPoints(list *l)
{
while (l != NULL)
	{
	drawPoint(l->data);
	l = l->next;
	}
}

void explode(list *l, point *p)
{
int i,n;

n = (rand()%5) + 5;

for(i=0;i<n;i++)
addToList(l, initPoint(newPoint(), p->x, p->y, p->xd + ((rand()%200)/100.0)-1.0, p->yd + ((rand()%100)/200.0)-0.25, '.', COLOR_PAIR(2), (rand()%5)+20 ));
}

list *moveAllPoints(list *l, int ymax, int xmax)
{
list *r = l;
while (l != NULL)
	{
	if (movePoint(l->data, ymax, xmax))
		{
		r = removeFromList(l, l->data);
		freePoint(l->data);
		}

	if (l->data->timer <= 0)
		{
		explode(l, l->data);
		r = removeFromList(l, l->data);
		freePoint(l->data);
		}
	l = l->next;
	}
return r;
}


