#include <stdlib.h>
#include <stdio.h>
#include "list.h"
#include "point.h"

list *newList(void)
{
list *l;
if ((l = (list *)malloc(sizeof(list)))==NULL)
	{
	fprintf(stderr,"\nOut of memory");
	return NULL;
	}
l->next = NULL;
l->data = NULL;
return l;
}

void freeList(list *l)
{
if (l == NULL)
	{
	fprintf(stderr, "\nMoron alert");
	return;
	}
free(l);
}

list *addToList(list *l, point *p)
{
list *temp;

if (l==NULL)
	{
	l = newList();
	l->next = NULL;
	l->data = p;
	return l;
	}

if (l->data == NULL && l->next==NULL)
	{
	l->data = p;
	l->next = NULL;
	return l;
	}

while(l->next != NULL)		// find last element
	l = l->next;
temp = l->next = newList();	// stick a new element on it
temp->data = p;			// put n in it
temp->next = NULL;		// terminate
return l;
}

list *removeFromList(list *l, point *p)
{
list *prev = l;
list *orig = l;

if (l == NULL)
	return NULL;

if (l->data == p)
	return l->next;

while(l->next != NULL)
	{
	if (l->data == p)
		{
		prev->next = l->next;
		return orig;
		}
	prev = l;
	l = l->next;
	}

if (prev == l)
	{
	l->data = NULL;
	return orig;
	}
prev->next = NULL;
return orig;
}


