//******************************************************************************
// -----------------------------------------------------------
// tbutton V1.05
// -----------------------------------------------------------
//   Main Applet class for button Applet
// -----------------------------------------------------------
// Author : R. BERTHOU
// E-Mail : rberthou@wanadoo.fr
// URL    : http://perso.wanadoo.fr/rberthou
// -----------------------------------------------------------
// Ver  * Author     *  DATE    * Description
// ....................DD/MM/YY...............................
// 1.00 * R. BERTHOU * 21/05/97 * Creation 
//******************************************************************************

import java.awt.Event;
import java.awt.Graphics;
import java.awt.Color;
import java.awt.Image;
import java.awt.MediaTracker;

import java.net.URL;
import java.net.MalformedURLException;
import java.lang.InterruptedException;
import java.applet.Applet;

public class tbutton extends java.applet.Applet{
	private	Image buffer;
	private	Image button ;
	private	Graphics offScreen;
	private	boolean onButt = false;
	private	boolean pressedButt = false;
	private	int onIs = 0;
	private	URL clickDest;
	private	String dest;
	private	String targ;
	private	String sBulle;
	private	int iMode;
	private	int backcolour ;

	int appletWidth, appletHeight;

	public void init(){
		String temp;

		// initialise the double buffering screen

		MediaTracker  trk = new MediaTracker(this) ;
		temp = getParameter("img");
		if (temp != null) {
			button =  getImage(getCodeBase(), temp);
			trk.addImage(button, 0) ;
		}
		try {
			trk.waitForAll() ;
//			iLoad = !trk.isErrorAny() ;
		} catch (InterruptedException e) {
		}

/*		appletWidth  = button.getWidth(this) ;
		appletHeight = button.getHeight(this);

		resize(appletWidth, appletHeight) ;
		pack() ;
		show() ;
*/
		try {
			appletWidth = size().width;
			appletHeight = size().height;
			buffer = createImage (appletWidth, appletHeight);
			offScreen = buffer.getGraphics ();
		} catch (Exception e) {
			offScreen = null;
		}


		temp = getParameter("backcolour");
		backcolour= (temp==null) ? 0xffffff : Integer.parseInt( temp );

		temp = getParameter("tl");
		iMode= (temp==null) ? 0 : Integer.parseInt( temp );

		sBulle = getParameter("texte");

		temp = getParameter("target");
		targ= (temp==null) ? "_self" : temp ;

		dest = getParameter("link");
		try{
			if (iMode != 1)
				clickDest = new URL(getCodeBase(), dest);
			else
				clickDest = new URL(dest);
		}catch(MalformedURLException mal){
			System.out.println("Bad URL!");
		}


}

  public void start(){
		repaint();
  }

  public void stop(){
  }

  public void destroy(){
  }

  public boolean mouseDown(Event e, int x, int y){
		pressedButt = true;
		repaint();
		return(true);
  }


  public boolean mouseUp(Event e, int x, int y){
	if(pressedButt && onButt){
		pressedButt = false;
		repaint();
		getAppletContext().showDocument(clickDest, targ);
	}else{
		pressedButt = false;
		repaint();
	}
	return(true);
  }


  public boolean mouseEnter(Event e, int x, int y){
		onButt = true;
		showStatus(dest);
		repaint();
		return(true);
  }


  public boolean mouseExit(Event e, int x, int y){
	  pressedButt=false;
	  onButt = false;
	  showStatus("");
	  repaint();
	  return(true);
  }

	// Called when the applet needs to be painted
	// calls the flicker free updating system
	public void paint (Graphics g) {
		update(g);
	} // end of paint


	// Draw the applet without flicker
	public synchronized void update(Graphics g) {
		if(onButt) {
			onIs = 1;
			if(pressedButt)
				onIs = 2;
      }
		else
			onIs = 0;

		if (offScreen!=null) {
			paintApplet(offScreen);
			g.drawImage(buffer,0,0,this);
		} else
			paintApplet(g);
	} // end of update

	// Paint the applet into whatever image
	public void paintApplet(Graphics g) {
		if (onIs > 0) {
			if (onIs == 2)
				g.drawImage(button,2,2,this);
         else
				g.drawImage(button,0,0,this);

			if (sBulle!=null) {
				g.setColor(new Color(0xffffff));
				g.fillRect(4,4,appletWidth-12,12);
				g.setColor(new Color(0x000000));
				g.drawRect(4,4,appletWidth-12,12);
				g.drawString (sBulle, 6, 15 );
         }

			g.setColor(new Color(backcolour));
	 		g.draw3DRect(2, 2, appletWidth-5, appletHeight-5, (onIs == 1)) ;
	 		g.draw3DRect(1, 1, appletWidth-3, appletHeight-3, (onIs == 1)) ;
	 		g.draw3DRect(0, 0, appletWidth-1, appletHeight-1, (onIs == 1)) ;
      }
      else
			g.drawImage(button,0,0,this);


	 }

	public String getAppletInfo() {
		return "tbutton v1.05 * Button Applet by R. BERTHOU (1996) - E-Mail : rberthou@pratique.fr";
	} // end of getAppletInfo



	// Return the parameter information on the applet
	public String[][] getParameterInfo() {
		String[][] info = {
			{"img",	 		"text",		"name image"},
			{"backcolour",  "int",		"rrggbb info"},
			{"tl", 			"int",	 	"1 = full URL"},
			{"link", 		"text", 	"dest. URL"},
			{"target", 		"text", 	"target dest."},
			{"texte", 		"text",		"texte display"}
		};
		return info;
	} // end of getParameterInfo

}

