#!/bin/perl
$| = 1;
#####################################
#                                   #
# RobPoll v1.1                      #
# Copyright 1998 by Rob Eisler      #
# eislerr@tdi.uregina.ca            #
# http://tdi.uregina.ca/~eislerr    #
#                                   #
# Last modified on Sept 12, 1998    #
#                                   #
#####################################
#
# Copyright Notice:
# Copyright 1998 Robert S. Eisler.  All Rights Reserved.
#
# This code may be used and modified by anyone so long as this header and
# copyright information remains intact.  By using this code you agree to
# indemnify Robert S. Eisler from any liability that might arise from its
# use.  You must obtain written consent before selling or redistributing
# this code.
#
#####################################
#
# The cookie functions used in this script are based on the HTTP
# Cookie Library 2.1 by Matt Wright. The copyright information for his
# library are at the end of the readme.txt. Check out Matt's Script 
# Archive: http://www.worldwidemart.com/scripts
#
#####################################

# declare the variables

$polldir = '/path/to/your/poll';
$graph_image = 'http://www.yourhost.com/~yoursite/white.jpg';
$cgi = 'http://www.yourhost.com/~yoursite/cgi-bin/robpoll.cgi';

$check_cookies = 1;                # how to block multi-voting
$check_ip = 0;                     # 1 = use, 0 = don't

# the following variable is only for the SSI poll
$return_page = 'http://www.yourhost.com/~yoursite/return.html';

# the rest are only for the full-page poll

$tablecolor = 'lightgrey';         # these colors can be entered as a word like
$textcolor = 'black';              # 'black' or an RGB value like '#FFFFFF'
$textfont = 'arial';
$textsize = 3;
$border = 1;
$cellpadding = 2;
$cellspacing = 1;
$graph_height = 10;
$graph_width = 3;                  # factor for the graph width - the width of 
                                   # the graph in pixels = percent * graph_width

$include_percent = 1;              # 1 = include this option, 0 = don't
$include_graph = 0;
$include_total = 1;

#########################################################################
# Don't change anything below here unless you know what you're doing :) #
#########################################################################

read(STDIN, $input, $ENV{'CONTENT_LENGTH'});

@pairs = split(/&/, $input);
foreach $pair (@pairs) {

        ($name, $value) = split(/=/, $pair);

        $name =~ tr/+/ /;
        $name =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
        $value =~ tr/+/ /;
        $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;

        $value =~ s/<!--(.|\n)*-->//g;
        $FORM{$name} = $value;
}

$ip = $ENV{REMOTE_ADDR};
$ssi = 'false';
$ssi_total = $include_percent + $include_graph + 2;
$polldata = "$polldir/data.txt";
$return_page .= "?results";
$Cookie_Exp_Date = 'Tue, 31-Dec-1999 00:00:00 GMT';
$Secure_Cookie = '0';
$Cookie_Path = '/';

@Cookie_Encode_Chars = ('\%', '\+', '\;', '\,', '\=', '\&', '\:\:', '\s');

%Cookie_Encode_Chars = ('\%',   '%25',
                        '\+',   '%2B',
                        '\;',   '%3B',
                        '\,',   '%2C',
                        '\=',   '%3D',
                        '\&',   '%26',
                        '\:\:', '%3A%3A',
                        '\s',   '+');

@Cookie_Decode_Chars = ('\+', '\%3A\%3A', '\%26', '\%3D', '\%2C', '\%3B', '\%2B', '\%25');

%Cookie_Decode_Chars = ('\+',       ' ',
                        '\%3A\%3A', '::',
                        '\%26',     '&',
                        '\%3D',     '=',
                        '\%2C',     ',',
                        '\%3B',     ';',
                        '\%2B',     '+',
                        '\%25',     '%');

open(FILE, "$polldata") || &file_open_error($polldata);
@lines = <FILE>;
close(FILE);
$num = @lines;

($num_questions,$nochop) = split(/``/,$lines[0]);
(@num_answers) = split(/``/,$lines[1]);
(@q_id) = split(/``/,$lines[2]);
(@questions) = split(/``/,$lines[3]);
(@answers) = split(/``/,$lines[4]);
($encrypted_password, $nochop) = split(/``/, $lines[5]);

$total_answers[0] = 0;

for ($a = 1; $a < $num_questions; $a++) {
	$total_answers[$a] = $total_answers[$a-1] + $num_answers[$a-1];
}

$what = $FORM{'what'};
$what = $ENV{'QUERY_STRING'} unless ($what);

$ssi = 'true' if ($what eq 'votessi');
&vote if ($what eq 'vote' || $what eq 'votessi');
&results($FORM{'q'}) if ($what eq 'results');

print "Content-type: text/html\n\n";

&start if ($what eq 'start');
&select_q if ($what eq 'select_q');
&admin if ($what eq 'admin');
&add if ($what eq 'add');
&add2 if ($what eq 'add2');
&remove if ($what eq 'remove');
&remove2 if ($what eq 'remove2');
&passwd if ($what eq 'pass');
&setpass if ($what eq 'setpass');

&fatal_error("Error in HTML Form 'what' Variable");

exit;

sub start {

	for ($a = 0; $a < $num_questions; $a++) {

		&check($a);
		if ($foundip eq 'Yes') {
			$voted[$a] = 'Yes';
		} else {
			$voted[$a] = 'No';
		}

	}

	print "<html>\n";
	print "<head><title>Please Select a Topic</title></head>\n";
	print "<body bgcolor=white text=black link=blue vlink=blue>\n";
	print "<font face=arial>\n";
	print "<center>\n";
	print "<h2>Please Select a Topic</h2>\n";

	print "<table border=0 cellpadding=8>\n";

	for ($a = 1; $a <= $num_questions; $a++) {
		print "<tr bgcolor=$tablecolor>\n";
		print "<td align=center><font face=$textfont size=$textsize color=$textcolor>Question $a</td>\n";
		print "<td align=left><font face=$textfont size=$textsize color=$textcolor>$questions[$a-1]<br>\n";
		$b = $a - 1;

		if ($voted[$a-1] eq 'No') {
			print "<b>You have not voted on this topic yet.</b></td>\n";
			print "<td valign=center align=center><br><form action=\"$cgi\" method=\"post\">\n";
			print "<input type=\"hidden\" name=\"what\" value=\"select_q\">\n";
			print "<input type=\"hidden\" name=\"q\" value=\"$a\">\n";
			print "<input type=\"submit\" value=\"Vote\">\n";
			print "</form></td>\n";
			print "<td valign=center align=center><br><form action=\"$cgi\" method=\"post\">\n";
			print "<input type=\"hidden\" name=\"what\" value=\"results\">\n";
			print "<input type=\"hidden\" name=\"q\" value=\"$b\">\n";
			print "<input type=\"submit\" value=\"View Results\"></form></td>\n";
		} else {
			print "<b>You have already voted on this topic.</b></td>\n";
			print "<td valign=center align=center colspan=2><br><form action=\"$cgi\" method=\"post\">\n";
			print "<input type=\"hidden\" name=\"what\" value=\"results\">\n";
			print "<input type=\"hidden\" name=\"q\" value=\"$b\">\n";
			print "<input type=\"submit\" value=\"View Results\">\n";
			print "</form></td>\n";
		}

		print "</tr>\n";

	}

	print "</table>\n";
	print "<center><a href=\"http://tdi.uregina.ca/~eislerr/cgi/index.html\">Rob's Perl</a></center>\n";

	print "</font></center></body></html>\n";

	exit;

}

sub select_q {

	$q = $FORM{'q'};
	$voted = $FORM{'voted'};
	&check($q-1);
	&results($q-1) if ($voted eq 'Yes' || $foundip eq 'Yes');

	print "<html>\n";
	print "<head><title>$questions[$q-1]</title></head>\n";
	print "<body bgcolor=white text=black link=blue vlink=blue>\n";
	print "<font face=arial>\n";
	print "<center>\n";
	print "<form action=\"$cgi\" method=\"post\">\n";
	print "<h2>$questions[$q-1]</h2>\n";

	print "<table border=0 cellpadding=8>\n";

	for ($b = $total_answers[$q-1]; $b < $total_answers[$q-1]+$num_answers[$q-1]; $b++) {
                $c = $b-$total_answers[$q-1] + 1;
		print "<tr bgcolor=$tablecolor>\n";
		print "<td><input type = \"radio\" name=\"response\" value=\"$c\"></td>\n";
                print "<td align=left><font face=$textfont size=$textsize color=$textcolor>$answers[$b]</td></tr>\n";
        }

	print "</table>\n";

	print "<input type=\"hidden\" name=\"what\" value=\"vote\">\n";
	print "<input type=\"hidden\" name=\"q\" value=\"$q\">\n";
	print "<input type=\"submit\" value=\"Submit Vote\">\n";
	print "</form>\n";
	print "</center></font></body></html>\n";

	exit;

}

sub vote {

	$q = $FORM{'q'};
	$q--;
	if ($FORM{'response'}) {

		$v = $FORM{'response'};
		$v--;
		&check($q);
		&results($q) if ($foundip eq 'Yes' && $ssi eq 'false');
		&ssi_results($q) if ($foundip eq 'Yes' && $ssi eq 'true');

		if ($check_ip) {
			open(FILE, ">>$polldir/ip$q_id[$q]\.txt") || &file_open_error("ip$q_id[$q]\.txt");
			print FILE "\n$ip``x\n";
			close(FILE);
		}

		if ($check_cookies) {
			$set_me = '';
			for ($f = 0; $f < @answered - 1; $f++) {
				$set_me .= ",$answered[$f]";
			}
			$set_me .= ",$q_id[$q]";
			$set_me .= ",xx";
			&SetCookies('questions',$set_me);
		}

		open(FILE, "$polldir/q$q_id[$q]\.txt") || &file_open_error("q$q_id[$q]\.txt"); 
		@lines = <FILE>;
		close(FILE);

		@numbers = split(/``/, $lines[0]);
		$numbers[$v]++;

		open(FILE, ">$polldir/q$q_id[$q]\.txt") || &file_open_error("q$q_id[$q]\.txt");
		for ($a = 0; $a < $num_answers[$q]; $a++) {
			print FILE "$numbers[$a]";
			print FILE "``";
		}
		print FILE "x";
		close(FILE);

		&results($q) if ($ssi eq 'false');
		&ssi_results;

	} else {
		print "Content-type: text/html\n\n";
		&fatal_error("No Response Selected");
	}

	exit;

}

sub results {

	print "Content-type: text/html\n\n";
	local($qu) = @_;
	open(FILE, "$polldir/q$q_id[$qu]\.txt") || &file_open_error("q$q_id[$qu]\.txt");
	@lines = <FILE>;
	close(FILE);
	@values = split(/``/, $lines[0]);
	$nv = @values;
	$total = 0;

	for ($a = 0; $a < $nv; $a++) {
		$total += $values[$a];
	}

	for ($a = 0; $a < $nv; $a++) {
		if ($values[$a] > 0) {
			$values_p[$a] = sprintf("%.2f", ($values[$a]/$total) * 100);
		} else {
			$values_p[$a] = 0;
		}
		$values_g[$a] = int($graph_width*$values_p[$a])+1;
	}

	print "<html>\n";
	print "<head><title>Results</title></head>\n";
	print "<body bgcolor=white text=black link=blue vlink=blue>\n";
	print "<font face=arial>\n";
	print "<center>\n";
	print "<h2>$questions[$qu]</h2>\n";
	print "<table border=1 bgcolor=$tablecolor>\n";
	print "<tr>\n";
	print "<th><font face=$textfont size=$textsize color=$textcolor>RESPONSE</font></th>\n";
	print "<th><font face=$textfont size=$textsize color=$textcolor>VOTES</font></th>\n";
	if ($include_percent == 1) {
		print "<th><font face=$textfont size=$textsize color=$textcolor>PERCENT</font></th>\n";
	}
	if ($include_graph == 1) {
		print "<th><font face=$textfont size=$textsize color=$textcolor>GRAPH</font></th>\n";
	}
	print "</tr>\n";

	$c = 0;
	for ($b = $total_answers[$qu]; $b < $total_answers[$qu]+$num_answers[$qu]; $b++) {
		print "<tr>\n";
		print "<td align=left><font face=$textfont size=$textsize color=$textcolor>$answers[$b]</font></td>\n";
		print "<td align=center><font face=$textfont size=$textsize color=$textcolor>$values[$c]</font></td>\n";
		if ($include_percent == 1) {
			print "<td align=center><font face=$textfont size=$textsize color=$textcolor>$values_p[$c] %</font></td>\n";
		}
		if ($include_graph == 1) {
			print "<td align=left><img src=\"$graph_image\" height=\"$graph_height\" ";
			print "width=\"$values_g[$c]\"></td></tr>\n";
		}
		$c++;
	}

	if ($include_total == 1) {
		print "<tr>\n";
		print "<th><font face=$textfont size=$textsize color=$textcolor>TOTAL</font></th>\n";
		print "<th><font face=$textfont size=$textsize color=$textcolor>$total</font></th>\n";
		if ($include_percent == 1) {
			print "<th><font face=$textfont size=$textsize color=$textcolor>100.00 %</font></th>\n";
		}
		if ($include_graph == 1) {
			print "<td><font color=$tablecolor>..</font></td>\n";
		}
	}
	print "</tr>\n";
	print "</table>\n";

	print "<form action=\"$cgi\" method=\"post\">\n";
	print "<input type=\"hidden\" name=\"what\" value=\"start\">\n";
	print "<input type=\"submit\" value=\"Back to Question Select\">\n";
	print "</form>\n";
	print "</center></body></html>\n";

	exit;

}

sub ssi_results {
	print "HTTP/1.0 302 Temporary Redirection\r\n" if $ENV{PERLXS} eq "PerlIS";
	print "Content-type: text/html\n";
	print ("Location: $return_page\n\n");
	exit;
}

sub check {

	local($qu) = @_;
	$foundip = 'No';

	if ($check_cookies) {
		if (&GetCookies('questions')) {
			(@answered) = split(/,/,$Cookies{'questions'});
			for ($f = 0; $f < @answered - 1; $f++) {	
				$foundip = 'Yes' if ($answered[$f] == $q_id[$qu]);
			}
		}
	}

	if ($check_ip) {
		open(FILE, "$polldir/ip$q_id[$qu]\.txt") || &file_open_error("ip$q_id[$qu]\.txt");
		@lines = <FILE>;
		close(FILE);
		$numip = @lines;
		$voted[$a] = 'No';
		for ($b = 0; $b < $numip; $b++) {
			($check_ip,$nochop) = split(/``/,$lines[$b]);
			if ($check_ip eq $ip) {
				$foundip = 'Yes';
				$b = $numip;
			}
		}
	}

}

sub admin {

	print "<html>\n";
	print "<head><title>RobPoll Admin</title></head>\n";
	print "<body bgcolor=white text=black>\n";
	print "<font face=arial>\n";
	print "<center>\n";
	print "<h2>Admin</h2>\n";

	print "<form action=\"$cgi\" method=\"post\">\n";
	print "<input type=\"hidden\" name=\"what\" value=\"add\">\n";
	print "<input type=\"submit\" value=\"Add a New Question\">\n";
	print "</form><p>\n";

	print "<form action=\"$cgi\" method=\"post\">\n";
	print "<input type=\"hidden\" name=\"what\" value=\"remove\">\n";
	print "<input type=\"submit\" value=\"Remove a Question\">\n";
	print "</form><p>\n";

	print "<form action=\"$cgi\" method=\"post\">\n";
	print "<input type=\"hidden\" name=\"what\" value=\"pass\">\n";
	print "<input type=\"submit\" value=\"Change Password\">\n";
	print "</form><p>\n";

	print "<a href=\"http://tdi.uregina.ca/~eislerr/\">Rob's Place</a>\n";
	print "</center></font></body></html>\n";

	exit;

}

sub add {

	print "<html>\n";
	print "<head><title>Add a New Question</title></head>\n";
	print "<body bgcolor=white text=black>\n";
	print "<font face=arial>\n";
	print "<center>\n";
	print "<h2>Add a New Question</h2>\n";
	
	print "<form action=\"$cgi\" method=\"post\">\n";

	print "Password:\n";
	print "<input type=\"password\" size=20 name=\"pass\">\n";

	print "<table border=0 bgcolor=lightgrey>\n";
	print "<tr><td align=center colspan=2>\n";
	print "<font face=arial>Please enter the new question:</font><br>\n";
	print "<input type=text name=question size=50></td></tr>\n";

	print "<tr><td align=center colspan=2>\n";
	print "<font face=arial>Please enter the number of available responses:</font>\n";

	print "<select size=1 name=\"num_responses\">\n";

	for ($a = 2; $a < 21; $a++) {
		print "<option value=\"$a\">$a</option>\n";
	}

	print "</select>\n";
	print "</td></tr>\n";

	print "<tr><td align=center colspan=2>\n";
	print "<font face=arial>Please enter the available responses:</font></td></tr>\n";

	for ($a = 0; $a < 20; $a++) {
		$aa = $a + 1;
		print "<tr><td>$aa</td>\n";
		print "<td><input type=\"text\" name=\"r$a\" size=50></td></tr>\n";
	}
	print "<tr><td align=center colspan=2>\n";
	print "<input type=\"hidden\" name=\"what\" value=\"add2\">\n";
	print "<input type=\"submit\" value=\"Add This Information\">\n";
	print "</td></tr></table>\n";
	print "</form>\n";
	print "</center></font></body></html>\n";

	exit;

}

sub add2 {

	$new_q = $FORM{'question'};
	$num_r = $FORM{'num_responses'};

	&badpass if ($encrypted_password ne crypt($FORM{'pass'}, substr($encrypted_password, 0, 2)));

	for ($a = 0; $a < $num_r; $a++) {
		if ($FORM{"r$a"}) {
			$r[$a] = $FORM{"r$a"};
		} else {
			$b = $a+1; 
			&fatal_error("Response Number $b Not Entered");
		}
	}

	open(NUMBER,"$polldir/num.txt") || &file_open_error("num.txt");
	$num = <NUMBER>;
	close(NUMBER);
	if ($num == 99999)  {
		$num = "1";
	}
	else {
		$num++;
	}

	open(NUM,">$polldir/num.txt") || &file_open_error("num.txt");
	print NUM "$num";
	close(NUM);

	$num_questions++;

	open (FILE, ">$polldir/data.txt") || &file_open_error("data.txt");
	print FILE "$num_questions``x\n";

	for ($a = 0; $a < $num_questions-1; $a++) {
		print FILE "$num_answers[$a]";
		print FILE "``";
	}
	print FILE "$num_r";
	print FILE "``x\n";

	for ($a = 0; $a < $num_questions-1; $a++) {
		print FILE "$q_id[$a]";
		print FILE "``";
	}
	print FILE "$num";
	print FILE "``x\n";

	for ($a = 0; $a < $num_questions-1; $a++) {
		print FILE "$questions[$a]";
		print FILE "``";
	}
	print FILE "$new_q";
	print FILE "``x\n";

	$total_a = @answers;

	for ($a = 0; $a < $total_a-1; $a++) {
		print FILE "$answers[$a]";
		print FILE "``";
	}

	for ($a = 0; $a < $num_r; $a++) {
		print FILE "$r[$a]";
		print FILE "``";
	}
	print FILE "x\n";
	print FILE "$encrypted_password";
	print FILE "``x\n";
	close(FILE);

	open(FILE, ">$polldir/q$num\.txt") || &file_open_error("q$num\.txt");
	for ($a = 0; $a < $num_r; $a++) {
		print FILE "0``";
	}
	print FILE "x";
	close(FILE);

	open(FILE, ">$polldir/ip$num\.txt") || &file_open_error("ip$num\.txt");
	print FILE "zzz.zzz.zzz.zzz``x\n";
	close(FILE);

	print "<html>\n";
	print "<head><title>Finished</title></head>\n";
	print "<body bgcolor=white text=black>\n";
	print "<font face=arial>\n";
	print "<center>\n";
	print "<h2>The following information was added</h2>\n";

	print "<table bgcolor=lightgrey>\n";

	print "<tr><th>$new_q</th></tr>\n";

	print "<tr><td align=center>\n";

	for ($a = 0; $a < $num_r; $a++) {
		print "$r[$a]<br>\n";
	}

	print "</td></tr>\n";
	print "</table>\n";

	print "<form action=\"$cgi\" method=\"post\">\n";
	print "<input type=\"hidden\" name=\"what\" value=\"admin\">\n";
	print "<input type=\"submit\" value=\"Back to Admin\">\n";
	print "</form>\n";
	print "</center></font></body></html>\n";
	
	exit;

}

sub remove {

	&remove_last if ($num_questions < 2);

	print "<html>\n";
	print "<head><title>Remove a Question</title></head>\n";
	print "<body bgcolor=white text=black>\n";
	print "<font face=arial>\n";
	print "<center>\n";
	print "<h2>Remove a Question</h2>\n";

	print "<form action=\"$cgi\" method=\"post\">\n";
	
	print "Password:\n";
	print "<input type=\"password\" size=20 name=\"pass\">\n";

	print "<table bgcolor=lightgrey>\n";

	for ($a = 0; $a < $num_questions; $a++) {

		print "<tr>\n";
		print "<td><input type=\"radio\" name=\"q\" value=\"$a\"></td>\n";
		print "<td align=left>$questions[$a]</td>\n";
		print "</tr>\n";

	}
	
	print "<tr><td align=center colspan=2>\n";
	print "<input type=\"hidden\" name=\"what\" value=\"remove2\">\n";
	print "<input type=\"submit\" value=\"Remove the Selected Question\"></td></tr>\n";
	
	print "</table>\n";
	print "</form>\n";
	print "</center></form></body></html>\n";

	exit;

}

sub remove2 {

	&remove_last if ($num_questions < 2);
	&badpass if ($encrypted_password ne crypt($FORM{'pass'}, substr($encrypted_password, 0, 2)));
	$question = $FORM{'q'};

	open (FILE, ">$polldir/data.txt") || &file_open_error("data.txt");

	$tempxxx = $num_questions - 1;

	print FILE "$tempxxx";
	print FILE "``x\n";

	for ($a = 0; $a < $question; $a++) {
		print FILE "$num_answers[$a]";
		print FILE "``";
	}
	
	for ($a = $question+1; $a < $num_questions; $a++) {
		print FILE "$num_answers[$a]";
		print FILE "``";
	}
	print FILE "x\n";

	for ($a = 0; $a < $question; $a++) {
		print FILE "$q_id[$a]";
		print FILE "``";
	}

	for ($a = $question+1; $a < $num_questions; $a++) {
		print FILE "$q_id[$a]";
		print FILE "``";
	}
	print FILE "x\n";

	for ($a = 0; $a < $question; $a++) {
		print FILE "$questions[$a]";
		print FILE "``";
	}

	for ($a = $question+1; $a < $num_questions; $a++) {
		print FILE "$questions[$a]";
		print FILE "``";
	}
	print FILE "x\n";

	for ($a = 0; $a < $total_answers[$question]; $a++) {
		print FILE "$answers[$a]";
		print FILE "``";
	}

	$na = @answers;
	for ($a = $total_answers[$question] + $num_answers[$question]; $a < $na-1; $a++) {
		print FILE "$answers[$a]";
		print FILE "``";
	}
	print FILE "x\n";
	print FILE "$encrypted_password";
	print FILE "``x\n";
	close(FILE);

	&del_file("$polldir/q$q_id[$question]\.txt");
	&del_file("$polldir/ip$q_id[$question]\.txt");

	print "<html>\n";
	print "<head><title>Finished</title></head>\n";
	print "<body bgcolor=white text=black>\n";
	print "<font face=arial>\n";
	print "<center>\n";
	print "<h2>\"$questions[$question]\" was removed</h2>\n";

	print "<form action=\"$cgi\" method=\"post\">\n";
	print "<input type=\"hidden\" name=\"what\" value=\"admin\">\n";
	print "<input type=\"submit\" value=\"Back to Admin\">\n";
	print "</form>\n";

	print "</center>\n";
	print "</font></body></html>";
	
	exit;

}

sub passwd {

	print "<html>\n";
	print "<head><title>Change Password</title></head>\n";
	print "<body bgcolor=white text=black>\n";
	print "<font face=arial>\n";
	print "<center>\n";
	print "<h2>Change Password</h2>\n";

	print "<form action=\"$cgi\" method=\"post\">\n";

	print "<table border=0>\n";

	print "<tr><td align=right>Password:</td>\n";
	print "<td><input type=\"password\" size=20 name=\"pass\"></td></tr>\n";

	print "<tr><td align=right>New Password:</td>\n";
	print "<td><input type=\"password\" size=20 name=\"newpass1\"></td></tr>\n";

	print "<tr><td align=right>Retype Password:</td>\n";
	print "<td><input type=\"password\" size=20 name=\"newpass2\"></td></tr>\n";

	print "<tr><td align=center colspan=2>\n";
	print "<input type=\"hidden\" name=\"what\" value=\"setpass\">\n";
	print "<input type=\"submit\" value=\"Submit New Password\">\n";
	print "</td></tr>\n";
	print "</table>\n";

	print "</form>\n";
	print "</center></form></body></html>\n";
	exit;

}

sub setpass {

	&badpass if ($encrypted_password ne crypt($FORM{'pass'}, substr($encrypted_password, 0, 2)));
	&fatal_error("The Two New Password Fields Don't Match") if ($FORM{'newpass1'} ne $FORM{'newpass2'});
	&fatal_error("No New Password Entered") if ($FORM{'newpass1'} eq "");

	$write_pass = crypt($FORM{'newpass1'}, substr($encrypted_password, 0, 2));

	open (FILE, ">$polldir/data.txt") || &file_open_error("data.txt");
	print FILE "$num_questions``x\n";

	for ($a = 0; $a < $num_questions; $a++) {
		print FILE "$num_answers[$a]";
		print FILE "``";
	}
	print FILE "x\n";

	for ($a = 0; $a < $num_questions; $a++) {
		print FILE "$q_id[$a]";
		print FILE "``";
	}
	print FILE "x\n";

	for ($a = 0; $a < $num_questions; $a++) {
		print FILE "$questions[$a]";
		print FILE "``";
	}
	print FILE "x\n";

	$total_a = @answers;

	for ($a = 0; $a < $total_a-1; $a++) {
		print FILE "$answers[$a]";
		print FILE "``";
	}

	print FILE "x\n";
	print FILE "$write_pass";
	print FILE "``x\n";
	close(FILE);

	print "<html>\n";
	print "<head><title>Finished</title></head>\n";
	print "<body bgcolor=white text=black>\n";
	print "<font face=arial>\n";
	print "<center>\n";
	print "<h2>Password Changed</h2>\n";

	print "<form action=\"$cgi\" method=\"post\">\n";
	print "<input type=\"hidden\" name=\"what\" value=\"admin\">\n";
	print "<input type=\"submit\" value=\"Back to Admin\">\n";
	print "</form>\n";

	print "</center>\n";
	print "</font></body></html>";
	
	exit;


}

sub GetCookies {

    local(@ReturnCookies) = @_;
    local($cookie_flag) = 0;
    local($cookie,$value);

    if ($ENV{'HTTP_COOKIE'}) {

        if ($ReturnCookies[0] ne '') {

            foreach (split(/; /,$ENV{'HTTP_COOKIE'})) {

                ($cookie,$value) = split(/=/);

                foreach $char (@Cookie_Decode_Chars) {
                    $cookie =~ s/$char/$Cookie_Decode_Chars{$char}/g;
                    $value =~ s/$char/$Cookie_Decode_Chars{$char}/g;
                }

                foreach $ReturnCookie (@ReturnCookies) {
                    if ($ReturnCookie eq $cookie) {
                        $Cookies{$cookie} = $value;
                        $cookie_flag = "1";
                    }
                }
            }

        }
        else {

            foreach (split(/; /,$ENV{'HTTP_COOKIE'})) {
                ($cookie,$value) = split(/=/);

                foreach $char (@Cookie_Decode_Chars) {
                    $cookie =~ s/$char/$Cookie_Decode_Chars{$char}/g;
                    $value =~ s/$char/$Cookie_Decode_Chars{$char}/g;
                }

                $Cookies{$cookie} = $value;
            }
            $cookie_flag = 1;
        }
    }

    return $cookie_flag;
}

sub SetCookieExpDate {

    if ($_[0] =~ /^\w{3}\,\s\d{2}\-\w{3}-\d{4}\s\d{2}\:\d{2}\:\d{2}\sGMT$/ || $_[0] eq '') {
        $Cookie_Exp_Date = $_[0];
        return 1;
    }
    else {
        return 0;
    }
}

sub SetCookiePath {
    $Cookie_Path = $_[0];
}

sub SetCookies {

    local(@cookies) = @_;
    local($cookie,$value,$char);

    while( ($cookie,$value) = @cookies ) {

        foreach $char (@Cookie_Encode_Chars) {
            $cookie =~ s/$char/$Cookie_Encode_Chars{$char}/g;
            $value =~ s/$char/$Cookie_Encode_Chars{$char}/g;
        }

        print 'Set-Cookie: ' . $cookie . '=' . $value . ';';

        if ($Cookie_Exp_Date) {
            print ' expires=' . $Cookie_Exp_Date . ';';
        }

        if ($Cookie_Path) {
            print ' path=' . $Cookie_Path . ';';
        }

        if ($Cookie_Domain) {
            print ' domain=' . $Cookie_Domain . ';';
        }

        if ($Secure_Cookie) {
            print ' secure';
        }

        print "\n";

        shift(@cookies); shift(@cookies);
    }
}

sub del_file {
	local($filename) = @_;
	unlink("$filename") if (-e $filename);
}

sub remove_last {
	&fatal_error("Can't Remove Last Question");
	exit;
}

sub badpass {
	&fatal_error("Invalid Password");
	exit;
}

sub file_open_error {
	local($err) = @_;
	&fatal_error("Can't Open $err");
	exit;
}

sub fatal_error {
	local($e) = @_;

	print "<html>\n";
	print "<head><title> RobPoll Fatal Error </title></head>\n";
	print "<body bgcolor=white text=black link=blue vlink=blue>\n";
	print "<font face=arial><center>\n";
	print "<h2>RobRing Fatal Error</h2>\n";

	print "<blockquote>\n";
	print "RobPoll experienced an unrecoverable error. The error seems\n";
	print "to be:<p>\n";

	print "<b>$e</b><p>\n\n";

	print "If this error continues, you should contact the administrator.<p>\n";

	print "<a href=\"$ENV{HTTP_REFERER}\">Back</a>\n";
	print "</blockquote>\n";
	print "</center>";
	print "</font></body></html>\n";
	exit;
}
