#!/bin/perl
$| = 1;
#####################################
#                                   #
# RobPoll v1.1                      #
# Copyright 1998 by Rob Eisler      #
# eislerr@tdi.uregina.ca            #
# http://tdi.uregina.ca/~eislerr    #
#                                   #
# Last modified on Sept 12, 1998    #
#                                   #
#####################################
#
# Copyright Notice:
# Copyright 1998 Robert S. Eisler.  All Rights Reserved.
#
# This code may be used and modified by anyone so long as this header and
# copyright information remains intact.  By using this code you agree to
# indemnify Robert S. Eisler from any liability that might arise from its
# use.  You must obtain written consent before selling or redistributing
# this code.
#
#####################################
#
# The cookie functions used in this script are based on the HTTP
# Cookie Library 2.1 by Matt Wright. The copyright information for his
# library are at the end of the readme.txt. Check out Matt's Script 
# Archive: http://www.worldwidemart.com/scripts
#
#####################################

# declare the variables

$q = 1;                        # the question you want to ask

$polldir = '/path/to/your/poll';
$graph_image = 'http://www.yourhost.com/~yoursite/poll/white.jpg';
$cgi = 'http://www.yourhost.com/~yoursite/cgi-bin/robpoll.cgi';

$check_cookies = 1;            # how to block multi-voting
$check_ip = 0;                 # 1 = use, 0 = don't

$tablecolor = 'lightgrey';     # these colors can be entered as a word like
$textcolor = 'black';          # 'black' or an RGB value like '#FFFFFF'
$textfont = 'arial';
$textsize = 1;
$border = 0;
$cellpadding = 2;
$cellspacing = 1;

$graph_height = 5;
$graph_width = 0.5;            # factor for the graph width

$include_percent = 1;          # 1 = include this option, 0 = don't
$include_graph = 0;
$include_total = 1;

#########################################################################
# Don't change anything below here unless you know what you're doing :) #
#########################################################################

print "Content-type: text/html\n\n";

$ip = $ENV{REMOTE_ADDR};
$ssi_total = $include_percent + $include_graph + 2;
$polldata = "$polldir/data.txt";
$Cookie_Exp_Date = 'Tue, 31-Dec-1999 00:00:00 GMT';
$Secure_Cookie = '0';
$Cookie_Path = '/';

@Cookie_Encode_Chars = ('\%', '\+', '\;', '\,', '\=', '\&', '\:\:', '\s');

%Cookie_Encode_Chars = ('\%',   '%25',
                        '\+',   '%2B',
                        '\;',   '%3B',
                        '\,',   '%2C',
                        '\=',   '%3D',
                        '\&',   '%26',
                        '\:\:', '%3A%3A',
                        '\s',   '+');

@Cookie_Decode_Chars = ('\+', '\%3A\%3A', '\%26', '\%3D', '\%2C', '\%3B', 
'\%2B', '\%25');

%Cookie_Decode_Chars = ('\+',       ' ',
                        '\%3A\%3A', '::',
                        '\%26',     '&',
                        '\%3D',     '=',
                        '\%2C',     ',',
                        '\%3B',     ';',
                        '\%2B',     '+',
                        '\%25',     '%');

open(FILE, "$polldata") || 
&file_open_error($polldata); @lines = <FILE>;
close(FILE);
$num = @lines;

($num_questions,$nochop) = split(/``/,$lines[0]);
(@num_answers) = split(/``/,$lines[1]);
(@q_id) = split(/``/,$lines[2]);
(@questions) = split(/``/,$lines[3]);
(@answers) = split(/``/,$lines[4]);
($encrypted_password, $nochop) = split(/``/, $lines[5]);

$total_answers[0] = 0;

for ($a = 1; $a < $num_questions; $a++) {
	$total_answers[$a] = $total_answers[$a-1] + $num_answers[$a-1];
}

&ssi_results($q-1) if ($ENV{QUERY_STRING} eq 'results');
&go;
exit;
sub go {

	&check($q-1);
	&ssi_results($q-1) if ($foundip eq 'Yes');

	print "<form action=\"$cgi\" method=\"post\">\n";

	print "<table bgcolor=$tablecolor border=$border cellpadding=$cellpadding cellspacing=$cellspacing>\n";

	print "<tr><th colspan=2><font face=$textfont color=$textcolor size=$textsize>$questions[$q-1]</font></th></tr>\n";

	for ($b = $total_answers[$q-1]; $b < $total_answers[$q-1]+$num_answers[$q-1]; $b++) {
                $c = $b-$total_answers[$q-1] + 1;
		print "<tr>\n";
		print "<td><input type=\"radio\" name=\"response\" value=\"$c\"></td>\n";
                print "<td align=left><font face=$textfont color=$textcolor size=$textsize>$answers[$b]</td></tr>\n";
        }

	print "<tr><td align=center colspan=2>\n";
	print "<input type=\"hidden\" name=\"what\" value=\"votessi\">\n";
	print "<input type=\"hidden\" name=\"q\" value=\"$q\">\n";
	print "<input type=\"submit\" value=\"Submit Vote\">\n";
	print "</td></tr>\n";
	print "</table>\n";
	print "</form>\n";
	print "</center></font></body></html>\n";

	exit;

}

sub ssi_results {

	local($qu) = @_;

	open(FILE, "$polldir/q$q_id[$qu]\.txt") || &file_open_error("q$q_id[$qu]\.txt");
	@lines = <FILE>;
	close(FILE);
	@values = split(/``/, $lines[0]);
	$nv = @values;
	$total = 0;

	for ($a = 0; $a < $nv; $a++) {
		$total += $values[$a];
	}

	for ($a = 0; $a < $nv; $a++) {
		if ($values[$a] > 0) {
			$values_p[$a] = sprintf("%.2f", ($values[$a]/$total) * 100);
		} else {
			$values_p[$a] = 0;
		}
		$values_g[$a] = int($graph_width * $values_p[$a])+1;
	}

	print "<font face=\"$textfont\" size=\"$textsize\" color=\"$textcolor\">";
	print "You have voted on this topic.</font><br>\n\n";

	print "<table bgcolor=\"$tablecolor\" cellpadding=$cellpadding cellspacing=$cellspacing>\n";
	print "<tr><th colspan=$ssi_total><font face=\"$textfont\" size=\"$textsize\" color=\"$textcolor\">";
	print "$questions[$qu]</font></td></tr>\n";

	$c = 0;
	for ($b = $total_answers[$qu]; $b < $total_answers[$qu]+$num_answers[$qu]; $b++) {
		print "<tr>\n";
		print "<td align=left><font face=\"$textfont\" size=\"$textsize\" color=\"$textcolor\">$answers[$b]</font></td>\n";
		print "<td align=center><font face=\"$textfont\" size=\"$textsize\" color=\"$textcolor\">$values[$c]</td></font>\n";
		if ($include_percent == 1) {
			print "<td align=center><font face=\"$textfont\" size=\"$textsize\" color=\"$textcolor\">$values_p[$c] %</font></td>\n";
		}
		if ($include_graph == 1) {
			print "<td align=left><img src=\"$graph_image\" height=\"$graph_height\" ";
			print "width=\"$values_g[$c]\"></td>\n";
		}
		print "</tr>\n";
		$c++;
	}
	if ($include_total == 1) {
		print "<tr>\n";
		print "<th><font face=\"$textfont\" size=\"$textsize\" color=\"$textcolor\">TOTAL</font></th>\n";
		print "<th><font face=\"$textfont\" size=\"$textsize\" color=\"$textcolor\">$total</font></th>\n";

		if ($include_percent == 1) {
			print "<th><font face=\"$textfont\" size=\"$textsize\" color=\"$textcolor\">100.00 %</font></th>\n";
		}
		if ($include_graph == 1) {
			print "<td><font color=$tablecolor>..</font></td>\n";
		}
		print "</tr>\n";

	}

	print "</table>\n";

	exit;

}

sub check {

	local($qu) = @_;
	$foundip = 'No';

	if ($check_cookies) {
		if (&GetCookies('questions')) {
			(@answered) = split(/,/,$Cookies{'questions'});
			for ($f = 0; $f < @answered - 1; $f++) {	
				$foundip = 'Yes' if ($answered[$f] == $q_id[$qu]);
			}
		}
		else {
			$Cookies{'questions'} = "No Cookies Found";
		}
	}

	if ($check_ip) {
		open(FILE, "$polldir/ip$q_id[$qu]\.txt") || &file_open_error("ip$q_id[$qu]\.txt");
		@lines = <FILE>;
		close(FILE);
		$numip = @lines;
		$voted[$a] = 'No';
		for ($b = 0; $b < $numip; $b++) {
			($check_ip,$nochop) = split(/``/,$lines[$b]);
			if ($check_ip eq $ip) {
				$foundip = 'Yes';
				$b = $numip;
			}
		}
	}

}

sub file_open_error {
	local($err) = @_;
	&fatal_error("Can't Open $err");
	exit;
}

sub fatal_error {
	local($e) = @_;
	print "<font face=arial size=3>";
	print "[ RobPoll Fatal Error: $e ]</font>\n";
	exit;
}

sub GetCookies {

    local(@ReturnCookies) = @_;
    local($cookie_flag) = 0;
    local($cookie,$value);

    if ($ENV{'HTTP_COOKIE'}) {

        if ($ReturnCookies[0] ne '') {

            foreach (split(/; /,$ENV{'HTTP_COOKIE'})) {

                ($cookie,$value) = split(/=/);

                foreach $char (@Cookie_Decode_Chars) {
                    $cookie =~ s/$char/$Cookie_Decode_Chars{$char}/g;
                    $value =~ s/$char/$Cookie_Decode_Chars{$char}/g;
                }

                foreach $ReturnCookie (@ReturnCookies) {
                    if ($ReturnCookie eq $cookie) {
                        $Cookies{$cookie} = $value;
                        $cookie_flag = "1";
                    }
                }
            }

        }
        else {

            foreach (split(/; /,$ENV{'HTTP_COOKIE'})) {
                ($cookie,$value) = split(/=/);

                foreach $char (@Cookie_Decode_Chars) {
                    $cookie =~ s/$char/$Cookie_Decode_Chars{$char}/g;
                    $value =~ s/$char/$Cookie_Decode_Chars{$char}/g;
                }

                $Cookies{$cookie} = $value;
            }
            $cookie_flag = 1;
        }
    }

    return $cookie_flag;
}

sub SetCookieExpDate {

    if ($_[0] =~ /^\w{3}\,\s\d{2}\-\w{3}-\d{4}\s\d{2}\:\d{2}\:\d{2}\sGMT$/ || $_[0] eq '') {
        $Cookie_Exp_Date = $_[0];
        return 1;
    }
    else {
        return 0;
    }
}

sub SetCookiePath {
    $Cookie_Path = $_[0];
}

sub SetCookies {

    local(@cookies) = @_;
    local($cookie,$value,$char);

    while( ($cookie,$value) = @cookies ) {

        foreach $char (@Cookie_Encode_Chars) {
            $cookie =~ s/$char/$Cookie_Encode_Chars{$char}/g;
            $value =~ s/$char/$Cookie_Encode_Chars{$char}/g;
        }

        print 'Set-Cookie: ' . $cookie . '=' . $value . ';';

        if ($Cookie_Exp_Date) {
            print ' expires=' . $Cookie_Exp_Date . ';';
        }

        if ($Cookie_Path) {
            print ' path=' . $Cookie_Path . ';';
        }

        if ($Cookie_Domain) {
            print ' domain=' . $Cookie_Domain . ';';
        }

        if ($Secure_Cookie) {
            print ' secure';
        }

        print "\n";

        shift(@cookies); shift(@cookies);
    }
}

