#!/usr/bin/perl
##########################################################################
# Online Voting System 0.8.5
#
# [Eng/Unix/Perl5]
#
# Written by Ray Chan, 1998/09/01
#
# Copyright 1998 All Rights Reserved.
##########################################################################
#
# Perl Reunion 98
# URL  : http://www.ray.org.hk/perl/
# Mail : perl@ray.org.hk
#
##########################################################################
#
# This script is free for personal use only.
# Please register the script if you find it useful.
#
##########################################################################
#
# Disclaimer
#
# By using the script(s), you are supposed to agree and understand that
# the writers are not responsible for any damages caused under any
# conditions due to the malfunction or bugs from the script(s). Please
# use at your own risk.
#
##########################################################################
#
# userman.pl
#
#	This script handles all the user account related functions.
#
##########################################################################
# Setup Section
#
# $conf
#	full unix path where the configuration file (vote.conf) located
#

$conf='/home/httpd/cgi-bin/vote-0.8.5/vote.conf';

#
# $acl
#	full unix path where the library (acl-lib.pl) located

$acl='/home/httpd/cgi-bin/vote-0.8.5/acl-lib.pl';

# End of Setup Section
##########################################################################

require 5;
require $conf;
require $acl;

&form_data;

if ($ARGV[0] eq "logout"){
	$tchk=&checkin;
	if ($tchk == 1){
		&logout;
		print "Location: $logoff\n\n";
	}else{
		&denied;
	}
}

if ($DATA{"MODE"} eq "NEWREG"){
	##############################
	# New User Registration Mode #
	##############################
	
	# first check for duplicated login ID
	open (FILE, $userdb);
	@USER=<FILE>;
	close(FILE);

	$fDupID=0;
	foreach $rec (@USER){
		chomp($rec);
		@record=split(/\|/,$rec);
		if (uc($record[2]) eq uc($DATA{"LOGIN"})){
			$fDupID=1;
			last;
		}
	}

	# then check for duplicated email address

	$fDupMail=0;
	foreach $rec (@USER){
		chomp($rec);
		@record=split(/\|/,$rec);
		if (uc($record[1]) eq uc($DATA{"EMAIL"})){
			$fDupMail=1;
			last;
		}
	}

	# finally, check for valid email address

	if ($DATA{'EMAIL'} =~ /.+\@.+\..+/){
		$fValidMail=0;
	}else{
		$fValidMail=1;
	}

	if ($fDupID == 0 && $fDupMail == 0 && $fValidMail == 0){
		# Registration allow
		# password generator (8 random digits)
		$tmppwd="";
		$count=1;
		srand();
		while ($count<=8){
			$ran=int(rand(9))+1;
			$tmppwd.=$ran;
			$count++;
		}

		# write to user database
		open(FILE,">>$userdb");
		print FILE "$DATA{'NAME'}|$DATA{'EMAIL'}|$DATA{'LOGIN'}|$tmppwd\n";
		close(FILE);

		print "Content-type: text/html\n\n";
		
		# print result to browser
		open(FILE,$msgtem);
		@RESULT=<FILE>;
		close(FILE);
		
		foreach $line (@RESULT){
			print $line;
		}	
		print "<HTML><BODY>";
		print "<P>$userdb<P>";
		print "<P><B>Thank you for your registration!</B><P>\n";
		print "Here is your registration information:<P>\n";
		print "<TABLE BORDER=1>\n";
		print "<TR><TD>User Name</TD><TD>$DATA{'NAME'}</TD></TR>\n";
		print "<TR><TD>Email Address</TD><TD>$DATA{'EMAIL'}</TD></TR>\n";
		print "<TR><TD>Login ID</TD><TD>$DATA{'LOGIN'}</TD></TR>\n";
		print "</TABLE><P>\n";
		print "Please check your email box for your temporary password.\n";
		print "</BODY></HTML>";

		# print result to sendmail

		open (MAIL, "|$sendmail $DATA{'EMAIL'}");
		print MAIL "From: $webmaster <$wmail>\n";
		print MAIL "To: $DATA{'EMAIL'}\n";
		print MAIL "Subject: $regSub\n\n";
		print MAIL "Thank you for your registration.\n\n";
		print MAIL "User Name = $DATA{'NAME'}\n";
		print MAIL "Email     = $DATA{'EMAIL'}\n";
		print MAIL "Login ID  = $DATA{'LOGIN'}\n";
		print MAIL "Password  = $tmppwd\n\n";
		$date=localtime();
		print MAIL "$date\n";
		close(MAIL);
	}else{
		# print error page
		open (FILE,$errortem);
		@ERROR=<FILE>;
		close(FILE);
		print "Content-type: text/html\n\n";
		foreach $line (@ERROR){
			print $line;
		}
		print "\n<B>Sorry, your registration can not be process due to the following error(s):</B><P>";
		if ($fDupID != 0){
			print "Login ID already existed in our database.<P>";
		}
		if ($fDupMail != 0){
			print "Email Address already existed in our database.<P>";
		}
		if ($fValidMail != 0){
			print "Invalid Email Address entered.<P>";
		}
		print "<P>Please click <A HREF='javascript:history.go(-1);'>here</A> and edit again.<P>";
		print "</BODY></HTML>";
	}
}

if ($ARGV[0] eq "accedit"){

	$flag=&checkin;

	if ($flag==1){

	print "Content-type: text/html\n\n";

	#########################
	# Account Edit Function #
	#########################
	
	$from=$ENV{'REMOTE_ADDR'};

	# get current login ID
	open(FILE,$sessdb);
	@VD=<FILE>;
	close(FILE);
	
	foreach $zid (@VD){
		chomp($zid);
		@vdata=split(/\|/,$zid);
		if ($vdata[1] eq $from){
			$login=$vdata[0];
			last;
		}
	}

	# read current data from user database
	open (FILE,$userdb);
	@UD =<FILE>;
	close(FILE);

	foreach $rec (@UD){
		chomp($rec);
		($uname,$umail,$uid,$upwd)=split(/\|/,$rec);
		if ($uid eq $login){
			last;
		}
	}

	# print to browser
	#	open template
	open (FILE,$accedit);
	@PB =<FILE>;
	close(FILE);
	

	foreach $line (@PB){
		if ($line =~ /<!--## User Name ##-->/){
			$line=~s/<!--## User Name ##-->/$uname/;
		}
		if ($line =~ /<!--## Email Address ##-->/){
			$line=~s/<!--## Email Address ##-->/$umail/;
		}
		if ($line =~ /<!--## Password ##-->/){
			$line=~s/<!--## Password ##-->/$upwd/;
		}
		if ($line =~ /<!--## Login ID ##-->/){
			$line=~s/<!--## Login ID ##-->/$uid/;
		}
		print $line;
	}
		&writein;
	}else{
		&denied;
	}
	
}

if ($DATA{"MODE"} eq "ACCEDIT"){

	###########################
	# Account Update Function #
	###########################	

	$flag=&checkin;

	if ($flag==1){
	open (FILE,$userdb);
	@USER =<FILE>;
	close(FILE);

	# first check for duplicated email address
                                                  
	$fDupMail=0;
	foreach $rec (@USER){
        	chomp($rec);
        	@record=split(/\|/,$rec);
		if ($DATA{"LOGIN"} ne $record[2]){
        	if (uc($record[1]) eq uc($DATA{"EMAIL"})){
                	$fDupMail=1;
                	last;
        	}
		}
	}                                  

	# then check for valid email address
                                                  
	if ($DATA{'EMAIL'} =~ /.+\@.+\..+/){
        	$fValidMail=0;
	}else{
	        $fValidMail=1;
	}

	if ($fValidMail == 0 && $fDupMail == 0){

		$fDidit=0;
		$tmppwd="";
		open (FILE, ">$userdb");
		foreach $userec (@USER){
			chomp($userec);
			@urec=split(/\|/,$userec);
			if ($urec[2] eq $DATA{"LOGIN"}){
				# check if email address change, if yes,
				# reset password
				if ($urec[1] ne $DATA{"EMAIL"}){
					# raymark
					$count=1;
					srand();
					while ($count<=8){
        					$ran=int(rand(9))+1;
        					$tmppwd.=$ran;
        					$count++;
					}
					print FILE "$DATA{'NAME'}|$DATA{'EMAIL'}|$DATA{'LOGIN'}|$tmppwd\n";
					$fDidit=1;
				}else{
					print FILE "$DATA{'NAME'}|$urec[1]|$urec[2]|$DATA{'PASS1'}\n";
				}
			}else{
				print FILE "$userec\n";
			}
		}
		close(FILE);
		# print result to browser

		open (FILE, $msgtem);
		@PB =<FILE>;
		close(FILE);
		print "Content-type: text/html\n\n";
		foreach $line (@PB){
			print $line;
		}
		print "<P><B>Your information has been updated.</B><P>";
		print "Following is your updated information:<P>";
		print "<TABLE BORDER=1>";
		print "<TR>";
		print "<TD>User Name</TD><TD>$DATA{'NAME'}</TD>";
		print "</TR>";
		print "<TR>";
		print "<TD>Email Address</TD><TD>$DATA{'EMAIL'}</TD>";
		print "</TR>";
		print "<TR>";
		print "<TD>Password</TD><TD>********</TD></TR>";
		print "</TABLE><P>";
		if ($fDidit==1){
			print "In order to verify the new email address you provided, your password has been reset by the system. Please check your mailbox for your new password and <B>login</B> again.";
			print "<P><B>You Have Successfully Logged Out</B>";
		}
		print "</BODY></HTML>";
		
		if ($fDidit==1){
			# send mail to user
			open (MAIL, "|$sendmail $DATA{'EMAIL'}");
			print MAIL "From: $webmaster <$wmail>\n";
			print MAIL "To: $DATA{'EMAIL'}\n";
			print MAIL "Subject: $editSub\n\n";
			print MAIL "Thank you for your registration.\n\n";
			print MAIL "User Name = $DATA{'NAME'}\n";
			print MAIL "Email     = $DATA{'EMAIL'}\n";
			print MAIL "Login ID  = $DATA{'LOGIN'}\n";
			print MAIL "Password  = $tmppwd\n\n";
			$date=localtime();
			print MAIL "$date\n";
			close(MAIL);
		}
		
		# log user out by overwrite the lock file, if email is changed
		if ($fDidit == 1){
			&logout;
		}
	}else{
		# print error page to browser
		# print error page
		open (FILE,$errortem);
		@ERROR=<FILE>;
		close(FILE);
		print "Content-type: text/html\n\n";
		foreach $line (@ERROR){
       	 		print $line;
		}
		print "<B>Sorry, your information cannot update due to the following error(s)</B><P>";
		if ($fDupMail != 0){
			print "Email Address already existed in our database.<P>";
		}
		if ($fValidMail != 0){
			print "Invalid Email Address entered.<P>\n";
		}
		print "Please press <A HREF='javascript:history.go(-1);'>here</A> and edit again.<P>";
		print "</BODY></HTML>";
	}
		&writein;
	}else{
		&denied;
	}
}

if ($ARGV[0] eq "accdel"){

	$auth=&checkin;
	if ($auth==1){
	# write to delete list
	$myid=&getid;

	open (FILE,">>$deldb");
	print FILE "$myid\n";
	close(FILE);
	&logout;
	open (FILE,$msgtem);
	@DB1=<FILE>;
	close(FILE);
	print "Content-type: text/html\n\n";
	foreach $line (@DB1){
		print $line;
	}
	print "<B>Account Delete Process</B><P>";
	print "Your account have been removed successfully.";
	print "</BODY></HTML>";
	}else{
		&denied;
	}
}

if ($DATA{"MODE"} eq "FORGOT"){

	########################
	# Forgot Password Mode #
	########################

	open (FILE, $userdb);
	@DB =<FILE>;
	close(FILE);

	$fFit=0;
	foreach $record (@DB){
		chomp($record);
		@rf=split(/\|/,$record);
		if ($rf[0] eq $DATA{"NAME"} && $rf[2] eq $DATA{"LOGIN"}){
			$fFit=1;
			# send mail to user
			open (MAIL, "|$sendmail $rf[1]");
			print MAIL "From: $webmaster <$wmail>\n";
			print MAIL "To: $rf[1]\n";
			print MAIL "Subject: $forgSub\n\n";
			print MAIL "Here is the information you request.\n\n";
			print MAIL "User Name = $rf[0]\n";
			print MAIL "Email     = $rf[1]\n";
			print MAIL "Login ID  = $rf[2]\n";
			print MAIL "Password  = $rf[3]\n\n";
			$date=localtime();
			print MAIL "$date\n";
			close(MAIL);
			last;
		}
	}
	if ($fFit==0){
		open (FILE,$errortem);
	}else{
		open (FILE,$msgtem);
	}
	@PB =<FILE>;
	close(FILE);
	print "Content-type: text/html\n\n";
	foreach $line (@PB){
		print $line;
	}
	if ($fFit==0){
		print "Sorry, we did not found the account you specify.";
	}else{
		print "<P><B>Thank you for your submission.</B>";
		print "<P>Please check your mailbox now for your account password.";
	}
	print "</BODY></HTML>";
}

sub form_data {

	# read form get data
	local (*ARG) = @_ if @_;
  	local ($i, $key, $val);
  	$ARG = $ENV{'QUERY_STRING'};
  	@ARG = split(/[&;]/,$ARG);
  	foreach $i (0 .. $#ARG) {
  	  $ARG[$i] =~ s/\+/ /g;
    	  ($key, $val) = split(/=/,$ARG[$i],2);
    	  $key =~ s/%(..)/pack("c",hex($1))/ge;
    	  $val =~ s/%(..)/pack("c",hex($1))/ge;
    	  $ARG{$key} .= "\0" if (defined($ARG{$key}));
    	  $ARG{$key} .= $val;
	  $ARG{$key} =~ s/\|//g;
	  $ARG{$key} =~ s/;//g;
  	}

	# read form post data
     read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});

      @pairs = split(/&/, $buffer);
  foreach $pair (@pairs) {
      ($name, $value) = split(/=/, $pair);

      $name =~ tr/+/ /;
      $name =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;

      $value =~ tr/+/ /;
      $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
      $value =~ s/<!--(.|\n)*-->//g;
      $DATA{$name} = $value;

      $DATA{$name} =~ s/\|//g;
      $DATA{$name} =~ s/;//g;

  }

      $ARGV[0] =~ s/\|//g;
      $ARGV[0] =~ s/;//g;
}
