#!/usr/bin/perl
##########################################################################
# Online Voting System 0.8.5
#
# [Eng/Unix/Perl5]
#
# Written by Ray Chan, 1998/09/01
#
# Copyright 1998 All Rights Reserved.
##########################################################################
#
# Perl Reunion 98
# URL  : http://www.ray.org.hk/perl/
# Mail : perl@ray.org.hk
#
##########################################################################
#
# This script is free for personal use only.
# Please register the script if you find it useful.
#
##########################################################################
#
# Disclaimer
#
# By using the script(s), you are supposed to agree and understand that
# the writers are not responsible for any damages caused under any
# conditions due to the malfunction or bugs from the script(s). Please
# use at your own risk.
#
##########################################################################
#
# vote.pl
#
#	This is the script handle all the voting related function.
#
##########################################################################
# Setup Section
#
# $conf
#	full unix path where the configuration file (vote.conf) located
#

$conf='/home/httpd/cgi-bin/vote-0.8.5/vote.conf';

#
# $acl
#	full unix path where the library file (acl-lib.pl) located

$acl='/home/httpd/cgi-bin/vote-0.8.5/acl-lib.pl';

# End of Setup Section
##########################################################################

require 5;
require $conf;
require $acl;

&checkin;
if ($pass==1){
&form_data;

if ($ARGV[0] eq "list"){

	#####################
	# Get Category List #
	#####################

	&header;
		
	print "<B>Category List</B><P>";
	print "<TABLE BORDER=0>";

	$fCount=0;
	open (FILE, $cata);
	@db =<FILE>;
	close(FILE);

	foreach $test (@db){
		chomp($test);
		($gname,$gid)=split(/\|/,$test);
		$fCount++;
		if ($fCount/2 != int($fCount/2)){
			print "<TR>";
		}
		$cname=$gname;
		$cname=~s/ /_/g;
		print "<TD><UL><LI>";
		print "<A HREF=\"$voteurl?mode=cat&cname=$cname&cat=$gid\" onmouseover=\"window.status='Category - $gname';return true\">";
		print "$gname</A></UL></TD>";
		if ($fCount/2 == int($fCount/2)){
			print "</TR>";
		}
	}
	
	print "</TABLE>";
	print "</UL>";
	print "</BODY></HTML>";

}

if ($ARG{"mode"} eq "cat"){
	
	##########################
	# List category question #
	##########################

	&header;

	# get question list

	$ccd=$ARG{"cat"};
	$tname=$ARG{"cname"};
	$tname=~s/_/ /g;
	
	print "<FONT SIZE=+1>$tname</FONT><P>";

	print<<EOF;
		<TABLE BORDER=0>
		<TR><TD BGCOLOR="#8080FF">
			<FONT COLOR="#FFFFFF">Title</FONT>
		    </TD>
		    <TD BGCOLOR="#8080FF">
			<FONT COLOR="#FFFFFF">Owner</FONT>
		    </TD>
		    <TD BGCOLOR="#8080FF">
			<FONT COLOR="#FFFFFF">Date</FONT>
		    </TD>
		</TR>
EOF
	$cfile=$votepath.'/'.$ccd.'.con';
	open (FILE,$cfile);
	@DDB=<FILE>;
	close(FILE);

	$fAny=0;
	$fflag=0;
	$fcount=0;
	foreach $line (@DDB){
		if ($fflag==1){
		$fcount++;
		chomp($line);
		if ($fcount==1){
			($tid,$title)=split(/\|/,$line);
			$dtitle=$title;
			$dtitle=~s/ /_/g;
		}
		if ($fcount==2){
			@info=split(/\|/,$line);
			if ($info[1] ne "N"){
				$fAny=1;
				print "<TR><TD>";
		print "<A HREF=\"$voteurl?mode=vin&tid=$tid&qname=$dtitle&cname=$ARG{'cname'}&cat=$ARG{'cat'}\" onmouseover=\"window.status='$title';return true\">";
		print "$title</A></TD><TD>$info[0]</TD><TD>$info[3]</TD></TR>\n";
			}
		}
		}
		if ($line=~/<NEWTITLE>/){
			$fcount=0;
			$fflag=1;
		}
	}
	print "</TABLE>";
	if ($fAny == 0){
		print "<P>Sorry, no title in this category yet, would you like to add one now?";
	}
	print "<P>[<A HREF='$voteurl?list' onmouseover=\"window.status='Category List';return true\">Category List</A>]";
	print "</BODY></HTML>";
}

if ($ARG{"mode"} eq "vin"){
	
	#################
	# Title Display #
	#################

	&header;

	$ccd=$ARG{"cat"};

	$cname=$ARG{"cname"};
	$cname=~s/_/ /g;

	$tcd=$ARG{"tid"};

	$tname=$ARG{"qname"};
	$tname=~s/_/ /g;

	print "<FONT SIZE=+1>$cname</FONT><P>";

	print "<B>$tname</B><P>";

	# read option from database

	print "<TABLE BORDER=0>\n";
	print "<TR><TD BGCOLOR='#8080FF'><FONT COLOR='#FFFFFF'>Option</FONT></TD>\n";
	print "<TD BGCOLOR='#8080FF'><FONT COLOR='#FFFFFF'>Vote</FONT></TD>";
	print "<TD BGCOLOR='#8080FF'><FONT COLOR='#FFFFFF'>Votes</FONT></TD></TR>";

	$rcon=$votepath.'/'.$ccd.'.con';
	$rdat=$votepath.'/'.$ccd.'.dat';
	$rlog=$votepath.'/'.$ccd.'.log';
	$rtxt=$votepath.'/'.$ccd.'.txt';

	open(FILE,$rcon);
	@dcon=<FILE>;
	close(FILE);

	$fGetit=0;
	foreach $item (@dcon){
		chomp($item);
		if ($fGetit==1){
			$check=$item;
			last;
		}
		($chkid,$chktitle)=split(/\|/,$item);
		if ($chkid eq $tcd){
			$fGetit=1;
		}
	}

	@cchk=split(/\|/,$check);

	$myid=&getid;

	if ($cchk[0] eq $myid){
		$fIsOwner=1;
	}else{
		$fIsOwner=0;
	}

	open(FILE,$rlog);
	@dlog=<FILE>;
	close(FILE);

	$fVoted=0;
	foreach $item (@dlog){
		chomp($item);
		($chktid,$chkuid)=split(/\|/,$item);
		if ($chktid eq $tcd && $chkuid eq $myid){
			$fVoted=1;
			last;
		}
	}

	if ($fVoted == 0){
		print "\n<FORM ACTION='$voteurl' METHOD=POST>";
		print "\n<INPUT TYPE=HIDDEN NAME=MODE VALUE=VOTE>\n";
		print "<INPUT TYPE=HIDDEN NAME=CAT VALUE=\"$ARG{'cat'}\">\n";
		print "<INPUT TYPE=HIDDEN NAME=TID VALUE=\"$ARG{'tid'}\">\n";
		print "<INPUT TYPE=HIDDEN NAME=QNAME VALUE=\"$ARG{'qname'}\">\n";
		print "<INPUT TYPE=HIDDEN NAME=CNAME VALUE=\"$ARG{'cname'}\">\n";
	}

	open(FILE,$rdat);
	@ddat=<FILE>;
	close(FILE);

	foreach $item (@ddat){
		chomp($item);
		@dresult=split(/\|/,$item);
		if ($dresult[0] eq $tcd){
			$temp=shift(@dresult);
			last;
		}
	}

	# find the highest vote in order to print the percent bar
	$high=0;
	$total=0;

	foreach $rc (@dresult){
		$total=$total+$rc;
		if ($rc > $high){
			$high=$rc;
		}
	}

	$dcount=0;
	$dflag=0;
	$dgetit=0;

	foreach $line (@dcon){
		chomp($line);
		if ($dflag==1 && $dgetit==0){
			($zid,$ztitle)=split(/\|/,$line);
			if ($zid eq $tcd){
				$dflag=1;
			}else{
				$dflag=0;
			}
		}
		if ($dflag==1){
			if ($line=~/<NEWTITLE>/){
				$dflag=0;
				last;
			}
		}
		if ($dflag==1){
		$dcount++;
		$dgetit=1;
		if ($dcount>2){
			print "\n<TR><TD>$line</TD><TD>\n";
			if ($fVoted == 1){
				$temp=$dcount-3;
				#print "$dresult[$temp]";
				if ($dresult[$temp]>0){
					$per=($dresult[$temp]/$total)*100;
				}else{
					$per=1;
				}
				print "<IMG SRC='$barurl' BORDER=0 WIDTH=$per>\n";
				#print $per;
			}else{
				$thisv=$dcount-2;
				if ($dcount==3){
				print "<INPUT TYPE=RADIO NAME=VOTE VALUE=$thisv CHECKED>\n";
				}else{
				print "<INPUT TYPE=RADIO NAME=VOTE VALUE=$thisv>\n";
				}
			}
			$per = sprintf("<RIGHT>%3.0f</RIGHT>",$per);
			print "</TD><TD>$per% ($dresult[$temp])</TD></TR>";
		}		
		}
		if ($dflag==0){
		if ($line =~ /<NEWTITLE>/){ $dflag=1;}
		}
	}
	if ($fVoted == 1){
		print "<TD COLSPAN=1>&nbsp;</TD>\n";
		print "<TD><BR><IMG SRC='$barurl' BORDER=0 WIDTH=100></TD>\n";
		print "<TD COLSPAN=1><BR>Total Votes: $total</TD></TR>\n";
	}
	print "</TABLE>";
	print "<P>";

	if ($cchk[2] eq "Y" && $fVoted == 0){
		print "OR... add your own choice!<P>";
		print "<INPUT TYPE=RADIO NAME=VOTE VALUE=NEW>\n";
		print "<INPUT TYPE=TEXT NAME=NEW SIZE=20>\n";
		print "<P>\n";
	}
	if ($fVoted == 0){
		print "<INPUT TYPE=SUBMIT VALUE=\"Vote Now!\">\n";
		print "</FORM>";
		print "<P>";
	}else{
		print "<FORM>";
		print "<INPUT TYPE=BUTTON VALUE='Discuss' onclick=\"location.href='$voteurl?mode=gbklist&cat=$ARG{'cat'}&tid=$ARG{'tid'}&cname=$ARG{'cname'}&tname=$ARG{'qname'}';\">";
		print "</FORM>";
	}

	if ($fIsOwner == 1){
		print "<FORM ACTION='$voteurl' METHOD=POST>\n";
		print "<INPUT TYPE=HIDDEN NAME=MODE VALUE=DELQ>\n";
		print "<INPUT TYPE=HIDDEN NAME=CAT VALUE=\"$ARG{'cat'}\">\n";
                print "<INPUT TYPE=HIDDEN NAME=TID VALUE=\"$ARG{'tid'}\">\n";
		print "<INPUT TYPE=SUBMIT VALUE=\"Delete Now\">\n";
		print "</FORM>\n";
	}
	print "[<A HREF='$voteurl?list' onmouseover=\"window.status='Category List';return true\">Category List</A> | <A HREF='$voteurl?mode=cat&cat=$ARG{'cat'}' onmouseover=\"window.status='Title List';return true\">Title List</A>]";
	print "</BODY></HTML>";
}


if ($DATA{"MODE"} eq "VOTE"){

	$myid=&getid;

	$ccd=$DATA{"CAT"};
	$cname=$DATA{"CNAME"};
                 
	$tcd=$DATA{"TID"};
	$tname=$DATA{"QNAME"};
	
	$doit=&dupvote($myid,$ccd,$tcd);

	if ($doit == 0){
	open (FILE,$votepath.'/'.$ccd.'.log');
	@CHK=<FILE>;
	close(FILE);

	$datpath=$votepath.'/'.$ccd.'.dat';
	$conpath=$votepath.'/'.$ccd.'.con';

	open (FILE,$datpath);
	@DB =<FILE>;
	close(FILE);

	foreach $rec (@DB){
		chomp($rec);
		@vote=split(/\|/,$rec);
		if ($vote[0] eq $tcd){
			$temp=shift(@vote);
			last;
		}
	}

	$vt=join('|',@vote);

	if ($DATA{'VOTE'} eq "NEW"){
		#is add new option
		$newopt=$vt.'|1';
	}else{
		$temp=$DATA{'VOTE'}-1;
		$vote[$temp]=$vote[$temp]+1;
		$newopt=join("|",@vote);
	}

	# print to count file

	open (FILE,">$datpath");
	foreach $rec (@DB){	
		chomp($rec);
		@tt=split(/\|/,$rec);
		if ($tt[0] ne $tcd){
			print FILE "$rec\n";
		}else{
			print FILE "$tcd|$newopt\n";
		}
	}
	close(FILE);
 
	# add option to list
	open (FILE,$conpath);
	@CONDB=<FILE>;
	close(FILE);

	if ($DATA{'VOTE'} eq "NEW"){
		open (FILE,, ">$conpath");
		$ttflag=0;
		$ped=0;
		foreach $conrec (@CONDB){
			chomp($conrec);
			@ttdb=split(/\|/,$conrec);
			if ($ttdb[0] eq $tcd){
				$ttflag=1;
			}
			if ($ttflag==1){
				if ($conrec=~/<NEWTITLE>/){
					print FILE "$DATA{'NEW'}\n";
					$ped=1;
				}
			}
			print FILE "$conrec\n";
		}
		if ($ped==0){
			print FILE "$DATA{'NEW'}\n";
		}
		close(FILE);
	}

	# print to log file
	$tlog=$votepath.'/'.$ccd.'.log';

	open (FILE, ">>$tlog");
	print FILE "$tcd|$myid\n";
	close(FILE);

	print "Location: $voteurl?cname=$DATA{'CNAME'}&qname=$DATA{'QNAME'}&mode=vin&cat=$DATA{'CAT'}&tid=$DATA{'TID'}\n\n";
	}else{
		&header;
		print "<B>Your request cannot be processed because of the following reason:</B><P>";
		print " - cannot vote twice to the same title.";
		print "</BODY></HTML>";
	}
}

if ($ARG{"mode"} eq "gbklist"){

	########################
	# title questbook list #
	########################

	&header;

	$ccd=$ARG{"cat"};
	$cname=$ARG{"cname"};
	$cname=~s/_/ /g;

	$tcd=$ARG{"tid"};
	$tname=$ARG{"tname"};
	$tname=~s/_/ /g;

	print "<FONT SIZE=+1>$cname</FONT><P>";

	print "<B>$tname</B><P>";

	open (FILE,$votepath.'/'.$ccd.'.txt');
	@DB =<FILE>;
	close(FILE);

	foreach $item (@DB){
		chomp($item);
		@hey=split(/\|/,$item);
		if ($hey[0] eq $tcd){
			print "$hey[1]\n";
		}
	}

	print "<FORM ACTION='$voteurl' METHOD=POST>\n";
	print "<INPUT TYPE=HIDDEN NAME=MODE VALUE=gbkadd>\n";
	print "<INPUT TYPE=HIDDEN NAME=CAT VALUE=\"$ARG{'cat'}\">\n";
	print "<INPUT TYPE=HIDDEN NAME=TID VALUE=\"$ARG{'tid'}\">\n";
	print "<INPUT TYPE=HIDDEN NAME=CNAME VALUE=\"$ARG{'cname'}\">\n";
	print "<INPUT TYPE=HIDDEN nAME=TNAME VALUE=\"$ARG{'tname'}\">\n";
	print "<TEXTAREA COLS=50 ROWS=5 NAME=COMMENT></TEXTAREA>\n";
	print "<P>";
	print "<INPUT TYPE=SUBMIT VALUE=\"Add my comment\">\n";
	print "</FORM>\n";
	print "<P>";
	print "[<A HREF='$voteurl?list' onmouseover=\"window.status='Category List';return true\">Category List</A> | <A HREF='$voteurl?mode=cat&cat=$ARG{'cat'}' onmouseover=\"window.status='Title List';return true\">Title List</A>]";
	print "</BODY></HTML>";
}

if ($DATA{"MODE"} eq "gbkadd"){

	###############
	# comment add #
	###############

	$DATA{"COMMENT"}=~s/\n/<BR>/g;

	$ccd=$DATA{"CAT"};
	$cname=$DATA{"cname"};
	$cname=~s/_/ /g;
                 
	$tcd=$DATA{"TID"};
	$tname=$DATA{"tname"};
	$tname=~s/_/ /g;

	$usernow=&getid;
	$date=localtime();
	$tempf=$votepath.'/'.$ccd.'.txt';
	if ($DATA{'COMMENT'} ne ""){
	open (FILE, ">>$tempf");
	print FILE "$tcd|$DATA{'COMMENT'}\n";
	print FILE "$tcd|<P>$usernow - $date\n";
	print FILE "$tcd|<HR>\n";
	close(FILE);
	}

	print "Location: $voteurl?tname=$DATA{'TNAME'}&cname=$DATA{'CNAME'}&mode=gbklist&cat=$DATA{'CAT'}&tid=$DATA{'TID'}\n\n";
}

if ($DATA{"MODE"} eq "DELQ"){

	################
	# Delete title #
	################

	$ccd=$DATA{"CAT"};
                 
	$tcd=$DATA{"TID"};

	$tfile=$votepath.'/'.$ccd.'.con';

	open (FILE,$tfile);
	@DB =<FILE>;
	close(FILE);

	$flag=0;

	foreach $rec (@DB){
		chomp($rec);
		if ($flag==1){
			$tnew=$rec;
			$flag=0;
			last;
		}
		@at=split(/\|/,$rec);
		if ($at[0] eq $tcd){
			$flag=1;
		}
	}

	@tnow=split(/\|/,$tnew);

	$tnow[1]="N";

	$tnew=join('|',@tnow);

	open (FILE,">$tfile");
	$tcount=0;
	foreach $item (@DB){
		chomp($item);
		if ($tcount==0){
			print FILE "$item\n";
		}else{
			print FILE "$tnew\n";
			$tcount=0;
		}
		@att=split(/\|/,$item);
		if ($att[0] eq $tcd){
			$tcount=1;
		}
	}
	close(FILE);

	print "Location: $voteurl?mode=cat&cat=$DATA{'CAT'}\n\n";
}

if ($ARGV[0] eq "addq"){

	#################
	# add new title #
	#################

	print "Location: $addnew\n\n";
}

if ($DATA{"MODE"} eq "NEWQ"){

	#################
	# ADD NEW TITLE #
	#################

	$myid=&getid;

	# print to category.con

	$ncon=$votepath.'/'.$DATA{"CAT"}.'.con';
	
	open(FILE,">>$ncon");
	print FILE "<NEWTITLE>\n";
	$tmppwd="";
	$count=1;
	srand();
	while ($count<=12){
        	$ran=int(rand(9))+1;
        	$tmppwd.=$ran;
        	$count++;
	}
	
	print FILE "$tmppwd|$DATA{'NAME'}\n";
	if ($DATA{"ADD"} eq "ON" || $DATA{"ADD"} eq "on"){
		$aadd="Y";
	}else{
		$aadd="N";
	}
	$currtime=time();
	@time=localtime($currtime);

	$time[4]=$time[4]+1;

	if ($time[4] < 10){
		$time[4]='0'.$time[4];
	}

	$ttime=$time[5].'-'.$time[4].'-'.$time[3];

	print FILE "$myid|Y|$aadd|$ttime\n";
	$ttc=0;
	if ($DATA{"c1"} ne ""){
		print FILE "$DATA{'c1'}\n";
		$ttc++;
	}
        if ($DATA{"c2"} ne ""){            
                print FILE "$DATA{'c2'}\n";
		$ttc++;
        }                                  
        if ($DATA{"c3"} ne ""){            
                print FILE "$DATA{'c3'}\n";
		$ttc++;
        }                                  
        if ($DATA{"c4"} ne ""){            
                print FILE "$DATA{'c4'}\n";
		$ttc++;
        }                                  
        if ($DATA{"c5"} ne ""){            
                print FILE "$DATA{'c5'}\n";
		$ttc++;
        }                                  
        if ($DATA{"c6"} ne ""){            
                print FILE "$DATA{'c6'}\n";
		$ttc++;
        }                                  
        if ($DATA{"c7"} ne ""){            
                print FILE "$DATA{'c7'}\n";
		$ttc++;
        }                                  
        if ($DATA{"c8"} ne ""){            
                print FILE "$DATA{'c8'}\n";
		$ttc++;
        }                                  
        if ($DATA{"c9"} ne ""){            
                print FILE "$DATA{'c9'}\n";
		$ttc++;
        }                                  
        if ($DATA{"c10"} ne ""){            
                print FILE "$DATA{'c10'}\n";
		$ttc++;
        }                                  
	close(FILE);
	
	# print to category.dat

	$ndat=$votepath.'/'.$DATA{"CAT"}.'.dat';
	$tstr=$tmppwd;

	for($i=1;$i<=$ttc;$i++){
		$tstr.='|0';
	}	

	open (FILE,">>$ndat");
	print FILE "$tstr\n";
	close(FILE);
	
	# print to category.txt
	$nlog=$votepath.'/'.$DATA{"CAT"}.'.txt';
	open (FILE,">>$nlog");
	print FILE "$tmppwd|<HR>\n";
	close(FILE);
	print "Location: $voteurl?list\n\n";
}
&writein;

}else{
	&denied;
}

sub header{
	print "Content-type: text/html\n\n";
	open (FILE, $msgtem);
	@abc=<FILE>;
	close(FILE);
	foreach $line (@abc){
		print $line;
	}
}

sub dupvote{
	local ($dupflag)=0;
	$chkid=$_[0];
	$chk_c=$_[1];
	$chk_t=$_[2];

	open(CHKF,$votepath.'/'.$chk_c.'.log');
	@chkdata=<CHKF>;
	close(CHKF);

	foreach $ud (@chkdata){
		chomp($ud);
		($ud_t,$ud_u)=split(/\|/,$ud);
		if ($ud_t eq $chk_t && $ud_u eq $chkid){
			$dupflag=1;
			last;
		}
	}

	$dupflag;
}
sub form_data {

	# read form get data
	local (*ARG) = @_ if @_;
  	local ($i, $key, $val);
  	$ARG = $ENV{'QUERY_STRING'};
  	@ARG = split(/[&;]/,$ARG);
  	foreach $i (0 .. $#ARG) {
  	  $ARG[$i] =~ s/\+/ /g;
    	  ($key, $val) = split(/=/,$ARG[$i],2);
    	  $key =~ s/%(..)/pack("c",hex($1))/ge;
    	  $val =~ s/%(..)/pack("c",hex($1))/ge;
    	  $ARG{$key} .= "\0" if (defined($ARG{$key}));
    	  $ARG{$key} .= $val;
  	}

	# read form post data
     read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});

      @pairs = split(/&/, $buffer);
  foreach $pair (@pairs) {
      ($name, $value) = split(/=/, $pair);

      $name =~ tr/+/ /;
      $name =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;

      $value =~ tr/+/ /;
      $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
      $value =~ s/<!--(.|\n)*-->//g;
      $DATA{$name} = $value;
  }
}
