#!/usr/bin/perl
##########################################################################
# Authorization Gateway 0.7.1a
#
# [Eng/Unix/Perl5]
#
# Written by Ray Chan, 1998/07/29
#
# Copyright 1998 All Rights Reserved.
##########################################################################
#
# Perl Reunion 98
# URL  : http://www.ray.org.hk/perl/
# Mail : perl@ray.org.hk
#
##########################################################################
#
# This script is free for personal use only.
# Please register the script if you find it useful.
#
##########################################################################
#
# Disclaimer
#
# By using the script(s), you are supposed to agree and understand that
# the writers are not responsible for any damages caused under any
# conditions due to the malfunction or bugs from the script(s). Please
# use at your own risk.
#
##########################################################################
#
# auth.pl
#
#	This script will handle all the permission check and login session.
#
##########################################################################
# Setup Section
#
# $conf
#	full unix path where the configuration file (vote.conf) located
#

$conf='/home/httpd/cgi-bin/vote-0.8/vote.conf';

# End of Setup Section
##########################################################################


require $conf;
require 5;

sub checkin{	#subroutine permission check

$pass=0;
$n2=$ENV{'REMOTE_ADDR'};
if (-e $sessdb){

	#initization
	$CHK[1]=31;
	$CHK[2]=28;
	$CHK[3]=31;
	$CHK[4]=30;
	$CHK[5]=31;
	$CHK[6]=30;
	$CHK[7]=31;
	$CHK[8]=31;
	$CHK[9]=30;
	$CHK[10]=31;
	$CHK[11]=30;
	$CHK[12]=31;

	#check for access permission

	#read current time
	$currtime=time();
	@time=localtime($currtime);

	$n3=$time[5];
	$n4=$time[4];
	$n5=$time[3];
	$n6=$time[2];
	$n7=$time[1];
	$n8=$time[0];
	$n4++;
	
	$add=1;
	$test=$n3/4;
	if ($test=~/\./){ #can't / by 4
		$add=0;
	}else{
		if ($n3=~/00$/){	#is century year
			$test=$n3/400;
			if ($test=~/\./){ #can't / by 400
				$add=0;
			}
		}
	}

	if ($add == 1){
		$CHK[2]=29;
	}
	
	open(FILE,$sessdb);
	@TMP1=<FILE>;
	close(FILE);

	foreach $login (@TMP1){

		@tin=split(/\|/,$login);

		($r1,$r2,$r3,$r4,$r5,$r6,$r7,$r8)=split(/\|/,$login);
		if ($r2 eq $n2){
			#check for time limit (expire)
			$t7=$r7+$expire;
			$t6=$r6;
			$t5=$r5;
			$t4=$r4;
			$t3=$r3;
			$t2=$r2;
			if ($t7>59){
				$t6=$r6+1;
			}	
			if ($t6>23){
				$t5=$r5+1;
			}
			if ($t5 > $CHK[$t4]){
				$t4=$r4+1;
			}
			if ($t4>12){
				$t3=$r3+1;
			}
			if ($n3<=$t3 && $n4<=$t4 && $n5<=$t5 && $n6<=$t6 && $n7<=$t7){
				$pass=1;
			}
		}		
	} # end of for loop
}
else{
	print "Session database not found!!\n";
} # end of if session file existed
	$pass;
}


sub writein{
	
	local ($wflag)=0;

	#$ray=$_[0];

	#if ($ray eq ""){
		$r1="system";
	#}else{
	#	$r1=$ray;
	#}

	$r2=$ENV{'REMOTE_ADDR'};

	open(FILE,$sessdb);
	@WEST=<FILE>;
	close(FILE);

	#clear previous entry first

	open(FILE,">$sessdb");
	foreach $wtem (@WEST){
		chomp($wtem);
		($tmp1,$tmp2,$tmp3,$tmp4,$tmp5,$tmp6,$tmp7,$tmp8)=split(/\|/,$wtem);
		if ($tmp2 ne $r2){
			print FILE "$wtem\n";
		}else{
			$r1=$tmp1;
		}
	}
	close(FILE);

	# add session entry then


	open(FILE,">>$sessdb");

	#overwrite previous session
	$wflag=1;
	$currtime=time();
	@time=localtime($currtime);
	$r3=$time[5];
	$r4=$time[4];
	$r5=$time[3];
	$r6=$time[2];
	$r7=$time[1];
	$r8=$time[0];
	$r4++;

	print FILE "$r1|$r2|$r3|$r4|$r5|$r6|$r7|$r8\n";

	close(FILE);
}

sub denied{
	print "Content-type: text/html\n\n";
	open (FILE,$denied);
	@YOY=<FILE>;
	close(FILE);
	foreach $item (@YOY){
		print "$item\n";
	}
}

sub getid{

	$uid="";
	$r2=$ENV{'REMOTE_ADDR'};
	$file=$sessdb;
	open(FILE,$file);
	@WEST=<FILE>;
	close(FILE);
	foreach $user (@WEST){
		chomp($user);
		($t1,$t2,$t3,$t4,$t5,$t6,$t7,$t8)=split(/\|/,$user);
		if ($t2 eq $r2){
			$uid=$t1;
			last;
		}
	}

	$uid;
}

sub logout{
	$from=$ENV{'REMOTE_ADDR'};
	open(FILE,"$sessdb");
	@Lou=<FILE>;
	close(FILE);

	open(FILE,">$sessdb");
	foreach $iusr (@Lou){
		chomp($iusr);
		($t1,$t2,$t3,$t4,$t5,$t6,$t7,$t8)=split(/\|/,$iusr);
		if ($t2 ne $from){
			print FILE "$iusr\n";
		}
	}
	close(FILE);
}

sub denied{
	print "Content-type: text/html\n\n";
	open (FILE,$denied);
	@YOY=<FILE>;
	close(FILE);

	foreach $item (@YOY){
		print "$item\n";
	}
}

sub form_data {
 local (*ARG) = @_ if @_;
  local ($i, $key, $val);
  $ARG = $ENV{'QUERY_STRING'};
  @ARG = split(/[&;]/,$ARG);
  foreach $i (0 .. $#ARG) {
    $ARG[$i] =~ s/\+/ /g;
    ($key, $val) = split(/=/,$ARG[$i],2);
    $key =~ s/%(..)/pack("c",hex($1))/ge;
    $val =~ s/%(..)/pack("c",hex($1))/ge;
    $ARG{$key} .= "\0" if (defined($ARG{$key}));
    $ARG{$key} .= $val;
  }

     read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});

      @pairs = split(/&/, $buffer);
  foreach $pair (@pairs) {
      ($name, $value) = split(/=/, $pair);

      $name =~ tr/+/ /;
      $name =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;

      $value =~ tr/+/ /;
      $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
      $value =~ s/<!--(.|\n)*-->//g;
      $DATA{$name} = $value;
  }
}

1;
