#!/usr/local/bin/perl
## ---------------------------------------------------------------------------
##  NC Vote from NetCode.
##  Copyright 2000 by cj. All rights reserved.
## ---------------------------------------------------------------------------
##  http://netcode.virtualave.net
## ---------------------------------------------------------------------------


$cfg_page    = "/index.shtml"; ## After-vote redirection page
$cfg_workdir = "ncvote";
$cfg_bar     = 4;

$class_table = "ncvtable";
$class_item  = "ncvitem";
$class_bar   = "ncvbar";

$button_caption = "";

$nss = "<IMS SRC=\"/images/dummy.gif\" WIDTH=\"1\" HEIGHT=\"1\">"; ## Netscape stub

use CGI;

$o = new CGI;

config_set();
script_init();
data_load();

if($cfg_action eq "result")
{
    print $o->header(-type=>"text/html");
    print form_result();
    exit(0);
}

if($cfg_action eq "vote")
{
    my($i) = $o->param("radio");
    $data[$i][1] ++;
    data_store();
    print $o->redirect($cfg_page);
    exit(0);
}

{
    print $o->header(-type=>"text/html");
    print form_q();
    exit(0);
}

## ---------------------------------------------------------------------------

sub config_set
{
    if($o->param("action") eq "vote")
    {
        $cfg_action = "vote";
    }
    if($o->param("action") eq "result")
    {
        $cfg_action = "result";
    }
    if(defined($o->param("vote")))
    {
        $cfg_vote = $o->param("vote");
    }
    if(defined($o->param("page")))
    {
        $cfg_page = $o->param("page");
    }
    if(defined($o->param("bar")))
    {
        $cfg_bar = $o->param("bar");
    }
    if(!defined($cfg_action))
    {
        $cfg_action = "form";
    }
}

## ---------------------------------------------------------------------------

sub script_init
{
    if(!(-e $cfg_workdir))
    {
        mkdir($cfg_workdir, 0777);
    }
    if(!defined($cfg_vote))
    {
        print $o->header(-type=>"text/html");
        exit(1);
    }
}

## ---------------------------------------------------------------------------

sub data_load
{
    my($filename, $i);
    $filename = $cfg_workdir."/".$cfg_vote.".ncv";
    open(DATA, $filename) || die();
    $i = 0;
    foreach(<DATA>)
    {
        chomp($_);
        if(length($_) > 0)
        {
            $data[$i][0] = $_;
            $data[$i][1] = 0;
            $i ++;
        }
    }
    close(DATA);
    
    $filename = $cfg_workdir."/".$cfg_vote.".idx";
    open(DATAINDEX, $filename) || return;
    $i = 0;
    foreach(<DATAINDEX>)
    {
        if($i == int(@data))
        {
            last;
        }
        chomp($_);
        $data[$i][1] = int($_);
        $i ++;
    }
    close(DATAINDEX);
}

## ---------------------------------------------------------------------------

sub data_store
{
    my($filename, $i);
    $filename = $cfg_workdir."/".$cfg_vote.".idx";
    open(DATAINDEX, ">$filename") || die("Couldn't open $filename for writting: $!");
    flock(DATAINDEX, 2);
    for($i = 0;$i < int(@data);$i ++)
    {
        print DATAINDEX $data[$i][1]."\n";
    }
    close(DATAINDEX);
}

## ---------------------------------------------------------------------------

sub form_q
{
    my($reply, $i);
    $reply = "<FORM METHOD=\"POST\" ACTION=\"".$o->url()."\">".
             "<TABLE WIDTH=\"100%\" CELLSCPACING=\"0\" CELLPADDING=\"0\" BORDER=\"0\" CLASS=\"$class_table\">";
    for($i = 0;$i < int(@data);$i ++)
    {
        $reply .= "<TR><TD><INPUT TYPE=\"RADIO\" NAME=\"radio\" VALUE=\"$i\"";
        if($i == 0)
        {
            $reply .= "CHECKED";
        }
        $reply .= "></TD><TD WIDTH=\"100%\" CLASS=\"$class_item\">".$data[$i][0]."</TD></TR>";
    }
    $reply .= "<TR><TD COLSPAN=\"2\"><INPUT TYPE=\"SUBMIT\" VALUE=\"$button_caption\"></TD></TR>";
    $reply .= "</TABLE>";
    $reply .= "<INPUT TYPE=\"HIDDEN\" NAME=\"action\" VALUE=\"vote\">";
    $reply .= "<INPUT TYPE=\"HIDDEN\" NAME=\"vote\" VALUE=\"$cfg_vote\">";
    $reply .= "</FORM>";
    
    return $reply;
}

## ---------------------------------------------------------------------------

sub form_result
{
    my($reply, $i, $sum, $percent);
    
    $reply = "<TABLE WIDTH=\"100%\" CELLSPACING=\"0\" CELLPADDING=\"0\" BORDER=\"0\" CLASS=\"$class_table\">";
    
    $sum = 0;
    for($i = 0;$i < int(@data);$i ++)
    {
        $sum = $sum + $data[$i][1];
    }
    for($i = 0;$i < int(@data);$i ++)
    {
        $percent = int(($data[$i][1] * 100)/$sum);
        $reply .= "<TR><TD CLASS=\"class_item\">".$data[$i][0].":&nbsp;".$percent."\%</TD></TR>";
        $reply .= "<TR><TD CLASS=\"class_item\">";
        $reply .= "<TABLE WIDTH=\"100%\" HEIGHT=\"$cfg_bar\" CELLSPACING=\"0\" CELLPADDING=\"0\" BORDER=\"0\" CLASS=\"$class_table\"><TR>";
        $reply .= "<TD WIDTH=\"$percent\%\" BGCOLOR=\"\#ff0000\" CLASS=\"$class_bar\">$nss</TD><TD WIDTH=\"".int(100-$percent)."\%\">$nss</TD>";
        $reply .= "</TR></TABLE>";
        $reply .= "</TD></TR>";
    }
    
    $reply .= "</TABLE>";
    return $reply;
}

## ---------------------------------------------------------------------------
##  End of ncvote.cgi