#!/usr/local/bin/perl
####################################################
#
# Quick Poll
#    Version 3.0
#    (C) 1999-2000 Taro Sato, All rights reserved.
#        See README.TXT for important information.
#
####################################################

##############################
#
# Main routine ---------------
#
##############################

require 'qpoll30.conf';
require 'qpshared30.lib';

#$scriptpath = $ENV{'SCRIPT_NAME'};
$scriptpath = $scriptpat;
$query = $ENV{'QUERY_STRING'};
@pairs = split (/&/, $query);
foreach $pair (@pairs) {
   ($key, $value) = split(/=/, $pair);

   $key =~ tr/+/ /;
   $key =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
   $value =~ tr/+/ /;
   $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;

   if ($urlquery{$key}) {
      $urlquery{$key} .= ", $value";
   } else {
      $urlquery{$key} = $value;
   }
}

$pollid = $urlquery{'poll_id'};
$action = $urlquery{'action'};

$pollCookie = "poll_id$pollid";

if ($action eq "view") {
   if ($pollid eq "all") {
      &ViewAll();
   } else {
      &PutResults($pollid);
   }
} elsif ($action eq "replace") {
   if ($pollid eq "all") {
      print "Content-type: text/html\n\n";
      &Error(" ", "  .   README .");      
   }
   if ($ENV{'HTTP_COOKIE'} =~ m/$pollCookie/) {
      &PutResults($pollid);
   } else {
      &PutForm($pollid);
   }
} elsif ($action eq "process") {
   &ProcessVote($pollid);
} elsif ($action =~ m/http:\/\/*/) {
   &PutForm($pollid);
} else {
   print "Content-type: text/html\n\n";
   &Error(" ", "  .   README.");
}

exit;


##############################
#
# Subroutines ----------------
#
##############################


sub ProcessVote {
   $pollid = $_[0];

   read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
   @pairs = split (/&/, $buffer);
   &ParsePairs(@pairs);

   if ($formdata{'choice'} eq "") {
      print "Content-type: text/html\n\n";
      &Error("   ", "    .");
   } elsif ($ENV{'HTTP_COOKIE'} =~ m/cookie=set/) {
      &ReadPollData($datafile);
      $linenum = &GetSinglePollData($pollid);

      for ($i = 0; $i < @choices; $i += 3) {
         unless ($ENV{'HTTP_COOKIE'} =~ m/$pollCookie/) {
            if ($formdata{'choice'} =~ m/C$i/) {
               $choices[$i+2]++;
            }
         }
      }

      &PutSinglePollData($linenum);
      &WritePollData("$datafile");

      $now = time;
      ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = gmtime($now + 24 * 60 * 60 * $expiredate);
      $dayOfWeek = ("Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat")[$wday];
      $monthName = ("Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec")[$mon];
      $year += 1900 if $year < 1900;
      $sec = "0$sec" if $sec < 10;
      $min = "0$min" if $min < 10;
      $hour = "0$hour" if $hour < 10;
      print "Set-Cookie: ";
      print ("poll_id$pollid=voted; expires=$dayOfWeek, $mday-$monthName-$year $hour:$min:$sec GMT; path=/\n");

      if ($formdata{'action'} eq "replace") {
         print "Location: $ENV{'HTTP_REFERER'}\n\n";
      } else {
         print "Location: $formdata{'action'}\n\n";
      }
   } else {
      print "Content-type: text/html\n\n";
      &Error("Cookies ", "    cookies.");
   }
}


sub PutForm {
   $pollid = $_[0];

   &ReadPollData($datafile);
   &GetSinglePollData($pollid);

   print "Content-type: text/html\n\n";

   $num = @choices;
   $submit_reset = "submit";

   print "<FORM METHOD=\"post\" ACTION=\"$scriptpath?poll_id=$pollid&action=process\">";
   &PutFormTable();
   print "<INPUT TYPE=\"hidden\" NAME=\"action\" VALUE=\"$action\">";
   print "</FORM>";
   print "</FONT>";
}


sub PutResults {
   $pollid = $_[0];

   &ReadPollData($datafile);
   &GetSinglePollData($pollid);

   print "Content-type: text/html\n\n";

   $num = @choices;
   &PutResultsTable();
}


sub ViewAll {
   &ReadPollData($datafile);

   print "Content-type: text/html\n\n";
   print "<HTML><BODY><CENTER>";

   foreach $temp (@indata) {
      ($dummy, $i) = split(/\|/, $temp);
      &GetSinglePollData($i);

      $num = @choices;
      &PutResultsTable();
      print "<BR><HR><BR>";
   }

   $now = gmtime(time);
   print <<END;
<FONT FACE="Arial" SIZE="-2">
<P>$now GMT</P>
<P>Generated by Quick Poll ver. 3.0
<BR>(C) 2000 Taro Sato, All Rights Reserved.</P>
<BR><p><a href="http://www.freyn.agava.ru/" target="_blank"></a></p>
</FONT>
</CENTER></BODY></HTML>
END
}


