#!/usr/local/bin/perl
####################################################
#
# Quick Poll Administrator
#    Version 3.0
#    (C) 1999 Taro Sato, All rights reserved.
#        See README.TXT for important information.
#
####################################################

##############################
#
# Main routine ---------------
#
##############################

require 'qpoll30.conf';
require 'qpshared30.lib';

$colorchoices = "
  <OPTION VALUE=HEX>HEX
  <OPTION VALUE=#000000>׸
  <OPTION VALUE=#FFFFFF>
  <OPTION VALUE=#FF0000>
  <OPTION VALUE=#0000FF>
  <OPTION VALUE=#008000>
  <OPTION VALUE=#FFFF00>Ƹ
  <OPTION VALUE=#FFA500>
  <OPTION VALUE=#EE82EE>
  <OPTION VALUE=#800080>
  <OPTION VALUE=#FFC0CB>
  <OPTION VALUE=#C0C0C0>
  <OPTION VALUE=#FFD700>
  <OPTION VALUE=#808080>
  <OPTION VALUE=#00FFFF>
  <OPTION VALUE=#87CEEB>
  <OPTION VALUE=#ADD8E6>
  <OPTION VALUE=#FF00FF>
  <OPTION VALUE=#F0E68C>
";

#$scriptpath = $ENV{'SCRIPT_NAME'};
$workfile = "$datafile~";

read (STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@pairs = split(/&/, $buffer);
&ParsePairs(@pairs);

if (($formdata{process} eq "new") && ($ENV{'HTTP_REFERER'} eq $qpadmin_url)) {
   &Registration;
} elsif (($formdata{process} eq "confirmation") && ($ENV{'HTTP_REFERER'} eq $qpadmin_url)) {
   &Confirmation;
} elsif (($formdata{process} eq "edit") && ($ENV{'HTTP_REFERER'} eq $qpadmin_url)) {
   &Edit;
} elsif (($formdata{process} eq "cancel") && ($ENV{'HTTP_REFERER'} eq $qpadmin_url)) {
   &Cancel;
} elsif (($formdata{process} eq "save") && ($ENV{'HTTP_REFERER'} eq $qpadmin_url)) {
   &Save;
} elsif (($formdata{process} eq "editpoll") && ($ENV{'HTTP_REFERER'} eq $qpadmin_url)) {
   &EditPoll;
} elsif (($formdata{process} eq "deletepoll") && ($ENV{'HTTP_REFERER'} eq $qpadmin_url)) {
   &DeletePoll;
   &Edit;
} elsif (($formdata{process} eq "viewresultshtml") && ($ENV{'HTTP_REFERER'} eq $qpadmin_url)) {
   &ResultHTML;
} elsif (($formdata{process} eq "createpoll") && ($ENV{'HTTP_REFERER'} eq $qpadmin_url)) {
   &CreatePoll;
   &EditPoll;
} elsif (($formdata{process} eq "refresh") && ($ENV{'HTTP_REFERER'} eq $qpadmin_url)) {
   &SaveWorkFile;
   &EditPoll;
} elsif (($formdata{process} eq "backtomenu") && ($ENV{'HTTP_REFERER'} eq $qpadmin_url)) {
   &Edit;
} elsif (-e "$qpadmin_pswd") {
   &Login;
} else {
   &New;
}

exit;



##############################
#
# Subroutines ----------------
#
##############################


sub New {
   &Header(" ");
   print "      <FONT COLOR=\"#000055\"><P ALIGN=\"left\">     :</FONT>$scriptpath<P>";
   &IDPasswordNew();
   &Footer();
}


sub Registration {
   if (($formdata{name} eq "") || ($formdata{password} eq "")) {
      &Header("    ");
      print "      <FONT COLOR=\"#000055\"><P ALIGN=\"left\">       .   .</FONT><P>";
      &IDPasswordNew();
      &Footer();
   } else {
      $dummy = crypt($formdata{password}, "ts");

      FileLock("$qpadmin_pswd");
      open (TEMPFILE, ">$qpadmin_pswd") || &FileCreateError;
         print TEMPFILE "$formdata{name}:$dummy";
      close (TEMPFILE);
      FileUnlock("$qpadmin_pswd");
      chmod (0660, "$qpadmin_pswd");

      &Header(" ");
      print <<END;
      <FONT COLOR="#000055"><P ALIGN="left">         .
      <P><A HREF="$scriptpath"></A><BR>
      </FONT>
END
      &Footer();
   }
}


sub Login {
   &Header("   ");
   print "      <FONT COLOR=\"#000055\"><P ALIGN=\"left\">    .</FONT><P>"; 
   &IDPassword();
   &Footer();
}


sub Confirmation {
   FileLock("$qpadmin_pswd");
   open (TEMPFILE, "<$qpadmin_pswd") || &NoFile("$qpadmin_pswd");
      $logininfo = <TEMPFILE>;
   close (TEMPFILE);
   FileUnlock("$qpadmin_pswd");

   ($name, $password) = split (/:/, $logininfo);

   if (($formdata{name} ne $name) || (crypt($formdata{password}, "ts") ne $password)) {
      &Header("");
      print "      <FONT COLOR=\"#000055\"><P ALIGN=\"left\">     .      .</FONT><P>";
      &IDPassword();
      &Footer();

      exit;
   }
   &ReadPollData("$datafile");
   &WritePollData("$workfile");
   &Edit;
}


sub Edit {
   &ReadPollData("$workfile");

   &Header(" ");
   print <<END;
      <FONT COLOR="#000055">
      <TABLE BORDER=0 CELLSPACING=3 CELLPADDING=2>
        <TR>
          <TD ALIGN=center BGCOLOR=#FFCCFF>
            <FONT FACE="Arial"><B> </B></FONT>
          </TD>
          <TD ALIGN=center BGCOLOR=#FFCCFF>
            <FONT FACE="Arial"><B></B></FONT>
          </TD>
          <TD>
          </TD>
          <TD>
          </TD>
          <TD>
          </TD>
        </TR>
END

   $i = 0;
   foreach $temp (@indata) {
      ($dummy, $j) = split(/\|/, $temp);
      &GetSinglePollData($j);

      print <<END;
        <TR>
          <TD ALIGN=CENTER VALIGN=CENTER BGCOLOR=#99FF99>
            <FONT FACE="Arial">$j</FONT>
          </TD>
          <TD ALIGN="center" BGCOLOR="#DDDDDD">
            <TABLE BORDER="$tableborder" CELLSPACING="$cellspacing" CELLPADDING="$cellpadding" WIDTH="$boxwidth" BGCOLOR="$bgcolor2">
              <TR>
                <TD COLSPAN="2" BGCOLOR="$bgcolor1">
                  <FONT FACE="$basefont" SIZE="$basefontsize" COLOR="$textcolor">
                  $qheader
                  </FONT>
                </TD>
              </TR>
            </TABLE>
          </TD>
          <TD ALIGN=CENTER VALIGN=CENTER BGCOLOR="#DDDDDD">
            <FORM METHOD=POST ACTION=$scriptpath>
              <INPUT TYPE=HIDDEN NAME="process" value="editpoll">
              <INPUT TYPE=HIDDEN NAME="id" value="$j">
              <INPUT TYPE=SUBMIT NAME="submit" VALUE="">
            </FORM>
          </TD>
          <TD ALIGN=CENTER VALIGN=CENTER BGCOLOR="#DDDDDD">
            <FORM METHOD=POST ACTION=$scriptpath>
              <INPUT TYPE=HIDDEN NAME="process" value="viewresultshtml">
              <INPUT TYPE=HIDDEN NAME="id" value="$j">
              <INPUT TYPE=SUBMIT NAME="submit" VALUE="">
            </FORM>
          </TD>
          <TD ALIGN=CENTER VALIGN=CENTER BGCOLOR="#DDDDDD">
            <FORM METHOD=POST ACTION=$scriptpath>
              <INPUT TYPE=HIDDEN NAME="process" value="deletepoll">
              <INPUT TYPE=HIDDEN NAME="id" value="$j">
              <INPUT TYPE=SUBMIT NAME="submit" VALUE="">
            </FORM>
          </TD>
        </TR>
END
      $i += 1;
   }
   print <<END;
      </TABLE>

      <FORM METHOD=POST ACTION=$scriptpath>
        <INPUT TYPE=HIDDEN NAME="process" value="createpoll">
        <INPUT TYPE=SUBMIT NAME="submit" VALUE="  ">
      </FORM>
      <HR>
      <FORM METHOD=POST ACTION=$scriptpath>
        <INPUT TYPE=HIDDEN NAME="process" value="save">
        <INPUT TYPE=SUBMIT NAME="submit" VALUE="  ">
      </FORM>
      <FORM METHOD=POST ACTION=$scriptpath>
        <INPUT TYPE=HIDDEN NAME="process" value="cancel">
        <INPUT TYPE=SUBMIT NAME="submit" VALUE="  ">
      </FORM>

      </FONT>
END
   &Footer();
}


sub Cancel {
   &Header(" ");
   print "      <FONT COLOR=\"#000055\"><P ALIGN=\"left\">    .      .</FONT><P>";
   &IDPassword();
   &Footer();
}


sub Save {
   &FileLock("$datafile");
   rename ($workfile, $datafile);
   &FileUnlock("$datafile");

   &Header("Modifications Saved");
   print "      <FONT COLOR=\"#000055\"><P ALIGN=\"left\">  , $datafile,   .      .</FONT><P>";
   &IDPassword();
   &Footer();
}


sub EditPoll {
   &ReadPollData($workfile);
   $linenum = &GetSinglePollData($formdata{id});

   &Header("");
   print <<END;
      <CENTER>
      <TABLE BORDER=0 CELLSPACING=3 CELLPADDING=2 WIDTH=100%>
        <TR>
          <TD ALIGN=center BGCOLOR=#FFCCFF>
            <FONT FACE="Arial"><B> </B></FONT>
          </TD>
        </TR>
        <TR>
          <TD ALIGN=center VALIGN=center BGCOLOR="#FFFFFF">
END
   &PutForm;
   print <<END;
          </TD>
        </TR>
        <TR>
          <TD ALIGN=center BGCOLOR=#FFCCFF>
            <FONT FACE="Arial"><B></B></FONT>
          </TD>
        </TR>
        <TR>
          <TD ALIGN=center VALIGN=center BGCOLOR="#FFFFFF">
END
   &PutResultsTable();
   print <<END;
          </TD>
        </TR>
      </TABLE>
      </CENTER>
      <HR>
END
   &EditScreen;
   print <<END;
    </TD>
  </TR>
</TABLE>
</BODY></HTML>
END
}


sub PutForm {
   $submit_reset = "reset";

   print "<FORM>";
   print "<INPUT TYPE=\"hidden\" NAME=\"process\" VALUE=\"refresh\">";
   print "<INPUT TYPE=\"hidden\" NAME=\"id\" VALUE=\"$formdata{id}\">";
   &PutFormTable();
   print "</FORM>";
}


sub LoadDefaultSelections {
   %basefontsizeset = ("");
   $basefontsizeset{$basefontsize} = "SELECTED";

   %styleset = ("");
   $styleset{$style} = "SELECTED";

   %barwidthset = ("");
   $barwidthset{$barwidth} = "SELECTED";

   %decimalset = ("");
   $decimalset{$decimal} = "SELECTED";

   ($temp, $dummy) = split(/B/, $displayorder);

   $temp = substr($dummy, 0, 1);
   %barrightset = ("");
   $barrightset{$temp} = "SELECTED";

   $temp = substr($dummy, 1, 1);
   %barbelowset = ("");
   $barbelowset{$temp} = "SELECTED";

   $temp = substr($displayorder, 0, 1);
   %column1set = ("");
   $column1set{$temp} = "SELECTED";

   $temp = substr($displayorder, 3, 1);
   %column2set = ("");
   $column2set{$temp} = "SELECTED";

   $temp = substr($displayorder, 6, 1);
   %column3set = ("");
   $column3set{$temp} = "SELECTED";

   $temp = substr($displayorder, 9, 1);
   %column4set = ("");
   $column4set{$temp} = "SELECTED";
}


sub EditScreen {
   &LoadDefaultSelections;

   print <<END;
<CENTER>
<FORM METHOD=POST ACTION=$scriptpath>
<INPUT TYPE=HIDDEN NAME="process" value="backtomenu">
<INPUT TYPE=SUBMIT NAME="submit" VALUE="  ">
</FORM>
<P><HR>
<FORM METHOD=POST ACTION=$scriptpath>
<INPUT TYPE=HIDDEN NAME="process" value="refresh">
<INPUT TYPE=HIDDEN NAME="previd" value="$id">
<INPUT TYPE=SUBMIT NAME="submit" VALUE=" ">
<P>
</CENTER>
<HR>

<H3 ALIGN=left><FONT COLOR=lightgreen>1.   </FONT></H3>

<TABLE>
  <TR>
    <TD ALIGN=right><FONT FACE=Arial COLOR=#FFFFFF><B>  :</B></FONT></TD>
    <TD><INPUT TYPE=TEXT NAME="id" SIZE=3 MAXLENGTH=3 VALUE="$id"></TD>
  </TR>
  <TR>
    <TD ALIGN=right><FONT FACE=Arial COLOR=#FFFFFF><B>  Cookie:</B></FONT></TD>
    <TD><INPUT TYPE=TEXT NAME="expiredate" SIZE=6 VALUE="$expiredate"></TD>
  </TR>
</TABLE>

<H3 ALIGN=left><FONT COLOR=lightgreen>2.  </FONT></H3>

<BLOCKQUOTE><H4 ALIGN=4><FONT COLOR=skyblue></FONT></H4></BLOCKQUOTE>

<TABLE>
  <TR>
    <TD ALIGN=right><FONT FACE=Arial COLOR=#FFFFFF><B> :</B></FONT></TD>
    <TD><INPUT TYPE=TEXT NAME="basefont" SIZE=20 VALUE="$basefont"></TD>
  </TR>
  <TR>
    <TD ALIGN=right><FONT FACE=Arial COLOR=#FFFFFF><B> :</B></FONT></TD>
    <TD>
      <SELECT NAME="basefontsize" SIZE=1>
      <OPTION VALUE="+4" $basefontsizeset{'+4'}>+4
      <OPTION VALUE="+3" $basefontsizeset{'+3'}>+3
      <OPTION VALUE="+2" $basefontsizeset{'+2'}>+2
      <OPTION VALUE="+1" $basefontsizeset{'+1'}>+1
      <OPTION VALUE="+0" $basefontsizeset{'+0'}>0
      <OPTION VALUE="-1" $basefontsizeset{'-1'}>-1
      <OPTION VALUE="-2" $basefontsizeset{'-2'}>-2
      <OPTION VALUE="-3" $basefontsizeset{'-3'}>-3
      <OPTION VALUE="-4" $basefontsizeset{'-4'}>-4
      </SELECT>
    </TD>
  </TR>
  <TR>
    <TD ALIGN=right><FONT FACE=Arial COLOR=#FFFFFF><B> :</B></FONT></TD>
    <TD><INPUT TYPE=TEXT NAME="boxwidth" SIZE=4 MAXLENGTH=4 VALUE="$boxwidth"><FONT FACE=Arial COLOR=#FFFFFF>(pixel)</FONT></TD>
  </TR>
  <TR>
    <TD ALIGN=right><FONT FACE=Arial COLOR=#FFFFFF><B> :</B></FONT></TD>
    <TD><INPUT TYPE=TEXT NAME="tableborder" SIZE=2 MAXLENGTH=2 VALUE="$tableborder"><FONT FACE=Arial COLOR=#FFFFFF>(pixel)</FONT></TD>
  </TR>
  <TR>
    <TD ALIGN=right><FONT FACE=Arial COLOR=#FFFFFF><B>  :</B></FONT></TD>
    <TD><INPUT TYPE=TEXT NAME="cellspacing" SIZE=2 MAXLENGTH=2 VALUE="$cellspacing"><FONT FACE=Arial COLOR=#FFFFFF>(pixel)</FONT></TD>
  </TR>
  <TR>
    <TD ALIGN=right><FONT FACE=Arial COLOR=#FFFFFF><B> :</B></FONT></TD>
    <TD><INPUT TYPE=TEXT NAME="cellpadding" SIZE=2 MAXLENGTH=2 VALUE="$cellpadding"><FONT FACE=Arial COLOR=#FFFFFF>(pixel)</FONT></TD>
  </TR>
</TABLE>

<BLOCKQUOTE><H4 ALIGN=4><FONT COLOR=skyblue> </FONT></H4></BLOCKQUOTE>

<TABLE>
  <TR>
    <TD ALIGN=right><FONT FACE=Arial COLOR=#FFFFFF><B>:</B></FONT></TD>
    <TD>
      <SELECT NAME="style" SIZE=1>
      <OPTION VALUE="0" $styleset{'0'}> <OPTION VALUE="2" $styleset{'2'}> 
      <OPTION VALUE="3" $styleset{'3'}> <OPTION VALUE="4" $styleset{'4'}> 
      <OPTION VALUE="1" $styleset{'1'}> 
      </SELECT>
    </TD>
  </TR>
  <TR>
    <TD ALIGN=right><FONT FACE=Arial COLOR=#FFFFFF><B>  :</B></FONT></TD>
    <TD><INPUT TYPE=TEXT NAME="submittext" SIZE=15 VALUE="$submittext"><FONT FACE=Arial COLOR=#FFFFFF>()</FONT></TD>
  </TR>
  <TR>
    <TD ALIGN=right><FONT FACE=Arial COLOR=#FFFFFF><B>  :</B></FONT></TD>
    <TD><INPUT TYPE=TEXT NAME="submitimage" SIZE=30 VALUE="$submitimage"><FONT FACE=Arial COLOR=#FFFFFF>(URL)</FONT></TD>
  </TR>
  <TR>
    <TD ALIGN=right><FONT FACE=Arial COLOR=#FFFFFF><B>  :</B></FONT></TD>
    <TD>
      <TEXTAREA NAME="viewresults" ROWS=2 COLS=30 WRAP=VIRTUAL>$viewresults</TEXTAREA><FONT FACE=Arial COLOR=#FFFFFF>(HTML)</FONT>
    </TD>
  </TR>
</TABLE>

<BLOCKQUOTE><H4 ALIGN=4><FONT COLOR=skyblue></FONT></H4></BLOCKQUOTE>

<TABLE>
  <TR>
    <TD ALIGN=right><FONT FACE=Arial COLOR=#FFFFFF><B>  :</B></FONT></TD>
    <TD><INPUT TYPE=TEXT NAME="totaltext" SIZE=15 VALUE="$totaltext"><FONT FACE=Arial COLOR=#FFFFFF>(HTML)</FONT></TD>
  </TR>
  <TR>
    <TD ALIGN=right><FONT FACE=Arial COLOR=#FFFFFF><B>  ():</B></FONT></TD>
    <TD><INPUT TYPE=TEXT NAME="votepre" SIZE=15 VALUE="$votepre"><FONT FACE=Arial COLOR=#FFFFFF>(HTML)</FONT></TD>
  </TR>
  <TR>
    <TD ALIGN=right><FONT FACE=Arial COLOR=#FFFFFF><B>  ():</B></FONT></TD>
    <TD><INPUT TYPE=TEXT NAME="votesuff" SIZE=15 VALUE="$votesuff"><FONT FACE=Arial COLOR=#FFFFFF>(HTML)</FONT></TD>
  </TR>
  <TR>
    <TD ALIGN=right><FONT FACE=Arial COLOR=#FFFFFF><B>    %:</B></FONT></TD>
    <TD>
      <SELECT NAME="decimal" SIZE=1>
      <OPTION VALUE="0" $decimalset{'0'}>0<OPTION VALUE="1" $decimalset{'1'}>1<OPTION VALUE="2" $decimalset{'2'}>2
      <OPTION VALUE="3" $decimalset{'3'}>3<OPTION VALUE="4" $decimalset{'4'}>4<OPTION VALUE="5" $decimalset{'5'}>5
      </SELECT>
    </TD>
  </TR>
  <TR>
    <TD ALIGN=right><FONT FACE=Arial COLOR=#FFFFFF><B> :</B></FONT></TD>
    <TD>
      <SELECT NAME="barwidth" SIZE=1>
      <OPTION VALUE="+4" $barwidthset{'+4'}>+4
      <OPTION VALUE="+3" $barwidthset{'+3'}>+3
      <OPTION VALUE="+2" $barwidthset{'+2'}>+2
      <OPTION VALUE="+1" $barwidthset{'+1'}>+1
      <OPTION VALUE="+0" $barwidthset{'+0'}>0
      <OPTION VALUE="-1" $barwidthset{'-1'}>-1
      <OPTION VALUE="-2" $barwidthset{'-2'}>-2
      <OPTION VALUE="-3" $barwidthset{'-3'}>-3
      <OPTION VALUE="-4" $barwidthset{'-4'}>-4
      </SELECT>
    </TD>
  </TR>
  <TR>
    <TD ALIGN=right><FONT FACE=Arial COLOR=#FFFFFF><B>  :</B></FONT></TD>
    <TD><INPUT TYPE=TEXT NAME="barmaxlength" SIZE=3 MAXLENGTH=3 VALUE="$barmaxlength"><FONT FACE=Arial COLOR=#FFFFFF>(pixel)</FONT></TD>
  </TR>
  <TR>
    <TD ALIGN=right><FONT FACE=Arial COLOR=#FFFFFF><B>   :</B></FONT></TD>
    <TD>
      <SELECT NAME="barright" SIZE=1>
      <OPTION VALUE="0" $barrightset{'0'}><OPTION VALUE="2" $barrightset{'2'}><OPTION VALUE="1" $barrightset{'1'}>%
      </SELECT>
    </TD>
  </TR>
  <TR>
    <TD ALIGN=right><FONT FACE=Arial COLOR=#FFFFFF><B>  :</B></FONT></TD>
    <TD>
      <SELECT NAME="barbelow" SIZE=1>
      <OPTION VALUE="0" $barbelowset{'0'}><OPTION VALUE="2" $barbelowset{'2'}><OPTION VALUE="1" $barbelowset{'1'}>%
      </SELECT>
    </TD>
  </TR>
  <TR>
    <TD ALIGN=right><FONT FACE=Arial COLOR=#FFFFFF><B> :</B></FONT></TD>
    <TD>
      <SELECT NAME="column1" SIZE=1>
      <OPTION VALUE="C00" $column1set{'C'}><OPTION VALUE="B00" $column1set{'B'}><OPTION VALUE="P00" $column1set{'P'}>%<OPTION VALUE="N00" $column1set{'N'}>
      </SELECT>
    </TD>
  </TR>
  <TR>
    <TD ALIGN=right><FONT FACE=Arial COLOR=#FFFFFF><B> :</B></FONT></TD>
    <TD>
      <SELECT NAME="column2" SIZE=1>
      <OPTION VALUE="C00" $column2set{'C'}><OPTION VALUE="B00" $column2set{'B'}><OPTION VALUE="P00" $column2set{'P'}>%<OPTION VALUE="N00" $column2set{'N'}>
      </SELECT>
    </TD>
  </TR>
  <TR>
    <TD ALIGN=right><FONT FACE=Arial COLOR=#FFFFFF><B> :</B></FONT></TD>
    <TD>
      <SELECT NAME="column3" SIZE=1>
      <OPTION VALUE="" $column3set{''}><OPTION VALUE="C00" $column3set{'C'}><OPTION VALUE="B00" $column3set{'B'}><OPTION VALUE="P00" $column3set{'P'}>%<OPTION VALUE="N00" $column3set{'N'}>
      </SELECT>
    </TD>
  </TR>
  <TR>
    <TD ALIGN=right><FONT FACE=Arial COLOR=#FFFFFF><B> :</B></FONT></TD>
    <TD>
      <SELECT NAME="column4" SIZE=1>
      <OPTION VALUE="" $column4set{''}><OPTION VALUE="C00" $column4set{'C'}><OPTION VALUE="B00" $column4set{'B'}><OPTION VALUE="P00" $column4set{'P'}>%<OPTION VALUE="N00" $column4set{'N'}>
      </SELECT>
    </TD>
  </TR>
</TABLE>

<H3 ALIGN=left><FONT COLOR=lightgreen>3. </FONT></H3>

<TABLE>
  <TR>
    <TD ALIGN=right><FONT FACE=Arial COLOR=#FFFFFF><B> :</B></FONT></TD>
    <TD>
      <SELECT name="textcolor" size=1>$colorchoices</SELECT>
      <FONT FACE=Arial COLOR=#FFFFFF>HEX: </FONT><INPUT TYPE=TEXT NAME="textcolorHEX" SIZE=7 VALUE="$textcolor">
    </TD>
  </TR>
  <TR>
    <TD ALIGN=right><FONT FACE=Arial COLOR=#FFFFFF><B>  :</B></FONT></TD>
    <TD>
      <SELECT name="bgcolor1" size=1>$colorchoices</SELECT>
      <FONT FACE=Arial COLOR=#FFFFFF>HEX: </FONT><INPUT TYPE=TEXT NAME="bgcolor1HEX" SIZE=7 VALUE="$bgcolor1">
    </TD>
  </TR>
  <TR>
    <TD ALIGN=right><FONT FACE=Arial COLOR=#FFFFFF><B>  :</B></FONT></TD>
    <TD>
      <SELECT name="bgcolor2" size=1>$colorchoices</SELECT>
      <FONT FACE=Arial COLOR=#FFFFFF>HEX: </FONT><INPUT TYPE=TEXT NAME="bgcolor2HEX" SIZE=7 VALUE="$bgcolor2">
    </TD>
  </TR>
  <TR>
    <TD ALIGN=right><FONT FACE=Arial COLOR=#FFFFFF><B>  :</B></FONT></TD>
    <TD>
      <SELECT name="barbackground" size=1>$colorchoices</SELECT>
      <FONT FACE=Arial COLOR=#FFFFFF>HEX: </FONT><INPUT TYPE=TEXT NAME="barbackgroundHEX" SIZE=7 VALUE="$barbackground">
    </TD>
  </TR>
</TABLE>


<H3 ALIGN=left><FONT COLOR=lightgreen>4. </FONT></H3>

<TABLE>
  <TR><TD><FONT FACE=Arial COLOR=#FFFFFF><B> :</B></FONT></TD></TR>
  <TR>
    <TD>
      <TEXTAREA NAME="qheader" ROWS=4 COLS=60 WRAP=VIRTUAL>$qheader</TEXTAREA>
    </TD>
  </TR>
</TABLE>

<H3 ALIGN=left><FONT COLOR=lightgreen>5. </FONT></H3>
END

   for ($i = 0; $i < @choices ; $i += 3) {
      $dummy = $i/3+1;
      print <<END;
<TABLE>
  <TR><TD COLSPAN=2><FONT FACE=Arial COLOR=#FFFFFF><B>  $dummy:</B></FONT></TD></TR>
  <TR>
    <TD COLSPAN=2>
      <TEXTAREA NAME="choice$i" ROWS=3 COLS=60 WRAP=VIRTUAL>$choices[$i]</TEXTAREA>
    </TD>
  <TR>
    <TD NOWRAP>
      <FONT FACE=Arial COLOR=#FFFFFF><B> :</B></FONT>
      <SELECT name="barcolor$i" size=1>$colorchoices</SELECT>
      <FONT FACE=Arial COLOR=#FFFFFF>HEX:</FONT><INPUT TYPE=TEXT NAME="barcolorHEX$i" SIZE=7 VALUE="$choices[$i+1]">
    </TD>
    <TD ALIGN=right>
      <FONT FACE=Arial COLOR=#FFFFFF><B>:</B></FONT><INPUT TYPE=TEXT NAME="vote$i" SIZE=7 VALUE="$choices[$i+2]">
    </TD>
  </TR>
</TABLE>
<P>
END
   }

   print <<END;
<TABLE>
  <TR><TD COLSPAN=2><FONT FACE=Arial COLOR=#FFFFFF><B>  :</B></FONT></TD></TR>
  <TR>
    <TD COLSPAN=2>
      <TEXTAREA NAME="choice$i" ROWS=3 COLS=60 WRAP=VIRTUAL>$choices[$i]</TEXTAREA>
    </TD>
  <TR>
    <TD NOWRAP>
      <FONT FACE=Arial COLOR=#FFFFFF><B> :</B></FONT>
      <SELECT name="barcolor$i" size=1>$colorchoices</SELECT>
      <FONT FACE=Arial COLOR=#FFFFFF>HEX:</FONT><INPUT TYPE=TEXT NAME="barcolorHEX$i" SIZE=7 VALUE="$choices[$i+1]">
    </TD>
    <TD ALIGN=right>
      <FONT FACE=Arial COLOR=#FFFFFF><B>:</B></FONT><INPUT TYPE=TEXT NAME="vote$i" SIZE=7 VALUE="$choices[$i+2]">
    </TD>
  </TR>
</TABLE>
<P>
</FORM>
END

   &Footer();
}


sub SaveWorkFile {
   &ReadPollData($workfile);
   $linenum = &GetSinglePollData($formdata{previd});

         $id = $formdata{id};
         $id =~ s/[^0-9\.]//g;
         $id = &SeekHighestPollID if ($id eq "");
         $qheader = $formdata{qheader};
         $qheader =~ s/[|\n\r]//g;
         $expiredate = $formdata{expiredate};
         $expiredate =~ s/[^0-9\.]//g;
         $expiredate = 365 if ($expiredate eq "");
         $boxwidth = $formdata{boxwidth};
         $boxwidth =~ s/[^0-9\.]//g;
         $boxwidth = 0 if ($boxwidth eq "");
         $tableborder = $formdata{tableborder};
         $tableborder =~ s/[^0-9\.]//g;
         $tableborder = 0 if ($tableborder eq "");
         $cellspacing = $formdata{cellspacing};
         $cellspacing =~ s/[^0-9\.]//g;
         $cellspacing = 0 if ($cellspacing eq "");
         $cellpadding = $formdata{cellpadding};
         $cellpadding =~ s/[^0-9\.]//g;
         $cellpadding = 2 if ($cellpadding eq "");
         $style = $formdata{style};
         $submittext = $formdata{submittext};
         $submittext =~ s/[|\n\r]//g;
         $submittext = "Vote!" if ($submittext eq "");
         $submitimage = $formdata{submitimage};
         $submitimage =~ s/[|\n\r]//g;
         $viewresults = $formdata{viewresults};
         $viewresults =~ s/[|\n\r]//g;
         $basefont = $formdata{basefont};
         $basefont =~ s/[|\n\r]//g;
         $basefont = "Arial" if ($basefont eq "");
         $basefontsize = $formdata{basefontsize};
         $decimal = $formdata{decimal};
         $votepre = $formdata{votepre};
         $votepre =~ s/[|\n\r]//g;
         $votesuff = $formdata{votesuff};
         $votesuff =~ s/[|\n\r]//g;
         $totaltext = $formdata{totaltext};
         $totaltext =~ s/[|\n\r]//g;
         $barwidth = $formdata{barwidth};
         $barmaxlength = $formdata{barmaxlength};
         $barmaxlength =~ s/[^0-9\.]//g;
         $barmaxlength = 100 if ($barmaxlength eq "");
         $displayorder = "$formdata{column1}$formdata{column2}$formdata{column3}$formdata{column4}";
         $displayorder =~ s/B00/B$formdata{barright}$formdata{barbelow}/g;
         if ($formdata{textcolor} eq "HEX") {
            if ($formdata{textcolorHEX} =~ /^#[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F]/) {
               $textcolor = $formdata{textcolorHEX};
            } else {
               $textcolor = "#000000";
            }
         } else {
            $textcolor = $formdata{textcolor};
         }
         if ($formdata{bgcolor1} eq "HEX") {
            if ($formdata{bgcolor1HEX} =~ /^#[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F]/) {
               $bgcolor1 = $formdata{bgcolor1HEX};
            } else {
               $bgcolor1 = "#FFFFFF";
            }
         } else {
            $bgcolor1 = $formdata{bgcolor1};
         }
         if ($formdata{bgcolor2} eq "HEX") {
            if ($formdata{bgcolor2HEX} =~ /^#[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F]/) {
               $bgcolor2 = $formdata{bgcolor2HEX};
            } else {
               $bgcolor2 = "#FFFFFF";
            }
         } else {
            $bgcolor2 = $formdata{bgcolor2};
         }
         if ($formdata{barbackground} eq "HEX") {
            if ($formdata{barbackgroundHEX} =~ /^#[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F]/) {
               $barbackground = $formdata{barbackgroundHEX};
            } else {
               $barbackground = "#FFFFFF";
            }
         } else {
            $barbackground = $formdata{barbackground};
         }

         $num = @choices + 3;
         @choices = ("");
         $j = 0;
         for ($k = 0; $k < $num; $k += 3) {
            if ($formdata{"choice$k"} eq "") {
               # skip
            } else {
               $choices[$j] = $formdata{"choice$k"};
               $choices[$j] =~ s/[|\n\r]//g;
               if ($formdata{"barcolor$k"} eq "HEX") {
                  if ($formdata{"barcolorHEX$k"} =~ /^#[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F]/) {
                     $choices[$j+1] = $formdata{"barcolorHEX$k"};
                  } else {
                     $choices[$j+1] = "#0000FF";
                  }
               } else {
                  $choices[$j+1] = $formdata{"barcolor$k"};
               }
               $choices[$j+2] = $formdata{"vote$k"};
               $choices[$j+2] =~ s/\D//g;
               $choices[$j+2] = 0 if ($choices[$j+2] eq "");
               $j += 3;
            }
         }

   $formdata{id} = $id;

   &PutSinglePollData($linenum);
   &WritePollData($workfile);
}


sub ResultHTML {
   &ReadPollData($workfile);
   &GetSinglePollData($formdata{id});
   print "Content-type: text/html\n\n";
   &PutResultsTable();
}


sub CreatePoll {
   local($id) = &SeekHighestPollID;
   &ReadPollData($workfile);
   push(@indata, "QP30|$id|  |0|0|0|0|2|0|!|||Arial|-1|1|(|)|<B> :|+0|100|C00B00P00N00|#000000|#FFFFFF|#FFFFFF|#FFFFFF| |#0000FF|0\n");
   &WritePollData($workfile);
   $formdata{id} = $id;
}


sub SeekHighestPollID {
   local($i) = 0;
   local($highest) = 0;
   &ReadPollData($workfile);

   foreach $temp (@indata) {
      ($dummy, $i, $dummy) = split(/\|/, $temp);
      $highest = $i if ($i > $highest);
   }
   return $highest + 1;
}


sub CheckPollID {
   local($id) = $_[0];

   &ReadPollData($workfile);

   foreach $temp (@indata) {
      ($dummy, $i, $dummy) = split(/\|/, $temp);
      $id = &SeekHighestPollID if ($i eq $id);
   }
   return $id;
}


sub DeletePoll {
   &ReadPollData($workfile);
   (@dummy) = (@indata);
   $linenum = &GetSinglePollData($formdata{id});
   (@indata) = ("");
   $i = 0;
   foreach $temp (@dummy) {
      push(@indata, $temp) if ($i ne $linenum);
      $i += 1;
   }
   &WritePollData($workfile);
}


sub IDPasswordNew {
   print <<END;
      <CENTER>
      <TABLE BORDER=0><TR><TD>
        <FORM METHOD=POST ACTION=$scriptpath>
        <FONT FACE="Arial" COLOR="#000055">
        <INPUT TYPE=HIDDEN NAME="process" VALUE="new">
         :<BR>
        <INPUT TYPE=TEXT NAME="name"><BR>
        :<BR>
        <INPUT TYPE=PASSWORD NAME="password"><BR><BR>
        <CENTER>
        <INPUT TYPE=SUBMIT NAME="submit" VALUE="">
        </CENTER>
        </FONT>
        </FORM>
      </TD></TR></TABLE>
      </CENTER>
END
}


sub IDPassword {
   print <<END;
      <CENTER>
      <TABLE BORDER=0><TR><TD>
        <FONT FACE="Arial" COLOR="#000055">
        <FORM METHOD=POST ACTION=$scriptpath>
        <INPUT TYPE=HIDDEN NAME="process" VALUE="confirmation">
         :<BR>
        <INPUT TYPE=TEXT NAME="name"><BR>
        :<BR>
        <INPUT TYPE=PASSWORD NAME="password"><BR><BR>
        <CENTER>
        <INPUT TYPE=SUBMIT NAME="submit" VALUE="">
        </CENTER>
        </FORM>
        </FONT>
      </TD></TR></TABLE>
      </CENTER>
END
}


sub Header {
   $title = $_[0];

   print "Content-type: text/html\n\n";
   print <<END;
<HTML><HEAD><TITLE> </TITLE></HEAD><BODY>
<CENTER>
<TABLE BORDER="8" CELLPADDING="4" BGCOLOR="#9999FF" WIDTH="380">
  <TR>
    <TD ALIGN="CENTER">
      <FONT FACE="Arial" COLOR="#FFFFFF">
      <BR>
      <H4> </H4>
      <P><HR>
      <FONT COLOR="#FF0000"><H3>$title</H3></FONT>
END
}


sub Footer {
   print <<END;
      <CENTER>
      <P><HR>
      <FONT SIZE="-2"><P>Quick Poll Administrator ver. 3.0<BR>
      (C) 1999-2000 Taro Sato, All Rights Reserved.</FONT> 
      <BR>
<p><a href="http://www.freyn.agava.ru/" target="_blank"></a></p>
<BR>
    </TD>
  </TR>
</TABLE>
</CENTER>
</BODY>
</HTML>
END
}

