#!/usr/local/bin/perl
#
#########################################
#            Fatalyzer                  #
#                                       #
#     by  David J Spelts                #
#     http://www.spelts.com/            #
#     dave@spelts.com                   #
#                                       #
#########################################


#Do not edit below this line
##############################################################################################

print "Content-type: text/html\n\n";


MAIN:
{
&ReadParse;

if ($in{'Mid Thigh'}) {
	&Percentage;
	} elsif ($in{'sex'} eq "Male") {
	&Male;
	} elsif ($in{'sex'} eq "Female") {
	&Female;
	} else {
	&ShowForm;
	}
}

#############   ShowForm   #################
sub ShowForm {
print <<EOT;
<HTML><HEAD>    
<TITLE>Fatalyzer</TITLE>
</HEAD>

<BODY bgcolor="\#000066">
<center>
<table border="0" width="100%" bgcolor="\#EEEEEE" cellspacing="6" cellpadding="6">
<tr><td align="center"><H1>Fatalyzer</H1></td></tr>
<tr><td><P>Fatalyzer will calculate your percentage of bodyfat based on various skinfold measurements. 
You will need skinfold calipers in order to obtain these measurements.</td></tr>
<tr><td align="center">
	<table border="0" width="50%" bgcolor="\#DDDDDF" cellspacing="6" cellpadding="6">
	<form method="post">
	<tr><td width="50%"><b>Sex:</b></td><td width="50%"><input type=radio name="sex" value="Male"><b>Male</b><br><input type=radio name="sex" value="Female"><b>Female</b></td></tr>
	<tr><td width="50%"><b>Age:</b></td><td width="50%"><input type=text name="age" size="4"></td></tr>
	<tr><td colspan="2" align="center"><input type="submit" value="Continue"></td></tr>
	</form>
	</table>
</td></tr>

<tr><td bgcolor="\#000066"><br></td></tr>
<tr><td align=center>
<A HREF="http://www.burstnet.com/ads/ad4762a-map.cgi"><IMG SRC="http://www.burstnet.com/cgi-bin/ads/ad4762a.cgi" ISMAP BORDER="2" ALIGN="BOTTOM" width="468" height="60"></A><BR><font size="-1"><a href="http://www.spelts.com/">David Spelts Software</a> Copyright 1999.</font>
</td></tr>
</table>
</center>
</BODY>
</HTML>
EOT
}

#############   Male  #################
sub Male {

$sex = $in{'sex'}; 
$age = $in{'age'}; 

print <<EOT;
<HTML><HEAD>    
<TITLE>Fatalyzer</TITLE>
</HEAD>

<BODY bgcolor="\#000066">
<center>
<table border="0" width="100%" bgcolor="\#EEEEEE" cellspacing="6" cellpadding="6">
<tr><td align="center"><H1>Fatalyzer</H1></td></tr>
<tr><td align="center">Enter your skinfold measurements (in millimeters).</td></tr>
<tr><td align="center">
	<table border="0" width="50%" bgcolor="\#DDDDDF" cellspacing="6" cellpadding="6">
	<form method="post">
	<tr><td width="50%"><b>Upper Chest</b></td><td width="50%"><input type=text name="Upper Chest" size="4"></td></tr>
	<tr><td width="50%"><b>Mid Abdomen</b></td><td width="50%"><input type=text name="Mid Abdomen" size="4"></td></tr>
	<tr><td width="50%"><b>Mid Thigh</b></td><td width="50%"><input type=text name="Mid Thigh" size="4"></td></tr>
	<tr><td colspan="2" align="center"><input type="submit" value="Continue"></td></tr>
	<input type="hidden" name="sex" value=$sex>
	<input type="hidden" name="age" value=$age>
	</form>
	</table>
</td></tr>

<tr><td bgcolor="\#000066"><br></td></tr>
<tr><td align=center>
<A HREF="http://www.burstnet.com/ads/ad4762a-map.cgi"><IMG SRC="http://www.burstnet.com/cgi-bin/ads/ad4762a.cgi" ISMAP BORDER="2" ALIGN="BOTTOM" width="468" height="60"></A><BR><font size="-1"><a href="http://www.spelts.com/">David Spelts Software</a> Copyright 1999.</font>
</td></tr>
</table>
</center>
</BODY>
</HTML>
EOT

}


#############   Female  #################
sub Female {

$sex = $in{'sex'}; 
$age = $in{'age'}; 

print <<EOT;
<HTML><HEAD>    
<TITLE>Fatalyzer</TITLE>
</HEAD>

<BODY bgcolor="\#000066">
<center>
<table border="0" width="100%" bgcolor="\#EEEEEE" cellspacing="6" cellpadding="6">
<tr><td align="center"><H1>Fatalyzer</H1></td></tr>
<tr><td align="center">Enter your skinfold measurements (in millimeters).</td></tr>
<tr><td align="center">
	<table border="0" width="50%" bgcolor="\#DDDDDF" cellspacing="6" cellpadding="6">
	<form method="post">
	<tr><td width="50%"><b>Tricep</b></td><td width="50%"><input type=text name="Tricep" size="4"></td></tr>
	<tr><td width="50%"><b>Far Right Abdomen</b></td><td width="50%"><input type=text name="Far Right Abdomen" size="4"></td></tr>
	<tr><td width="50%"><b>Mid Thigh</b></td><td width="50%"><input type=text name="Mid Thigh" size="4"></td></tr>
	<tr><td colspan="2" align="center"><input type="submit" value="Continue"></td></tr>
	<input type="hidden" name="sex" value=$sex>
	<input type="hidden" name="age" value=$age>
	</form>
	</table>
</td></tr>

<tr><td bgcolor="\#000066"><br></td></tr>
<tr><td align=center>
<A HREF="http://www.burstnet.com/ads/ad4762a-map.cgi"><IMG SRC="http://www.burstnet.com/cgi-bin/ads/ad4762a.cgi" ISMAP BORDER="2" ALIGN="BOTTOM" width="468" height="60"></A><BR><font size="-1"><a href="http://www.spelts.com/">David Spelts Software</a> Copyright 1999.</font>
</td></tr>
</table>
</center>
</BODY>
</HTML>
EOT
}



#############   Percentage  #################
sub Percentage {

$sex = $in{'sex'}; 
$age = $in{'age'}; 
$skinfoldsum = $in{'Upper Chest'} + $in{'Mid Abdomen'} + $in{'Mid Thigh'} + $in{'Tricep'} + $in{'Far Right Abdomen'};
$skinfoldsquared = $skinfoldsum * $skinfoldsum;

if ($sex eq "Male") {
 $bd = 1.10938 - (0.0008267 * $skinfoldsum) + (0.0000016 * $skinfoldsquared) - (0.0002574 * $age);
  } elsif ($sex eq "Female") {
 $bd = 1.099421 - (0.0009929 * $skinfoldsum) + (0.0000023 * $skinfoldsquared) - (0.0001392 * $age);
}

$bodyfat = sprintf("%.1f",(((457 / $bd) - 414.2) + ((495 / $bd) - 450)) / 2);

print <<EOT;
<HTML><HEAD>    
<TITLE>Fatalyzer</TITLE>
</HEAD>

<BODY bgcolor="\#000066">
<center>
<table border="0" width="100%" bgcolor="\#EEEEEE" cellspacing="6" cellpadding="6">
<tr><td align="center"><H1>Fatalyzer</H1></td></tr>
<tr><td align="center"><b>Your bodyfat percentage is: <font size=+1>$bodyfat \%</font></b><td></tr>
<tr><td align="center"><a href="http://www.spelts.com/fatalyzer/"><b>Download Windows version</b></a><td></tr>
<tr><td bgcolor="\#000066"><br></td></tr>
<tr><td align=center>
<A HREF="http://www.burstnet.com/ads/ad4762a-map.cgi"><IMG SRC="http://www.burstnet.com/cgi-bin/ads/ad4762a.cgi" ISMAP BORDER="2" ALIGN="BOTTOM" width="468" height="60"></A>
<BR><font size="-1"><a href="http://www.spelts.com/">David Spelts Software</a> Copyright 1999.</font>
</td></tr>
</table>
</center>
</BODY>
</HTML>
EOT
}


##############   ReadParse  ################
sub ReadParse {

local (*in)= @_ if @_;
local ($i,$key,$val);

# Read in text
if (&MethGet) {
  $in=$ENV{'QUERY_STRING'};
  } elsif (&MethPost) {
  read(STDIN,$in,$ENV{'CONTENT_LENGTH'});
  }

@in=split(/[&;]/,$in);

foreach $i (0..$#in) {
  #Convert plus"s to spaces
  $in[$i] =~ s/\+/ /g;

  #Split into key and value.
  ($key, $val) = split(/=/,$in[$i],2); # splits on the first =.

  #Convert %XX from hex numbers to alphanumeric
  $key =~ s/%(..)/pack("c",hex($1))/ge;
  $val =~ s/%(..)/pack("c",hex($1))/ge;

  #Associate key and value
  $in{$key} .= "\0" if (defined($in{$key})); # \0 is the multiple separator
  $in{$key} .= $val;

}
return scalar(@in);
}

####### MethGet  ##############
sub MethGet {
  return ($ENV{'REQUEST_METHOD'} eq "GET");
}

####### MethPost  ##############
sub MethPost {
  return ($ENV{'REQUEST_METHOD'} eq "POST");
}
