#!/usr/bin/perl -w
use strict;
use Common;

my $basedir = '../..';

my $err_msg = '';
Err: {

		$err_msg = &query_scripts( $basedir );
		next Err if ($err_msg);

		$err_msg = &build_dependency_map( $basedir );
		next Err if ($err_msg);

	if (0) {

		$err_msg = &extract_function_comments( $basedir );
		next Err if ($err_msg);

		$err_msg = &restore_function_comments( $basedir );
		next Err if ($err_msg);
		}

	last Err;
	}
continue {
	print "<P><B>Error:</B> $err_msg.</P>\n";
	}



sub extract_function_comments {
	my ($basedir) = @_;
	my $err_msg = '';
	Err: {
		my @files = (
			"$basedir/search.pl",
			"$basedir/searchmods/common.pl",
			"$basedir/searchmods/common_admin.pl",
			"$basedir/searchmods/common_parse_page.pl",
			);
		my $text = '';
		my $file = ();


		my %func = ();

		foreach $file (@files) {
			($err_msg, $text) = &ReadFile( $file );
			next Err if ($err_msg);
			print "Opened file '$file'\n";

			my $newtext = '';
			while ($text =~ m!^(.*?)=item (\w+)(.*?)=cut(.*?)sub (\w+) (.*)$!s) {
				if ($2 eq $5) {
					$newtext .= "$1\n$4sub $5 ";
					$text = $6;
					$func{$2} = "\n=item $2$3=cut\n\n"
					}
				else {
					$newtext .= "$1=item $2$3=cut$4sub $5 ";
					$text = $6;
					}
				}
			$err_msg = &WriteFile($file, $newtext);
			next Err if ($err_msg);
			}

		unless (keys %func) {
			print "Warning: found no function specs - have you already run extract?\n";
			last Err;
			}

		my $spec = '';
		foreach (sort keys %func) {
			$spec .= $func{$_};
			}
		$err_msg = &WriteFile('function_spec.txt', $spec);
		next Err if ($err_msg);

		last Err;
		}
	return $err_msg;
	}


sub restore_function_comments {
	my ($basedir) = @_;
	my $err_msg = '';
	Err: {
		my @files = (
			"$basedir/search.pl",
			"$basedir/searchmods/common.pl",
			"$basedir/searchmods/common_admin.pl",
			"$basedir/searchmods/common_parse_page.pl",
			);
		my $text = '';
		my $file = ();

		($err_msg, $text) = &ReadFile('function_spec.txt');
		next Err if ($err_msg);

		my %func = ();
		foreach (split(m!=item!s, $text)) {
			next unless (m!^ (\w+)(.*?)=cut!s);
			$func{$1} = &Trim($2);
			print "Loaded function comments for '$1'\n";
			}

		foreach $file (@files) {
			($err_msg, $text) = &ReadFile( $file );
			next Err if ($err_msg);
			print "Opened file '$file'\n";

			my $key = ();
			foreach $key (reverse sort keys %func) {
				my $qmkey = quotemeta($key);
				$text =~ s!=item $qmkey\W.*?=cut.*?sub $qmkey !=item $qmkey\n\n$func{$key}\n\n=cut\n\nsub $qmkey !sg;
				$text =~ s!\}\s*sub $qmkey !\}\n\n=item $qmkey\n\n$func{$key}\n\n=cut\n\nsub $qmkey !sg;
				}
			$err_msg = &WriteFile($file,$text);
			next Err if ($err_msg);
			}
		last Err;
		}
	return $err_msg;
	}


=item build_dependency_map($)

Requires that all subs be defined at the end of the file - no mixing of subs and code.  All code goes at the top.

=cut

sub build_dependency_map {
	my ($basedir) = @_;
	my $err_msg = '';
	Err: {

		my @files = (
			"$basedir/index.cgi",
			);

		my %subs = ();
		my %subdepend = ();
		my %people_who_use_me = ();

		my %homefiles = ();
			# key - sub ; value - file

		my $glob = '';
		my $text = '';
		my $file = ();
		foreach $file (@files) {
			($err_msg, $text) = &ReadFile( $file );
			next Err if ($err_msg);

			print "Opened file '$file'\n";

			$text = " sub main " . $text;

			my $new = '';
			foreach (split(m!\r|\n!s, $text)) {
				next if (m!^\s*\#!);

				# strip stuff that's inside a sub regex:
				s!s\!.*?\!.*?\!\w*\;!!g;
				s!s\'.*?\'.*?\'\w*\;!!g;

				$new .=  " $_ ";
				}
			$text = $new;

			$text =~ s!(\r|\n)! !gs;

			$text =~ s!=item.*?=cut! !gs;
			$text =~ s!package .*?sub! sub!gs; # strip package declarations

			$glob .= $text;




			my @x = split(m! sub !is, $text);
			$x[0] = '';
			foreach (@x) {
				next unless (m!^\s*(\w+)\s+(.*)!);
				my ($name,$code) = ($1,$2);
				if ($subs{$name}) {
					print "Warning: duplicate sub declared: '$name' - rename\n";
					}
				$subs{$name}++;
				$homefiles{$name} = $file;

				my %depend = ();

				my $savecode = $code;

				while ($code =~ m!\&(\w+)(\W)(.*)$!) {
					my ($substring, $nextch, $end) = ($1, $2, $3);
					$code = $end;

					next if ($substring =~ m!^(gt|lt|nbsp)$!i); # just html, kids, nothing to be afraid of - just rmemeber not to use these for any of your sub names
					next if ($nextch eq '=') or ($nextch eq ':'); # there are HTML link creations - foo.cgi?bob=1&jane=2 -> thinks &jane is a function call

					if (($nextch eq ':') and ($end =~ m!^\:(\w+)!)) {
						$substring = $1;
						}

					$depend{$substring}++;

					$people_who_use_me{$substring} .= " $name ";
					}

				$code = $savecode;
				while ($code =~ m!\-\>(\w+)(\W)(.*)$!) {
					my ($substring, $nextch, $end) = ($1, $2, $3);
					$code = $end;
					$depend{$substring}++;
					$people_who_use_me{$substring} .= " $name ";
					}
				$subdepend{$name} = \%depend;
				}


			}

		foreach (sort keys %subs) {
			my $p_depend = $subdepend{$_};
			print "Function: $_\n";

			my $home = $homefiles{$_};

			print "Defined in: $home\n\n";

			my @clients = split(m!\s+!, $people_who_use_me{$_} || '' );
			my %uniq = ();
			foreach (sort @clients) {
				next unless $_;
				next if ($uniq{$_});
				$uniq{$_} = 1;
				print "	Called By: $_\n";
				}
			print "\n";



			my %required_libs = ();
			foreach (sort keys %$p_depend) {
				my $libfile = $homefiles{$_};
				$required_libs{$libfile}++;
				print "	Dependency: $_ - $$p_depend{$_}\n";
				unless ($subs{$_}) {
					print "	Warning: sub '$_' referenced but not defined in this group\n";
					exit;
					}
				}
			print "\n";
			foreach (sort keys %required_libs) {
				print "	Requires: $_\n";

				if (($_ =~ m!common_admin!) and ($home =~ m!(common.pl|common_parse_page.pl)!)) {
					print "This won't do... improper load sequence... fix it\n";
					exit;
					}
				if (($_ =~ m!common_parse_page!) and ($home =~ m!common.pl!)) {
					print "This won't do... improper load sequence... fix it\n";
					exit;
					}

				}
			print "\n\n";

			print "\n";
			}

		last Err;
		}
	return $err_msg;
	}







sub query_scripts {
	my ($basedir) = @_;
	my $err_msg = '';
	Err: {

		my ($subcount, $subcalls) = (0, 0);

		my @files = &GetFiles( $basedir, '.cgi' );

		my %subs = ();

		my $glob = '';

		my $text = '';

		my $file = ();
		foreach $file (@files) {
			($err_msg, $text) = &ReadFile( $file );
			next Err if ($err_msg);

			print "Opened file '$file'\n";

			my $new = '';
			foreach (split(m!\r|\n!s, $text)) {
				next if (m!^\s*\#!);
				$new .=  " $_ ";
				}
			$text = $new;

			$text =~ s!(\r|\n)! !gs;

			$text =~ s!=item.*?=cut! !gs;

			$glob .= $text;


			my @x = split(m! sub !is, $text);
			$x[0] = '';
			foreach (@x) {
				next unless (m!^\s*(\w+)\s+!);

				my $name = $1;
				if ($subs{$name}) {
					print "Warning: duplicate sub declared: '$name' - rename\n";
					}
				$subs{$name}++;
				$subcount++;
				}
			}

		if ($glob =~ m!(.{100})foreach \$?\w*\s*\(\%(.{100})!s) {
			print "Possible foreach over hash instead of keys %hash:\n";
			print "$1$2\n";
			exit;
			}
		if ($glob =~ m!(.{100})(push|pop|scalar|sort|reverse)\s*\(?\%(.{100})!s) {
			print "Possible array operation on hash instead of keys %hash:\n";
			print "$1$2$3\n";
			exit;
			}

		foreach (sort keys %subs) {
			my @words = ();
			my $count = scalar (@words = ($glob =~ m!\W$_\W!og));
			my $excount = scalar (@words = ($glob =~ m!\&$_\W!og));
			my $pkcount = scalar (@words = ($glob =~ m!\:\:$_\W!og));
			my $obcount = scalar (@words = ($glob =~ m!\-\>$_\W!og));

			$subcalls += $excount + $pkcount + $obcount;

			if ($count != ($excount + $pkcount + $obcount + 1)) {
				print "Warning: check for non-explicit calls to sub \&$_() - $count vs $excount + $pkcount + $obcount\n";
				}

			print "sub: $_ - $count\n";

			if ($count == 1) {
				print "WARNING:\n";
				exit;
				}
			}

		print '-' x 78 . "\n";
		print "Total $subcount functions defined - total $subcalls calls to them.\n";
		print '-' x 78 . "\n";

		last Err;
		}
	return $err_msg;
	}


