#!/usr/local/bin/perl -w
use strict;
no locale;
require '/usr/home/xav/Common.pm';

use vars qw! %global_no_translate $transdir !;

my $VERSION = '2.0.0.0033';
my $PRODUCT = 'Fluid Dynamics Search Engine';

my @htmlfiles = sort ('searchform.htm', 'footer.htm', 'admin_fr2.txt', 'admin_fr.txt', 'admin_footer2.txt', 'admin_ads.txt', 'admin_navbar.txt', 'header.htm', 'tips.htm', 'admin_ui.txt', 'admin_pass1.txt', 'admin_pass2.txt', 'admin_personal.txt', 'linkline1.txt', 'linkline2.txt');

my @languages = (
	'dutch',
	'french',
	'german',
	'italian',
	'portuguese',
	'spanish',
	);

if ($ARGV[0]) {
	@languages = ($ARGV[0]);
	}

my $dir = 'E:/usr/home/xav/products/fdse/2.0.0.0033/files/searchdata/templates';
$transdir = 'E:/translator';

if (0) {
	&merge_ver( $dir, 'e:/dutch/dutch', 'dutch', 'Richard van Rucphen' );
	exit;
	}

chdir($dir) || die $!;

my $err_msg = '';
Err: {

	my $llang = ();
	foreach $llang (@languages) {

		my $text = '';
		my $trans = '';
		my $new = ();

		print "Initiating language '$llang'\n";

		my $cfile = "$transdir/$llang.txt";

		my %str_used_phrases = ();
		my %lcache = ();
		my %authority = ();
		my %time = ();

		$err_msg = &load_cache( $cfile, \%lcache, \%time, \%authority, \%str_used_phrases );
		next Err if ($err_msg);

		print "Loaded cache (" . scalar (keys %lcache) . ")\n";
		my $filetext = ();

		($err_msg, $filetext) = &ReadFile("english/strings.txt");
		next Err if ($err_msg);

		my $count = 0;
		foreach $text (split(m!\n!, $filetext)) {
			$count++;
			$trans = &Trim($text);
			if ($count > 1) {
				($err_msg, $trans) = &Translate( $text, $llang, \%lcache, \%str_used_phrases, \%authority );
				if ($err_msg) {
					print "<P><B>Error:</B> $err_msg.</P>\n";
					}
				#print "Trans [$llang:$count]: $trans\n";
				}
			$new .= "$trans\n";
			}

		$err_msg = &WriteFile("$llang/strings.txt", $new);
		next Err if ($err_msg);


		$err_msg = &save_cache( $cfile, \%lcache, \%time, \%authority, \%str_used_phrases, 0 );
		next Err if ($err_msg);


		my $tmp_err_msg = '';

		($err_msg, $filetext) = &ReadFile("english/settings_desc.txt");
		next Err if ($err_msg);

		$new = '';
		$text = '';
		$count = 0;
		foreach $text (split(m!\n!, $filetext)) {
			$count++;
			next unless ($text =~ m!^(.*?)=(.*)$!);
			my ($name, $value) = (&Trim($1), &Trim($2));
			$trans = $value;

			($tmp_err_msg, $trans) = &Translate( $value, $llang, \%lcache, \%str_used_phrases, \%authority );
			if ($tmp_err_msg) {
				print "<P><B>Error:</B> $err_msg.</P>\n";
				}
			#print "Trans [$llang:$count]: $trans\n";

			$new .= "$name = $trans\n";
			}

		$err_msg = &WriteFile("$llang/settings_desc.txt", $new);
		next Err if ($err_msg);


		$err_msg = &save_cache( $cfile, \%lcache, \%time, \%authority, \%str_used_phrases, 0 );
		next Err if ($err_msg);



		my @files = ();
		opendir(DIR, "english") || die $!;
		foreach (readdir(DIR)) {
			next if (-d "english/$_");
			next if ($_ eq 'settings_desc.txt');
			next if ($_ eq 'strings.txt');
			push(@files, $_);
			}
		closedir(DIR);
		my $file = ();
		foreach $file (@files) {


			($err_msg, $filetext) = &ReadFile("english/$file");
			next Err if ($err_msg);

			my $new = '';
			my $text = '';
			my $count = 0;

			while ($filetext =~ m!^(.*?)>([^\w\<\>]*)([^\<\>]+?)([^\w\<\>]*)<(.*)$!s) {
				my ($start, $mid, $end1, $end2) = ("$1>$2", $3, "$4<", $5);
				$filetext = $end2;
				$new .= $start;

				$trans = $mid;

				($tmp_err_msg, $trans) = &Translate( $trans, $llang, \%lcache, \%str_used_phrases, \%authority );
				if ($tmp_err_msg) {
					print "<P><B>Error:</B> $err_msg.</P>\n";
					}
				$new .= $trans;
				$new .= $end1;
				}
			$new .= $filetext;

			# Now fix for those damn submit buttons

			$filetext = $new;
			$new = '';

			while ($filetext =~ m!^(.*?)<INPUT TYPE=submit CLASS=submit VALUE="(.*?)">(.*)$!s) {
				my ($start, $value, $end) = ($1, $2, $3);

				#print "Hello... translating '$value' to $llang\n";

				$new .= $start;
				$new .= "<INPUT TYPE=submit CLASS=submit VALUE=\"";

				$trans = $value;
				($tmp_err_msg, $trans) = &Translate( $trans, $llang, \%lcache, \%str_used_phrases, \%authority );
				if ($tmp_err_msg) {
					print "<P><B>Error:</B> $err_msg.</P>\n";
					}
				$new .= $trans;

				$new .= "\">";

				$filetext = $end;
				}
			$new .= $filetext;

			$err_msg = &WriteFile("$llang/$file", $new);
			next Err if ($err_msg);

			}

		$err_msg = &save_cache( $cfile, \%lcache, \%time, \%authority, \%str_used_phrases, 1 );
		next Err if ($err_msg);
		}

	last Err;
	}
continue {
	print "Error: $err_msg.\n";
	}


=item merge_ver($$$$)

Usage:
	&merge_ver($english_dir, $alt_dir, $language, $authority);

This is used to merge versions when somebody sends a completed translation in, one that has translated strings.txt etc. rather than translating the language files themselves.

=cut

sub merge_ver {
	my ($english_dir, $alt_dir, $language, $authority) = @_;
	my $err_msg = '';
	Err: {

		$english_dir =~ s!\\!/!g;
		$english_dir =~ s!/$!!o;

		$alt_dir =~ s!\\!/!g;
		$alt_dir =~ s!/$!!o;

		my $text = '';
		my $trans = '';
		my $new = ();

		print "Merging translated version - '$language' - by '$authority'\n";

		my $cfile = "e:/translator/$language.txt";

		my %str_used_phrases = ();
		my %lcache = ();
		my %authority = ();
		my %time = ();

		$err_msg = &load_cache( $cfile, \%lcache, \%time, \%authority, \%str_used_phrases );
		next Err if ($err_msg);

		print "Loaded cache (" . scalar (keys %lcache) . ")\n";
		my $filetext = ();

		my $engtext = '';
		my $alttext = '';

		($err_msg, $engtext) = &ReadFile("$english_dir/english/strings.txt");
		next Err if ($err_msg);

		($err_msg, $alttext) = &ReadFile("$alt_dir/strings.txt");
		next Err if ($err_msg);

		my @eng_str = split(m!\n!, $engtext);
		my @alt_str = split(m!\n!, $alttext);

		my $count = 0;
		foreach $count (0..$#eng_str) {
			my $text = &Trim($eng_str[$count]);
			my $alttext = &Trim($alt_str[$count]);
			if (($authority{$text}) and ($authority{$text} ne 'NEED TRANSLATION') and ($alttext ne $lcache{$text})) {
				print "Text: $text\n";
				print "Translated to: $lcache{$text}\n";
				print "Authority: $authority{$text}\n";
				next unless (&Confirm("Override?"));
				}

			if ($text eq $alttext) {
				print "Warning: translated and English versions the same.\n";
				next;
				}

			$lcache{$text} = $alttext;
			$authority{$text} = $authority;
			}

		$err_msg = &save_cache( $cfile, \%lcache, \%time, \%authority, \%str_used_phrases, 0 );
		next Err if ($err_msg);


		($err_msg, $engtext) = &ReadFile("$english_dir/english/settings_desc.txt");
		next Err if ($err_msg);

		($err_msg, $alttext) = &ReadFile("$alt_dir/settings_desc.txt");
		next Err if ($err_msg);

		@eng_str = split(m!\n!, $engtext);
		@alt_str = split(m!\n!, $alttext);

		foreach $count (0..$#eng_str) {
			next unless ($eng_str[$count] =~ m!^.*?=(.*)$!);
			my $text = &Trim($1);

			next unless ($alt_str[$count] =~ m!^.*?=(.*)$!);
			my $alttext = &Trim($1);

			if (($authority{$text}) and ($authority{$text} ne 'NEED TRANSLATION') and ($alttext ne $lcache{$text})) {
				print "Text: $text\n";
				print "Translated to: $lcache{$text}\n";
				print "Authority: $authority{$text}\n";
				next unless (&Confirm("Override?"));
				}

			if ($text eq $alttext) {
				print "Warning: translated and English versions the same.\n";
				next;
				}

			$lcache{$text} = $alttext;
			$authority{$text} = $authority;
			}


		$err_msg = &save_cache( $cfile, \%lcache, \%time, \%authority, \%str_used_phrases, 0 );
		next Err if ($err_msg);


		my $tmp_err_msg;

		my @files = ();
		opendir(DIR, "$english_dir/english") || die $!;
		foreach (readdir(DIR)) {
			next if (-d "$english_dir/english/$_");
			next if ($_ eq 'settings_desc.txt');
			next if ($_ eq 'strings.txt');
			push(@files, $_);
			}
		closedir(DIR);
		my $file = ();
		foreach $file (@files) {

			my $new = '';
			my $text = '';
			my $temp_text = '';

			my @eng_str = ();
			my @alt_str = ();

			($err_msg, $engtext) = &ReadFile("$english_dir/english/$file");
			next Err if ($err_msg);
			$temp_text = $engtext;
			while ($temp_text =~ m!^(.*?)>([^\w\<\>]*)([^\<\>]+?)([^\w\<\>]*)<(.*)$!s) {
				my ($start, $mid, $end1, $end2) = ("$1>$2", $3, "$4<", $5);
				$temp_text = $end2;
				push(@eng_str, $mid);
				}
			$temp_text = $engtext;
			while ($temp_text =~ m!^(.*?)<INPUT TYPE=submit CLASS=submit VALUE="(.*?)">(.*)$!s) {
				my ($start, $value, $end) = ($1, $2, $3);
				push(@eng_str, $value);
				$temp_text = $end;
				}

			($err_msg, $alttext) = &ReadFile("$alt_dir/$file");
			next Err if ($err_msg);
			$temp_text = $alttext;
			while ($temp_text =~ m!^(.*?)>([^\w\<\>]*)([^\<\>]+?)([^\w\<\>]*)<(.*)$!s) {
				my ($start, $mid, $end1, $end2) = ("$1>$2", $3, "$4<", $5);
				$temp_text = $end2;
				push(@alt_str, $mid);
				}
			$temp_text = $alttext;
			while ($temp_text =~ m!^(.*?)<INPUT TYPE=submit CLASS=submit VALUE="(.*?)">(.*)$!s) {
				my ($start, $value, $end) = ($1, $2, $3);
				push(@alt_str, $value);
				$temp_text = $end;
				}

			if ($#eng_str != $#alt_str) {
				print "Error: formatting difference in HTML translated file '$file' - $#eng_str != $#alt_str - cannot merge.\n";
				# next;
				}

			my $count = 0;
			foreach $count (0..$#eng_str) {
				my $text = &Trim($eng_str[$count]);
				my $alttext = &Trim($alt_str[$count]);

				if (($lcache{$text}) and ($alttext eq $lcache{$text})) {
					next;
					}

				if (($authority{$text}) and ($authority{$text} ne 'NEED TRANSLATION') and ($authority{$text} ne $authority)) {
					print "Text: $text\n";
					print "Translated to: $lcache{$text}\n";
					print "Authority: $authority{$text}\n";
					next unless (&Confirm("Override?"));
					}

				if ($text eq $alttext) {
					print "Warning: translated and English versions the same.\n";
					next;
					}


				print "\n\n\n";
				print '-' x 78;
				print "\n";
				print "English: $text\n";
				print '-' x 78;
				print "\n";
				print "$language: $alttext\n";
				print '-' x 78;
				print "\n";
				next unless (&Confirm('okay?'));

				$lcache{$text} = $alttext;
				$authority{$text} = $authority;
				}
			$err_msg = &save_cache( $cfile, \%lcache, \%time, \%authority, \%str_used_phrases, 0 );
			next Err if ($err_msg);

			}


		last Err;
		}
	continue {
		print "Error: $err_msg.\n";
		}
	}







=item load_cache($$$$$)

Usage:
	$err_msg = &load_cache( $cfile, \%lcache, \%time, \%authority, \%str_used );
	next Err if ($err_msg);

=cut


sub load_cache {
	my ($cfile, $p_lcache, $p_time, $p_authority, $p_str_used) = @_;
	my $err_msg = '';
	Err: {
		unless (-e $cfile) {
			$err_msg = &WriteFile($cfile, '');
			next Err if ($err_msg);
			}
		my $text = '';

		%global_no_translate = ();
		($err_msg, $text) = &ReadFile("$transdir/global_no_translate.txt");
		next Err if ($err_msg);
		foreach (split(m!\n+!s, $text)) {
			my $name = &Trim($_);
			#print "no translate: $name\n";
			$global_no_translate{$name} = 1;
			$$p_lcache{$name} = $name;
			$$p_str_used{$name} = 0;
			$$p_time{$name} = 0;
			$$p_authority{$name} = 'Global NoTranslate List';
			}

		($err_msg, $text) = &ReadFile($cfile);
		next Err if ($err_msg);
		foreach (split(m!\n\n+!s, $text)) {
			next if (m!^##!);
			my ($name, $value, $authority, $time) = ('', '', '', '');
			if (m!^\s*Authority:(.*?)Time:(.*?)Instances:\s*\d+\n--\n(.+)\n(.+)$!s) {
				($authority, $time, $name, $value) = ( &Trim($1), &Trim($2), &Trim($3), &Trim($4) );
				}
			elsif (m!^(.+)\n(.+)$!s) {
				($name, $value) = (&Trim($1), &Trim($2) );
				$authority = "Altavista/Babelfish";
				$time = scalar localtime(time);
				$time .= " - " . time();
				}
			else {
				next;
				}
			next if ($global_no_translate{$name});
			$$p_lcache{$name} = $value;
			$$p_str_used{$name} = 0;
			$$p_time{$name} = $time;
			$$p_authority{$name} = $authority;
			}

		}
	return $err_msg;
	}


=item save_cache($$$$$)

Usage:
	$err_msg = &save_cache( $cfile, \%lcache, \%time, \%authority, \%str_used, $b_warn );
	next Err if ($err_msg);

=cut

sub save_cache {
	my ($cfile, $p_lcache, $p_time, $p_authority, $p_str_used, $b_warn) = @_;
	my $err_msg = '';
	Err: {

		# Save cache:
		my $timestr = scalar localtime(time);
		my $new = <<"EOM";
###
### Product: $PRODUCT
### Version: $VERSION
### Last updated: $timestr
###
### File format:
###
###		Authority: Person or software responsible for translated fragment
###		Time: time translation was performed
###		Instances: number of times this fragment is used in the files
###		--
###		english string
###		translated string
###
### To contribute, simply edit the "translated string" and enter your name
### in the Authority field, and email to zoltanm\@xav.com.
###
### Those who update at least 40 strings from "NEED TRANSLATION" status
### (or "worthlessly translated" status) will receive a free registered
### version of the product and will have their names included in the
### "translated by" credits that are included in the product (if they want).
### If they've already paid the shareware fee, they will be sent \$35 which
### is what the fee becomes after transaction costs.* They will also win
### the love of many who speak their native language and you never know
### where that could lead.
###
### To be useful, translations must be distributable by Fluid Dynamics and
### end users must be free to modify them. Thus, translations cannot be
### accepted unless you transfer copyright to Fluid Dynamics. Your free
### registered version and mention in the product is a thank-you gesture for
### that transfer.
###
### * limit one refunded license per person !  :)
###

EOM
		foreach (sort (keys %$p_lcache)) {
			unless ($$p_str_used{$_}) {
				print "Warning: haven't used string '$_' yet\n" if ($b_warn);
				$$p_str_used{$_} = 0;
				}

			my $time = $$p_time{$_};
			unless ($time) {
				$time = scalar localtime(time) . ' - ' . time();
				}

			next if ($global_no_translate{$_});

			$new .= "\n\n";
			$new .= " Authority: $$p_authority{$_}\n";
			$new .= "      Time: $time\n";
			$new .= " Instances: $$p_str_used{$_}\n";
			$new .= "--\n";
			$new .= "$_\n";
			$new .= "$$p_lcache{$_}";
			$new .= "\n\n";
			}
		$err_msg = &WriteFile($cfile, $new);
		next Err if ($err_msg);
		}
	return $err_msg;
	}


sub Translate {
	my ($text, $la, $p_lcache, $p_str_used, $p_authority) = @_;

	my $trans = $text;

	my $err_msg = '';
	Err: {

		unless ('HASH' eq ref($p_lcache)) {
			$err_msg = "invalid arg - lcache not supplied";
			next Err;
			}

		my %bblfish = (
			'french' => 'fr',
			'german' => 'de',
			'italian' => 'it',
			'portuguese' => 'pt',
			'spanish' => 'es',
			'japanese' => 'ja',
			'korean' => 'ko',
			'chinese' => 'zh',
			);

		# don't sweat the whitespace
		last Err if ($trans =~ m!^\s+$!);

		last Err unless (length($trans)); # or nulls!

		last Err if ($trans eq '.');

		if (defined($$p_lcache{$text})) {
			$trans = $$p_lcache{$text};
			$$p_str_used{$text}++;
#			print "Serving from cache\n";
			last Err;
			}

		unless ($bblfish{$la}) {
			# uh-oh
			$$p_authority{$text} = "NEED TRANSLATION";
			$$p_lcache{$text} = $text;
			last Err;
			}


		print "Doing network lookup '$text'\n";

		my $url = 'http://babel.altavista.com/translate.dyn';



		my $stext = ".FDINIT.\n\n$text\n\n.FDEND.";
		$stext =~ s!\%d!JFIWEWOJFS!sg;
		$stext =~ s!\'\%s\'!Mixdwees!sg;
		$stext =~ s!\%s!Misdfaxdwees!sg;

		my %values = (
			'enc' => 'utf8',
			'doit' => 'done',
			'BabelFishFrontPage' => 'yes',
			'bblType' => 'urltext',
			'urltext' => $stext,
			'lp' => "en_$bblfish{$la}",
			);

		my $body = '';
		foreach (keys %values) {
			$body .= '&' . &url_encode( $_ ) . '=' . &url_encode( $values{$_} );
			}

		$body =~ s!^\&!!o;

		my ($is_error, $error_msg, $URL, $ResponseBody, $ResponseCode, %Headers) = &http_ex( $url, 'POST', $body, 10, 'HTTP_REFERER' => $url );
		if ($is_error) {
			$err_msg = $error_msg;
			next Err;
			}
		unless ($ResponseBody =~ m!FDINIT\.?(.*?)\.?FDEND!si) {
			$err_msg = "unable to parse translated response";
#			print "Input: '$text'\n\n";
#			print $ResponseBody;
			next Err;
			}
		$trans = &Trim( $1 );
		$trans =~ s!(\r|\n)! !sg;
		$trans =~ s!\s+! !sg;
		$trans =~ s!<\s+!<!sg;
		$trans =~ s!\s+>!>!sg;
		my $ach = '';
		my $new = '';
		while ($trans =~ m!^(.*?)$ach(.)(.*)$!) {
			$trans = $3;
			$new .= $1;
			my $ch = $2;

			if (ord($ch) > 127) {
				my $newch = chr(64 + ord($2));
				print "Mapping '$ach$2' => $newch\n";
				$new .= $newch;
				}
			else {
				$new .= '' . $ch;
				}
			}
		$new .= $trans;
		$trans = $new;

		$trans =~ s!JFIWEWOJFS!%d!sg;
		$trans =~ s!Mixdwees!'%s'!sg;
		$trans =~ s!Misdfaxdwees!%s!sg;



#		print "Trans is $trans\n\n";
		$$p_lcache{$text} = $trans;
		$$p_authority{$text} = 'Altavista/Babelfish';
		$$p_str_used{$text}++;
		last Err;
		}
	return ($err_msg, $trans);
	}
