#include <iostream.h>
#include <string.h>
#include <time.h>
/*****************************************************************************
* TextClock  (C++ Version)      Version 1.0.3                                *
* Copyright 1996 Matt Wright    mattw@worldwidemart.com                      *
* Created 07/15/96              Last Modified 03/29/97                       *
* Matt's Script Archive, Inc.   http://www.worldwidemart.com/scripts/        *
******************************************************************************
* COPYRIGHT NOTICE                                                           *
* Copyright 1996 Matthew M. Wright  All Rights Reserved.                     *
*                                                                            *
* TextClock may be used and modified free of charge by anyone so long as     *
* this copyright notice and the comments above remain intact.  By using this *
* code you agree to indemnify Matthew M. Wright from any liability that      *
* might arise from it's use.                                                 *
*                                                                            *
* Selling the code for this program without prior written consent is         *
* expressly forbidden.  In other words, please ask first before you try and  *
* make money off of my program.                                              *
*                                                                            *
* Obtain permission before redistributing this software over the Internet or *
* in any other medium.  In all cases copyright and header must remain intact *
*****************************************************************************/
// Define Variables

const int Display_Week_Day = 1;
const int Display_Month = 1;
const int Display_Month_Day = 1;
const int Display_Year = 1;
const int Display_Time = 1;
const int Display_Time_Zone = 1;

const char Standard_Time_Zone[4] = "EST";
const char Daylight_Time_Zone[4] = "EDT";

const char Display_Link[] = "http://www.worldwidemart.com/scripts/";

// Done
/****************************************************************************/

void main()
{
    char Week_Days[7][10] = { "Sunday", "Monday", "Tuesday", "Wednesday",
                              "Thursday", "Friday", "Saturday" };
    char Months[12][10] =   { "January", "February", "March", "April", "May", 
                              "June", "July", "August", "September", 
                              "October", "November", "December" };
    char Time_Zone[4];

    tm *ptm;
    time_t *cur_time;

    cout << "Content-type: text/html\n\n";

    if (strlen(Display_Link) > 0)
        cout << "<a href=\"" << Display_Link << "\">";

    // Set up the memory for the time and time time struct.
    cur_time = new time_t;
    ptm = new tm;

    // Get the time, then create the struct with time values.
    time(cur_time);
    ptm = localtime(cur_time);

    // Determine whether it is daylight savings time or not.
    if (ptm->tm_isdst)
        strcat(Time_Zone,Daylight_Time_Zone);
    else
        strcat(Time_Zone,Standard_Time_Zone);

    // Display the day of the week if requested.
    if (Display_Week_Day)
    {
        cout << Week_Days[ptm->tm_wday];

        if (Display_Month)
            cout << ", ";
    }

    // Display the name of the month if requested.
    if (Display_Month)
        cout << Months[ptm->tm_mon] << " ";

    // Display the day of the month if requested.
    if (Display_Month_Day != 0) 
    {
        if (ptm->tm_mday < 10)
            cout << "0";

        cout << ptm->tm_mday;

        if (Display_Year)
            cout << ", ";
    }

    // Display the year if requested.
    if (Display_Year)
    {
        cout << ptm->tm_year + 1900;

        if (Display_Time)
            cout << " - ";
        else if (Display_Time_Zone)
            cout << " ";
    }

    // Display the time if requested.
    if (Display_Time)
    {
        if (ptm->tm_hour < 10)
            cout << "0";
        cout << ptm->tm_hour << ":";

        if (ptm->tm_min < 10)
            cout << "0";
        cout << ptm->tm_min << ":";

        if (ptm->tm_sec < 10)
            cout << "0";
        cout << ptm->tm_sec;
 
        if (Display_Time_Zone)
            cout << " ";
    }

    // Display the time zone if requested.
    if (Display_Time_Zone)
        cout << Time_Zone;

    // Close the link if we linked the clock.
    if (Display_Link)
        cout << "</a>";
}