#!/usr/bin/perl5
# NOTE:  the above line must be changed to show the path to the
# Perl interpreter on your system!  Leave the #! as is, but
# the path may have to be changed if yours is different.

#########################################################################
#									#
# CrosswordMaker v1.3beta 						#
# Copyright 1998, Kristina Pfaff-Harris (scripts@tesol.net)		#
#									#
# A simple crossword puzzle maker/grader.  The crossword creator	#
# goes through a few simple steps to create a crossword puzzle.  The	#
# program then creates an html form for the puzzle pointing back to 	#
# itself so that it can grade the puzzle.  (Puzzles are either exactly	#
# solved correctly, or they are not correct. Sorry, no fancy percentage	#
# scores here. :)  In fact, the algorithm (if you could call it that)	#
# which grades the puzzle is rather stupid: basically it takes all the	#
# letters for all the squares in the puzzle, puts them in alphabetical	#
# order, and compares the resulting string of letters with the ones	#
# that the user enters.  However, I tend to think that it's probably	#
# less frustrating to get false successes than false failures, and 	#
# the results will tend to be correct most of the time.  At any rate,	#
# you should no longer get an "Incorrect" message when you have indeed	#
# solved it correctly. :)						#
#									#
#########################################################################
##### Licensing:                                                        #
#####                                                                   #
#####  This program may be used free of charge under the following      #
#####  conditions:                                                      #
#####                                                                   #
#####  1. All instructions and Copyright lines must remain unchanged.   #
#####                                                                   #
#####  2. All pages generated by the program must contain one of the    #
#####     following pieces of HTML code:                                #
#####                                                                   #
#####     <font size=-2>CrosswordMaker v1.3 Copyright &copy; 2000,	#
#####     Kristina Pfaff-Harris and can be found at:			#
#####     <a href="http://www.tesol.net/scripts/">                      #
#####     http://www.tesol.net/scripts</a></font>                       #
#####  OR:                                                              #
#####     <!-- CrosswordMaker Copyright 2001 Kristina Pfaff-Harris -->	#
#####     <!-- Get it at http://www.tesol.net/scripts/         -->      #
#####                                                                   #
#####  3. You may not sell or distribute this program.  You may charge  #
#####     a reasonable fee for installing it for a client as long as    #
#####     you make it clear that you are not the author, and you are    #
#####     not selling the program to them: only charging for installing #
#####     it.                                                           #
#####                                                                   #
#####  4. You agree that this program is offered without warranty of    #
#####     any kind, including warranty of fitness for a particular      #
#####     purpose. You further agree that the author and all sites      #
#####     associated in any way with this program are not liable for    #
#####     any damage or loss incurred as a result of using this program.#
#########################################################################
#####                                                                   #
##### IMPORTANT INSTRUCTIONS:                                           #
#####                                                                   #
##### In this program, I have put **CHANGE** in all the places where    #
##### you will need to modify the program to run on your server, so     #
##### that you can easily find all the places where changes are         #
##### necessary.  This program must be chmod 755 or 775 in order to     #
##### work, and the directory where you want CrosswordMaker to create	#
##### its puzzles must be chmod 777.                                    #
#####                                                                   #
#########################################################################
#                                                                       #
# IMPORTANT: If you FTPed this program to your server in "binary" mode, #
# it will NOT work!  If you're not sure, please go back and FTP it      #
# to your server again and make sure you use "ascii" mode.  If you get  #
# "500 Server Error", this is almost always the cause. :)               #
#                                                                       #
# Using the program:                                                    #
# This program requires the file "crosswordmaker.cgi" at a minimum in	#
# order  to work.  Please read the README.crosswordmaker file for more	#
# information. 								#
#                                                                       #
# I hope this program proves useful to you!  If you are having problems,#
# please read all the instructions carefully, and check the FAQ at	#
# http://www.tesol.net/scripts/FAQ/ . If none of this helps, please 	#
# contact me (http://www.tesol.net/scriptmail.html) for any bugs or 	#
# feedback.                         					#
#########################################################################
#####                                                                   #
#####  BEGIN SECTION WHERE YOU WILL NEED TO CHANGE THINGS:              #
#####                                                                   #
#####   In this section, there are several places where you'll need     #
#####   to make changes.  Please read all instructions carefully        #
#####   before you make the changes.                                    #
#####                                                                   #
#########################################################################

# Okay, first, let's decide if we want to see debugging information.
# Debugging is turned on by default. When you're satisfied that this
# script is working, **CHANGE** 
# $debugging = "yes";
# to
# $debugging = "no";
# And that will stop all the annoying "DEBUGGING INFO" messages. :)

$debugging = "no";

# $htmlheader is the HTML code that you want to print out at the
# top of all pages generated by the program as well as at the top
# of the final crossword puzzle page.  If you don't know much about
# HTML, you may leave this as is. Otherwise, **CHANGE** it to the
# HTML code you wish. IMPORTANT: If you use any of the following
# characters " @ % you must put a backslash \ in front of them
# like this: \" \@ \% . Otherwise, the program will not run.
# Only change between the lines <!-- Start changing HTML code here -->
# and <!-- Stop changing HTML code here -->.  If you have changed this
# and you are getting "Internal Server Error" or "Premature end of
# script headers," you almost certainly did not backslash one of these
# characters.  Please do this extremely carefully, or the program will
# not work. If you're not sure how to get this HTML code, please see
# the FAQ at http://www.tesol.net/scripts/FAQ/ and scroll down until
# you see the question about $header or $htmlheader.

$htmlheader = "

<!-- Start changing HTML code here -->
<html><head><title>CrosswordMaker</title></head>
<body bgcolor=#FFFFFF>
<center><FONT SIZE=+3><FONT COLOR=#FF0000>C</FONT><FONT COLOR=#0000FF>r</FONT><FONT COLOR=#008040>o</FONT><FONT COLOR=#FF8000>s</FONT><FONT COLOR=#FF00FF>s</FONT><FONT COLOR=#800080>w</FONT><FONT COLOR=#FF0000>o</FONT><FONT COLOR=#0000FF>r</FONT><FONT COLOR=#008000>d</FONT><FONT COLOR=#FF8040>M</FONT><FONT COLOR=#FF00FF>a</FONT><FONT COLOR=#800080>k</FONT><FONT COLOR=#FF0000>e</FONT><FONT COLOR=#0000FF>r</FONT><FONT COLOR=#008000>!</FONT></FONT></center>
<P>
<!-- Stop changing HTML code here -->

";

# $htmlfooter is pretty much the same as above.  You may **CHANGE** this
# to any HTML code to want to appear at the end of the pages generated
# by the program and on the puzzle HTML page.  I ask that you do not
# remove the lines that refer back to the Scripts for Educators site.
# If you must, please leave the reference in, but put it in HTML
# comment format. If you don't know how to do that, just leave this alone.

$htmlfooter = "

<!-- Start changing HTML code here -->
<hr></body></html>
<!-- Stop changing HTML code here -->
";

# $cgi_url is the full URL to the crossword.cgi program. This
# must begin with "http://" and should end in "crossword.cgi".
# **CHANGE** this to the URL of the crossword.cgi program on your
# server.

$cgi_url = "http://www.your_site.com/cgi-bin/crossword.cgi";

# $puzzle_directory should be the system path to the directory on your
# server where you want CrosswordMaker to create the HTML puzzle forms.
# **CHANGE** this to the full system path to the directory where you
# want the puzzles to be created and stored.  This MUST begin with a /
# (forward slash) and must NOT begin with "http://".  It should not
# end with a /, though. On NT, you may
# need to put it in this format: "D:\\inetpub\\wwwroot\\crosswords"
# (note the double backslashes).  On Unix-based systems, it should be
# something like "/home/users/yourlogin/public_html/crosswords" or
# something similar. Please find out what it is from your web hosting
# company: there's no way I can know that, since it's different on
# every server.  Ask them, "What is the full system path to my files
# on the server?" That should get you something close to the right answer.
# :)

$puzzle_directory = "/path/to/your/Crossword/files/";

# $puzzle_url is similar to $puzzle_directory, but it is the URL
# to the directory where your puzzle files are.  This must begin
# with "http://" and must not end in a /. **CHANGE** this to the URL
# of the puzzle directory.  Basically, if you were going to try to
# look at pages in the folder you put in $puzzle_directory, this
# is what you would put in your web browser to bring it up.

$puzzle_url = "http://www.your_site.com/Crossword/files";

#########################################################################
#
# All done!  You should not have to change anything beyond this point.
# However, you may look through the code if it interests you. I have to
# warn you, it's pretty ugly: HTML crossword puzzles present some 
# interesting coding dilemmas.  Enjoy!
#
#########################################################################
$| = 1;
%data = &get_data();
print "Content-type: text/html\n\n";

&debug("IMPORTANT: If you are having problems, please copy and paste this debugging output into an email at <a target=\"_blank\" href=\"http://www.tesol.net/scriptmail.html\">http://www.tesol.net/scriptmail.html</a> and I will try to help you.");
&debug("Your web server operating system is $^O");
&debug("Your web server software is $ENV{'SERVER_SOFTWARE'}");
unless(-d "$puzzle_directory"){
 &debug("Oops: You said that \$puzzle_directory was $puzzle_directory, but either that doesn't exist, or is not a directory. Please make sure that this is a system path to a folder on your server, and that the folder is chmod 777. If it starts with \"http://\", then you've set it up incorrectly.");
 }
foreach $key (keys(%ENV)){
  &debug("$key = '$ENV{$key}'");
  }

# If you remove this link, without replacing it with a similar
# HTML comment (as above in the Licensing section) you are in violation
# of the license for this program. No, I don't have the resources to
# enforce this, and I know that some people will remove it anyway.
# But honestly, since you didn't have to pay for this, is the link
# really too much to ask? :)

$htmlfooter = "<hr><font size=-2>CrosswordMaker v1.3beta is Copyright
               &copy; 1998 Kristina Pfaff-Harris and can be found at
	       <a href=\"http://www.tesol.net/scripts/\">
	       http://www.tesol.net/scripts/</a>.<br>$htmlfooter";

if($data{'Action'} eq "Step1"){
  &show_create_screen;
  exit();
  }
elsif($data{'Action'} eq "Step2"){
  &show_numbers_screen;
  exit();
  }
elsif($data{'Action'} eq "Step3"){
  &show_across_screen;
  exit();
  }
elsif($data{'Action'} eq "Create"){
  &create_new;
  exit();
  }
elsif($data{'puzsol'} ne ""){
  &grade_puzzle;
  exit();
}
else {
 &default_page;
 }

sub default_page {

 print <<EOF;
$htmlheader
<br>
$error
<table border=0>
<tr><td>
<form action=$cgi_url>
<table border=0><tr><td align=right>
Number of squares across:</td><td><input type=text name=Across size=5></td></tr>
<tr><td align=right>Number of squares down:</td><td> <input type=text name=Down size=5></td></tr></table>
<input type=hidden name=Action value=Step1>
<br><input type=submit value="Create Grid"></form></td>
<td valign=TOP><strong>Step 1:</strong><BR><BR>
First, choose the size of your crossword puzzle grid by
typing the number of squares across, and number of
squares down.</td></tr></table>
$htmlfooter
EOF
exit();
}

sub show_create_screen {

   $number_across = $data{'Across'};
   $number_down = $data{'Down'};
   if($number_across <= 1 || $number_down <= 1){
      $error = "<font color=#FF0000><b>Error: You must enter the size of
		the grid you want. (Smallest possible grid is 2 x 2.)
		</b></font>";
      &default_page;
      }
   print "$htmlheader";
   print "<form method=POST action=$cgi_url>
	  <table border=0><tr><td><table border=0>\n";

   for ($i = 1; $i <= $number_down; $i++){
     
      print "<tr>";

      for($j = 1; $j <= $number_across; $j++){
	 print "<td><input type=text name=\"$i,$j\" size=3></td>\n";
	 }
      print "</tr>\n";
      }
    print "</table></td><td><strong>Instructions</strong><BR><BR>
	   ($error)<br>
	   On the left side, simply type in words to create the
	   crossword puzzle of your choice.  In the next screen,
	   you'll be given the opportunity to write the clues for
	   the words you enter here.  Any blank boxes left will
	   become solid black squares in the puzzle.<br><BR>
	   When you are done, please count the total number of
	   words Across and enter it here:
	   <input type=text name=Num_across size=10 
	   value=\"$data{'Num_across'}\">.<br><BR> Then,
	   count the total number of words Down and enter it
	   here: <input type=text name=Num_down size=10
	   value=\"$data{'Num_down'}\">.
	   </td></tr></table>
	   <input type=hidden name=Action value=Step2>
	   <input type=hidden name=Down value=$number_down>
	   <input type=hidden name=Across value=$number_across>
	   <input type=submit value=\"Go to Adding Clues\"></form>$htmlfooter";
	   exit();

}

sub show_numbers_screen {

   $number_across = $data{'Across'};
   $number_down = $data{'Down'};
   if($data{'Num_across'} <= 0 || $data{'Num_down'} <= 0){
      $error = "<font color=#FF0000><b>Error: You must enter the number
		of words across and down. There must be at least one
		word.
		</b></font>";
      &show_create_screen;
      }

@keys = keys(%data); 

foreach $key (@keys){

  if ($key =~ /\d+,\d+/ && $data{$key} ne ""){
    $correct .= "$data{$key}";
    }
  }
@correct = split("", $correct);
@correct = sort(@correct);
$correct = "";
foreach $cor (@correct){
    $correct .= $cor;
    }

print "$htmlheader
	<table border = 0>
	<tr><td colspan=3>
	<strong><center>Instructions</center></strong><BR><br>
	($error)<br>
	Now, in the slots below, write your clues for each word you see in
	the finished puzzle to the left.  For the words Across, you should
	number from top to bottom; for words Down, you should number from
	left to right.</td>
	<tr><td rowspan=2>
	<table border=1>\n";

 for($i = 1; $i <= $number_down; $i++){
   
    print "<tr>";
    $puz_html .= "<tr>";
       for ($j = 1; $j <= $number_across; $j++){

	  if($data{"$i,$j"} ne ""){
	     $td = "<td align=center>&nbsp;".$data{"$i,$j"}."&nbsp;</td>";
	     $hidden .= "<input type=hidden name=\"$i,$j\" value=\"".$data{"$i,$j"}."\">\n";
	     }
	  else {
	     $td = "<td bgcolor=#000000>.....</td>";
	     }
	     print "$td";
	     $puz_html .= "$td";
	 }
	print "</tr>";
	$puz_html .= "</tr>";
      }
  print "<form method=POST action=$cgi_url>
	 <input type=hidden name=Num_down value=$data{'Num_down'}>
	 <input type=hidden name=Num_across value=$data{'Num_across'}>
	 <input type=hidden name=Down value=$data{'Down'}>
	 <input type=hidden name=Across value=$data{'Across'}>
	 <input type=hidden name=Hidden value=\"$correct\">
	 $hidden
	</table>\n<td valign=TOP><strong>Across:</strong><br><BR>";
  for($i = 1; $i <= $data{'Num_across'}; $i++){
    print "$i. <input type=text name=Across$i><BR>\n";
    }
  print "</td><td valign=TOP><strong>Down:</strong><br><br>\n";
  for($i = 1; $i <= $data{'Num_down'}; $i++){
    print "$i. <input type=text name=Down$i><BR>\n";
    }
  print "</td></tr><tr>
	<td colspan=2>
	   <input type=hidden name=Action value=Step3>
	   <input type=hidden name=Puzzle_html value=\"$puz_html\">
	<input type=submit value=\"Go To Step 3\"></form></td></tr>
  </table>$htmlfooter\n";
  exit();
}

sub show_across_screen {

   $number_across = $data{'Across'};
   $number_down = $data{'Down'};
   if($data{'Across1'} eq "" && $data{'Down1'} eq ""){
      $error = "<font color=#FF0000><b>Error: You must a clue for each
		word.
		</b></font>";
      &show_numbers_screen;


    }
@keys = keys(%data); 

foreach $key (@keys){

  if ($key =~ /\d+,\d+/ && $data{$key} ne ""){
    $correct .= "$data{$key}";
    }
  }
@correct = split("", $correct);
@correct = sort(@correct);
$correct = "";
foreach $cor (@correct){
    $correct .= $cor;
    }

 print "$htmlheader
	<strong><center>Instructions</center></strong><BR>
	<br>
	($error)<br>
	<b>Okay, this last step will allow you to number the
	entries in your crossword puzzle. Put the number that corresponds
	to the number on your clues in the box to the left of the first
	letter of that word. Don't worry if there's more than one \"1\" or
	\"2\" -- there will be.
	Leave all other blanks empty.
	<table border = 0>
	<form method=POST action=$cgi_url>
	<tr><td colspan=3>
	</td>
	<tr><td rowspan=2>
	<table border=1>\n";

 $k = 1;
 for($i = 1; $i <= $number_down; $i++){
   
    print "<tr>";
    $puz_html .= "<tr>";
       for ($j = 1; $j <= $number_across; $j++){

	  if($data{"$i,$j"} ne ""){
	     $td = "<td align=center>&nbsp;".$data{"$i,$j"}."&nbsp;</td>\n";
             print "<td><input size=0 type=text name=\"num:$k\" value=\"\">&nbsp;".
	     $data{"$i,$j"}."&nbsp;</td>\n";
	     $hidden .= "<input type=hidden name=\"$i,$j\" value=\"".$data{"$i,$j"}."\">\n";
	     }
	  else {
	     $td = "<td bgcolor=#000000>.....</td>\n";
             print "<td bgcolor=#000000>.....</td>\n";
	     }
	     $k++;
	     #print "$td";
	     $puz_html .= "$td";
	 }
	print "</tr>";
	$puz_html .= "</tr>";
      }
  print "
	 <input type=hidden name=Num_down value=$data{'Num_down'}>
	 <input type=hidden name=Num_across value=$data{'Num_across'}>
	 <input type=hidden name=Down value=$data{'Down'}>
	 <input type=hidden name=Across value=$data{'Across'}>
	 <input type=hidden name=Hidden value=\"$correct\">
	 $hidden
	</table>\n<td valign=TOP><strong>Across:</strong><br><BR>";
  for($i = 1; $i <= $data{'Num_across'}; $i++){
    print "$i. ".$data{"Across$i"}."<BR>\n";
    print "<input type=hidden name=\"Across$i\" value=\"".$data{"Across$i"}."\"><BR>\n";
    }
  print "</td><td valign=TOP><strong>Down:</strong><br><br>\n";
  for($i = 1; $i <= $data{'Num_down'}; $i++){
    print "$i. ".$data{"Down$i"}."<BR>\n";
    print "<input type=hidden name=\"Down$i\" value=\"".$data{"Down$i"}."\"><BR>\n";
    }
  $puz_html =~ s/\"/&quot;/g;
  $puz_html =~ s/>/&gt;/g;
  $puz_html =~ s/</&lt;/g;
  print "</td></tr><tr>
	<td colspan=2>
	   <input type=hidden name=Action value=Create>
	   <input type=hidden name=Puzzle_html value=\"$puz_html\">
	<input type=submit value=\"Create Puzzle\"></form></td></tr>
  </table>$htmlfooter\n";
  exit();


}

sub create_new {

if($puzzle_directory){
  $puzzlefile = "$puzzle_directory/puzzle$$.html";
  }
else{
  $puzzlefile = "puzzle$$.html";
  }
if($puzzle_url){
  $puzzle_link = "$puzzle_url/puzzle$$.html";
  }
else {
  $puzzle_link = "puzzle$$.html";
  }

$data{'Puzzle_html'} =~ s/&lt;/</g;
$data{'Puzzle_html'} =~ s/&gt;/>/g;
$data{'Puzzle_html'} =~ s/&quot;/\"/g;
print "$htmlheader<center><h1>Finished!</h1></center><br>
	Here's what your finished puzzle will look like:<P>\n";
print "You can find the HTML version at <a href=$puzzle_link>$puzzle_link</a>.<P><b>PLEASE do not link to this puzzle!! This is a demonstration only, and all puzzles are removed every so often.  Just <a href=\"/scripts/CrosswordMaker/\">download the CrosswordMaker CGI program</a>, and you can set it up on your site. Then you can have all the puzzles you want, and won't have to worry about me deleting them. :-)</b><P>\n";

$puz_form = $data{'Puzzle_html'};


@puz_form = split(/<td/, $puz_form);
$i = 0;
foreach $bit (@puz_form){
  if($bit =~ /align=center>\W\D\W<\/td>/){
     $bit2 = $bit;
     $ansnum = "num:$i"; 
     $bit2 =~ s/\W\D\W<\/td>/<sup><b>$data{$ansnum}<\/b><\/sup><input type=text name=letter$i size=2><\/td>/;
     $bit2 =~ s/align=center/align=right/g;
     $correct2 = $bit;
     $correct2 =~ s/align=center>//; $correct2 =~ s/(\W)(\D)(\W)/$2/;
     $correct2 =~ s/\s//g;$correct2 =~ s/<\/td>//g;
     }
  else {
     $bit2 = $bit;
     }
  if($bit2 =~ /^</){
    $printpuz .= $bit2;
    }
  else {
  $printpuz .= "<td$bit2\n";
  } 
  $i++;
  $submitcorrect .= "$correct2";
}
$total_squares = $i;


open(PUZZLE, ">$puzzlefile") ||
 &debug("Could not create puzzle file: $!");
print PUZZLE "$htmlheader <table border=0><tr><td>\n";
print "$htmlheader <table border=0><tr><td>\n";
      
	 
	    print "<table border=1>\n<form method=POST action=$cgi_url>
		   $printpuz\n</table>\n<td valign=TOP>
		   ACROSS<br><BR>";
	    print PUZZLE "<table border=1><form method=POST action=$cgi_url>
		   $printpuz</table><td valign=TOP>
		   ACROSS<br><BR>";
             
	       for ($j = 1; $j <= $data{'Num_across'}; $j++){

	       print "$j.".$data{"Across$j"}."<BR>";
	       print PUZZLE "$j.".$data{"Across$j"}."<BR>";
	       }
	    print "</td><td valign=TOP>DOWN<BR><BR>";
	    print PUZZLE "</td><td valign=TOP>DOWN<BR><BR>";
	       for ($j = 1; $j <= $data{'Num_down'}; $j++){

	       print "$j.".$data{"Down$j"}."<BR>";
	       print PUZZLE "$j.".$data{"Down$j"}."<BR>";
	       }
	    print "<input type=hidden name=totalsquares value=$total_squares>
		   <input type=hidden name=Hidden value=$data{'Hidden'}>
	 	   <input type=hidden name=Down value=$data{'Down'}>
	   	   <input type=hidden name=Across value=$data{'Across'}>
		   <input type=hidden name=puzsol value=Yes>
		   <input type=submit value=\"Grade puzzle\"></form>
		   </td><tr></table> $htmlfooter";
	    print PUZZLE "<input type=hidden name=totalsquares value=$total_squares>
		   <input type=hidden name=Hidden value=$data{'Hidden'}>
	 	   <input type=hidden name=Down value=$data{'Down'}>
	   	   <input type=hidden name=Across value=$data{'Across'}>
		   <input type=hidden name=puzsol value=Yes>
		   <input type=submit value=\"Grade puzzle\"></form>
		   </td><tr></table>$htmlfooter";

close(PUZZLE);
exit();
 }

sub grade_puzzle {


$totalsquares = $data{'totalsquares'} - 1;

   $j = 1;
   for ($i = 1; $i < $data{'totalsquares'}; $i++){
      $datakey = "letter$i";
      if($testnum !~ /\./ || $testnum == 0){
      $puzhtml .= "<tr>"; 
      }
       if($data{$datakey} eq ""){
           $puzhtml .= "<td bgcolor=#000000>.....</td>";
           }
       else {
           $puzhtml .= "<td align=center>&nbsp;$data{$datakey}&nbsp;</td>";
            }
      $testnum = $j + $data{'Across'} - 1; 
      $testnum = $i / $testnum;
          $puzhtml .= "</tr>\n" if "$testnum" !~ /\./ && $testnum != 0; 
      }
@keys = keys(%data); 
foreach $key (@keys){

 if($key =~ /letter/ && $data{$key} ne ""){
     $totalcorrect .= $data{$key};
     }
}
@totalcorrect = split("", $totalcorrect);
@totalcorrect = sort(@totalcorrect);
$testcorrect = "";
foreach $cor (@totalcorrect){
  $testcorrect .= $cor;
  }

$data{'Hidden'} =~ tr/[A-Z]/[a-z]/;
$testcorrect =~ tr/[A-Z]/[a-z]/;

if($data{'Hidden'} eq $testcorrect){
   print "$htmlheader<center><h1>Correct!</h1></center><br>
	  <table border=0><tr>
          <td><table border=1>$puzhtml</table></td>
          <td> Good job!  You solved the puzzle!</td></tr></table>
	  $htmlfooter";
  }
else {
  print "$htmlheader<center><h1>Sorry, Not correct.</h1></center><br>
	 <table border=0><tr>
	 <td><table border=1>$puzhtml</table></td>
	 <td>I'm sorry, but you have not solved the puzzle correctly. Please
	 go back and try again. </td></tr></table>$htmlfooter";
  }
}


sub get_data {
    local($string);

    # get data
    if ($ENV{'REQUEST_METHOD'} eq 'GET') {
        $_ = $string = $ENV{'QUERY_STRING'};
	tr/\"~;/_/;
	$string = $_;

    }				
    else { read(STDIN, $string, $ENV{'CONTENT_LENGTH'});
        $_ = $string;
	$OK_CHARS='a-zA-Z0-9=&%\n\/_\-\.@';
	tr/\"~;/_/;
	$string = $_;
	   }

    # split data into name=value pairs
    @data = split(/&/, $string);
   
    # split into name=value pairs in associative array
    foreach (@data) {
	split(/=/, $_);
	$_[0] =~ s/\+/ /g; # plus to space
	$_[0] =~ s/%(..)/pack("c", hex($1))/ge; # hex to alphanumeric
	$data{"$_[0]"} = $_[1];
    }

    # translate special characters
    foreach (keys %data) {
	$data{"$_"} =~ s/\+/ /g; # plus to space
	$data{"$_"} =~ s/%(..)/pack("c", hex($1))/ge; # hex to alphanumeric
    }

    %data;			# return associative array of name=value
}
sub debug {

if($debugging eq "yes"){
  print "DEBUGGING INFO: $_[0]<br>\n";
  }

}
